%from ...dao.def_items import WORKING_AREA_STATUS, ITEM_TYPE

%item_type_without_s=item_type[:-1]
%text = app._('element.in_work_area')%app._('type.%s'%item_type_without_s) if working_area else app._('type.%s'%item_type_without_s)
%if 'work_area_status' not in locals():
    %work_area_status = None
%end

<div class="area-header shinken-area-header">
    <div class="working-area-banner">
        <table>
            <tr><td>
            <div class="white-around">
                <i class="icon shinkon shinkon-tools"></i>{{app._('header.working_area')}}
                %if is_disabled and block_acl_cause == 'PROPOSE':
                    <span class="warning_proposed">
                        %if is_admin:
                            %wait_msg = app._('element.this_is_lock_waiting_accept_or_refuse_propose_working_area')
                        %else:
                            %wait_msg = app._('element.this_is_lock_waiting_accept_or_refuse_propose_si')
                        %end
                        <i class="shinkon shinkon-lock"></i> {{ wait_msg % app._('type.%s'%item_type_without_s) }}
                    </span>
                %elif is_disabled and block_acl_cause == 'DELETED':
                    <span class="warning_proposed">
                        <i class="shinkon shinkon-lock"></i> {{app._('element.item_deleted_title')}}
                    </span>
                %elif is_disabled:
                    <span class="warning_proposed">
                        <i class="shinkon shinkon-lock"></i> {{app._('element.no_edit')}}
                    </span>
                %end
            </div>
            </td><td>
                %if is_disabled and block_acl_cause == 'PROPOSE' and is_admin:
                <div class="to-staging-button">
                    %_url_add = '/elements/%s/%s'%( item_type,item_id )
                    <a class="btn-elements" href="{{_url_add}}" draggable="false">
                        <i class="icon-arrow-right"></i>&nbsp;{{app._('element.to_staging')}}
                    </a>
                </div>
                %end
            </td></tr>
        </table>
    </div>
    <div class="staging-area-banner">
        <div class="title">
            <img class="database-image" src="/static/{{app.http_start_time}}/main/img/databases.png">
            <div class="database-text">{{app._('header.staging')}} > {{!text}}</div>
        </div>
        %if is_disabled and block_acl_cause == 'PROPOSE':
            %if is_admin:
                %wait_msg = app._('element.this_is_lock_waiting_accept_or_refuse_propose_staging')
            %else:
                %wait_msg = app._('element.this_is_lock_waiting_accept_or_refuse_propose_si')
            %end
            <div class="message no-edit-propose"><i class="shinkon shinkon-lock"></i> {{ wait_msg % app._('type.%s'%item_type_without_s) }}</div>
        %elif is_disabled and block_acl_cause in ('WORK', 'DELETED'):
            <div class="message no-edit-working-area">
                <span class="shinkon shinkon-lock"></span>
                <span>
                    {{app._('element.item_in_work_area_1')}}
                </span>
                <span class="shinken-link"
                      onclick="MANAGER.EventManager.clickOnLinkForWorkingArea( event, '{{item_id}}')"
                      onmouseenter="SHINKEN_TOOLTIP.showTooltip(this);"
                      onmouseleave="SHINKEN_TOOLTIP.hideTooltip();"
                      shi-tip-placement="top"
                      shi-tip-text="{{app._('element.item_in_work_area_3')}}">
                    {{app._('element.item_in_work_area_2')}}
                </span>
            </div>
        %elif is_disabled:
            <div class="message no-access-banner"><i class="shinkon shinkon-lock"></i>{{app._('element.no_edit')}}</div>
        %elif item_type==ITEM_TYPE.HOSTS and work_area_status == WORKING_AREA_STATUS.VALIDATED:
            <div class="white-around hide-when-save-direct-in-staging">
                <span class="warning_proposed">
                    <i class="shinkon shinkon-warning"></i> {{app._('element.a_change_will_put_in_working_area')%app._('type.%s'%item_type_without_s)}}
                </span>
            </div>
        %end
    </div>
    <div class="shinken-tab-title">
        <div class="shinken-type-name-header" >{{text}} >&nbsp;</div>
        %if item_is_new:
            <span id="shinken-tag-element-new">{{app._('element.new')}}</span>
        %end
        %if not item_is_new and work_area_status and item_type == ITEM_TYPE.HOSTS:
            <div class='tag {{work_area_status}}'> {{app._('element.%s' %(work_area_last_action.lower()))}}</div>
        %end
        <div class="shinken-title-page-edition-disabled tag">
            {{app._('element.disabled')}}
        </div>
        %if presence_protection:
            <div class="shinken-presence-protection">&nbsp;{{app._('header.presence_protection')}}</div>
        %end
        <div class="shinken-element-name-container">
            <div id='shinken-title-page-edition' class="shinken-element-name">
            {{name}}
            </div>
        </div>

        %last_comment = app.helper.get_last_comment(item)
        %if last_comment:
        %comment_text = app._('element.comment_in_item') % (last_comment['user_name'], app.helper.print_date(last_comment['at']), app._('element.%s' % last_comment['on']), last_comment['text'])
            <div class="pull-right comment-header text-ellipsis">
                <i class="icon-comment"></i> {{!comment_text}}
                %include("__print_pane_comment")
            </div>
        %end
    </div>
</div>
