#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2018
# This file is part of Shinken Enterprise, all rights reserved.

from shinken.http_client import HTTPClient
from shinken.misc.type_hint import TYPE_CHECKING

if TYPE_CHECKING:
    from shinken.misc.type_hint import Optional
    from ...synchronizerdaemon import Synchronizer

app = None  # type: Optional[Synchronizer]


def _get_all_log_info(conf):
    con = _get_daemon_connection(conf)
    return con.get(u'get_log_info')


def _enable_log(conf, logger_id, enable):
    con = _get_daemon_connection(conf)
    return con.get(u'set_log_enable', {u'logger_id': logger_id, u'enable': u'1' if enable else u'0'})


def _get_daemon_connection(conf):
    con = HTTPClient(
        address=conf[u'address'],
        port=conf[u'port'],
        timeout=conf[u'timeout'],
        data_timeout=conf[u'data_timeout'],
        use_ssl=conf[u'use_ssl'],
        strong_ssl=conf[u'hard_ssl_name_check']
    )
    
    return con


def _get_all_daemon_conf():
    conf_all_daemons = app.conf.get_all_daemons()
    
    logger_control_infos = {}
    for daemon_type, confs in conf_all_daemons.iteritems():
        infos = []
        logger_control_infos[daemon_type] = infos
        for conf in confs:
            c = {
                u'name'               : conf.get_name(),
                u'address'            : conf.address,
                u'port'               : conf.port,
                u'use_ssl'            : conf.use_ssl,
                u'timeout'            : conf.timeout,
                u'data_timeout'       : conf.data_timeout,
                u'enabled'            : conf.enabled,
                u'hard_ssl_name_check': conf.hard_ssl_name_check,
            }
            
            infos.append(c)


def get_logger_control():
    user = app.get_user_auth()
    conf_all_daemons = app.conf.get_all_daemons()
    
    logger_control_infos = {}
    for daemon_type, confs in conf_all_daemons.iteritems():
        infos = []
        logger_control_infos[daemon_type] = infos
        for conf in confs:
            c = {
                u'name'               : conf.get_name(),
                u'address'            : conf.address,
                u'port'               : conf.port,
                u'use_ssl'            : conf.use_ssl,
                u'timeout'            : conf.timeout,
                u'data_timeout'       : conf.data_timeout,
                u'enabled'            : conf.enabled,
                u'hard_ssl_name_check': conf.hard_ssl_name_check,
                u'error_message'      : u'',
                u'url'                : u'%s://%s:%s' % (u'https' if conf.use_ssl else u'http', conf.address, conf.port),
            }
            
            try:
                c[u'all_log_info'] = _get_all_log_info(c)
            except Exception as e:
                c[u'all_log_info'] = {}
                c[u'error_message'] = u'Fail to connect to [%s] because : %s' % (c[u'url'], e)
            
            infos.append(c)
    
    return {
        u'app'                 : app,
        u'user'                : user,
        u'logger_control_infos': logger_control_infos
    }


def get_enable_log():
    daemon_name = app.request.GET.get(u'daemon_name', None)
    logger_id = app.request.GET.get(u'logger_id', None)
    enable_log = app.request.GET.get(u'enable', None)
    
    conf_all_daemons = app.conf.get_all_daemons()
    
    for daemon_type, confs in conf_all_daemons.iteritems():
        for conf in confs:
            if conf.get_name() == daemon_name:
                c = {
                    u'name'               : conf.get_name(),
                    u'address'            : conf.address,
                    u'port'               : conf.port,
                    u'use_ssl'            : conf.use_ssl,
                    u'timeout'            : conf.timeout,
                    u'data_timeout'       : conf.data_timeout,
                    u'enabled'            : conf.enabled,
                    u'hard_ssl_name_check': conf.hard_ssl_name_check,
                }
                return _enable_log(c, logger_id, enable_log == u'1')
    return u'FAIL'


pages = {
    get_logger_control: {u'routes': [u'/debug_logger_control'], u'view': u'logger_control', u'static': True, u'wrappers': [u'auth_admin']},
    get_enable_log    : {u'routes': [u'/enable_log'], u'wrappers': [u'auth_admin']}
}
