#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2021
# This file is part of Shinken Enterprise, all rights reserved.


import hashlib

from shinken.misc.type_hint import TYPE_CHECKING
from ...component.component_manager import component_manager
from ...dao.dataprovider.dataprovider_mongo import DataProviderMongo

if TYPE_CHECKING:
    from shinken.misc.type_hint import Dict, Optional
    from ...synchronizerdaemon import Synchronizer

app = None  # type: Optional[Synchronizer]


def get_item():
    # type: () -> Dict
    if not app.debug:
        app.abort(403, u'route available only in debug')
    password = app.request.GET.get(u'password', u'')
    if not hashlib.sha256(password).hexdigest() == u'0f27566355a683248a1ec3311ea17cffcaa42609085775f03a45a74d7f35d48c':
        app.abort(401, u'incorrect password')
    item_id = app.request.GET.get(u'item_id', u'')
    item_type = app.request.GET.get(u'item_type', u'')
    item_state = app.request.GET.get(u'item_state', u'')
    if not item_id or not item_type or not item_state:
        app.abort(400, u'Incorrect arguments, need item_id, item_type and item_state')
    response = {u'item': {}}
    mongo_component = component_manager.get_mongo_component()
    db = DataProviderMongo(mongo_component, app.database_cipher)
    response[u'item'] = db.find_item_by_id(item_id, item_type, item_state)
    return response


pages = {
    get_item: {u'routes': [u'/internal/private_shinken_test/item'], u'method': u'GET', u'wrappers': [u'json']},
}

# error = ''
# results = ''
# c = pycurl.Curl()
# url = "%s://%s:%d/checkkey/%s" % ('https' if app.use_ssl else 'http', app.host, app.port, api_key)
# logger.debug('[test_api] testing with key [%s] on url [%s]' % (api_key, url))
#
# # Oups, seems that url an unicode are BAD :)
# url = str(url)
# c.setopt(c.URL, url)
# c.setopt(c.VERBOSE, 1)
#
# response = StringIO()
# c.setopt(c.WRITEFUNCTION, response.write)
# r = c.perform()
# response.seek(0)
# status_code = c.getinfo(pycurl.HTTP_CODE)
#
# # We only parse the json if we got
# if status_code == 200:
#     results = json.loads(response.read().replace('\\/', '/'))
# else:
#     error = response.read().replace('\\/', '/')
#
# c.close()
#
# logger.debug('[test_api] testing result status code [%s] json loaded [%s]-[%s]' % (status_code, results, error))
# return (results, error)
