<div class="table-body-js scroll-body content shinken-page-source-conf">
    <table class="table striped bordered shinken-analyser-table-configuration" role="grid">
        <thead>
            <tr role="row">
                <th><div class="shinken-header">{{app._('source.key')}}</div></th>
                <th><div class="shinken-header">{{app._('source.value')}}</div></th>
            </tr>
        </thead>
        <tbody>
            <tr><td>{{app._('source.order')}}</td><td>{{source_json.get('order', source.order)}}</td></tr>
            <tr><td>{{app._('source.last_synchronization')}}</td><td>{{app.helper.print_date(getattr(source, 'last_import', 0))}}</td></tr>
            <tr><td>{{app._('source.import_interval')}}</td><td>{{source.import_interval}}</td></tr>
            <tr><td>{{app._('source.modules')}}</td><td>{{','.join([m.get_name() for m in source.modules])}}</td></tr>
            <tr><td>{{app._('source.module_type')}}</td><td>{{source.module_type}}</td></tr>
            <tr><td>{{app._('source.description')}}</td><td>{{source.description}}</td></tr>
            %for key in source.view_conf:
                <tr><td>{{key}}</td><td>{{getattr(source, key)}}</td></tr>
            %end
        </tbody>
    </table>

    %if source.type in ('analyzer', 'listener') and source_conf:
        <div class="shinken-source-conf-container">
            <form id="shinken-form-source-conf" action="/sources/{{source.get_name()}}/configuration" method="post">
                %for config_type, fields in source_conf.iteritems():
                    <div class="span12">
                        <div style="    background: #494949; color: #FFFFFF;margin-bottom: 10px;padding-left: 10px; font-size: 24px;">
                            <img style="width: 35px; height: 35px;" src="/static/{{app.http_start_time}}/sources/images/configuration/{{config_type.lower()}}.png"> {{config_type.title()}}
                        </div>
                        <div class="span3">
                            <table style="width: 500px;">
                                <tbody>
                                    %# if all field disabled we will remove the submit button
                                    %all_input_disabled = True

                                    %for field_name, properties in fields.iteritems():
                                        %if field_name == 'authentication' and source.get_name() in ('listener-shinken'):
                                            %continue
                                        %end
                                        %item_id = "%s__%s" % (config_type, field_name)
                                        %field_type = 'password' if properties.get('protected', False) else properties['type']
                                        %field_name = properties.get('display_name', field_name.replace('_', ' ').title())
                                        <tr title="{{properties.get('help', '')}}">
                                            <td>{{field_name}}</td>
                                            %read_only_field = properties.get('read_only', False)
                                            %disabled = 'disabled="disabled"' if read_only_field else ''
                                            %# if a field is not disabled, that mean there is at least one input to send
                                            %if not read_only_field:
                                                %all_input_disabled = False
                                            %end

                                            <td>
                                                %if field_type == 'checkbox':
                                                    %checked = "checked" if str(properties['value']) == 'True' else ''
                                                    %display_bind_management = ''
                                                    %data_display_bind = ""

                                                    %# for check box a class to disable it, it will remove events
                                                    %if disabled:
                                                        %disabled = 'shinken-content-readonly'
                                                    %end

                                                    %if properties.get('display_bind', False):
                                                        %display_bind_management = "onclick=updateDisplayBind(this,event);"
                                                        %data_display_bind = ""
                                                        %for i, data_bind_name in enumerate(properties['display_bind']):
                                                            %data_bind_id = "%s__%s" % (config_type, data_bind_name)
                                                            %data_display_bind += ' data-bind-display-%s=%s' % (i, data_bind_id)
                                                        %end
                                                    %end
                                                    <input class="{{disabled}}" id={{item_id}} name="{{item_id}}" {{data_display_bind}} {{display_bind_management}} type="{{field_type}}" {{checked}}>

                                                %else:
                                                    %cipher_management = "data-is-changed=0 onkeydown=change_protected_value(this,event);" if properties['protected'] else ''
                                                    <input class="span12" autocomplete="new-password" {{cipher_management}} id={{item_id}} name="{{item_id}}" type="{{field_type}}"  value="{{properties['value']}}" {{disabled}}>
                                                %end
                                            </td>
                                        </tr>
                                    %end
                                </tbody>
                            </table>
                        </div>
                    </div>
                %end
                %if not all_input_disabled:
                    <div class="button">
                        <div class="shinken-button" onclick="submit_form_source_conf( this );">
                            <div class="text">{{app._('source.submit')}}</div>
                        </div>
                        <div class="floatingBarsG">
                            <div class="shinken-block rotate-01"></div>
                            <div class="shinken-block rotate-02"></div>
                            <div class="shinken-block rotate-03"></div>
                            <div class="shinken-block rotate-04"></div>
                            <div class="shinken-block rotate-05"></div>
                            <div class="shinken-block rotate-06"></div>
                            <div class="shinken-block rotate-07"></div>
                            <div class="shinken-block rotate-08"></div>
                        </div>
                    </div>
                %else:
                    %# fake button used for a fully readonly form
                    <div class="button">
                        <button class="btn-disabled" disabled><span class="shinicon shinicon-save"></span> {{app._('source.submit')}}</button>
                    </div>
               %end
            </form>
        </div>
    %end

    %if source.type == 'listener' and source_conf and source.module_type == 'listener-shinken':
        %include("__listener_shinken_curl_example", app=app, source=source)
    %elif source.type == 'listener' :
        %include("__listener_rest_curl_example", app=app, source=source)
    %end

    %if len(source.configuration_errors) >= 1:
        <span class='span12'>{{app._('source.configuration_errors')}}&nbsp;:&nbsp;</span>
        %for err in source.configuration_errors:
            <span class='alert alert-error'>{{err}}</span>
        %end
    %end
</div>
