<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
    <style type="text/css">
        body {
            text-align  : center;
            font-family : Verdana, sans-serif;
            font-size   : 10pt;
        }
        h4 {
            display   : inline-block;
            font-size : 12pt;
        }
        img {
            display : inline-block;
        }
        table {
            width          : 600px;
            text-align     : center;
            margin-left    : auto;
            margin-right   : auto;
            vertical-align : middle;
            border         : 1px solid #D9D9D9;
        }
        th {
            white-space : nowrap;
            width       : 150px;
        }
        th.even {
            background-color : #D9D9D9;
        }
        th.odd {
            background-color : #F2F2F2;
        }
        td.blue {
            background-color : #BDD7EE;
        }
        th, td {
            font-family : Verdana, sans-serif;
            font-size   : 10pt;
            text-align  : left;
            padding     : 2px
        }
    </style>
</head>
<body>
{% if shinken_var['Images enabled'] %}
    <img style='width:154px;height:66px;' src="cid:logo">
{% endif %}
<h4>{{ mail_welcome }} on Host [ {{ shinken_var['Hostname'] }} ]</h4>
<table>
    <tr>
        <td colspan="2">
    <tr>
        <th class="odd">Notification type</th>
        <td>{{ shinken_var['Notification type'] }}</td>
    </tr>
    <tr>
        <th class="even">Realm</th>
        <td>{{ shinken_var['Realm'] }}</td>
    </tr>
    <tr>
        <th class="odd">Host</th>
        <td>{{ shinken_var['Hostname'] }}</td>
    </tr>
    <tr>
        <th class="even">Host address</th>
        <td>{{ shinken_var['Host address'] }}</td>
    </tr>
</table>
<br>
<table>
    <tr>
        <th class="even">Host link</th>
        <td><a href="{{ shinken_var['View'] }}">Detail view</a></td>
    </tr>
    <tr>
        <th class="odd">Status</th>
        <td>
            {% if shinken_var['Images enabled'] %}
                <img src="cid:state_logo">
            {% endif %}{{ shinken_var['state_html'] }}
        </td>
    </tr>
    <tr>
        <th class="even">Last check</th>
        <td>{{ shinken_var['Check date'] }}</td>
    </tr>
    <tr>
        <th class="odd">Last change</th>
        <td>
            {% if shinken_var['Images enabled'] %}
                <img src="cid:last_state_logo"><img src="cid:arrow"><img src="cid:state_logo">
            {% else %}
                Changed from {{ shinken_var['Last state'] }} to {{ shinken_var['state_html'] }}
            {% endif %}
            {% if shinken_var['State duration'] %}
                since {{ shinken_var['State duration'] }}
            {% endif %}
            {% if shinken_var['Notification number'] == 1 and shinken_var['Notification delay'] > 0 %}
                <br><span style="color: darkgrey; font-size: smaller;">This notification was delayed by {{ shinken_var['Notification delay'] }} minutes as defined in the host or cluster configuration (first_notification_delay)</span>
            {% endif %}
        </td>
    </tr>
    {% if shinken_var['downtime_author'] %}
        <tr>
            <th class="even">Author</th>
            <td class="even">{{ shinken_var['downtime_author'] }}</td>
        </tr>
        <tr>
            <th class="odd">Comment</th>
            <td class="odd" style="word-break:break-all;">{{ shinken_var['downtime_comment'] }}</td>
        </tr>
    {% endif %}
    {% if shinken_var['Acknowledge author'] %}
        <tr>
            <th class="even">Author</th>
            <td class="even">{{ shinken_var['Acknowledge author'] }}</td>
        </tr>
        <tr>
            <th class="odd">Comment</th>
            <td class="odd" style="word-break:break-all;">{{ shinken_var['Acknowledge data'] }}</td>
        </tr>
    {% endif %}</table>
<br>
<table>
    <tr>
        <td colspan="2" class="blue"><br><b>Output: </b> {{ shinken_var['Output'] }}<br>&nbsp;</td>
    </tr>
</table>
{% if shinken_var['Long output'] %}
    <br>
    <table>
        <tr>
            <td colspan="2" class="blue"><br><b>Long output: </b> {{ shinken_var['Long output'] }}<br>&nbsp;</td>
        </tr>
    </table>
{% endif %}
</body>
</html>