# !/usr/bin/python
# -*- coding: utf-8 -*-
# Copyright (C) 2013-2021:
# This file is part of Shinken Enterprise, all rights reserved.

ALL_FIX = []
NUMBER_INDENT_SPACES = 0


def add_doc(doc_):
    def decorated(func):
        func.doc = doc_
        return func
    
    
    return decorated


def add_context_daemons(lst):
    # protect again dev that don't read the doc...
    if isinstance(lst, basestring):
        lst = [lst]
    
    
    def decorated(func):
        func.context_daemons = lst
        return func
    
    
    return decorated


def add_version(v):
    def decorated(func):
        func.version = v
        return func
    
    
    return decorated


def auto_launch(value):
    def decorated(func):
        func.auto_launch = value
        return func
    
    
    return decorated


def need_shinken_stop(value):
    def decorated(func):
        func.need_shinken_stop = value
        return func
    
    
    return decorated


def add_data_type(value):
    def decorated(func):
        func.data_type = value
        return func
    
    
    return decorated


def add_fix(func):
    global NUMBER_INDENT_SPACES
    ALL_FIX.append(func)
    name_length = len(func.__name__)
    if name_length > NUMBER_INDENT_SPACES:
        NUMBER_INDENT_SPACES = name_length
    return func


def cyan(text):
    # type: (unicode) -> unicode
    return u'\033[36m%s\033[0m' % text
