# !/usr/bin/python
# -*- coding: utf-8 -*-
# Copyright (C) 2013-2021:
# This file is part of Shinken Enterprise, all rights reserved.
import logging
import logging.handlers
import sys

from shinken.misc.type_hint import TYPE_CHECKING

if TYPE_CHECKING:
    pass
formatter = logging.Formatter('[%(asctime)s] [%(name)s] %(message)s')
DEFAULT_LOG_FILENAME = '/var/log/shinken/sanitize.log'
orig_stdout = sys.stdout
orig_stderr = sys.stderr


class LogFile(object):
    def __init__(self, name=None):
        self.console_handler = logging.StreamHandler(orig_stdout)
        self.file_handler = None
        
        self.logger = logging.getLogger(name)
        self.logger.setLevel(logging.DEBUG)
        
        self.logger.addHandler(self.console_handler)
        self.encoding = None
    
    
    def set_console_level(self, level):
        self.console_handler.setLevel(level)
    
    
    def get_console_level(self):
        return self.console_handler.level
    
    
    def set_file_handler(self, path):
        self.file_handler = logging.handlers.RotatingFileHandler(path, maxBytes=1024 * 1024, backupCount=5)
        self.file_handler.setFormatter(formatter)
        self.logger.addHandler(self.file_handler)
    
    
    def write(self, msg, level=logging.DEBUG):
        self.logger.log(level, msg.strip())
    
    
    def flush(self):
        for handler in self.logger.handlers:
            handler.flush()


sanitize_log = LogFile('Sanitize')
log = sanitize_log.logger

sys.stdout = sanitize_log
sys.stderr = sanitize_log
