# !/usr/bin/python
# -*- coding: utf-8 -*-

# Copyright (C) 2013-2021:
# This file is part of Shinken Enterprise, all rights reserved.

import sys

from shinken.objects import Item, Items
from shinken.objects.config import Config
from shinken.property import StringProp, BoolProp

ENVIRONMENT_VARIABLE_FILE = u'/etc/shinken/tools_used_by_shinken/shinken_mongo/mongos_socket_keep_alive.cfg'
LIB_PATH = u'/opt/shinken/shinken_mongo/libs/libkeepalive/libkeepalive.so'

NO_NEED_ENVIRONMENT_RETURN_CODE = 2
ENVIRONMENT_LOADED_RETURN_CODE = 0


class MongoEnvironmentConfs(Items):
    pass


class MongoEnvironmentConf(Item):
    id = 1  # zero is always special in database, so we do not take risk here
    my_type = 'mongo_environment'
    
    properties = {
        'tools_used_by_shinken__mongo__tcp_keep_alive__enabled'                     : BoolProp(default='1'),
        'tools_used_by_shinken__mongo__tcp_keep_alive__number_of_probes'            : StringProp(default='3'),
        'tools_used_by_shinken__mongo__tcp_keep_alive__time_interval_between_probes': StringProp(default='5'),
        'tools_used_by_shinken__mongo__tcp_keep_alive__time_before_idle'            : StringProp(default='15'),
        'tools_used_by_shinken__mongo__tcp_keep_alive__enable_debug'                : BoolProp(default='1'),
    }


class MongosConfig(Config):
    types_creations = {
        'mongo_environment': (MongoEnvironmentConf, MongoEnvironmentConfs, 'mongo_environment')
    }


def _get_environment_variable_from_file():
    config = MongosConfig()
    config.read_config_silent = 1
    buf = config.read_config([ENVIRONMENT_VARIABLE_FILE])
    raw_objects = config.read_config_buf(buf)
    config.create_objects_for_type(raw_objects, 'mongo_environment')
    return next(config.mongo_environment.items.itervalues(), MongoEnvironmentConf())


def _build_environment_line_from_mongo_environment(mongo_env):
    return u'TCP_KEEPCNT=%s TCP_KEEPINTVL=%s TCP_KEEPIDLE=%s LIBKEEPALIVE_DEBUG=%s LD_PRELOAD=%s' % (
        mongo_env.tools_used_by_shinken__mongo__tcp_keep_alive__number_of_probes,
        mongo_env.tools_used_by_shinken__mongo__tcp_keep_alive__time_interval_between_probes,
        mongo_env.tools_used_by_shinken__mongo__tcp_keep_alive__time_before_idle,
        mongo_env.tools_used_by_shinken__mongo__tcp_keep_alive__enable_debug,
        LIB_PATH
    )


# This function that returns the environment needed BEFORE starting mongos. Without that, mongos will have issue with sockets #SEF-9216
def get_mongo_environment():
    mongo_env = _get_environment_variable_from_file()
    mongo_env.fill_default()
    mongo_env.pythonize()
    if not mongo_env.tools_used_by_shinken__mongo__tcp_keep_alive__enabled:
        sys.exit(NO_NEED_ENVIRONMENT_RETURN_CODE)
    
    env_string = _build_environment_line_from_mongo_environment(mongo_env)
    print env_string
    sys.exit(ENVIRONMENT_LOADED_RETURN_CODE)


if __name__ == '__main__':
    get_mongo_environment()
