#!/usr/bin/python
# -*- coding: utf-8 -*-

# Copyright (C) 2013-2020:
# This file is part of Shinken Enterprise, all rights reserved.

from shinkensolutions.api.synchronizer.source.display_origin_item.abstract_display_origin_item import AbstractDisplayOriginItem
from shinkensolutions.toolbox.box_tools_string import ToolsBoxString


class DisplayOriginItemAsString(AbstractDisplayOriginItem):
    
    def controller(self, item, item_type):
        if not self.title:
            self.title = self.translator.translate('display_origin_item.element_found_by_source')
        
        return {
            'title'   : self.title,
            'raw_data': ToolsBoxString.unescape_XSS(self.raw_data)
        }
