SHINKEN.TOOLS.TEST_AUTO_APPLY = (function ( self ) {
    self.DOM                          = {};
    self.ACTION                       = {};
    self.TEST                         = {};
    //********************************************  GET DOM ELEMENT   **************************************************//
    self.DOM.getLeftColumn            = function () {
        return document.getElementById( "left-column" );
    };
    self.DOM.getRightColumn            = function () {
        return document.getElementById( "apply-right-block" );
    };
    self.DOM.getCheckButton           = function () {
        return self.DOM.getLeftColumn().querySelector( "#check-btn" );
    };
    self.DOM.getApplyButton              = function () {
        return self.DOM.getLeftColumn().querySelector( "#restart-btn" );
    };
    self.DOM.getCheckIsOkPanel            = function () {
        return self.DOM.getLeftColumn().querySelector( "#checking-is-ok" );
    };
    self.DOM.getModifiedListElement            = function () {
        return self.DOM.getRightColumn().querySelector( "#apply-right-block-changed" );
    };
    self.DOM.getModifiedElement            = function ( uuid_element ) {
        return self.DOM.getModifiedListElement().querySelector( ".shinken-li-element[data-uuid-element='" + uuid_element + "']" );
    };
    self.DOM.getModifiedElementLastUser     = function ( uuid_element ) {
        return self.DOM.getModifiedElement(uuid_element).querySelector( ".shinken-info" );
    };
    self.DOM.getDeletedListElement            = function () {
        return self.DOM.getRightColumn().querySelector( "#apply-right-block-removed" );
    };
    self.DOM.getDeletedElement            = function ( uuid_element ) {
        return self.DOM.getDeletedListElement().querySelector( ".shinken-li-element[data-uuid-element='" + uuid_element + "']" );
    };
    self.DOM.getDeletedElementLastUser     = function ( uuid_element ) {
        return self.DOM.getDeletedElement(uuid_element).querySelector( ".shinken-info" );
    };
    //********************************************  ACTION   **************************************************//
    self.ACTION.clickOnCheck          = function ( timeout ) {
        setTimeout( function () {
            var _button = self.DOM.getCheckButton();
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, _button );
        }, timeout );
        return 4000;
    };
    self.ACTION.clickOnExecuteApply            = function ( timeout ) {
        setTimeout( function () {
            var _button = self.DOM.getApplyButton();
            SHINKEN.TOOLS.TEST_AUTO.__isVisible( _button, '' );
            if ( !SHINKEN.TOOLS.TEST_AUTO.hasMessage() ) {
                SHINKEN.HIGHWAY.changeUrl( SHINKEN.TOOLS.TEST_AUTO_PHASE.getNextPhaseLink() );
                really_click_on_restart_configuration();
            }
            else {
                SHINKEN.TOOLS.TEST_AUTO.addError( "Le test comporte des erreurs, la dernière action n'a pas été faites" );
            }
        }, timeout );
        return 2000;
    };
    //********************************************  TEST   **************************************************//
    self.TEST.checkResultContainsText = function ( timeout, text ) {
        var _to_return = 50;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'checkResultContainsText', text );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_DOM.containsText( 0, self.DOM.getCheckIsOkPanel(), text, 'checkResultContainsText' );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.TEST.lastModifiedUser = function ( timeout, uuid_element, user_name ) {
        var _to_return = 50;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'checkResultContainsText', user_name );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_DOM.containsText( 0, self.DOM.getModifiedElementLastUser(uuid_element), user_name, 'lastModifiedUser' );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.TEST.deletingUser = function ( timeout, uuid_element, user_name ) {
        var _to_return = 50;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'deletingUser', user_name );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_DOM.containsText( 0, self.DOM.getDeletedElementLastUser(uuid_element), user_name, 'lastModifiedUser' );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    
    return self;
})( SHINKEN.TOOLS.TEST_AUTO_APPLY || {} );

//@override
function form_restart_success () {
    SHINKEN.HIGHWAY.refreshCurrentPage();
}
