SHINKEN.TOOLS.TEST_AUTO_UI_VISU_LIST_ALL = (function ( self ) {
    self.DOM                   = {};
    self.TEST                  = {};
    self.ACTION                = {};
    self.CONST                 = {};
    //********************************************  GET DOM ELEMENT   **************************************************//
    self.DOM.getIframe         = function () {
        SHINKEN.TOOLS.IFRAME.getIframeJs( "#id-shinken-iframe-for-ui-visualisation" ).window.onerror = function () {
            _has_script_error++;
        };
        return SHINKEN.TOOLS.IFRAME.getIframeJs( "#id-shinken-iframe-for-ui-visualisation" ).document;
    };
    self.DOM.header            = function () {
        return self.DOM.getIframe().querySelector( "#id-shinken-title-list-all" );
    };
    self.DOM.buttonAutoRefresh = function () {
        return self.DOM.header().querySelector( ".actionButtons .auto-refresh-btn" );
    };
    self.DOM.buttonExportCSV   = function () {
        return self.DOM.header().querySelector( ".shinken-export-csv-btn" );
    };
    self.DOM.exportCSVFrame    = function () {
        return self.DOM.getIframe().querySelector( ".loading-frame" );
    };
    //********************************************  GETTER   **************************************************//
    //********************************************  TEST   **************************************************//
    self.TEST.displayCSVExportFrame = function ( timeout ) {
        var _to_return = 1000;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'TEST.displayCSVExportFrame', "" );
        
        setTimeout( function () {
            var csvFrame = self.DOM.exportCSVFrame();
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 0, csvFrame );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK" );
        }, 10000 );
        
        return _to_return
    };
    
    //********************************************  ACTION   **************************************************//
    self.ACTION.clickOnAutoRefresh = function ( timeout ) {
        var _to_return = 200;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.clickOnAutoRefresh', "" );
        
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.DOM.buttonAutoRefresh() );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        
        return _to_return;
    };
    self.ACTION.clickOnExportCSV   = function ( timeout ) {
        var _to_return = 3000;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.clickOnExportCSV', "" );
        
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( timeout, self.DOM.buttonExportCSV() );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK" );
        }, timeout );
        
        return _to_return
    };
    //********************************************  CONSTANT **************************************************//
    
    return self;
})( SHINKEN.TOOLS.TEST_AUTO_UI_VISU_LIST_ALL || {} );

