//__lib__ lib_common
'use strict';

COMPONENT.Button           = function ( dom_element, name ) {
    this.__class_name__ = 'COMPONENT.Button';
    // dom_element
    // value
    // state
    // label
    // name
    this.uuid   = SHINKEN.TOOLS.STRING.buildUUID();
    this.state  = COMPONENT.CONST.BTN_STATE.OFF;
    this.status = COMPONENT.CONST.BTN_STATUS.NONE;
    this.name   = name;
    this.value  = '';
    this.init( dom_element );
};
COMPONENT.Button.prototype = {
    init             : function ( dom_element ) {
        this.dom_element = dom_element;
        if ( this.dom_element ) {
            this.initDomElement();
        }
        else {
            this.state = COMPONENT.CONST.BTN_STATE.DISABLED;
        }
        this._computeState();
    },
    initDomElement   : function () {
        this.value = this.dom_element.value;
        if ( this.dom_element.classList.contains( 'shinken-error' ) ) {
            this.status = COMPONENT.CONST.BTN_STATUS.ERROR;
        }
        else if ( this.dom_element.classList.contains( 'shinken-warning' ) ) {
            this.status = COMPONENT.CONST.BTN_STATUS.WARNING;
        }
    },
    //********************************************  GETTER AND SETTER  ***********************************************//
    setState         : function ( to_set ) {
        this.state = to_set;
        if ( !this.dom_element ) {
            return;
        }
        this.resetStateClass();
        switch ( this.state ) {
            case COMPONENT.CONST.BTN_STATE.ON:
                this.dom_element.classList.add( "shinken-active" );
                break;
            case COMPONENT.CONST.BTN_STATE.DISABLED:
                this.dom_element.classList.add( "shinken-disabled" );
                break;
            case COMPONENT.CONST.BTN_STATE.ENABLED_WITH_ERRORS:
                this.dom_element.classList.add( "shinken-enabled-with-errors" );
                break;
        }
    },
    resetStateClass  : function () {
        if ( !this.dom_element ) {
            return;
        }
        this.dom_element.classList.remove( "shinken-active" );
        this.dom_element.classList.remove( "shinken-disabled" );
        this.dom_element.classList.remove( "shinken-enabled-with-errors" );
    },
    getValue         : function () {
        return this.value;
    },
    getState         : function () {
        return this.state;
    },
    isOn             : function () {
        return this.state === COMPONENT.CONST.BTN_STATE.ON;
    },
    setInheritedLabel: function ( to_set ) {
        this.dom_element.querySelector( '.shinken-inherited-value' ).innerHTML = to_set;
    },
    addClass         : function ( to_add ) {
        this.dom_element.classList.add( to_add );
    },
    removeClass      : function ( to_remove ) {
        this.dom_element.classList.remove( to_remove );
    },
    setTooltip       : function ( to_set, type ) {
        if ( to_set ) {
            this.dom_element.setAttribute( "onmouseenter", "SHINKEN_TOOLTIP.showTooltip(this)" );
            this.dom_element.setAttribute( "onmouseleave", "SHINKEN_TOOLTIP.hideTooltip()" );
            this.dom_element.setAttribute( 'shi-tip-html', to_set );
            if ( type ) {
                this.dom_element.setAttribute( 'shi-tip-type', type );
            }
        }
        else {
            this.dom_element.setAttribute( 'shi-tip-html', '' );
        }
    },
    //********************************************  COMPUTE  ***********************************************//
    computeCounters  : function () {
        switch ( this.status ) {
            case COMPONENT.CONST.BTN_STATUS.ERROR:
                this.getCounterError().update( this.uuid, 1 );
                break;
            case COMPONENT.CONST.BTN_STATUS.WARNING:
                this.getCounterWarning().update( this.uuid, 1 );
                break;
        }
    },
    _computeState    : function () {
        if ( this.state === COMPONENT.CONST.BTN_STATE.DISABLED ) {
            return;
        }
        if ( this.dom_element.classList.contains( "shinken-active" ) ) {
            this.setState( COMPONENT.CONST.BTN_STATE.ON );
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.Button, COMPONENT.Interface );