//__lib__ lib_common
'use strict';

COMPONENT.Checkbox           = function ( dom_element, parent ) {
    // dom_element
    // is_checked
    // checkbox_user
    // checkbox_inherited
    this.init( dom_element, parent );
};
COMPONENT.Checkbox.prototype = {
    init                       : function ( dom_element, parent ) {
        this.dom_element = dom_element;
        this.initCounters( parent );
        this.checkbox_user      = new OBJECT.ElementCheckbox( dom_element.querySelector( ".shinken-checkbox-user" ), this );
        this.checkbox_inherited = new OBJECT.ElementCheckbox( dom_element.querySelector( ".shinken-checkbox-inherited" ), this );
        this.checkbox_default   = new OBJECT.ElementCheckbox( dom_element.querySelector( ".shinken-checkbox-default" ), this );
        this.initInterface();
    },
    toggleCheckedUser          : function () {
        var _value = !this.isCheckedUser();
        this.setCheckedUser( _value );
    },
    isCheckedUser              : function () {
        return this.checkbox_user.isChecked();
    },
    isCheckedInheritance       : function () {
        return this.checkbox_inherited.isChecked();
    },
    isCheckedDefault           : function () {
        return this.checkbox_default.isChecked();
    },
    //********************************************  GETTER SETTER  *********************************************************//
    setCheckedUser             : function ( to_set ) {
        this.checkbox_user.setChecked( to_set );
        this.doExtraAction();
    },
    setCheckedInheritance      : function ( to_set ) {
        this.checkbox_inherited.setChecked( to_set );
    },
    getChildrenObject              : function () {
        return [this.checkbox_user, this.checkbox_inherited, this.checkbox_default];
    },
    //********************************************  COMPUTE  *********************************************************//
    updateUrlWithValue         : function () {
        var _value = this.isCheckedUser() ? '1' : '';
        SHINKEN.HIGHWAY.setParam( this.url_param_key, _value );
    }
    
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.Checkbox, COMPONENT.Interface );