//__lib__ lib_common
"use strict";

SHINKEN.OBJECT.Progressbar           = function ( parent, nb_steps, min_timeout, dom_element_parent ) {
    this._parent                           = parent;
    this._nb_steps                         = nb_steps;
    this._min_timeout                      = min_timeout;
    __SHINKEN_TEMPLATE_HTML_PROGRESS_BAR__ = __SHINKEN_TEMPLATE_HTML_PROGRESS_BAR__.replace( "$$$$__COLLAPSE__TITLE__$$$$", _( "progress_bar.toggle_display_message_label", [DICTIONARY_COMMON_UI] ) );
    dom_element_parent.innerHTML           = __SHINKEN_TEMPLATE_HTML_PROGRESS_BAR__;
    this._dom_element                      = dom_element_parent.querySelector( ".shinken-popup-progress-bar-container" );
    this._dom_progress_bar                 = this._dom_element.querySelector( ".shinken-progress-bar" );
    this._dom_title                        = this._dom_element.querySelector( ".shinken-popup-title" );
    this._dom_message                      = this._dom_element.querySelector( ".shinken-progress-bar-message" );
    this.starting_time                     = null;
    this.initPhase( this._dom_element );
    this.setPhase( SHINKEN.OBJECT.CONST.PHASE.HIDDEN );
};
SHINKEN.OBJECT.Progressbar.prototype = {
    //********************************  INIT    ******************************************************************//
    reset    : function () {
        this._timeout_run                          = null;
        this._current_step                         = 0;
        this._dom_element.dataset.messageDisplayed = "0";
        this.initSteps();
    },
    initSteps: function () {
        this._steps = [];
        for ( var i = 0; i <= this._nb_steps; i++ ) {
            this._steps.push( new SHINKEN.OBJECT.ProgressbarStep( i ) );
        }
    },
    //********************************  GETTER SETTER    ******************************************************************//
    setParamStep    : function ( step, to_set ) {
        this._steps[ step ].setParam( to_set );
    },
    setMessageStep  : function ( step, to_set ) {
        this._steps[ step ].setMessage( to_set );
    },
    setTitleStep    : function ( step, to_set ) {
        this._steps[ step ].setTitle( to_set );
    },
    callbackForPhase: function () {
        var _current = this.getCurrentPhase();
        switch ( _current ) {
            case SHINKEN.OBJECT.CONST.PHASE.HIDDEN:
                this.reset();
                break;
        }
    },
    //********************************  OTHERS    ******************************************************************//
    kill    : function () {
        DOM.Service.removeElement(this._dom_element);
    },
    //********************************  PROGRESS    ******************************************************************//
    doProgress: function ( expected_step, phase, param, message, title ) {
        if ( expected_step === 1 ) {
            this.reset();
            this.setPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING );
        }
        var _step = this._steps[ expected_step ];
        _step.setPhase( phase );
        _step.setParam( param );
        _step.setMessage( message );
        _step.setTitle( title );
        _step.askForRun();
        this._run();
    },
    _run      : function () {
        if ( this._timeout_run ) {
            return;
        }
        if ( !this._steps[ this._current_step + 1 ].needToBeRun() ) {
            return;
        }
        if ( this.isPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING_NOK ) ) {
            return;
        }
        this._current_step++;
        var _current_step = this._steps[ this._current_step ];
        this._parent.doActionWhenProgressStart( this._current_step, _current_step.getParam(), this );
        this._updateHtml( _current_step );
        
        var self          = this;
        this._timeout_run = setTimeout( function () {
            self._parent.doActionWhenProgressEnd( self._current_step, _current_step.getParam(), self );
            self._timeout_run = null;
            if ( self._current_step < self._nb_steps ) {
                self._run();
            }
        }, this._min_timeout );
    },
    //********************************  UPDATE HTML    ******************************************************************//
    _updateHtml   : function ( current_step ) {
        if ( current_step.getPhase() ) {
            this.setPhase( current_step.getPhase() );
        }
        if ( current_step.getTitle() ) {
            this._dom_title.innerHTML = current_step.getTitle();
        }
        if ( current_step.getMessage() ) {
            this._dom_message.innerHTML = current_step.getMessage();
        }
        this._updateBarHtml();
    },
    _updateBarHtml: function () {
        DOM.Service.setStyle( this._dom_progress_bar, DOM.CONST.STYLE.WIDTH, (this._current_step / this._nb_steps * 100) + "%" );
        DOM.Service.setDataSet( this._dom_element, "isComplete", (this._current_step === this._nb_steps) ? "1" : "0" );
    }
};

SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.Progressbar, SHINKEN.OBJECT.PhaseInterface );


SHINKEN.OBJECT.ProgressbarStep           = function ( index ) {
    this._index        = index;
    this._phase        = null;
    this._title        = null;
    this._message      = null;
    this._param        = null;
    this._run_expected = false;
};
SHINKEN.OBJECT.ProgressbarStep.prototype = {
    //********************************  GETTER SETTER    ******************************************************************//
    setPhase   : function ( to_set ) {
        if ( to_set !== undefined ) {
            this._phase = to_set;
        }
    },
    setMessage : function ( to_set ) {
        if ( to_set !== undefined ) {
            this._message = to_set;
        }
    },
    getTitle   : function ( to_set ) {
        return this._title;
    },
    setTitle   : function ( to_set ) {
        if ( to_set !== undefined ) {
            this._title = to_set;
        }
    },
    getMessage : function ( to_set ) {
        return this._message;
    },
    setParam   : function ( to_set ) {
        if ( to_set !== undefined ) {
            this._param = to_set;
        }
    },
    askForRun  : function () {
        this._run_expected = true;
    },
    needToBeRun: function () {
        return this._run_expected;
    },
    getParam   : function () {
        return this._param;
    },
    getPhase   : function () {
        return this._phase;
    }
};


SHINKEN.OBJECT.ProgressbarInterface           = function () {
};
SHINKEN.OBJECT.ProgressbarInterface.prototype = {
    doActionWhenProgressStart        : function ( current_step, param, progress_bar_object ) {
        if ( current_step === progress_bar_object._nb_steps ) {
            this.doActionWhenProgressionIsComplete( progress_bar_object );
        }
        this._doActionWhenProgressStart( current_step, param );
    },
    doActionWhenProgressEnd          : function ( current_step, param, progress_bar_object ) {
        if ( current_step === progress_bar_object._nb_steps - 1 && progress_bar_object.isPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING_OK ) ) {
            progress_bar_object.doProgress( progress_bar_object._nb_steps );
        }
        this._doActionWhenProgressEnd( current_step, param );
    },
    _doActionWhenProgressStart       : function ( current_step, param ) {
    },
    _doActionWhenProgressEnd         : function ( current_step, param ) {
    },
    doActionWhenProgressionIsComplete: function ( progress_bar_object ) {
        progress_bar_object.setPhaseWithTimeOut( SHINKEN.OBJECT.CONST.PHASE.HIDDEN, 2000 );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.PhaseInterface, SHINKEN.OBJECT.ShinkenObject );

var __SHINKEN_TEMPLATE_HTML_PROGRESS_BAR__ = '<div class="shinken-popup-progress-bar-container shinken-parent-event-listener" data-controller="common_ui" data-message-displayed="0">\n' +
                                             '    <div class="shinken-popup-title"></div>\n' +
                                             '    <div class="shinken-progress-bar-container">\n' +
                                             '        <div class="shinken-progress-bar"></div>\n' +
                                             '    </div>\n' +
                                             '    <div class="shinken-popup-success-icon shinicon shinicon-check-circle"></div>\n' +
                                             '    <div class="shinken-collapse-button-container">\n' +
                                             '        <div class="shinken-button-container">\n' +
                                             '            <div class="shinken-button shinken-popup-message-detail-collapse" onclick="MANAGER.EventManager.clickOnButton(event)" data-name="toggle_display_popup_progress_bar_message">\n' +
                                             '                <div class="shinken-display-table">\n' +
                                             '                    <div class="shinken-display-table-cell">\n' +
                                             '                        <span class="">$$$$__COLLAPSE__TITLE__$$$$</span>\n' +
                                             '                    </div>\n' +
                                             '                </div>\n' +
                                             '            </div>\n' +
                                             '        </div>\n' +
                                             '    </div>\n' +
                                             '    <div class="shinken-popup-close">\n' +
                                             '        <div class="shinken-button-container">\n' +
                                             '            <div class="shinken-button" onclick="MANAGER.EventManager.clickOnButton(event)" data-name="close_popup_progress_bar">\n' +
                                             '                <div class="shinken-display-table">\n' +
                                             '                    <div class="shinken-display-table-cell"><span class=""><span class="shinkon shinkon-times"></span></span></div>\n' +
                                             '                </div>\n' +
                                             '            </div>\n' +
                                             '        </div>\n' +
                                             '    </div>\n' +
                                             '    <div class="shinken-progress-bar-message"></div>\n' +
                                             '</div>';
