//priority 3
//__lib__ lib_common
'use strict';
SHINKEN.OBJECT.ShinkenObject           = function () {
    this.__class_name__ = 'SHINKEN.OBJECT.ShinkenObject';
};
SHINKEN.OBJECT.ShinkenObject.prototype = {
    //********************************************  DEBUG   **************************************************//
    setShinkenDebug : function ( to_set ) {
        this.is_shinken_debug = to_set;
        var _components       = this.getChildrenObject();
        for ( var i = 0, _size_i = _components.length; i < _size_i; i++ ) {
            if ( _components[ i ] ) {
                _components[ i ].setShinkenDebug( to_set );
            }
        }
    },
    isShinkenDebugOn: function () {
        return this.is_shinken_debug;
    },
    //********************************************  SETTER GETTER   **************************************************//
    getChildrenObject    : function () {
        return [];
    },
    getChildrenObjectDict: function () {
        return {};
    },
    setMessages          : function ( to_set ) {
        this.messages = new OBJECT.Messages();
        if ( !to_set ) {
            return;
        }
        var _keys = Object.keys( to_set );
        var _current_key;
        for ( var i = 0, _size_i = _keys.length; i < _size_i; i++ ) {
            _current_key = _keys[ i ];
            for ( var j = 0, _size_j = to_set[ _current_key ].length; j < _size_j; j++ ) {
                this.messages.addMessage( OBJECT.MessageService.parseBackendStatus( _current_key ), to_set[ _current_key ][ j ] );
            }
        }
    },
    //********************************************  VALIDATION   **************************************************//
    setNeedValidation: function ( to_set ) {
        this.need_validation = to_set;
        var _components      = this.getChildrenObject();
        for ( var i = 0, _size_i = _components.length; i < _size_i; i++ ) {
            _components[ i ].setNeedValidation( to_set );
        }
    },
    //********************************************  OTHER   **************************************************//
    getObjectClassName: function () {
        return this.__class_name__;
    }
};


SHINKEN.OBJECT.ShinkenObjectJson           = function () {
    this.__class_name__ = 'SHINKEN.OBJECT.ShinkenObjectJson';
};
SHINKEN.OBJECT.ShinkenObjectJson.prototype = {
    parseToJson               : function () {
        var _to_return = this.getObjectToJson();
        
        var _components = this.getChildrenObjectDict();
        
        
        if ( Array.isArray( _components ) ) {
            _to_return = [];
            for ( var i = 0, _size_i = _components.length; i < _size_i; i++ ) {
                _to_return.push( _components[ i ].parseToJson() );
            }
        }
        else {
            var _keys = Object.keys( _components );
            var _current_key;
            for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
                _current_key = _keys[ i ];
                if ( Array.isArray( _components[ _current_key ] ) ) {
                    _to_return[ _current_key ] = [];
                    for ( var j = 0, _size_j = _components[ _current_key ].length; j < _size_j; j++ ) {
                        _to_return[ _current_key ].push( _components[ _current_key ][ j ].parseToJson() );
                    }
                }
                else if ( _components[ _current_key ] ) {
                    _to_return[ _current_key ] = _components[ _current_key ].parseToJson();
                }
            }
        }
        this.computeJsonLength( _to_return );
        return _to_return;
    },
    computeJsonLength         : function ( dict ) {
        this.json_length = SHINKEN.TOOLS.STRING.JSON.getFormattedLineNumber( dict );
    },
    getAllMessagesWithLineJson: function ( index_parent ) {
        var to_return = [];
        var _index    = index_parent ? index_parent + 1 : 1;
        if ( this.messages ) {
            var _message_current = this.messages.getAllMessages();
            for ( var i = 0, _size_i = _message_current.length; i < _size_i; i++ ) {
                _message_current[ i ].setLineIndex( _index );
            }
            to_return = _message_current;
        }
        var _components = this.getChildrenObject();
        for ( var j = 0, _size_j = _components.length; j < _size_j; j++ ) {
            if ( _components[ j ] ) {
                to_return = SHINKEN.TOOLS.ARRAY.concat( to_return, _components[ j ].getAllMessagesWithLineJson( _index ) );
                _index    = _index + _components[ j ].json_length;
            }
        }
        return to_return;
    },
    getUnknownValue           : function () {
        return this.unknown_property;
    },
    setUnknownValue           : function ( key, value ) {
        if ( !this.unknown_property ) {
            this.unknown_property = {};
        }
        this.unknown_property[ key ] = value;
    },
    getObjectToJson           : function () {
        var _to_return = this._getObjectToJson() || {};
        if ( this.unknown_property ) {
            SHINKEN.TOOLS.DICT.assign( _to_return, this.unknown_property );
        }
        return _to_return;
    },
    _getObjectToJson          : function () {
        return {};
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.ShinkenObjectJson, SHINKEN.OBJECT.ShinkenObject );

SHINKEN.OBJECT.InterfaceHtml           = function () {
};
SHINKEN.OBJECT.InterfaceHtml.prototype = {
    //********************************************  GETTER SETTER  *****************************************************//
    addClass: function ( toAdd ) {
        if ( !this.class ) {
            this.class = toAdd;
        }
        else {
            this.class = this.class + " " + toAdd;
        }
    }
};