//__lib__ lib_common
'use strict';

SHINKEN.OBJECT.Refresh = function ( countdown, parent, do_once ) {
    this.parent_object     = parent;
    this.countdown         = countdown || 60000;
    this.countdown_tic     = 1000;
    this.current_countdown = this.countdown;
    this.do_once           = do_once || true;
    this.ui_components     = [];
    this.phase             = new SHINKEN.OBJECT.Phase( this );
    this.interval_tic_tac  = null;
};

SHINKEN.OBJECT.Refresh.prototype = {
    //********************************************  GETTER SETTER  *****************************************************//
    addUiComponent    : function ( to_add ) {
        this.ui_components.push( to_add );
    },
    getPercent        : function () {
        return (1 - this.current_countdown / this.countdown) * 100;
    },
    setLastComputeDate: function ( to_set ) {
        for ( var i = 0, _size_i = this.ui_components.length; i < _size_i; i++ ) {
            this.ui_components[ i ].setLastComputeDate( to_set );
        }
    },
    //********************************************  ACTIONS  *****************************************************//
    askParentPhaseUpdated: function () {
        if ( !this.ui_components ) {
            return;
        }
        for ( var i = 0, _size_i = this.ui_components.length; i < _size_i; i++ ) {
            this.ui_components[ i ].phaseUpdated( this.phase.current_phase );
        }
    },
    //********************************************  COMPUTE  *****************************************************//
    updateCountdown: function () {
        if ( this.phase.isPhase( SHINKEN.OBJECT.CONST.PHASE.STUCK ) ) {
            return;
        }
        this.current_countdown -= this.countdown_tic;
        this.current_countdown = Math.max( this.current_countdown, 0 );
        for ( var i = 0, _size_i = this.ui_components.length; i < _size_i; i++ ) {
            this.ui_components[ i ].updateCountdown( this );
        }
    },
    reset          : function () {
        clearInterval( this.interval_tic_tac );
        this.current_countdown = this.countdown;
    },
    tictac         : function () {
        var _phase_value = this.phase.current_phase;
        this.updateCountdown();
        if ( this.current_countdown <= 0 ) {
            switch ( _phase_value ) {
                case SHINKEN.OBJECT.CONST.PHASE.RUNNING:
                    this.phase.setPhase( SHINKEN.OBJECT.CONST.PHASE.REFRESHING );
                    break;
                case SHINKEN.OBJECT.CONST.PHASE.HIDDEN:
                    if ( !SHINKEN.NAVIGATOR.isNavigatorHidden() ) {
                        this.phase.setPhase( SHINKEN.OBJECT.CONST.PHASE.REFRESHING );
                    }
                    break;
            }
        }
    },
    //********************************************  OTHERS  *****************************************************//
    callbackForPhase: function () {
        this.askParentPhaseUpdated();
        switch ( this.phase.current_phase ) {
            case SHINKEN.OBJECT.CONST.PHASE.RUNNING :
                var _self = this;
                if ( this.phase.previous_phase !== SHINKEN.OBJECT.CONST.PHASE.EDITING ) {
                    this.reset();
                }
                this.interval_tic_tac = setInterval( function () {
                    _self.tictac();
                }, this.countdown_tic );
                break;
            case SHINKEN.OBJECT.CONST.PHASE.REFRESHING :
                if ( SHINKEN.NAVIGATOR.isNavigatorHidden() ) {
                    this.phase.setPhase( SHINKEN.OBJECT.CONST.PHASE.HIDDEN );
                }
                else {
                    clearInterval( this.interval_tic_tac );
                    if ( this.parent_object ) {
                        this.parent_object.refresh();
                    }
                }
                break;
            case SHINKEN.OBJECT.CONST.PHASE.EDITING :
                clearInterval( this.interval_tic_tac );
                break;
        }
    }
};

SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.Refresh, SHINKEN.OBJECT.PhaseInterface );