//__lib__ lib_common
'use strict';

SHINKEN_GRID.Cells           = function ( data ) {
    this.init( data );
};
SHINKEN_GRID.Cells.prototype = {
    init: function ( data ) {
        this.content      = [];
        this.mapping_uuid = {};
        if ( data ) {
            this.initData( data );
        }
    },
    
    //********************************************  EVENT LISTENER  *****************************************************//
    computeNewPosition: function ( uuid ) {
        if ( this.mapping_uuid[ uuid ] ) {
            this.mapping_uuid[ uuid ].getClosestPosition();
        }
    },
    //********************************************  GETTER SETTER  *****************************************************//
    getChildrenObject    : function () {
        return this.content;
    },
    getChildrenObjectDict: function () {
        return this.content;
    },
    //********************************************  OTHERS  *****************************************************//
    
    //********************************************  COMPUTE  *****************************************************//
    computeMapping: function ( mapping ) {
        for ( var i = 0, _size_i = this.content.length; i < _size_i; i++ ) {
            this.content[ i ].computeMapping( mapping );
        }
    },
    updateSize    : function ( tile_pixel_size ) {
        for ( var i = 0, _size_i = this.content.length; i < _size_i; i++ ) {
            this.content[ i ].updateSize( tile_pixel_size );
        }
    },
    //********************************************  SAVE  *****************************************************//
    
    //********************************************  HTML   **************************************************//
    computeHtml: function ( shinken_grid, extra_class ) {
        for ( var i = 0, _size_i = this.content.length; i < _size_i; i++ ) {
            DOM.Service.addElementTo( this.content[ i ].computeHtml( shinken_grid, extra_class ) );
        }
    },
    //********************************************  UPDATE DATA   **************************************************//
    initData      : function ( data ) {
        for ( var i = 0, _size_i = data.length; i < _size_i; i++ ) {
            this.addCell( data[ i ] );
        }
    },
    addCell       : function ( data ) {
        var _to_return = new SHINKEN_GRID.Cell( data );
        this.content.push( _to_return );
        this.mapping_uuid[ _to_return.uuid ] = _to_return;
        return _to_return;
    },
    addHiddenCell : function ( pos_x, pos_y ) {
        var data                                              = {};
        data[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_X ] = pos_x;
        data[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_Y ] = pos_y;
        data[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.HEIGHT ]     = 1;
        data[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.WIDTH ]      = 1;
        data[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.CONTENT ]    = { type: WIDGET.CONST.WIDGET_TYPE.SHINKEN_GRID_STRUCTURE, content: pos_x + "-" + pos_y };
        var _cell                                             = this.addCell( data );
        _cell.type                                            = WIDGET.CONST.WIDGET_TYPE.SHINKEN_GRID_STRUCTURE;
        _cell.addClass( WIDGET.CONST.WIDGET_TYPE.SHINKEN_GRID_STRUCTURE );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_GRID.Cells, SHINKEN.OBJECT.ShinkenObjectJson );