#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2021:
# This file is part of Shinken Enterprise, all rights reserved.

import hashlib
import os

import shutil

SLA_DATABASE_PY = u'/var/lib/shinken/modules/sla/component/sla_database.py'

THIS_FOLDER = os.path.dirname(os.path.abspath(__file__))
PATCHED_FILES_FOLDER = os.path.join(THIS_FOLDER, 'patched_files')


def md5(file_name):
    hash_md5 = hashlib.md5()
    with open(file_name, u'rb') as f:
        for chunk in iter(lambda: f.read(4096), b''):
            hash_md5.update(chunk)
    return hash_md5.hexdigest()


def main():
    # print 'searching base version'
    
    sla_database_md5 = md5(u'%s' % SLA_DATABASE_PY)
    known_hash = [f for f in os.listdir(PATCHED_FILES_FOLDER)]
    
    if sla_database_md5 not in known_hash:
        # print 'The file %s is not a 02.08.01 known file. The surpatch will not be executed' % SLA_DATABASE_PY
        return 1
    

    shutil.copy(os.path.join(PATCHED_FILES_FOLDER, sla_database_md5, 'sla_database.py'), '%s' % SLA_DATABASE_PY)
    
    print 'The file %s has been patched' % SLA_DATABASE_PY
    return 0


if __name__ == '__main__':
    exit(main())
