#!/usr/bin/python

# -*- coding: utf-8 -*-

# Copyright (C) 2009-2012:
#    Gabes Jean, naparuba@gmail.com
#    Gerhard Lausser, Gerhard.Lausser@consol.de
#    Gregory Starck, g.starck@gmail.com
#    Hartmut Goebel, h.goebel@goebel-consult.de
#
# This file is part of Shinken.
#
# Shinken is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# Shinken is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with Shinken.  If not, see <http://www.gnu.org/licenses/>.

"""
This class is for looking in the configuration for auth
"""

from shinken.basemodule import BaseModule

from shinken.log import logger
from shinken.misc.type_hint import TYPE_CHECKING

if TYPE_CHECKING:
    from shinken.misc.type_hint import Dict, Union
    from synchronizer.synchronizerdaemon import Synchronizer
    from webui.module import WebuiBroker
    from shinken.objects.config import Config

properties = {
    u'daemons': [u'webui', u'synchronizer-ui', u'synchronizer'],
    u'type'   : u'cfg_password_webui'
}


# called by the plugin manager
def get_instance(plugin):
    logger.info(u'[Cfg Password UI] Get an CFG/Password Authentication module for plugin %s' % plugin.get_name())
    
    instance = DatabaseAuthenticationModule(plugin)
    return instance


class DatabaseAuthenticationModule(BaseModule):
    
    def __init__(self, modconf):
        # type: (Config) -> None
        BaseModule.__init__(self, modconf)
        self.app = None  # type: (Union[None, Synchronizer, WebuiBroker])
        self.logger_auth = self.logger.get_sub_part(u'AUTHENTICATION')
    
    
    def do_loop_turn(self):
        # type: () -> None
        # function for typing
        pass
    
    
    # To load the webui application
    def load(self, app):
        # type: (Union[Synchronizer, WebuiBroker]) -> None
        self.app = app
    
    
    def check_auth(self, username, password, requester, authentication_phase_id):
        # type: (unicode, unicode, unicode, unicode) -> Union[bool, Dict]
        
        authentication_logger = self.logger_auth.get_sub_part(requester)
        
        authentication_logger.debug(u'Trying to authenticate username "%s" in database ( authentication phase %s )' % (username, authentication_phase_id))
        
        shinken_contact = self.app.datamgr.get_contact(username)
        
        # Ok, if the user is bad, bailout
        if not shinken_contact:
            authentication_logger.debug(u'User "%s" tried to connect but this user doesn\'t exist in Shinken database ( authentication phase %s )' % (username, authentication_phase_id))
            return False
        
        # shinken_contact is a dict   -> Module is on Synchronizer
        # shinken_contact is a Object -> module is on WebUI
        if isinstance(shinken_contact, dict):
            password_in_base = shinken_contact.get(u'password', u'')
            contact_name = shinken_contact[u'contact_name']
        else:
            password_in_base = shinken_contact.password
            contact_name = shinken_contact.contact_name
        
        authentication_logger.debug(u'User "%s" was found in database ( authentication phase %s )' % (username, authentication_phase_id))
        
        if password_in_base and password_in_base == password:
            authentication_logger.debug(u'Credentials for "%s" are OK. Authenticated as shinken user "%s" ( authentication phase %s )' % (username, contact_name, authentication_phase_id))
            return shinken_contact
        
        authentication_logger.debug(u'Credentials for "%s" failed. Password is not the same in database ( authentication phase %s )' % (username, authentication_phase_id))
        return False
