%name        = rule['name']
%prefix_name = rule['prefix_name']
%state      = rule['state']
%errors     = rule['errors']
%use         = rule['use']
%bad_keys   = rule['bad_keys']
%conditions  = rule['conditions']
%from discoveryrules import INVALID_STATE, WARNING_STATE, BAD_CONDITION_ERROR, NOT_APPLIED_ERROR, MISSING_NAME_ERROR, ILLEGAL_CHARS_ERROR, WARNING_RULES_STATES

%if state == INVALID_STATE:
    %state_translation = 'element.invalid'
    %data_state = state
%else:
    %state_translation = 'element.' + state
    %if state in WARNING_RULES_STATES:
        %data_state = WARNING_STATE
    %else:
        %data_state = state
    %end
%end
<tr class="table-hover shinken-table-element" role="row" data-state="{{data_state}}">
    <td class="shinken-col-status" data-th="{{mod._('source.status')}}">
        <span class="tag" data-state="{{data_state}}">{{mod._(state_translation)}}</span>
    </td>
    <td class="shinken-col-rule" data-th="{{mod._('source.rule_number')}}">
        {{mod._('element.rule')}} {{elt_number}}
    </td>
    %if not bad_keys:
        <td class="shinken-col-name" data-th="{{mod._('source.name')}}">
            %if not name and MISSING_NAME_ERROR in errors:
                <span class="shinken-name-error">{{mod._('error.error')}}</span>
                <span>{{mod._('element.missing_name')}}</span>
            %else:
                <span>{{name}}</span>
            %end
        </td>
        <td class="shinken-col-conditions" data-th="{{mod._('source.conditions')}}">
            <ol class="table-hover shinken-content-list" role="row" >
                %if conditions:
                    %for condition in conditions:
                        <li data-th="{{mod._('source.conditions')}}">
                            %if BAD_CONDITION_ERROR in errors:
                                %if condition.get('error', ''):
                                    <span class="shinken-condition-error">{{mod._('error.error')}}</span>
                                    <span>{{mod._(condition['error']) % condition['number']}}: {{condition['expression']}}</span>
                                %end
                            %else:
                                <span>{{condition['expression']}}</span>
                            %end
                        </li>
                    %end
                %elif NOT_APPLIED_ERROR in errors:
                    <span class="shinken-condition-error">{{mod._('error.error')}}</span>
                    <span>{{mod._('error.no_condition')}}</span>
                %end
            </ol>
        </td>
        %if not use and not prefix_name and NOT_APPLIED_ERROR in errors:
            <td colspan="2" class="shinken-col-not-applied" data-th="{{mod._('source.not_applied')}}">
                <span class="shinken-use-and-prefix-error">{{mod._('error.error')}}</span>
                <span>{{mod._('error.no_model_or_prefix')}}</span>
            </td>
        %else:
            <td class="shinken-col-use" data-th="{{mod._('source.use')}}">
                %if use:
                    %for model in use:
                        %if ILLEGAL_CHARS_ERROR in errors:
                            %if mod.discovery_rules_manager.contains_illegal_chars(model):
                                <span class="shinken-illegal-chars-error">{{mod._('error.error')}}</span>
                                <span>{{mod._('error.illegal_chars_model') % model}}</span>
                            %end
                        %else:
                            <div class="tag template" title="">
                                {{!app.helper.get_tag_img(model, img_size="list-tag-img")}}
                                {{model}}
                            </div>
                        %end
                    %end
                %end
            </td>
            <td class="shinken-col-prefix" data-th="{{mod._('source.prefix')}}">
                %if ILLEGAL_CHARS_ERROR in errors and mod.discovery_rules_manager.contains_illegal_chars(prefix_name):
                    <span class="shinken-illegal-chars-error">{{mod._('error.error')}}</span>
                    <span>{{mod._('error.illegal_chars')}}</span>
                %else:
                    <span>{{prefix_name}}</span>
                %end
            </td>
        %end
    %else:
        <td colspan="4" class="shinken-col-bad-keys">
            <ol class="table-hover shinken-content-list" role="row" >
                %for key in bad_keys:
                <li>
                    <span class="shinken-bad-keys-error">{{mod._('error.error')}}</span>
                    <span>{{mod._('error.unknown_key') % key}}</span>
                </li>
                %end
            </ol>
        </td>
    %end
</tr>
