#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2019
# This file is part of Shinken Enterprise, all rights reserved.

import bson
import pymongo

from component.sla_common import shared_data
from sla_module_broker import SLAModuleBroker
from sla_module_webui import SLAModuleWebUI
from livedata_module_sla_provider import LivedataModuleSlaProvider


# called by the plugin manager to get a module instance
def get_instance(configuration, module_on, module_type, display_info=True, already_archived=False):
    shared_data.set_already_archived(already_archived)
    
    if not pymongo.has_c():
        raise Exception(u'Your pymongo lib has not the C extension installed')
    if not bson.has_c():
        raise Exception(u'Your bson lib has not the C extension installed')
    
    if (module_type == u'sla' and module_on == u'broker') or module_type == u'sla_broker_writer':
        return SLAModuleBroker(configuration, display_info=display_info)
    elif (module_type == u'sla' and module_on == u'webui') or module_type == u'sla_webui_reader':
        return SLAModuleWebUI(configuration, display_info=display_info)
    elif module_type == u'livedata_module_sla_provider':
        return LivedataModuleSlaProvider(configuration)
