#!/usr/bin/python
# -*- coding: utf-8 -*-

# Copyright (C) 2013-2020:
# This file is part of Shinken Enterprise, all rights reserved.


from shinken.misc.type_hint import TYPE_CHECKING

try:
    from shinken.synchronizer.component.abstract_component import AbstractComponent
    from shinken.synchronizer.synchronizer_mongo_conf import SynchronizerMongoConf
except ImportError:
    from synchronizer.component.abstract_component import AbstractComponent
    from synchronizer.synchronizer_mongo_conf import SynchronizerMongoConf

if TYPE_CHECKING:
    from shinken.objects import Module as ShinkenModuleDefinition
    from shinken.misc.type_hint import NoReturn
    from shinkensolutions.ssh_mongodb.mongo_conf import MongoConf
    from .logger_component import LoggerComponent


class ConfigurationComponent(AbstractComponent):
    
    def __init__(self, conf, mongo_conf, logger):
        # type: (ShinkenModuleDefinition, MongoConf, LoggerComponent) -> None
        self._logger = logger
        self._conf = conf
        self._mongo_conf = mongo_conf
    
    
    # *****************************   INIT  ************************************************************#
    def init(self):
        # type: () -> NoReturn
        pass
    
    
    # -- MONGO
    def get_mongo_configuration(self, logger=None):
        return self._mongo_conf
