#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2018
# This file is part of Shinken Enterprise, all rights reserved.

from shinken.misc.type_hint import TYPE_CHECKING
from shinkensolutions.ssh_mongodb.mongo_client import MongoClient

try:
    from shinken.synchronizer.component.abstract_component import AbstractComponent
except ImportError:
    from synchronizer.component.abstract_component import AbstractComponent

if TYPE_CHECKING:
    from shinken.log import PartLogger
    from .configuration_component import ConfigurationComponent


class MongoComponent(AbstractComponent, MongoClient):
    def __init__(self, logger, configuration_component, requester):
        # type: (PartLogger, ConfigurationComponent, str) -> None
        MongoClient.__init__(self, configuration_component.get_mongo_configuration(logger=logger), logger=logger)
        self.requester = requester
    
    
    def init(self):
        # type: () -> None
        MongoClient.init(self, self.requester)
