#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2022
# This file is part of Shinken Enterprise, all rights reserved.

import json

from shinken.log import logger
from shinken.misc.type_hint import TYPE_CHECKING

if TYPE_CHECKING:
    from shinken.misc.type_hint import Optional
    from webui.module import WebuiBroker

app = None  # type: Optional[WebuiBroker]


def GET_usersave():
    user = app.get_user_auth()
    
    # Get mongodb collection for such entries
    tiles_collection = app.get_tiles_collection()
    if not tiles_collection:
        app.abort(500, 'No more backend for saving the data')
        return
    
    user_without_pass = user.copy()
    if hasattr(user_without_pass, 'password'):
        setattr(user_without_pass, 'password', '****************')
    
    # Our main key is the username
    tiles = [e for e in tiles_collection.find({'user': user.get_name()})]
    
    # if no previous entries, None is good
    if len(tiles) == 0:
        return '%s' % json.dumps(None)
    
    # New style, one real object
    if len(tiles) == 1:
        return '%s' % json.dumps(tiles[0])
    
    # old one, migration from old code spotted
    return '%s' % json.dumps(tiles)


def DELETE_usersave():
    user = app.get_user_auth()
    
    # Get mongodb collection for such entries
    col = app.get_tiles_collection()
    if not col:
        app.abort(500, 'No more backend for saving the data')
        return
    
    col.remove({'user': user.get_name()})
    logger.warning('deleting old format user [%s] data' % user.get_name())


def __sort_widgets(w1, w2):
    order = ["detail", "sla", "sla_full", "depgraph", "problems", "graphs", "iframe", "360"]
    n1 = w1['name']
    n2 = w2['name']
    if n1 in order and n2 in order:
        return cmp(order.index(n1), order.index(n2))
    return cmp(n1, n2)


def GET_widget_list():
    widgets = app.widgets['dashboard']
    widgets.sort(__sort_widgets)
    return json.dumps(widgets, indent=4)


def GET_versions():
    from shinkensolutions.localinstall import VERSION
    d = {'backend'  : '00.06.00',
         'framework': VERSION
         }
    return json.dumps(d)


pages = {
    GET_usersave   : {'routes': ['/usersave/', '/usersave', '/tiles/', '/tiles'], 'wrappers': ['auth', 'json']},
    DELETE_usersave: {'routes': ['/usersave/', '/usersave', '/tiles/', '/tiles'], 'method': 'DELETE', 'wrappers': ['auth', 'json']},
    GET_widget_list: {'routes': ['/api/widgets/'], 'method': 'GET', 'wrappers': ['json']},
    GET_versions   : {'routes': ['/api/versions/'], 'method': 'GET', 'wrappers': ['json']},
}
