//'use strict';

SHINKEN_METRIC.List           = function () {
    // list_metric
    // series_size
    // size
    // list_metric_warning
    // list_metric_critical
    // nb_columns
    // nb_lines
    // graph_min
    // graph_max
    this.time_range;
    this.show_trending = false;
    
    this.init();
};
SHINKEN_METRIC.List.prototype = {
    init                  : function () {
        this.list_metric = [];
        this.size        = 0;
        this.series_size = 0;
        //this.list_metric_warning  = {};
        //this.list_metric_critical = {};
        
        //this._computeListWarningAndCritical();
    },
    initData              : function ( data ) {
        this.size = data.length;
        var object;
        for ( var i = 0; i < this.size; i++ ) {
            object = new SHINKEN_METRIC.Object();
            object.init( data[ i ] );
            this.list_metric[ i ] = object;
        }
        this.computeSeries();
    },
    computeSeries         : function () {
        this.series_size = 0;
        this.series      = [];
        var _series;
        var _size;
        for ( var i = 0; i < this.size; i++ ) {
            _series = this.list_metric[ i ].getSeries();
            _size   = _series.length;
            this.series_size += _size;
            for ( var j = 0; j < _size; j++ ) {
                this.series.push( _series[ j ] );
            }
        }
    },
    getMetric             : function ( index ) {
        return this.list_metric[ index ];
    },
    getMetricByUUID       : function ( uuid_metric, metric ) {
        var _current_metric;
        for ( var i = 0; i < this.size; i++ ) {
            _current_metric = this.list_metric[ i ];
            if ( _current_metric.getUUID() === uuid_metric && _current_metric.getMetric() === metric ) {
                return _current_metric;
            }
        }
        return false;
    },
    setGraphMin           : function ( value ) {
        this.graph_min = value;
    },
    setGraphMax           : function ( value ) {
        this.graph_max = value;
    },
    buildPanelMetrics     : function () {
        this.dom_element_container = document.getElementById( 'container' );
        this.dom_element           = document.getElementById( 'panel-metrics' );
        var widget_width           = this.dom_element_container.dataset.widgetWidth;
        var widget_height          = this.dom_element_container.dataset.widgetHeight;
        
        var max_height_panel = widget_height * SHINKEN_METRIC.CONST.SIZE.MAX_HEIGHT_PERCENT;
        var _width_column    = SHINKEN_METRIC.CONST.SIZE.WIDTH_COLUMN;
        var _height_lines    = SHINKEN_METRIC.CONST.SIZE.HEIGHT_LINE;
        
        this.nb_columns = Math.floor( widget_width / _width_column );
        this.nb_lines   = Math.ceil( this.series_size / this.nb_columns );
        
        var _height_panel_container = this.nb_lines * _height_lines;
        var isScrollable            = _height_panel_container > max_height_panel;
        
        this.dom_element.innerHTML = this.buildTabHtml();
        
        if ( isScrollable ) {
            this.dom_element.style.maxHeight        = max_height_panel;
            this.dom_element_container.style.height = widget_height - max_height_panel;
        }
        else {
            this.dom_element_container.style.height = widget_height - _height_panel_container - 18;
        }
        this.dom_element_container.style.width = widget_width;
    },
    buildTabHtml          : function () {
        
        var _current_metric;
        var index_metric = 0;
        var _number      = 0;
        var _to_return = "<table>";
        for ( var i = 0; i < this.nb_lines; i++ ) {
            _to_return += "<tr>";
            for ( var j = 0; j < this.nb_columns; j++ ) {
                index_metric = i + j * this.nb_lines;
                if ( index_metric >= this.series_size ) {
                    break;
                }
                if ( _number >= this.series_size ) {
                    break;
                }
                _current_metric = this.series[ index_metric ];
                
                _to_return += _current_metric.createCellPanelMetric().outerHTML;
                _number++;
            }
            _to_return += "</tr>";
        }
        _to_return += "</table>";
        return _to_return;
    },
    getDomElementContainer: function () {
        return this.dom_element_container;
    },
    add_widgets_graph     : function () {
        this.time_range = '-1d';
        setResetExtremes( false );
        var _current_metrics;
        for ( var i = 0; i < this.size; i++ ) {
            _current_metrics = this.getMetric( i );
            _current_metrics.loadMetric( this.time_range, this.show_trending );
        }
    },
    createHighChartGraph  : function () {
        var _dom_ccontainer = $( '#container' );
        __val_fix_min_scale = this.graph_min;
        __val_fix_max_scale = this.graph_max;
        
        _dom_ccontainer.highcharts( 'StockChart', {
            scrollbar    : {
                enabled: false
            },
            credits      : {
                enabled: false
            },
            xAxis        : {
                ordinal : false,
                minRange: 5 * 60 * 10000
            },
            yAxis        : {
                startOnTick: false,
                max        : __val_fix_max_scale,
                min        : __val_fix_min_scale
            },
            rangeSelector: {
                allButtonsEnabled: true,
                selected         : 1,
                buttons          : [
                    {
                        type : 'minute',
                        count: 60,
                        text : _( 'graphics.hour' )
                    },
                    {
                        type: 'all',
                        text: _( 'graphics.day' )
                    }
                ]
            }
        } );
    }
};
var __instance_list_metric    = new SHINKEN_METRIC.List();