var FORM = {};

FORM.graphic = function () {
    this.initGraph();
    this.initDom();
    this.initForm();
};

FORM.graphic.prototype = {
    initDom: function () {
        this.domYMinLabel       = document.querySelector( '.shinken-column-ymin-value-cell .shinken-column-ymin-value-cell-label' );
        this.domYMaxLabel       = document.querySelector( '.shinken-column-ymax-value-cell .shinken-column-ymax-value-cell-label' );
        this.dom_element        = document.querySelector( '.shinken-form' );
        this.dom_scale_selector = this.dom_element.querySelector( '.shinken-graphics-scale-cell .shinken-graphics-scale-selector' );
        
        this.dom_ymin       = this.dom_element.querySelector( '.shinken-column-ymin-select-cell .shinken-column-ymin-selector' );
        this.dom_ymin_value = this.dom_element.querySelector( '.shinken-column-ymin-value-cell .shinken-column-ymin-value' );
        this.dom_ymax       = this.dom_element.querySelector( '.shinken-column-ymax-select-cell .shinken-column-ymax-selector' );
        this.dom_ymax_value = this.dom_element.querySelector( '.shinken-column-ymax-value-cell .shinken-column-ymax-value' );
    },
    //********************************************  EVENTS              ************************************************//
    clickOnItemSelector : function ( event, parent_name, dom_element ) {
        var _name  = event.target.name;
        var _value = this.dom_element[ _name ].value;
        this.handleItemSelector( _name, _value );
    },
    handleItemSelector  : function ( name, _value ) {
        DOM.Service.setDataSet( this.dom_element, name, _value );
        var nameHasMatch = false;
        
        switch ( name ) {
            case CONTROLLER.REPORT_FORM.CONST.FIELD.SCALE:
                nameHasMatch = true;
                this.handleScaleSelector( _value );
                break;
            case CONTROLLER.REPORT_FORM.CONST.FIELD.YMIN:
                nameHasMatch = true;
                this.handleYminSelector( _value );
                break;
            case CONTROLLER.REPORT_FORM.CONST.FIELD.YMAX:
                nameHasMatch = true;
                this.handleYmaxSelector( _value );
                break;
        }
        if ( nameHasMatch ) {
            this.computeGraphicsWithJetlag();
        }
    },
    handleYmaxSelector  : function ( _value ) {
        var YMinMaxOpt;
        var currentScale = this.dom_scale_selector.value;
        var _to_set;
        switch ( _value ) {
            case CONTROLLER.REPORT_FORM.CONST.Y_MAX_OPTION.AUTO:
                YMinMaxOpt                       = CONTROLLER.REPORT_FORM.CONST.AUTO_SETTINGS[ currentScale ];
                this.dom_ymax.options[ 0 ].label = YMinMaxOpt.yMax.label;
                
                this.dom_ymax.options.selectedIndex = 0;
                this.dom_ymax_value.value           = YMinMaxOpt.yMax.valeur;
                this.domYMaxLabel.innerHTML         = CONTROLLER.REPORT_FORM.CONST.DEFAULT_SETTINGS[ YMinMaxOpt.yMax.option ].innerHTML;
                break;
            case CONTROLLER.REPORT_FORM.CONST.Y_MAX_OPTION.VALEUR:
                _to_set                             = CONTROLLER.REPORT_FORM.CONST.DEFAULT_SETTINGS[ _value ];
                this.dom_ymax.options.selectedIndex = _to_set.selectedIndex;
                this.dom_ymax_value.value           = _to_set.value;
                this.domYMaxLabel.innerHTML         = _to_set.innerHTML;
                this.dom_ymin_value.step            = 0.1;
                break;
            case CONTROLLER.REPORT_FORM.CONST.Y_MAX_OPTION.MAXIMUM_SLA:
            case CONTROLLER.REPORT_FORM.CONST.Y_MAX_OPTION.SEUIL_CRITIC:
            case CONTROLLER.REPORT_FORM.CONST.Y_MAX_OPTION.SEUIL_WARNING:
                _to_set                             = CONTROLLER.REPORT_FORM.CONST.DEFAULT_SETTINGS[ _value ];
                this.dom_ymax.options.selectedIndex = _to_set.selectedIndex;
                this.dom_ymax_value.value           = _to_set.value;
                this.domYMaxLabel.innerHTML         = _to_set.innerHTML;
                this.dom_ymin_value.step            = 0.1;
                break;
        }
    },
    handleYminSelector  : function ( _value ) {
        var YMinMaxOpt;
        var currentScale = this.dom_scale_selector.value;
        var _to_set;
        switch ( _value ) {
            case CONTROLLER.REPORT_FORM.CONST.Y_MIN_OPTION.AUTO:
                this.dom_ymin.options.selectedIndex = 0;
                YMinMaxOpt                          = CONTROLLER.REPORT_FORM.CONST.AUTO_SETTINGS[ currentScale ];
                this.dom_ymin.options[ 0 ].label    = YMinMaxOpt.yMin.label;
                this.dom_ymin_value.value           = YMinMaxOpt.yMin.valeur;
                this.domYMinLabel.innerHTML         = CONTROLLER.REPORT_FORM.CONST.DEFAULT_SETTINGS[ YMinMaxOpt.yMin.option ].innerHTML;
                break;
            case CONTROLLER.REPORT_FORM.CONST.Y_MIN_OPTION.VALEUR:
                _to_set                             = CONTROLLER.REPORT_FORM.CONST.DEFAULT_SETTINGS[ _value ];
                this.dom_ymin.options.selectedIndex = _to_set.selectedIndex;
                this.dom_ymin_value.value           = _to_set.value;
                this.domYMinLabel.innerHTML         = _to_set.innerHTML;
                this.dom_ymin_value.step            = 1;
                break;
            case CONTROLLER.REPORT_FORM.CONST.Y_MIN_OPTION.MINIMUM_SLA:
            case CONTROLLER.REPORT_FORM.CONST.Y_MIN_OPTION.SEUIL_CRITIC:
            case CONTROLLER.REPORT_FORM.CONST.Y_MIN_OPTION.SEUIL_CRITIC_CENTER:
            case CONTROLLER.REPORT_FORM.CONST.Y_MIN_OPTION.SEUIL_WARNING:
            case CONTROLLER.REPORT_FORM.CONST.Y_MIN_OPTION.SEUIL_WARNING_CENTER:
                _to_set                             = CONTROLLER.REPORT_FORM.CONST.DEFAULT_SETTINGS[ _value ];
                this.dom_ymin.options.selectedIndex = _to_set.selectedIndex;
                this.dom_ymin_value.value           = _to_set.value;
                this.domYMinLabel.innerHTML         = _to_set.innerHTML;
                this.dom_ymin_value.step            = 0.1;
                break;
        }
    },
    handleScaleSelector : function ( _value ) {
        var valueHasMatch = true;
        switch ( _value ) {
            case CONTROLLER.REPORT_FORM.CONST.GRAPHIC_SCALE_OPTION.AUTO:
                this.dom_scale_selector.options.selectedIndex = 0;
                valueHasMatch                                 = true;
                break;
            case CONTROLLER.REPORT_FORM.CONST.GRAPHIC_SCALE_OPTION.LINEARE:
                this.dom_scale_selector.options.selectedIndex = 1;
                valueHasMatch                                 = true;
                break;
            case CONTROLLER.REPORT_FORM.CONST.GRAPHIC_SCALE_OPTION.ZOOM_TOP:
                this.dom_scale_selector.options.selectedIndex = 2;
                valueHasMatch                                 = true;
                break;
            case CONTROLLER.REPORT_FORM.CONST.GRAPHIC_SCALE_OPTION.LOGARITHMIC:
                this.dom_scale_selector.options.selectedIndex = 3;
                valueHasMatch                                 = true;
                break;
        }
        if ( valueHasMatch ) {
            this.handleItemSelector( CONTROLLER.REPORT_FORM.CONST.FIELD.YMIN, CONTROLLER.REPORT_FORM.CONST.Y_MIN_OPTION.AUTO );
            this.handleItemSelector( CONTROLLER.REPORT_FORM.CONST.FIELD.YMAX, CONTROLLER.REPORT_FORM.CONST.Y_MAX_OPTION.AUTO );
        }
    },
    clickOnCheckboxInput: function ( name ) {
        DOM.Service.setDataSet( this.dom_element, name, this.dom_element[ name ].checked );
    },
    mouseEnter          : function ( event ) {
    },
    onChangeOnInput     : function ( event ) {
        var hasMatch = false;
        switch ( event.target.name ) {
            case CONTROLLER.REPORT_FORM.CONST.FIELD.YMIN_VALUE:
            case CONTROLLER.REPORT_FORM.CONST.FIELD.YMAX_VALUE:
                hasMatch = true;
                break;
        }
        if ( hasMatch ) {
            this.computeGraphicsWithJetlag();
        }
    },
    //********************************************  FORM                ************************************************//
    initForm: function () {
        this.handleItemSelector(
            CONTROLLER.REPORT_FORM.CONST.FIELD.SCALE,
            __previous_form_graphic.scale
        );
        this.handleItemSelector(
            CONTROLLER.REPORT_FORM.CONST.FIELD.YMAX,
            __previous_form_graphic.yMax
        );
        this.handleItemSelector(
            CONTROLLER.REPORT_FORM.CONST.FIELD.YMIN,
            __previous_form_graphic.yMin
        );
        this.dom_ymax_value.value = __previous_form_graphic.yMaxValue;
        this.dom_ymin_value.value = __previous_form_graphic.yMinValue;
    },
    //********************************************  PREVIEW GRAPHIC     ************************************************//
    initGraph                : function () {
        this.IDSetTimeoutJetlag = null;
        this.preview_graph_data = {
            graph_scale       : CONTROLLER.REPORT_FORM.CONST.GRAPHIC_SCALE_OPTION.ZOOM_TOP,
            yMax              : 100,
            yMin              : 99,
            date              : DATE_TIME.initHistoricArrayTimeStamp( 5 ),
            sla               : [99.7, 100, 99.2, 99.99, 44.12],
            threshold_warning : [99.8, 99.8, 99.8, 99.8, 99.8],
            threshold_critical: [99.5, 99.5, 99.5, 99.5, 99.5]
        };
        //TODO CEPA JE COMPRENDS PAS POURQUOI ON COMPUTE DANS L'INIT...
        this.computeGraphicsWithJetlag();
    },
    getGraphPreviewData      : function () {
        return this.preview_graph_data;
    },
    updateGraphPreviewData   : function ( calOptionGraph ) {
        SHINKEN.TOOLS.DICT.assign( this.preview_graph_data, {
            graph_scale: calOptionGraph.scale,
            yMax       : calOptionGraph.yMax,
            yMin       : calOptionGraph.yMin
        } );
        //TODO CEPA JE COMPRENDS PAS POURQUOI ca existe
    },
    getGraphicPreview        : function () { //TODO CEPA (NOMMAGE)
        var _graphic = Graphics.Graphic.factory(
            this.preview_graph_data.graph_scale,
            document.querySelector( '.shinken-graph-container[data-item-uuid="preview_uuid"]' )
        );
        _graphic.setXLegend( this.getGraphPreviewData()[ 'date' ] );
        _graphic.addLine( new Graphics.Curve.Sla( this.getGraphPreviewData()[ 'sla' ],
            CONTROLLER.REPORT_FORM.CONST.CURVE_SLA_OPTION
        ) );
        _graphic.addThreshold(
            Graphics.CONST.SLA.CURVE.THRESHOLD_WARNING.TYPE,
            new Graphics.Curve.Threshold( this.getGraphPreviewData()[ 'threshold_warning' ],
                CONTROLLER.REPORT_FORM.CONST.CURVE_THRESHOLD_WARNING_OPTION
            )
        );
        _graphic.addThreshold(
            Graphics.CONST.SLA.CURVE.THRESHOLD_CRITICAL.TYPE,
            new Graphics.Curve.Threshold( this.getGraphPreviewData()[ 'threshold_critical' ],
                CONTROLLER.REPORT_FORM.CONST.CURVE_THRESHOLD_CRITICAL_OPTION
            )
        );
        _graphic.setYMax( this.preview_graph_data.yMax );
        _graphic.setYMin( this.preview_graph_data.yMin );
        return _graphic;
    },
    computeGraphicsWithJetlag: function () {
        var self = this;
        if ( this.IDSetTimeoutJetlag !== null ) {
            clearTimeout( this.IDSetTimeoutJetlag );
            this.IDSetTimeoutTampon = null;
        }
        this.IDSetTimeoutTampon = setTimeout( function () {
            self.computeGraphics();
        }, 300 );
    },
    computeGraphics          : function () {
        var optForm        = this.getOptionForm();
        var calOptionGraph = this.calculYminYmaxFromOption( optForm );
        
        
        this.updateGraphPreviewData( calOptionGraph );
        
        var _graphic       = this.getGraphicPreview();
        var _configChartJs = _graphic.getChartJsData();
        if ( !this.graphic_preview ) {
            this.graphic_preview = new Graphics.ChartJSContainer(
                _graphic.dom_element,
                _configChartJs
            );
        }
        else {
            this.graphic_preview.updateData( _configChartJs );
        }
    },
    getOptionForm            : function () {
        var scale = this.dom_scale_selector.value;
        if ( scale === CONTROLLER.REPORT_FORM.CONST.GRAPHIC_SCALE_OPTION.AUTO ) {
            scale = CONTROLLER.REPORT_FORM.CONST.GRAPHIC_SCALE_OPTION.ZOOM_TOP;
        }
        var yMax = this.dom_ymax.value;
        if ( yMax === CONTROLLER.REPORT_FORM.CONST.Y_MAX_OPTION.AUTO ) {
            yMax = CONTROLLER.REPORT_FORM.CONST.AUTO_SETTINGS[ scale ].yMax.option;
        }
        var yMin = this.dom_ymin.value;
        if ( yMin === CONTROLLER.REPORT_FORM.CONST.Y_MIN_OPTION.AUTO ) {
            yMin = CONTROLLER.REPORT_FORM.CONST.AUTO_SETTINGS[ scale ].yMin.option;
        }
        
        return {
            scale    : scale,
            yMax     : yMax,
            yMaxValue: parseFloat( this.dom_ymax_value.value ),
            yMin     : yMin,
            yMinValue: parseFloat( this.dom_ymin_value.value )
        };
    },
    _max_of_not_null         : function ( tab, _default ) {
        var _to_return = null;
        for ( var i = 0, _size_i = tab.length; i < _size_i; i++ ) {
            if ( tab[ i ] === null || tab[ i ] === undefined ) {
                continue;
            }
            else if ( _to_return === null ) {
                _to_return = tab[ i ];
            }
            else if ( tab[ i ] > _to_return ) {
                _to_return = tab[ i ];
            }
        }
        if ( _to_return === null ) {
            return _default;
        }
        return _to_return;
    },
    _min_of_not_null         : function ( tab, _default ) {
        var _to_return = null;
        for ( var i = 0, _size_i = tab.length; i < _size_i; i++ ) {
            if ( tab[ i ] === null || tab[ i ] === undefined ) {
                continue;
            }
            else if ( _to_return === null ) {
                _to_return = tab[ i ];
            }
            else if ( tab[ i ] < _to_return ) {
                _to_return = tab[ i ];
            }
        }
        if ( _to_return === null ) {
            return _default;
        }
        return _to_return;
    },
    calculYMax               : function ( option ) {
        var _to_return = 100;
        switch ( option.yMax ) {
            case CONTROLLER.REPORT_FORM.CONST.Y_MAX_OPTION.VALEUR:
                _to_return = option.yMaxValue;
                break;
            case CONTROLLER.REPORT_FORM.CONST.Y_MAX_OPTION.MAXIMUM_SLA:
                _to_return = this._max_of_not_null(
                    this.preview_graph_data.sla,
                    CONTROLLER.REPORT_FORM.CONST.Y_VALUE_MAX
                ) + option.yMaxValue;
                break;
            case CONTROLLER.REPORT_FORM.CONST.Y_MAX_OPTION.SEUIL_CRITIC:
                _to_return = this._max_of_not_null(
                    this.preview_graph_data.threshold_critical,
                    CONTROLLER.REPORT_FORM.CONST.Y_VALUE_MAX
                ) + option.yMaxValue;
                break;
            case CONTROLLER.REPORT_FORM.CONST.Y_MAX_OPTION.SEUIL_WARNING:
                _to_return = this._max_of_not_null(
                    this.preview_graph_data.threshold_warning,
                    CONTROLLER.REPORT_FORM.CONST.Y_VALUE_MAX
                ) + option.yMaxValue;
                break;
        }
        return SHINKEN.TOOLS.NUMBER.getValueInInterval(
            _to_return,
            CONTROLLER.REPORT_FORM.CONST.Y_VALUE_MIN,
            CONTROLLER.REPORT_FORM.CONST.Y_VALUE_MAX
        );
    },
    calculYMin               : function ( option, y_max ) {
        var _to_return = 0;
        switch ( option.yMin ) {
            case CONTROLLER.REPORT_FORM.CONST.Y_MIN_OPTION.VALEUR:
                _to_return = option.yMinValue;
                break;
            case CONTROLLER.REPORT_FORM.CONST.Y_MIN_OPTION.MINIMUM_SLA:
                _to_return = this._min_of_not_null(
                    this.preview_graph_data.sla,
                    CONTROLLER.REPORT_FORM.CONST.Y_VALUE_MIN
                ) - option.yMinValue;
                break;
            case CONTROLLER.REPORT_FORM.CONST.Y_MIN_OPTION.SEUIL_CRITIC:
                _to_return = this._min_of_not_null(
                    this.preview_graph_data.threshold_critical,
                    CONTROLLER.REPORT_FORM.CONST.Y_VALUE_MIN
                ) - option.yMinValue;
                break;
            case CONTROLLER.REPORT_FORM.CONST.Y_MIN_OPTION.SEUIL_CRITIC_CENTER:
                var min_critic = this._min_of_not_null(
                    this.preview_graph_data.threshold_critical,
                    CONTROLLER.REPORT_FORM.CONST.Y_VALUE_MIN
                );
                _to_return     = y_max - (y_max - min_critic) * 2;
                break;
            case CONTROLLER.REPORT_FORM.CONST.Y_MIN_OPTION.SEUIL_WARNING:
                _to_return = this._min_of_not_null(
                    this.preview_graph_data.threshold_warning,
                    CONTROLLER.REPORT_FORM.CONST.Y_VALUE_MIN
                ) - option.yMinValue;
                break;
            case CONTROLLER.REPORT_FORM.CONST.Y_MIN_OPTION.SEUIL_WARNING_CENTER:
                var min_warn = this._min_of_not_null(
                    this.preview_graph_data.threshold_warning,
                    CONTROLLER.REPORT_FORM.CONST.Y_VALUE_MIN
                );
                _to_return   = y_max - (y_max - min_warn) * 2;
                break;
        }
        return SHINKEN.TOOLS.NUMBER.getValueInInterval(
            _to_return,
            CONTROLLER.REPORT_FORM.CONST.Y_VALUE_MIN,
            CONTROLLER.REPORT_FORM.CONST.Y_VALUE_MAX
        );
    },
    calculYminYmaxFromOption : function ( option ) {
        var _to_return  = {
            scale: option.scale,
            yMax : 100,
            yMin : 0
        };
        _to_return.yMax = this.calculYMax( option );
        _to_return.yMin = this.calculYMin( option, _to_return.yMax );
        
        if ( _to_return.yMax < _to_return.yMin ) {
            _to_return.yMax = 100;
            _to_return.yMin = this.calculYMin( option, _to_return.yMax );
        }
        
        if ( _to_return.yMax === _to_return.yMin ) {
            _to_return.yMax += 0.01;
            _to_return.yMin -= 0.01;
        }
        
        _to_return.yMax = SHINKEN.TOOLS.NUMBER.getValueInInterval(
            _to_return.yMax,
            CONTROLLER.REPORT_FORM.CONST.Y_VALUE_MIN,
            CONTROLLER.REPORT_FORM.CONST.Y_VALUE_MAX
        );
        _to_return.yMin = SHINKEN.TOOLS.NUMBER.getValueInInterval(
            _to_return.yMin,
            CONTROLLER.REPORT_FORM.CONST.Y_VALUE_MIN,
            CONTROLLER.REPORT_FORM.CONST.Y_VALUE_MAX
        );
        
        if ( _to_return.yMin === 0 &&
             (option.scale === CONTROLLER.REPORT_FORM.CONST.GRAPHIC_SCALE_OPTION.AUTO ||
              option.scale === CONTROLLER.REPORT_FORM.CONST.GRAPHIC_SCALE_OPTION.ZOOM_TOP)
        ) {
            _to_return.scale = CONTROLLER.REPORT_FORM.CONST.GRAPHIC_SCALE_OPTION.LINEARE;
        }
        
        return _to_return;
    }
};
