//********************************************  DOM IS READY   ******************************************************//

document.addEventListener( "DOMContentLoaded", function ( e ) {
    "use strict";
    try {
        doActionWhenDomReady();
    }
    catch ( e ) {
        console.warn( "NO ACTION EXPECTED WHEN DOM READY", e );
    }
} );
var doActionWhenDomReady                           = function ( e ) {
    "use strict";
    CONTROLLER.ReportForm.init();
};
MANAGER.DistributorControllerManager.getController = function () {
    return CONTROLLER.ReportForm;
};

CONTROLLER.ReportForm = (function ( self ) {
    "use strict";
    self.controller_name      = 'report_form';
    self.datagraph            = null;
    self.form_graphic         = null;
    //********************************************  INIT            **************************************************//
    self.init                 = function () {
        self.form_graphic = new FORM.graphic();
    };
    //********************************************  EVENT LISTENER  **************************************************//
    self.keydown              = function ( event, key_code ) {
    };
    self.onFocusOut           = function ( event ) {
    };
    self.clickOnRadioBtn      = function ( event ) {
    };
    self.clickOnCheckboxInput = function ( event ) {
        var _name = event.target.name;
        switch ( _name ) {
            case CONTROLLER.REPORT_FORM.CONST.FIELD.DAILY_SLA_GRAPH :
                self.form_graphic.clickOnCheckboxInput( _name );
                break;
        }
    };
    self.onChangeOnInput      = function ( event ) {
    };
    self.mouseEnter           = function ( event ) {
        self.form_graphic.mouseEnter( event );
    };
    self.clickOnItemSelector  = function ( event, parent_name, dom_element ) {
        switch ( parent_name ) {
            case CONTROLLER.REPORT_FORM.CONST.FIELD.DATA_TYPE :
            case CONTROLLER.REPORT_FORM.CONST.FIELD.SCALE :
            case CONTROLLER.REPORT_FORM.CONST.FIELD.YMIN :
            case CONTROLLER.REPORT_FORM.CONST.FIELD.YMAX :
                self.form_graphic.clickOnItemSelector( event, parent_name, dom_element );
                break;
        }
    };
    self.clickOnInput         = function ( event ) {
    };
    self.clickOnPaste         = function ( event ) {
    };
    self.onClick              = function ( event ) {
    };
    self.onChangeOnInput      = function ( event ) {
        self.form_graphic.onChangeOnInput( event );
    };
    //********************************************  DO ACTION    ******************************************************//
    return self;
})
( CONTROLLER.ReportForm || {} );
