//********************************************  DOM IS READY   ******************************************************//

document.addEventListener( "DOMContentLoaded", function ( e ) {
    "use strict";
    try {
        doActionWhenDomReady();
    }
    catch ( e ) {
        console.warn( "NO ACTION EXPECTED WHEN DOM READY", e );
    }
} );

var doActionWhenDomReady = function ( e ) {
    "use strict";
    CONTROLLER.ReportWeb.init();
};

// ********************** RESIZE GRAPH DURING PRINT **************************//
function beforePrint () {
    var _body         = document.querySelector( 'body' );
    _body.style.width = '1080';
    Chart.helpers.each( Chart.instances, function ( chart ) {
        chart._printing = true;
        chart.resize();
        chart.update();
    } );
}

function afterPrint () {
    var _body         = document.querySelector( 'body' );
    _body.style.width = '100%';
    Chart.helpers.each( Chart.instances, function ( chart ) {
        chart._printing = false;
        chart.resize();
        chart.update();
    } );
}

window.onbeforeprint = beforePrint;
window.onafterprint  = afterPrint;

// *************** CONTROLLER ****************************//

CONTROLLER.ReportWeb = (function ( self ) {
    "use strict";
    self.controller_name    = 'report_web';
    self.graphics           = [];
    //********************************************  INIT  **************************************************//
    self.getGraphicFromData = function ( data ) {
        var _dom               = document.querySelector( '.shinken-graph-container[data-item-uuid="' + data.item_uuid + '"]' );
        var _to_return         = Graphics.Graphic.factory(
            data.scale_type,
            _dom
        );
        _to_return.has_no_data = data.no_data_graph;
        _to_return.setXLegend( data.xAxes );
        _to_return.addLine( new Graphics.Curve.Sla( data.sla.yAxes,
            CONTROLLER.REPORT_FORM.CONST.CURVE_SLA_OPTION
        ) );
        _to_return.addThreshold(
            Graphics.CONST.SLA.CURVE.THRESHOLD_WARNING.TYPE,
            new Graphics.Curve.Threshold( data.warning_thresholds.yAxes,
                CONTROLLER.REPORT_FORM.CONST.CURVE_THRESHOLD_WARNING_OPTION
            )
        );
        _to_return.addThreshold(
            Graphics.CONST.SLA.CURVE.THRESHOLD_CRITICAL.TYPE,
            new Graphics.Curve.Threshold( data.critical_thresholds.yAxes,
                CONTROLLER.REPORT_FORM.CONST.CURVE_THRESHOLD_CRITICAL_OPTION
            )
        );
        _to_return.setYMax( data.yMax );
        _to_return.setYMin( data.yMin );
        return _to_return;
    };
    self.init               = function () {
        var lineType  = [
            CONTROLLER.REPORT_FORM.CONST.GRAPHIC_SCALE_OPTION.LINEARE,
            CONTROLLER.REPORT_FORM.CONST.GRAPHIC_SCALE_OPTION.LOGARITHMIC,
            CONTROLLER.REPORT_FORM.CONST.GRAPHIC_SCALE_OPTION.ZOOM_TOP
        ];
        self.graphics = [];
        var _graphic  = {};
        var _config   = {};
        var data      = {};
        for ( var i = 0, _size = __reporting_data_graph.length; i < _size; i++ ) {
            data = __reporting_data_graph[ i ];
            if ( data.no_data_graph ) {
                continue;
            }
            // data.sla.yAxes                 = data.sla.yAxes.map( function ( y ) {
            //     return Math.random() * 0.1 + 99.9;
            // } );
            // data.sla.yAxes[ 5 ]            = 40;
            // data.sla.yAxes[ 8 ]            = 100;
            // data.sla.yAxes[ 9 ]            = 99.84;
            // data.sla.yAxes[ 10 ]           = 99.85;
            // data.sla.yAxes[ 11 ]           = 99.86;
            // data.sla.yAxes[ 12 ]           = 60;
            // data.sla.yAxes[ 16 ]           = 0;
            // data.sla.yAxes[ 20 ]           = 70;
            // data.critical_thresholds.yAxes = data.critical_thresholds.yAxes.map( function ( y ) {
            //     return 99.95;
            // } );
            // data.warning_thresholds.yAxes  = data.warning_thresholds.yAxes.map( function ( y ) {
            //     return 99.98;
            // } );
            // data.yMax       = 70;
            // data.yMin       = 35;
            // data.scale_type = lineType[ i % 3 ];
            // ---
            _graphic = self.getGraphicFromData( data );
            _config  = _graphic.getChartJsData();
            self.graphics.push( new Graphics.ChartJSContainer(
                _graphic.dom_element,
                _config
            ) );
        }
    };
    //********************************************  EVENT LISTENER  **************************************************//
    //********************************************  DO ACTION    ******************************************************//
    return self;
})
( CONTROLLER.ReportWeb || {} );
