'use strict';

Graphics.Graphic = {};

Graphics.Graphic.Interface = function () {
    this.__class_name__ = 'Graphics.Graphic.Interface';
    this.lines          = [];
    this.thresholds     = {};
    this.legends        = { x: [], y: [] };
};

Graphics.Graphic.Interface.prototype = {
    initCommon: function () {
        this.lines                      = [];
        this.thresholdsIndexes          = {};
        this.uniqueLineIndexes          = {};
        this.legends                    = { x: [] };
        this.y_min                      = 0;
        this.y_max                      = 100;
        this.nb_label_max_display_graph = NB_LABEL_MAX_DISPLAY_GRAPH;
        this.nb_data_max                = NB_DATA_MAX_GRAPH;
        this.tooltip_caret_pos          = { x: 0, y: 0 };
        this.tooltip_is_display         = false;
    },
    //********************************************  GETTER SETTER   ********************************************//
    setXLegend            : function ( to_add ) {
        this.legends.x   = to_add;
        this.data_labels = undefined; // delete memoized value
        this.computeIndexIsDisplayMultiple();
    },
    addLine               : function ( to_add ) {
        to_add.setNbDataMax( this.nb_data_max );
        this.lines.push( to_add );
    },
    addThreshold          : function ( type, to_add ) {
        to_add.setNbDataMax( this.nb_data_max );
        this.thresholdsIndexes[ type ] = this.lines.push( to_add ) - 1;
    },
    addUniqueLine         : function ( id, to_add ) {
        to_add.setNbDataMax( this.nb_data_max );
        if ( this.uniqueLineIndexes[ id ] ) {
            this.lines[ this.uniqueLineIndexes[ id ] ] = to_add;
        }
        else {
            this.uniqueLineIndexes[ id ] = this.lines.push( to_add ) - 1;
        }
    },
    setNbDataMax          : function ( nb_data_max ) {
        this.nb_data_max = nb_data_max;
        this.data_labels = undefined; // delete memoized value
        for ( var i = 0, _size_i = this.lines.length; i < _size_i; i++ ) {
            this.lines[ i ].setNbDataMax( nb_data_max );
        }
    },
    __takeLastMaxData     : function ( arr ) {
        return SHINKEN.TOOLS.ARRAY.takeLast( arr, this.nb_data_max );
    },
    setYMin               : function ( value ) {
        this.y_min = this._getYValueInterval( value );
    },
    setYMax               : function ( value ) {
        this.y_max = this._getYValueInterval( value );
    },
    _checkYminYmax        : function () {
    },
    _getYValueInterval    : function ( value ) {
        return SHINKEN.TOOLS.NUMBER.getValueInInterval(
            value,
            CONTROLLER.REPORT_FORM.CONST.Y_VALUE_MIN,
            CONTROLLER.REPORT_FORM.CONST.Y_VALUE_MAX
        );
    },
    getDrawYMin           : function () {
        return this.y_min;
    },
    getDrawYMax           : function () {
        return this.y_max;
    },
    getNbLabelMaxDisplay  : function () {
        return this.nb_label_max_display_graph;
    },
    setDomElement         : function ( dom_element ) {
        var canvas         = dom_element.querySelector( 'canvas' );
        this.dom_element   = dom_element;
        this.canvas_width  = canvas.clientWidth;
        this.canvas_height = canvas.clientHeight;
        // up new Chart ?
    },
    getThresholdCurve     : function ( type_threshold ) {
        if ( this.thresholdsIndexes[ type_threshold ] !== undefined ) {
            return this.lines[ this.thresholdsIndexes[ type_threshold ] ];
        }
        return null;
    },
    getThresholdFirstValue: function ( type_threshold ) {
        return this.getThresholdCurve( type_threshold ).getOriginalData( 0 );
    },
    _isThresholdByIndex   : function ( index_line ) {
        var _keys = Object.keys( this.thresholdsIndexes );
        var _current_key;
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current_key = _keys[ i ];
            if ( this.thresholdsIndexes[ _current_key ] === index_line ) {
                return true;
            }
        }
        return false;
    },
    //********************************************  GET TRANSFORMED    ********************************************//
    getDrawYMinTransformed     : function () {
        return this.getTransformedValue( this.getDrawYMin() ); //TODO CEPA pourquoi un param ici?
    },
    getDrawYMaxTransformed     : function () {
        return this.getTransformedValue( this.getDrawYMax() ); //TODO CEPA pourquoi un param ici?
    },
    getDrawThresholdTransformed: function ( type_threshold ) {
        return this.getTransformedValue( this.getThresholdFirstValue( type_threshold ) );
    },
    //********************************************  COMPUTE   ********************************************//
    computeFinal                 : function () {
        for ( var i = 0, _size_i = this.lines.length; i < _size_i; i++ ) {
            this.lines[ i ].computeFinal( this );
        }
    },
    getTransformedValue          : function ( value ) {
        return value;
    },
    computeIndexIsDisplayMultiple: function () { //TODO CEPA nommage
        this.multiple_display_value = Math.ceil( this.legends.x.length / this.getNbLabelMaxDisplay() ); //TODO CEPA nommage
        if ( this.multiple_display_value < 0 ) {
            this.multiple_display_value = 1;
        }
    },
    indexIsDisplay               : function ( i ) {
        return (i % this.multiple_display_value) === 0;
    },
    yIsInGraph                   : function ( y ) {
        return y >= this.getDrawYMin() && y <= this.getDrawYMax();
    },
    distance2D                   : function ( a, b ) {
        var dx = a.x - b.x;
        var dy = a.y - b.y;
        return Math.sqrt( dx * dx + dy * dy );
    },
    //********************************************  SPECIFIC CHART JS DRAW     ************************************//
    chartJs_extractPointsModelOfMeta: function ( _meta ) { //TODO CEPA nommage
        /*
        * After draw chartJs add meta data to datasets,
        * in this meta data you can find points positions on canvas
        * */
        var _to_return = [];
        
        var _keys = Object.keys( _meta );
        var _current_key;
        var _data;
        for ( var j = 0, _size = _keys.length; j < _size; j++ ) {
            _current_key = _keys[ j ];
            _data        = _meta[ _current_key ].data;
            
            for ( var i = 0, _size_i = _data.length; i < _size_i; i++ ) {
                _to_return.push( _data[ i ]._model );
            }
            return _to_return;
        }
        return _to_return;
    },
    chartJs_valueToDrawFromModels   : function ( _model, color, y ) { //TODO CEPA nommage
        var _round = Math.round( y * Graphics.CONST.ROUND_VALUE.IN_GRAPH_BASE) / Graphics.CONST.ROUND_VALUE.IN_GRAPH_BASE;
        return {
            x    : _model.x - Graphics.CONST.CANVAS.OFFSET.VALUE_X,
            y    : _model.y - Graphics.CONST.CANVAS.OFFSET.VALUE_Y,
            label: _round + ADDON_VALUE,
            color: color
        };
    },
    chartJs_valuesToDrawFromModels  : function ( _models, colors, yValues ) { //TODO CEPA nommage
        var _to_return = [];
        
        for ( var i = 0, _size_i = _models.length; i < _size_i; i++ ) {
            _to_return.push( this.chartJs_valueToDrawFromModels( _models[ i ], colors[ i ], yValues[ i ] ) );
        }
        
        return _to_return;
    },
    chartJs_initPosIntersectTooltip : function ( tooltipModel ) {
        var offAll           = 2;
        var offWidthText     = 40;
        var offHeightText    = 10;
        this.tooltip_opacity = tooltipModel.opacity;
        this.tooltip_xinf    = tooltipModel.x - offAll - offWidthText;
        this.tooltip_xsup    = tooltipModel.x + tooltipModel.width + offAll;
        this.tooltip_yinf    = tooltipModel.y - offAll;
        this.tooltip_ysup    = tooltipModel.y + tooltipModel.height + offAll + offHeightText;
    },
    chartJs_posIntersectTooltip     : function ( pos ) {
        if ( this.tooltip_opacity === 0 ) {
            return false;
        }
        return this.tooltip_xinf < pos.x && pos.x < this.tooltip_xsup &&
               this.tooltip_yinf < pos.y && pos.y < this.tooltip_ysup;
    },
    chartJs_initCanvasDraw          : function ( canvasDom, cfg ) { //TODO CEPA Pourquoi ici?
        this.canvasDrawCfg = SHINKEN.TOOLS.DICT.assigns( {}, [Graphics.CONST.CANVAS.DRAW_BASE, cfg || {}] );
        this.canvas2D      = canvasDom;
    },
    chartJs_canvasDraw              : function ( toDraw ) {  //TODO CEPA Ca redevient compliqué
        var _old           = this.canvas2D.fillStyle;
        this.canvas2D.font = this.canvasDrawCfg.fontType + ' ' + this.canvasDrawCfg.fontSize + "px " + this.canvasDrawCfg.fontName;
        if ( this.canvasDrawCfg.backgroundRect ) {
            this.canvas2D.fillStyle = this.canvasDrawCfg.backgroundRectColor;
            this.canvas2D.fillRect(
                toDraw.x - this.canvasDrawCfg.marginRect,
                toDraw.y - this.canvasDrawCfg.fontSize + this.canvasDrawCfg.marginRect,
                this.canvasDrawCfg.fontSize * toDraw.label.length * 0.5 + this.canvasDrawCfg.marginRect * 2,
                this.canvasDrawCfg.fontSize + this.canvasDrawCfg.marginRect * 2
            );
        }
        this.canvas2D.fillStyle = toDraw.color;
        this.canvas2D.fillText( toDraw.label, toDraw.x, toDraw.y, 600 );
        this.canvas2D.fillStyle = _old;
    },
    chartJs_canvasDrawLineValues    : function ( chart ) { //TODO CEPA Ca redevient compliqué
        var datasets = chart.config.data.datasets;
        var dataset;
        for ( var i = 0, _size_i = datasets.length; i < _size_i; i++ ) {
            if ( i >= this.lines.length ) {
                continue;
            }
            dataset     = datasets[ i ];
            var line    = this.lines[ i ];
            var colors  = line.getPointsBackground();
            var yValues = line.getOriginalDatas();
            
            if ( this.lines[ i ].__class_name__ !== 'Graphics.Curve.Threshold' ) {
                var _models      = this.chartJs_extractPointsModelOfMeta( dataset._meta );
                var valuesToDraw = this.chartJs_valuesToDrawFromModels( _models, colors, yValues );
                
                for ( var j = 0, _size_j = valuesToDraw.length; j < _size_j; j++ ) {
                    if ( this.indexIsDisplay( j ) &&
                         !this.chartJs_posIntersectTooltip( valuesToDraw[ j ] ) &&
                         this.yIsInGraph( yValues[ j ] ) ) {
                        this.chartJs_canvasDraw( valuesToDraw[ j ] );
                    }
                }
            }
        }
    },
    chartJs_drawVerticalLineTooltip : function ( chart ) {
        if ( !this.tooltip_is_display ) {
            return;
        }
        var datasets = chart.config.data.datasets;
        var _model_closer_caret_tooltip;
        
        var dataset;
        for ( var i = 0, _size_i = datasets.length; i < _size_i; i++ ) {
            if ( i >= this.lines.length ) {
                continue;
            }
            dataset = datasets[ i ];
            
            if ( this.lines[ i ].__class_name__ !== 'Graphics.Curve.Threshold' ) {
                var _models                 = this.chartJs_extractPointsModelOfMeta( dataset._meta );
                var _model;
                _model_closer_caret_tooltip = _models[ 0 ];
                for ( var j = 0, _size_j = _models.length; j < _size_j; j++ ) {
                    _model = _models[ j ];
                    if ( Math.abs( this.tooltip_caret_pos.x - _model.x ) < Math.abs( this.tooltip_caret_pos.x - _model_closer_caret_tooltip.x ) ) {
                        _model_closer_caret_tooltip = _model;
                    }
                }
                break;
            }
        }
        if ( _model_closer_caret_tooltip === undefined ) {
            return;
        }
        
        var _old_lineWidth   = chart.ctx.lineWidth;
        var _old_strokeStyle = chart.ctx.strokeStyle;
        
        chart.ctx.lineWidth   = Graphics.CONST.TOOLTIP.VERTICAL_LINE.lineWidth;
        chart.ctx.strokeStyle = Graphics.CONST.TOOLTIP.VERTICAL_LINE.strokeStyle;
        
        chart.ctx.beginPath();
        chart.ctx.moveTo( _model_closer_caret_tooltip.x, chart.scales[ 'y-axis-0' ].bottom );
        chart.ctx.lineTo( _model_closer_caret_tooltip.x, chart.scales[ 'y-axis-0' ].top );
        chart.ctx.stroke();
        
        chart.ctx.lineWidth   = _old_lineWidth;
        chart.ctx.strokeStyle = _old_strokeStyle;
    },
    chartJs_animationOnComplete     : function ( chart ) {
    },
    //********************************************  SPECIFIC CHART JS GETTER   ************************************//
    getChartJsData                              : function () {
        this.computeFinal();
        var _to_return = this.chartJs_getDefaultConfig();
        
        //x legends
        _to_return.data.labels = this.chartJs_getLabels();
        _to_return.options.scales.xAxes.push( this.chartJs_getXOptions() );
        _to_return.options.scales.yAxes.push( this.chartJs_getYOptions() );
        
        //x datas
        _to_return.data.datasets     = this.chartJs_getDatasets();
        //options
        _to_return.options.layout    = this.chartJs_getLayoutOptions();
        _to_return.options.tooltips  = this.chartJs_getTooltipOptions();
        _to_return.options.animation = this.chartJs_getAnimationOptions();
        
        return _to_return;
    },
    chartJs_getLabels                           : function () {
        if ( this.data_labels === undefined ) {
            this.data_labels = this.__takeLastMaxData( this.legends.x );
        }
        return this.data_labels;
    },
    chartJs_getDatasets                         : function () {
        var _to_return = [];
        for ( var i = 0, _size_i = this.lines.length; i < _size_i; i++ ) {
            _to_return.push( this.lines[ i ].chartJs_parseCurve() );
        }
        return _to_return;
    },
    chartJs_getDefaultConfig                    : function () {
        return {
            type   : 'line',
            data   : {
                labels  : [],
                datasets: []
            },
            options: {
                hover                      : {
                    animationDuration: 0
                },
                elements                   : {
                    line : {
                        tension    : 0.2,
                        borderWidth: LINE_SIZE
                    },
                    point: {
                        radius     : 0,
                        hoverRadius: 0
                    }
                },
                legend                     : {
                    display: false
                },
                tooltips                   : {
                    positioners    : {},
                    callbacks      : {
                        label     : function () {
                        },
                        title     : function () {
                        },
                        labelColor: function () {
                        }
                    },
                    custom         : function () {
                    },
                    mode           : 'index',
                    intersect      : false,
                    backgroundColor: 'rgba(0, 0, 0, 0.3)'
                },
                responsive                 : true,
                maintainAspectRatio        : false,
                responsiveAnimationDuration: 0,
                title                      : {
                    display: false
                },
                scales                     : {
                    yAxes: [],
                    xAxes: []
                },
                animation                  : {
                    duration: 0
                }
            }
        };
    },
    chartJs_getAnimationOptions                 : function () {
        var self        = this;
        var _onComplete = function () {
            self.canvas_width       = this.chart.ctx.canvas.clientWidth;
            self.canvas_height      = this.chart.ctx.canvas.clientHeight;
            self.tooltip_is_display = this.chart.tooltip._model.opacity > 0;
            
            self.chartJs_initPosIntersectTooltip( this.chart.tooltip._model );
            self.chartJs_initCanvasDraw( this.chart.ctx );
            
            self.chartJs_onCompleteCanvasDraw( this );
        };
        return {
            duration  : 0,
            onComplete: _onComplete
        };
    },
    chartJs_onCompleteCanvasDraw                : function ( chart ) {
        this.chartJs_drawVerticalLineTooltip( chart );
        this.chartJs_canvasDrawLineValues( chart );
        this.chartJs_animationOnComplete( chart );
    },
    chartJs_getTooltipOptions                   : function () {
        var self        = this;
        var _label      = function ( tooltipItem ) {
            return self.chartJs_getTooltipOptionsCallbacksLabel( tooltipItem );
        };
        var _title      = function ( tooltipItems ) {
            return self.chartJs_getTooltipOptionsCallbacksTitle( tooltipItems );
        };
        var _color      = function ( tooltipItem ) {
            return self.chartJs_getTooltipOptionsCallbacksColor( tooltipItem );
        };
        var _textColor  = function ( tooltipItem ) {
            return self.chartJs_getTooltipOptionsCallbacksTextColor( tooltipItem );
        };
        var _custom     = function ( tooltipItem ) {
            return self.chartJs_getTooltipOptionsCustom( tooltipItem );
        };
        var _afterLabel = function ( tooltipItem ) {
            return self.chartJs_getTooltipOptionsCallbacksAfterLabel( tooltipItem );
        };
        return {
            callbacks      : {
                label         : _label,
                title         : _title,
                labelColor    : _color,
                labelTextColor: _textColor,
                afterLabel    : _afterLabel
            },
            custom         : _custom,
            mode           : 'index',
            intersect      : false,
            backgroundColor: 'rgba(0, 0, 0, 0.3)'
        };
    },
    chartJs_getTooltipOptionsCallbacksAfterLabel: function ( tooltipItem ) {
        if ( tooltipItem.datasetIndex >= this.lines.length ) {
            return;
        }
        if ( !this._isThresholdByIndex( tooltipItem.datasetIndex ) ) {
            return Graphics.CONST.TOOLTIP.LABEL.textSeparator;
        }
        return '';
    },
    chartJs_getTooltipOptionsCallbacksLabel     : function ( tooltipItem ) {
        if ( tooltipItem.datasetIndex >= this.lines.length ) {
            return;
        }
        var _curve = this.lines[ tooltipItem.datasetIndex ];
        return _curve.getTooltipLabel( tooltipItem.index );
    },
    chartJs_getTooltipOptionsCallbacksTitle     : function ( tooltipItems ) {
        return DATE_TIME.FORMAT.get_date_from_timestamp( this.chartJs_getLabels()[ tooltipItems[ 0 ].index ] );
    },
    chartJs_getTooltipOptionsCallbacksColor     : function ( tooltipItem ) {
        if ( tooltipItem.datasetIndex >= this.lines.length ) {
            return;
        }
        var _curve = this.lines[ tooltipItem.datasetIndex ];
        return { backgroundColor: _curve.getColorTooltip() };
    },
    chartJs_getTooltipOptionsCallbacksTextColor : function ( tooltipItem ) {
        if ( tooltipItem.datasetIndex >= this.lines.length ) {
            return;
        }
        return Graphics.CONST.TOOLTIP.LABEL.textColor;
    },
    chartJs_getTooltipOptionsCustom             : function ( tooltipItem ) {
        this.tooltip_caret_pos.x = tooltipItem.caretX;
        this.tooltip_caret_pos.y = tooltipItem.caretY;
        if ( !this.canvas_width || tooltipItem.x > this.canvas_width / 2 ) {
            tooltipItem.x = 0;
        }
        else {
            tooltipItem.x = this.canvas_width - tooltipItem.width;
        }
        tooltipItem.y         = 0;
        tooltipItem.caretSize = 0;
        
        return tooltipItem;
    },
    chartJs_getLayoutOptions                    : function () {
        return {
            padding: this.chartJs_getLayoutPaddingOption()
        };
    },
    chartJs_getLayoutPaddingOption              : function () {
        return {
            left  : 0,
            right : 0,
            top   : CANVAS_MARGIN_TOP,
            bottom: 0
        };
    },
    chartJs_getXOptions                         : function () {
        var self      = this;
        var _callback = function ( value, index ) {
            return self.chartJs_getXTickOptionCallback( value, index );
        };
        return {
            gridLines: {
                color: "rgba(0, 0, 0, 0)"
            },
            ticks    : {
                // maxRotation  : 0,
                // minRotation  : 0,
                autoSkip: false,
                callback: _callback
            }
        };
    },
    chartJs_getYOptions                         : function () {
        return {
            type     : 'linear',
            gridLines: {
                color: "rgba(0, 0, 0, 0)"
            },
            ticks    : {
                display: false,
                min    : this.getDrawYMinTransformed(),
                max    : this.getDrawYMaxTransformed()
            }
        };
    },
    chartJs_getXTickOptionCallback              : function ( value, index ) {
        if ( !this.indexIsDisplay( index ) ) {
            return "";
        }
        return DATE_TIME.FORMAT.get_date_from_timestamp( value, DATE_TIME.FORMAT.DATE.NO_YEAR );
    }
};
Graphics.Graphic.factory             = function ( type, dom_element ) {
    var _to_return;
    switch ( type ) {
        case CONTROLLER.REPORT_FORM.CONST.GRAPHIC_SCALE_OPTION.AUTO:
        case CONTROLLER.REPORT_FORM.CONST.GRAPHIC_SCALE_OPTION.ZOOM_TOP:
            _to_return = new Graphics.Graphic.ZoomedWithCustomLegend();
            break;
        case CONTROLLER.REPORT_FORM.CONST.GRAPHIC_SCALE_OPTION.LOGARITHMIC:
            _to_return = new Graphics.Graphic.Logarithmic();
            break;
        case CONTROLLER.REPORT_FORM.CONST.GRAPHIC_SCALE_OPTION.LINEARE:
        default:
            _to_return = new Graphics.Graphic.LinearWithCustomLegend();
    }
    _to_return.setDomElement( dom_element );
    return _to_return;
};