'use strict';


Graphics.Graphic.Logarithmic           = function ( data ) {
    this.__class_name__ = 'Graphics.Graphic.Interface';
    this.init( data );
};
Graphics.Graphic.Logarithmic.prototype = {
    init: function ( data ) {
        this.initCommon( data );
        this.offsetLog = 0.1;
        this.y_min     = 0;
        this.y_max     = 100;
    },
    //********************************************  TRANSFORMATION   *****************************************//
    setYMin                       : function ( value ) {
    },
    setYMax                       : function ( value ) {
    },
    getTransformedValue           : function ( x ) {
        if ( x === null || x === undefined ) {
            return x;
        }
        return 100 - x + this.offsetLog;
    },
    chartJs_getYOptions           : function () {
        return {
            type     : 'logarithmic',
            gridLines: {
                color: "rgba(0, 0, 0, 0)"
                // lineWidth: 0.3
            },
            ticks    : {
                display: false,
                reverse: true,
                min    : this.getTransformedValue( 100 ),
                max    : this.getTransformedValue(-this.offsetLog)
            }
        };
    }
    //********************************************  LEGEND           *****************************************//
};
SHINKEN.TOOLS.CLASS.addPrototype( Graphics.Graphic.Logarithmic, Graphics.Graphic.WithCustomLegend );
