'use strict';


Graphics.Graphic.WithCustomLegend           = function ( data ) {
    this.__class_name__ = 'Graphics.Graphic.Interface';
    this.init( data );
};
Graphics.Graphic.WithCustomLegend.prototype = {
    init: function ( data ) {
        this.initCommon( data );
    },
    //********************************************  SPECIFIC CHART JS DRAW LEGEND *********************************//
    chartJs_legendValueLabel                    : function ( value ) {
        return SHINKEN.TOOLS.NUMBER.roundTo( value, Graphics.CONST.ROUND_VALUE.IN_GRAPH );
    },
    chartJs_completeLegendLabelWithOptionDefault: function ( label ) {
        return SHINKEN.TOOLS.DICT.assigns( {}, [Graphics.CONST.LEGEND.DEFAULT_CONFIG, label] );
    },
    chartJs_getLayoutPaddingOption              : function () {
        return {
            left  : LEGEND_CANVAS_MARGIN_LEFT,
            right : 0,
            top   : LEGEND_CANVAS_MARGIN_TOP,
            bottom: 0
        };
    },
    chartJs_onCompleteCanvasDraw                : function ( chart ) {
        this.chartJs_drawVerticalLineTooltip( chart );
        this.chartJs_canvasDrawLineValues( chart );
        this.chartJs_onCompleteDrawLegend( chart );
        this.chartJs_animationOnComplete( chart );
    },
    chartJs_getDatasets                         : function () {
        var _to_return = [];
        for ( var i = 0, _size_i = this.lines.length; i < _size_i; i++ ) {
            _to_return.push( this.lines[ i ].chartJs_parseCurve() );
        }
        return _to_return.concat( this.chartJs_getDatasetsToAddForLegend() );
    },
    chartJs_onCompleteDrawLegendGetDrawConf     : function () {
        return {
            fontName: "'Helvetica Neue', 'Helvetica', 'Arial', sans-serif",
            fontSize: 12
        };
    },
    chartJs_onCompleteDrawLegend                : function ( chart ) {
        var LEN_LABEL_MAX = 6; // 100.00 have six chars
        
        var datasets         = chart.config.data.datasets;
        var canvasdrawConfig = this.chartJs_onCompleteDrawLegendGetDrawConf();
        this.chartJs_initCanvasDraw( chart.chart.ctx, canvasdrawConfig );
        
        var labelsTodraw = this.chartJs_getLegendLabelsToDraw();
        
        var dataset;
        var labelToDraw;
        var _models;
        var p;
        var toDrawX;
        var toDraw;
        var toDraws = [];
        for ( var i = 0, _size_i = datasets.length; i < _size_i; i++ ) {
            dataset = datasets[ i ];
            
            for ( var j = 0, _size_j = labelsTodraw.length; j < _size_j; j++ ) {
                labelToDraw = labelsTodraw[ j ];
                if ( labelToDraw._meta_type === dataset[ '_meta_type' ] ) {
                    labelToDraw = this.chartJs_completeLegendLabelWithOptionDefault( labelToDraw );
                    _models     = this.chartJs_extractPointsModelOfMeta( dataset._meta );
                    if ( _models.length === 0 ) {
                        return;
                    }
                    p       = _models[ 0 ];
                    toDrawX = p.x - LEGEND_CANVAS_MARGIN_LEFT + labelToDraw.offsetX;
                    toDrawX = toDrawX + (LEN_LABEL_MAX - labelToDraw.label.length) * canvasdrawConfig.fontSize * 0.45;
                    toDraw  = {
                        x    : toDrawX,
                        y    : p.y + labelToDraw.offsetY,
                        label: labelToDraw.label,
                        color: labelToDraw.color
                    };
                    toDraws.push( toDraw );
                }
            }
        }
        toDraws.sort( function ( a, b ) {
            return a.y < b.y ? -1 : 1;
        } );
        for ( i = 1, _size_i = toDraws.length; i < _size_i; i++ ) {
            toDraws[ i ].y = Math.max( toDraws[ i ].y, toDraws[ i - 1 ].y + canvasdrawConfig.fontSize + 2 );
        }
        for ( i = 0, _size_i = toDraws.length; i < _size_i; i++ ) {
            toDraw = toDraws[ i ];
            if ( !this.chartJs_posIntersectTooltip( toDraw ) ) {
                this.chartJs_canvasDraw( toDraw );
            }
        }
    },
    chartJs_getDatasetsToAddForLegend           : function () {
        var upLegend          = {
            _meta_type      : Graphics.CONST.LEGEND.META_TYPE.LEGEND_UP,
            backgroundColor : "rgb(0, 0, 0, 0)",
            borderColor     : "rgb(0, 0, 0, 0)",
            data            : [this.getDrawYMaxTransformed()],
            borderWidth     : 0,
            pointRadius     : 0,
            pointHoverRadius: 0
        };
        var downLegend        = {
            _meta_type      : Graphics.CONST.LEGEND.META_TYPE.LEGEND_DOWN,
            backgroundColor : "rgb(0, 0, 0, 0)",
            borderColor     : "rgb(0, 0, 0, 0)",
            data            : [this.getDrawYMinTransformed()],
            borderWidth     : 0,
            pointRadius     : 0,
            pointHoverRadius: 0
        };
        var criticalThreshold = {
            _meta_type      : Graphics.CONST.LEGEND.META_TYPE.CRITICAL_THRESHOLD,
            backgroundColor : "rgb(0, 0, 0, 0)",
            borderColor     : "rgb(0, 0, 0, 0)",
            data            : [this.getDrawThresholdTransformed( Graphics.CONST.SLA.CURVE.THRESHOLD_CRITICAL.TYPE )],
            borderWidth     : 0,
            pointRadius     : 0,
            pointHoverRadius: 0
        };
        var warningThreshold  = {
            _meta_type      : Graphics.CONST.LEGEND.META_TYPE.WARNING_THRESHOLD,
            backgroundColor : "rgb(0, 0, 0, 0)",
            borderColor     : "rgb(0, 0, 0, 0)",
            data            : [this.getDrawThresholdTransformed( Graphics.CONST.SLA.CURVE.THRESHOLD_WARNING.TYPE )],
            borderWidth     : 0,
            pointRadius     : 0,
            pointHoverRadius: 0
        };
        return [upLegend, downLegend, criticalThreshold, warningThreshold];
    },
    chartJs_getLegendLabelsToDraw               : function () {
        var _to_return = [
            {
                _meta_type: Graphics.CONST.LEGEND.META_TYPE.LEGEND_DOWN,
                label     : this.chartJs_legendValueLabel( this.getDrawYMin() )
            },
            {
                _meta_type: Graphics.CONST.LEGEND.META_TYPE.LEGEND_UP,
                label     : this.chartJs_legendValueLabel( this.getDrawYMax() )
            },
            {
                _meta_type: Graphics.CONST.LEGEND.META_TYPE.LEGEND_UP,
                label     : "%",
                offsetY   : -20
            }
        ];
        if ( this.yIsInGraph( this.getThresholdFirstValue( Graphics.CONST.SLA.CURVE.THRESHOLD_CRITICAL.TYPE ) ) ) {
            _to_return.push( {
                _meta_type: Graphics.CONST.LEGEND.META_TYPE.CRITICAL_THRESHOLD,
                label     : this.chartJs_legendValueLabel( this.getThresholdFirstValue( Graphics.CONST.SLA.CURVE.THRESHOLD_CRITICAL.TYPE ) ),
                color     : this.getThresholdCurve( Graphics.CONST.SLA.CURVE.THRESHOLD_CRITICAL.TYPE ).getColor()
            } );
        }
        if ( this.yIsInGraph( this.getThresholdFirstValue( Graphics.CONST.SLA.CURVE.THRESHOLD_WARNING.TYPE ) ) ) {
            _to_return.push( {
                _meta_type: Graphics.CONST.LEGEND.META_TYPE.WARNING_THRESHOLD,
                label     : this.chartJs_legendValueLabel( this.getThresholdFirstValue( Graphics.CONST.SLA.CURVE.THRESHOLD_WARNING.TYPE ) ),
                color     : this.getThresholdCurve( Graphics.CONST.SLA.CURVE.THRESHOLD_WARNING.TYPE ).getColor()
            } );
        }
        return _to_return;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( Graphics.Graphic.WithCustomLegend, Graphics.Graphic.Interface );
