<td class="shinken-date-cell">
    <div class="range">
        <div>
            <div class="shinken-report-date-range-start"><span class="start"><i class="shinkon shinkon-circle"></i></span></div>
            <div class="shinken-report-date-range-date">{{date_string_begin}}</div>
        </div>
        <div>
            <div class="shinken-report-date-range-end"><span class="end"><i class="shinkon shinkon-triangle rotate"></i></span></div>
            <div class="shinken-report-date-range-date">{{date_string_end}}</div>
        </div>
    </div>
    %if 'sla' in modes:
        %if item_result.get('in_future', False) or item_result.get('in_past', False):
            <div class="display-sla-percent-day">
                <div class="display-sla-percent-container">
                    <p>-</p>
                </div>
            </div>
        %else:
            %include _report-info-sla app=app, _class="display-sla-percent-range", _type="sla-percent-range", item=item_result, last_day=date_string_end, current_search=current_search
        %end
    %end
</td>

%if item['no_data']:
    <td class="range-table-cell shinken-sla-no-data" colspan="{{len(modes) * len(ALL_STATES)}}">
        %no_data_img = '/static/%s/sla/img/no-data.png' % app.http_start_time
        {{app._('reporting.in_past')}}&nbsp;<img src={{no_data_img}} width="30px"/>
    </td>
%else:
    %for mode in modes:
        %if mode == 'sla' and current_search['shinken_daily_sla_graph'] == 'on':
            <td class="range-table-cell td-shinken-graph-container" colspan="{{len(ALL_STATES)}}">
                <div class="shinken-graph-container" data-item-uuid="{{item['item'].get_instance_uuid()}}">
                    <div class="shinken-not-enough-data-message">{{app._('reporting.not_enough_data_message')}}</div>
                    <canvas class="shinken-sla-historic-graph"></canvas>
                </div>
            </td>
        %else:
            <td class="range-table-cell" colspan="{{len(ALL_STATES)}}">
                <table class="sla-bars">
                    <tbody>
                    %_rows = ''
                    %for state in ALL_STATES:
                        %if state in item_result[mode]:
                            %_value = item_result[mode][state]
                            %_time = item_result[mode][KEY_TIME % state]
                            %_rows += html_get_value_bar(state, mode, _value, _time)
                        %end
                    %end
                    {{!_rows}}
                    </tbody>
                </table>
            </td>
        %end
    %end
%end