<table class="shinken-report-total-sla-table">
    <tr>
        <th class="shinken-table-header" colspan="{{len(ALL_STATES)}}">{{app._('reporting.total_sla_title')}}</th>
    </tr>
    <tr>
        <!-- state icon + arrow icon -->
        %for state in ALL_STATES:
            %icon = app.helper.get_sla_state_icon(state)
            %tooltip = 'data-toggle="tooltip" title="%s"' % app._('reporting.%s' % state)
            %if state == 'ok':
                %state_text = '''<span class="shinken-hide-if-under-600 sla-icon shinicon-arrow-up"></span>'''
            %else:
                %state_text = '''<span class="shinken-hide-if-under-600 sla-icon shinicon-arrow-down"></span>'''
            %end
            <td class="shinken-report-state-icon-cell col-{{state}}" {{tooltip}}>
                {{!icon}}
                {{!state_text}}
            </td>
        %end
    </tr>
    <tr class="shinken-hide-if-under-600">
        <!-- state name -->
        %for state in ALL_STATES:
            %icon = app.helper.get_sla_state_icon(state)
            %tooltip = 'data-toggle="tooltip" title="%s"' % app._('reporting.%s' % state)
            <td class="shinken-report-state-name-cell col-{{state}}" {{tooltip}}>
                <span class="shinken-report-state-name">{{app._('reporting.sla')}}</span>
            </td>
        %end
    </tr>
    <tr>
        %sla_keys = item_result['sla'].keys()
        %if len(sla_keys) == 1 and sla_keys[0] == 'thresholds':
            <td colspan="6">
                %no_data_img = '/static/%s/sla/img/no-data.png' % app.http_start_time
                {{app._('reporting.in_past')}}&nbsp;<img src={{no_data_img}} width="30px"/>
            </td>
        %else:
            <!-- state value -->
            %for state in ALL_STATES:
                %if state in item_result['sla']:
                    %_value = item_result['sla'][state]
                    <td class="shinken-report-sla-value-cell">
                        <div class="shinken-report-sla-value shinken-col-{{state}}">{{total_table_sla_history_value_percent(_value)}}</div>
                    </td>
                %else:
                    <td></td>
                %end
            %end
        %end
    </tr>
</table>