#!/usr/bin/python
# -*- coding: utf-8 -*-

# Copyright (C) 2013-2021:
# This file is part of Shinken Enterprise, all rights reserved.

from shinken.exceptions.business import BusinessException
from shinken.misc.type_hint import TYPE_CHECKING

if TYPE_CHECKING:
    from shinken.misc.type_hint import Optional
    from synchronizer.synchronizerdaemon import Synchronizer

# Set by state_controller.py
app = None  # type: Optional[Synchronizer]


class UnauthorizedSaveException(BusinessException):
    def __init__(self, code=403, text=None, shinken_return_code=None, validator_messages=None):
        text = text or app._("element.unauthorized_save")
        self.shinken_return_code = shinken_return_code
        super(UnauthorizedSaveException, self).__init__(code, text, shinken_return_code, validator_messages=validator_messages)


class AlreadyDeletedException(BusinessException):
    pass


class ItemNotFoundException(BusinessException):
    code = 404


class WorkAreaInfoUnknownStatus(BusinessException):
    pass


class ItemNotValid(BusinessException):
    code = "element-not-valide"


class MassiveChangeError(BusinessException):
    missing_values = []
    
    
    def __init__(self, code=None, text=None, missing_values=None):
        super(MassiveChangeError, self).__init__(code, text)
        if missing_values:
            self.missing_values = missing_values


class SaveException(BusinessException):
    pass
