#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2019:
# This file is part of Shinken Enterprise, all rights reserved.

class MASSIVE_CHANGE_OPERATOR:
    ADD = 'ADD'
    MOVE = 'MOVE'
    REMOVE = 'REMOVE'
    SET = 'SET'
    SET_IF_EXIST = 'SET_IF_EXIST'
    REPLACE = 'REPLACE'
    EMPTY = 'EMPTY'
    EXCLUDE = 'EXCLUDE'
    REMOVE_ALL_EXCEPT = 'REMOVE_ALL_EXCEPT'
    SET_SYNCHRO = 'SET_SYNCHRO'
    # FOR DATA ONLY
    SET_IF_DATA_EXISTS_ON_ITEM = 'SET_IF_DATA_EXISTS_ON_ITEM'
    SET_IF_DATA_IS_SET_ON_ITEM = 'SET_IF_DATA_IS_SET_ON_ITEM'
    ADD_CONSISTENCY = 'ADD_CONSISTENCY'
    
    FIRST = 'FIRST'
    LAST = 'LAST'
    BEFORE = 'BEFORE'
    AFTER = 'AFTER'
    
    ALL_ACTIONS = (ADD, MOVE, REMOVE, SET, REPLACE, EMPTY, EXCLUDE, SET_IF_EXIST, REMOVE_ALL_EXCEPT, SET_SYNCHRO, ADD_CONSISTENCY)
    ALL_DATA_ACTIONS = (SET, EMPTY, SET_IF_DATA_EXISTS_ON_ITEM, SET_IF_DATA_IS_SET_ON_ITEM)
    ALL_EXTRA_ACTIONS = {
        ADD : [FIRST, LAST, BEFORE, AFTER],
        MOVE: [FIRST, LAST, BEFORE, AFTER],
    }
    
    RULES = {
        'join'   : [ADD, REMOVE, SET, REPLACE, EMPTY, EXCLUDE, REMOVE_ALL_EXCEPT, ADD_CONSISTENCY],  # list fields
        'uniq'   : [SET, EMPTY, SET_IF_EXIST, SET_SYNCHRO],  # simple fields
        'ordered': ['%s_%s' % (ADD, FIRST), '%s_%s' % (ADD, LAST), '%s_%s' % (ADD, BEFORE), '%s_%s' % (ADD, AFTER), '%s_%s' % (MOVE, BEFORE), '%s_%s' % (MOVE, AFTER), '%s_%s' % (MOVE, FIRST), '%s_%s' % (MOVE, LAST), REMOVE, REPLACE, SET, EMPTY],
        # ordered list fields
    }
