#!/usr/bin/python
# -*- coding: utf-8 -*-

# Copyright (C) 2013-2018:
# This file is part of Shinken Enterprise, all rights reserved.

from .listener import Listener, Listeners
from shinken.property import StringProp


class Analyzer(Listener):
    # NOTE: DO NOT SET id HERE. We want to use the same id as the Source class
    my_type = 'analyzer'
    
    running_properties = Listener.running_properties.copy()
    running_properties.update({
        'type': StringProp(default='analyzer'),
    })
    
    
    def get_name(self):
        return getattr(self, 'analyzer_name', '')
    
    
    # The UI is asking us to analyze an host (already extract by the daemon). First we need to find our valid module
    # and then give it the host
    def analyze_host(self, job, host):
        self.get_module().analyze_host(job, host)
    
    
    def get_default_hosts_templates(self):
        return self.get_module().get_analyzer_host_templates()
    
    
    def restart(self):
        pass
    
    
    def callback_about_new_elements(self, items_type, data=None):
        # We have a new element, let the UI know it
        self.unmerged_new_nb += 1
        # keep the history of the actions done until the next merge
        self._update_last_action('new', items_type, data)
    
    
    def stop_all_analyzes(self):
        self.get_module().stop_all_analyzes()
    
    
    def _get_my_module_class(self):
        from shinkensolutions.api.synchronizer.source.abstract_module.analyzer_module import AnalyzerModule
        return AnalyzerModule


class Analyzers(Listeners):
    name_property = "analyser_name"
    inner_class = Analyzer
