#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2022
# This file is part of Shinken Enterprise, all rights reserved.

from shinken.misc.type_hint import TYPE_CHECKING
from shinkensolutions.ssh_mongodb.mongo_client import MongoClient
from .abstract_component import AbstractComponent

if TYPE_CHECKING:
    from shinken.misc.type_hint import TYPE_CHECKING, Optional
    from shinken.log import PartLogger
    from shinkensolutions.ssh_mongodb.mongo_collection import MongoCollection
    from .configuration_component import ConfigurationComponent

PROPERTIES_USED_AS = u'properties_used_as_synckey_for_'


class MongoComponentWithoutAutoReconnect(AbstractComponent, MongoClient):
    def __init__(self, logger, configuration_component, requester):
        # type: (PartLogger, ConfigurationComponent, str) -> None
        
        # WARNING : this component will skip the AutoReconnect method !! It will be used only in the SynchronizerDaemon IStatsInterface
        # The interface must be fast to reply (timeout is set at 2 seconds only) so we must to skip the AutoReconnect
        mongo_conf = configuration_component.get_mongo_configuration(logger=logger)
        mongo_conf.auto_reconnect_max_try = 1
        mongo_conf.auto_reconnect_sleep_between_try = 0
        MongoClient.__init__(self, mongo_conf, logger=logger)
        self.requester = requester
        
        self.col_synchronizer_info = None  # type: Optional[MongoCollection]
    
    
    def init(self):
        # type: () -> None
        MongoClient.init(self, self.requester)
        self._retrieve_collections()
    
    
    def recreate_connection(self, requester=u'unknown'):
        # type: (unicode) -> None
        MongoClient.recreate_connection(self, self.requester)
        self._retrieve_collections()
    
    
    def _retrieve_collections(self):
        self.col_synchronizer_info = self.get_collection('synchronizer-info')
