#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2021:
# This file is part of Shinken Enterprise, all rights reserved.
from shinken.log import logger

CALLBACK_LOG = False


class Callback(object):
    @staticmethod
    def log(item_type, item_state, item_id, action, text):
        if CALLBACK_LOG:
            logger.debug(u'[callback][%-26s:%-15s:%-20s:%s] - %s' % (item_type, item_state, item_id, action, text))


class PreSaver(Callback):
    def called_before_save(self, item_id=u'', item_type=u'', item_state=u'', item=None, old_item=None, user=None, action=u'', datamanager=None):
        raise NotImplementedError()


class PostSaver(Callback):
    def called_after_save(self, item_id=u'', item_type=u'', item_state=u'', item=None, old_item=None, user=None, action=u'', datamanager=None):
        raise NotImplementedError()


class PostLoader(Callback):
    def called_after_load(self, item_id=u'', item_type=u'', item_state=u'', item=None, old_item=None, user=None, action=u'', datamanager=None):
        raise NotImplementedError()


class PreDeleter(Callback):
    def called_before_delete(self, item_id=u'', item_type=u'', item_state=u'', item=None, old_item=None, user=None, action=u'', datamanager=None):
        raise NotImplementedError()


class PostDeleter(Callback):
    def called_after_delete(self, item_id=u'', item_type=u'', item_state=u'', item=None, old_item=None, user=None, action=u'', datamanager=None):
        raise NotImplementedError()
