#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2022:
# This file is part of Shinken Enterprise, all rights reserved.

import time

from shinken.misc.type_hint import TYPE_CHECKING
from .base_callback import PostSaver, PostDeleter
from ..def_items import ITEM_STATE, HISTORY_ACTION, ITEM_TYPE
from ...business.sync_ui_common import syncuicommon

if TYPE_CHECKING:
    from shinken.misc.type_hint import Optional, Dict
    from synchronizer.dao.datamanagerV2 import DataManagerV2
    from synchronizer.dao.items import ContactItem


class _CallbackComputeDiffStagingProduction(PostSaver, PostDeleter):
    def called_after_save(self, item_id=u'', item_type=u'', item_state=u'', item=None, old_item=None, user=None, action=u'', datamanager=None):
        # type: (unicode, unicode, unicode, Optional[Dict], Optional[Dict], Optional[ContactItem], unicode, Optional[DataManagerV2]) -> None
        if item_state != ITEM_STATE.STAGGING or action == HISTORY_ACTION.UPDATE_WORK_AREA_INFO:
            return
        
        self.log(item_type, item_state, item_id, action, u'compute diff staging <-> production')
        item_staging = datamanager.find_item_by_id(item_id, item_type, ITEM_STATE.STAGGING)
        item_production = datamanager.find_item_by_id(item_id, item_type, ITEM_STATE.PRODUCTION)
        
        syncuicommon.compute_one_diff_staging_production(item_id, item_type, item_staging, item_production)
        if item_production:
            datamanager.save_item(item_production, item_type=item_type, item_state=ITEM_STATE.PRODUCTION)
    
    
    def called_after_delete(self, item_id=u'', item_type=u'', item_state=u'', item=None, old_item=None, user=None, action=u'', datamanager=None):
        # type: (unicode, unicode, unicode, Optional[Dict], Optional[Dict], Optional[ContactItem], unicode, Optional[DataManagerV2]) -> None
        if item_state != ITEM_STATE.STAGGING or action == HISTORY_ACTION.UPDATE_WORK_AREA_INFO:
            return
        
        self.log(item_type, item_state, item_id, action, u'compute diff staging <-> production')
        item_staging = datamanager.find_item_by_id(item_id, item_type, ITEM_STATE.STAGGING)
        item_production = datamanager.find_item_by_id(item_id, item_type, ITEM_STATE.PRODUCTION)
        
        # We need to update the production item last_modification before compute_one_diff_staging_production
        if item_production and not item_staging:
            modification_info = item_production.get(u'last_modification', {})
            user_in_production = datamanager.find_item_by_id(user[u'_id'], ITEM_TYPE.CONTACTS, ITEM_STATE.PRODUCTION)
            modification_contact = {
                u'links'   : [
                    {
                        u'item_type': ITEM_TYPE.CONTACTS,
                        u'_id'      : user.get(u'_id', u''),
                        u'exists'   : True,
                        u'@link'    : {
                            ITEM_STATE.PRODUCTION: user_in_production
                        }
                    }
                ],
                u'has_plus': False
                
            }
            
            modification_info[u'contact'] = modification_contact
            modification_info[u'date'] = time.time()
            modification_info[u'action'] = HISTORY_ACTION.ELEMENT_DELETE
            
            item_production.set_value(u'last_modification', modification_info)
            datamanager.save_item(item_production, item_type=item_type, item_state=ITEM_STATE.PRODUCTION)
        
        syncuicommon.compute_one_diff_staging_production(item_id, item_type, item_staging, item_production)


_callback_compute_diff_staging_production = _CallbackComputeDiffStagingProduction()
