#!/usr/bin/python
# -*- coding: utf-8 -*-

# Copyright (C) 2013-2021:
# This file is part of Shinken Enterprise, all rights reserved.

from shinken.misc.type_hint import TYPE_CHECKING
from .base_callback import PostSaver, PostDeleter
from ...business.sync_ui_common import syncuicommon

if TYPE_CHECKING:
    from shinken.misc.type_hint import Optional, Dict
    from synchronizer.dao.datamanagerV2 import DataManagerV2
    from synchronizer.dao.items import ContactItem


class _CallbackConfigurationStatsCacheReset(PostSaver, PostDeleter):
    def called_after_save(self, item_id=u'', item_type=u'', item_state=u'', item=None, old_item=None, user=None, action=u'', datamanager=None):
        # type: (unicode, unicode, unicode, Optional[Dict], Optional[Dict], Optional[ContactItem], unicode, Optional[DataManagerV2]) -> None
        self.log(item_type, item_state, item_id, action, u'reset configuration stats cache')
        syncuicommon.reset_configuration_stats_cache()
    
    
    called_after_delete = called_after_save


_callback_configuration_stats_cache_reset = _CallbackConfigurationStatsCacheReset()
