#!/usr/bin/python
# -*- coding: utf-8 -*-

# Copyright (C) 2013-2021:
# This file is part of Shinken Enterprise, all rights reserved.

from shinken.misc.type_hint import TYPE_CHECKING
from .base_callback import PostDeleter
from ..def_items import ITEM_STATE

if TYPE_CHECKING:
    from shinken.misc.type_hint import Optional, Dict
    from synchronizer.dao.datamanagerV2 import DataManagerV2
    from synchronizer.dao.items import ContactItem


class _CallbackDeleteChangeInfo(PostDeleter):
    def called_after_delete(self, item_id=u'', item_type=u'', item_state=u'', item=None, old_item=None, user=None, action=u'', datamanager=None):
        # type: (unicode, unicode, unicode, Optional[Dict], Optional[Dict], Optional[ContactItem], unicode, Optional[DataManagerV2]) -> None
        if item_state not in (ITEM_STATE.STAGGING, ITEM_STATE.WORKING_AREA):
            return
        item_exist = datamanager.find_item_by_id(item_id, item_type, ITEM_STATE.WORKING_AREA if item_state == ITEM_STATE.STAGGING else ITEM_STATE.STAGGING)
        if not item_exist:
            self.log(item_type, item_state, item_id, action, u'delete change info')
            datamanager.delete_item(item, item_type=item_type, item_state=ITEM_STATE.CHANGES)


_callback_delete_change_info = _CallbackDeleteChangeInfo()
