#!/usr/bin/python
# -*- coding: utf-8 -*-

# Copyright (C) 2013-2021:
# This file is part of Shinken Enterprise, all rights reserved.

import urllib

from shinken.misc.type_hint import TYPE_CHECKING
from .base_callback import PostDeleter
from ..def_items import ITEM_STATE

if TYPE_CHECKING:
    from synchronizer.synchronizerdaemon import Synchronizer
    from shinken.misc.type_hint import Optional, Dict, Union
    from synchronizer.dao.datamanagerV2 import DataManagerV2
    from synchronizer.dao.items import ContactItem, BaseItem


class _CallbackRemoveFromSourceCache(PostDeleter):
    def called_after_delete(self, item_id=u'', item_type=u'', item_state=u'', item=None, old_item=None, user=None, action=u'', datamanager=None):
        # type: (unicode, unicode, unicode, Optional[Dict], Optional[Dict], Optional[ContactItem], unicode, Optional[DataManagerV2]) -> None
        if item_state not in (ITEM_STATE.STAGGING, ITEM_STATE.WORKING_AREA):
            return
        item_exist = datamanager.find_item_by_id(item_id, item_type, ITEM_STATE.WORKING_AREA if item_state == ITEM_STATE.STAGGING else ITEM_STATE.STAGGING)
        if item_exist:
            return
        self.log(item_type, item_state, item_id, action, u'remove item from source cache by _SYNC_KEYS')
        self._remove_delete_item_by_sync_keys_from_import_cache(datamanager.synchronizer, item)
    
    
    @staticmethod
    def _remove_delete_item_by_sync_keys_from_import_cache(synchronizer, item):
        # type: (Synchronizer, Union[Dict, BaseItem]) -> None
        _sync_keys = u','.join(item[u'_SYNC_KEYS'])
        _sync_keys = _sync_keys.encode(u'utf8', u'ignore')
        params = urllib.urlencode({u'deleted_item_sync_keys': _sync_keys})
        path = u'/remove_delete_item_by_sync_keys_from_import_cache?%s' % params
        
        conn = synchronizer.get_synchronizer_deamon_connection()
        conn.request(u'GET', path)
        r1 = conn.getresponse()
        r1.read()
        conn.close()


_callback_remove_from_source_cache = _CallbackRemoveFromSourceCache()
