#!/usr/bin/python
# -*- coding: utf-8 -*-

# Copyright (C) 2013-2021:
# This file is part of Shinken Enterprise, all rights reserved.

from shinken.misc.type_hint import TYPE_CHECKING
from .base_callback import PreDeleter
from ..def_items import ITEM_STATE
from ..trash_manager.trash_manager import trash_manager

if TYPE_CHECKING:
    from shinken.misc.type_hint import Optional, Dict
    from synchronizer.dao.datamanagerV2 import DataManagerV2
    from synchronizer.dao.items import ContactItem


class _CallbackSaveDeletedItem(PreDeleter):
    def called_before_delete(self, item_id='', item_type='', item_state='', item=None, old_item=None, user=None, action='', datamanager=None):
        # type: (unicode, unicode, unicode, Optional[Dict], Optional[Dict], Optional[ContactItem], unicode, Optional[DataManagerV2]) -> None
        if item_state not in (ITEM_STATE.STAGGING, ITEM_STATE.WORKING_AREA):
            return
        
        item_to_delete = datamanager.find_item_by_id(item_id, item_type, item_state)
        if item_to_delete:
            trash_manager.save_deleted_item(item_to_delete, item_type, user)


_callback_save_deleted_item = _CallbackSaveDeletedItem()
