#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2018:
# This file is part of Shinken Enterprise, all rights reserved.

from baseitem import BaseItem
from contactitem import ContactItem
from mixins import BPRuleMixin, CommandMixin, HostNameMixin, UseMixin, HostgroupNameMixin, ModulateDataMixin, ServiceOverridesMixin, LinkHostCheckForCheckMixin, LinkHostCheckForHostMixin, ServiceExcludesMixin
from shinken.misc.type_hint import TYPE_CHECKING

if TYPE_CHECKING:
    from shinken.misc.type_hint import Union
    from .contactitem import ContactItem


# cluster and cluster template
class ClusterItem(BaseItem, BPRuleMixin, CommandMixin, UseMixin, ModulateDataMixin, ServiceOverridesMixin, LinkHostCheckForHostMixin, ServiceExcludesMixin):
    pass


# host and host template
class HostItem(BaseItem, CommandMixin, UseMixin, ModulateDataMixin, ServiceOverridesMixin, LinkHostCheckForHostMixin, ServiceExcludesMixin):
    pass


class HostGroupItem(BaseItem):
    pass


# use for SERVICESHOSTS, SERVICESCLUSTERS, SERVICETPLS
class ServiceItem(BaseItem, CommandMixin, HostgroupNameMixin, UseMixin, ModulateDataMixin, LinkHostCheckForCheckMixin):
    
    def is_dfe(self):
        return bool('$KEY$' in self.get_name() and self.get('duplicate_foreach', False))


# SERVICESHOSTTPLS, SERVICESCLUSTERTPLS
class ServiceTemplateItem(BaseItem, CommandMixin, HostNameMixin, HostgroupNameMixin, UseMixin, ModulateDataMixin, LinkHostCheckForCheckMixin):
    
    def is_dfe(self):
        return bool('$KEY$' in self.get_name() and self.get('duplicate_foreach', False))


# CONTACTTPLS
class ContactTemplateItem(ContactItem, UseMixin):
    pass


class ContactGroupItem(BaseItem):
    pass


if TYPE_CHECKING:
    InstanceItem = Union[BaseItem, ContactItem, ClusterItem, HostItem, HostGroupItem, ServiceItem, ServiceTemplateItem, ContactTemplateItem, ContactGroupItem]
