#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2020:
# This file is part of Shinken Enterprise, all rights reserved.
from shinken.misc.type_hint import NoReturn
from ..shinken_object import ShinkenObject
from ....dao.def_items import ITEM_STATE, ITEM_TYPE, DEF_ITEMS, METADATA
from ...component_select_options import ComponentOption

class TagLink(ShinkenObject):
    def __init__(self):
        # type: ()-> NoReturn
        super(TagLink, self).__init__()

    @staticmethod
    def get_html_by_factory(link, prop_name, item_type, app, datamanagerV2):
        linked_item = {}
        _name = ''
        link_item_type = None
    
        if link['exists']:
            _link_item_type = link['item_type']
            _where = {'_id': link['_id']}
            _states = (ITEM_STATE.NEW, ITEM_STATE.WORKING_AREA, ITEM_STATE.STAGGING) if ITEM_TYPE.has_work_area(_link_item_type) else (ITEM_STATE.NEW, ITEM_STATE.STAGGING)
            items = datamanagerV2.find_merge_state_items(_link_item_type, _states, where=_where)
            if items:
                linked_item = items[0]
                link_item_type = linked_item.get_type()
                _name = linked_item.get_name()
        else:
            possible_link_item_type = DEF_ITEMS[item_type]['props_links'][prop_name]
            for _link_item_type in possible_link_item_type:
                _key = DEF_ITEMS[_link_item_type]['key_name']
                _states = (ITEM_STATE.NEW, ITEM_STATE.WORKING_AREA, ITEM_STATE.STAGGING) if ITEM_TYPE.has_work_area(_link_item_type) else (ITEM_STATE.NEW, ITEM_STATE.STAGGING)
                _where = {_key: link['name']}
                items = datamanagerV2.find_merge_state_items(_link_item_type, _states, where=_where)
                if items:
                    linked_item = items[0]
                    link_item_type = linked_item.get_type()
                    _name = linked_item.get_name()
                    break
        
            if not linked_item:
                _name = link['name']
    
        _current_entry = ComponentOption(
            METADATA.get_metadata(linked_item, METADATA.STATE),
            linked_item.get('enabled', '1'),
            _name,
            False,
            0,
            state_element=METADATA.get_metadata(linked_item, METADATA.STATE),
            _id=linked_item.get('_id', None),
            item_type=link_item_type
        )
    
        return app.helper.helper_object.get_tag_container_html(prop_name, _current_entry, add_close=False, add_dragging=False)
    
