from shinkensolutions.api.synchronizer import component_manager


def get_item_property_display_name(item_type, item_property):
    # type: (str, str)-> str
    _translator = component_manager.get_translate_component().translator()
    if item_property.startswith('_'):
        item_property_display_name = '%s [%s]' % (item_property, _translator.translate('element.data'))
    else:
        item_property_display_name = _translator.translate('%s.%s' % (item_type, item_property))
        if 'TO_TRAD(' in item_property_display_name:
            item_property_display_name = _translator.translate('element.unknown_import_key')
    return item_property_display_name
