'use strict';
var SHINKEN = {};
SHINKEN.DOM = {};
SHINKEN.MODAL     = {};
SHINKEN.NAVIGATOR = {};
SHINKEN.PAGE      = {};
SHINKEN.TOOLS            = {};
SHINKEN.TOOLS.ARRAY      = {};
SHINKEN.TOOLS.ENCRYPTION = {};
SHINKEN.OBJECT           = {};
SHINKEN.OBJECT.CONST     = {};
var DOM   = {};
DOM.CONST = {};
SHINKEN.CONST               = {
    KEY_CODE: {
        TAB   : 9,
        ENTER : 13,
        ESCAPE: 27,
        SPACE : 32,
        LEFT  : 37,
        UP    : 38,
        RIGHT : 39,
        DOWN  : 40,
        F1    : 112
    }
};
SHINKEN.CONST.CONFIGURATION = {
    ELEMENT_UNIQUE_ADDRESS_BEHAVIOUR: {
        DUPLICATED_ACCEPTED: "duplicated_accepted",
        WARNING_DISPLAYED  : "warning_displayed",
        ERROR_DISPLAYED    : "error_displayed",
        SAVE_FORBIDDEN     : "save_forbidden"
    }
};
SHINKEN.TOOLS.buildLinkDomElementDependIfAdmin = function ( link, id, label, _class, tooltip ) {
    if ( MANAGER.__instance_element_distributor.current_user.is_admin && link && id ) {
        return SHINKEN.TOOLS.buildLinkDomElement( link, id, label, _class, tooltip );
    }
    if ( !_class ) {
        _class = "title shinken-space";
    }
    var _to_return = DOM.Service.createElement( 'span', { class: _class }, label );
    DOM.Service.addTooltip( _to_return, tooltip );
    return _to_return;
};
SHINKEN.TOOLS.buildLinkDomElement              = function ( link, id, label, _class, tooltip ) {
    var _href = "/elements/" + link + '/' + id;
    if ( !_class ) {
        _class = "title shinken-link shinken-space";
    }
    var _to_return = DOM.Service.createElement( 'a', { class: _class, href: _href, draggable: 'false', target: "_blank", onclick: "MANAGER.EventManager.mutePropagation(event)" }, '<span class="shinken-tag-label">' + label + '</span>' );
    DOM.Service.addTooltip( _to_return, tooltip );
    return _to_return;
};
SHINKEN.TOOLS.buildLinkShinkenElement          = function ( element, label, _class, tooltip ) {
    var _uuid = element.uuid;
    if ( element.isNew() ) {
        _uuid += '?new=1';
    }
    if ( !label ) {
        label = element.getName();
    }
    return SHINKEN.TOOLS.buildLinkDomElementDependIfAdmin( element.getType(), _uuid, label, _class, tooltip );
};
var COMMUNICATION                = {};
COMMUNICATION.MESSAGE            = {};
COMMUNICATION.QUERY              = {};
COMMUNICATION.MESSAGE.SUCCESS    = 'success';
COMMUNICATION.MESSAGE.ERROR      = 'error';
COMMUNICATION.MESSAGE.WARNING    = 'warning';
COMMUNICATION.CODE               = {};
COMMUNICATION.CODE.SUCCESS       = 200;
COMMUNICATION.CODE.WARNING       = 202;
COMMUNICATION.CODE.RESET_CONTENT = 205;
COMMUNICATION.CODE.ERROR         = 400;
COMMUNICATION.CODE.UNAUTHORIZED  = 401;
COMMUNICATION.CODE.NOT_FOUND     = 404;
COMMUNICATION.RETURN_CODE        = {
    ELEMENT_UNKNOWN: "element-unknown"
};
COMMUNICATION.QUERY.GET = {
    SEPARATOR      : {
        GET_BEGINNER: '?',
        GET_ADD     : '&',
        PARAM_SETTER: '=',
        SLASH       : '/'
    },
    SOURCE         : {
        LIST                 : {
            URL    : "/api/sources",
            OPTIONS: {
                TIMESTAMP: "?ts="
            }
        },
        SET_ORDER            : {
            URL    : "/api/sources/setorder",
            OPTIONS: {
                TIMESTAMP: "?ts=",
                ORDER    : "&order="
            }
        },
        REFRESH              : {
            URL    : "/api/sources",
            OPTIONS: {
                TIMESTAMP: "?ts="
            }
        },
        SET_ENABLED          : {
            URL    : "/api/sources/setenabled",
            OPTIONS: {
                TIMESTAMP  : "?ts=",
                SOURCE_NAME: "&source_name=",
                ENABLED    : "&enabled="
            },
            CONST  : {
                ENABLED : '1',
                DISABLED: '0'
            }
        },
        SET_DISCOVERY_ENABLED: {
            URL    : "/api/sources/conf/setenabled",
            OPTIONS: {
                TIMESTAMP  : "?ts=",
                SOURCE_NAME: "&source_name=",
                CONF_ID    : "&conf_id=",
                ENABLED    : "&enabled="
            },
            CONST  : {
                ENABLED : '1',
                DISABLED: '0'
            }
        },
        FORCE_IMPORT         : {
            URL    : "/api/sources/forceimport/",
            OPTIONS: {
                TIMESTAMP: "?ts="
            }
        },
        CLEAN_IMPORT         : {
            URL    : "/api/sources/cleanimport/",
            OPTIONS: {
                TIMESTAMP: "?ts="
            }
        },
        REFRESH_UNIQUE       : {
            URL    : "/api/sources/unique_source/",
            OPTIONS: {
                TIMESTAMP: "?ts="
            }
        },
        ANALYZER             : {
            LAUNCH_BATCH      : "/api/analyzers/launch_analyze_batch",
            STOP_ANALYSE_BATCH: "/api/analyzers/stop_analyze_batch",
            GET_RESULTS       : "/api/analyzers/get_analyze_jobs_result"
        },
        REDIRECT_DETAIL      : {
            URL    : "/sources/",
            OPTIONS: {
                TAB_DETAIL         : "tab=tab-detail-last-run",
                TAB_SUMMARY_OLD_RUN: "tab=tab-summary-old-run",
                FILTER_STATUS      : "filter=status:"
            }
        }
    },
    OVERRIDE       : {
        BASE: '/elements/service_overrides/'
    },
    MASS_CHANGE    : {
        BASE        : "/elements/massive_change/",
        PROGRESS_BAR: "/elements/massive_change_progress/"
    },
    USER_MANAGER   : {
        USER_PREFERENCES: "/user_preferences/"
    },
    SERVICE_WEATHER: {
        WEATHER_SPACE       : 'service-weather',
        GET_WEATHER         : '/api/V1/get/',
        GET_EDITABLE_WEATHER: '/api/V1/get-editable/',
        PREVIEW_WEATHER     : '/api/V1/preview/',
        SAVE_WEATHER        : '/api/V1/save/'
    }
};
COMMUNICATION.PAGE_TYPE = {
    LIST_ALL_ELEMENT : "list-all-element",
    LIST_WORKING_AREA: "list-working-area"
};
SHINKEN.TOOLS.STRING             = (function ( self ) {
    "use strict";
    self.CONST = {
        REGEX                   : {
            HTML_TAG        : /<(?:.|\n)*?>/gm,
            ESCAPE_CHARACTER: /\x1b/g
        },
        WHITE_SPACE             : ' ',
        NON_BREAK_SPACE         : '\u00a0',
        INVISIBLE_CHAR          : '\u200b',
        COMMA                   : ',',
        CHAR_CODE_BACK_TO_LINE  : 10,
        CHAR_CODE_INVISIBLE_CHAR: 8203
    };
    
    self.capitalize                      = function ( str ) {
        if ( !str ) {
            return "";
        }
        return str.charAt( 0 ).toUpperCase() + str.substring( 1 ).toLowerCase();
    };
    self.toUpperCase                     = function ( str ) {
        return str.toUpperCase();
    };
    self.isUpperCase                     = function ( str ) {
        if ( !str ) {
            return false;
        }
        return str === self.toUpperCase( str );
    };
    self.extractBetween                  = function ( string, start_tag, end_tag ) {
        if ( !string ) {
            return string;
        }
        var _start = string.indexOf( start_tag );
        if ( _start === -1 ) {
            return string;
        }
        _start   = _start + start_tag.length;
        var _end = string.indexOf( end_tag, _start );
        if ( _end === -1 ) {
            return string;
        }
        return string.substring( _start, _end );
    };
    self.replaceAll                      = function ( string, target, replacement ) {
        return string.split( target ).join( replacement || '' );
    };
    self.replaceWithRegex                = function ( text_to_change, regex, change_with ) {
        return text_to_change.replace( regex, change_with );
    };
    self.extractStringIfBeginningBy      = function ( str, search ) {
        var _to_return = false;
        if ( str.startsWith( search ) ) {
            _to_return = str.substr( search.length, str.length );
        }
        return _to_return;
    };
    self.splitMultiselectValueWithNoPlus = function ( str ) {
        var _to_return = SHINKEN.TOOLS.STRING.replaceAll( str, PROPERTY.CONST.STATE_VALUE_PLUS.ON + ",", "" );
        _to_return     = SHINKEN.TOOLS.STRING.replaceAll( _to_return, PROPERTY.CONST.STATE_VALUE_PLUS.ON, '' );
        return _to_return.split( ',' );
    };
    self.contains                        = function ( string, to_find ) {
        if ( !string || !to_find ) {
            return false;
        }
        return string.indexOf( to_find ) !== -1;
    };
    self.containsAny                     = function ( string, to_find_any_of ) {
        for ( var _i = 0; _i < to_find_any_of.length; _i++ ) {
            if ( to_find_any_of[ _i ] && self.contains( string, to_find_any_of[ _i ] ) ) {
                return true;
            }
        }
        return false;
    };
    self.containsCharCode                = function ( string, char_code ) {
        if ( !string ) {
            return false;
        }
        var _codes = this.getCharCodes( string );
        return SHINKEN.TOOLS.ARRAY.contains( _codes, char_code );
    };
    self.containsIgnoreCase              = function ( string, to_find ) {
        if ( !string ) {
            return false;
        }
        
        var _string_to_lower_case  = string.toLowerCase();
        var _to_find_to_lower_case = to_find.toLowerCase();
        return self.contains( _string_to_lower_case, _to_find_to_lower_case );
    };
    self.cleanMultipleSpaces             = function ( string ) {
        string = self.trim( string );
        return self.replaceWithRegex( string, /\s\s+/g, self.CONST.WHITE_SPACE );
    };
    self.removeXss                       = function ( string ) {
        if ( typeof string !== 'string' ) {
            return string;
        }
        string = string || "";
        string = string.replace( /&/g, "" );
        string = string.replace( /</g, "" );
        string = string.replace( />/g, "" );
        string = string.replace( /"/g, "" );
        string = string.replace( /'/g, "" );
        string = string.replace( /\//g, "" );
        return string;
    };
    self.cleanXss                        = function ( string ) {
        if ( typeof string !== 'string' ) {
            return string;
        }
        string = string || "";
        string = string.replace( /&/g, "&amp;" );
        string = string.replace( /</g, "&lt;" );
        string = string.replace( />/g, "&gt;" );
        string = string.replace( /"/g, "&quot;" );
        string = string.replace( /'/g, "&#x27;" );
        string = string.replace( /\//g, "&#x2F;" );
        return string;
    };
    self.cleanXssForTooltip              = function ( string ) {
        var to_return = this.cleanXss( "" + string );
        to_return     = to_return.replace( /&/g, "___" );
        return to_return;
    };
    self.cleanJavaScript             = function ( string ) {
        if ( typeof string !== 'string' ) {
            return string;
        }
        var index_open  = string.indexOf( "<script>" );
        var index_close = string.indexOf( "</script>" );
        if ( index_open === -1 || index_close === -1 || index_close < index_open ) {
            return string;
        }
        index_close = index_close + "</script>".length;
        return self.cleanJavaScript( string.substring( 0, index_open ) + string.substring( index_close, string.length ) );
    };
    self.uncleanBeforecleanXss       = function ( string ) {
        if ( typeof string !== 'string' ) {
            return string;
        }
        var _string = self.unescape_xss( string + "" );
        return self.cleanXss( _string );
    };
    self.unescape_xss                = function ( string ) {
        if ( typeof string !== 'string' ) {
            return string;
        }
        string = string || "";
        string = string.replace( /&amp;/g, '&' );
        string = string.replace( /&lt;/g, '<' );
        string = string.replace( /&gt;/g, '>' );
        string = string.replace( /&quot;/g, '"' );
        string = string.replace( /&#x27;/g, "'" );
        string = string.replace( /&#x2F;/g, "/" );
        return string;
    };
    self.escapeBackslash             = function ( string ) {
        return SHINKEN.TOOLS.STRING.replaceAll( string, "\\", "___SHINKEN_BACKSLASH___" );
    };
    self.getRandomInt                = function ( max ) {
        return Math.floor( Math.random() * Math.floor( max ) );
    };
    self.trim                        = function ( string ) {
        return string.trim();
    };
    self.trimExtented                = function ( string ) {
        var _to_return = string.trim();
        if ( _to_return === string ) {
            return string;
        }
        return self.trimExtented( _to_return );
    };
    self.format                      = function () {
        var s = arguments[ 0 ];
        for ( var i = 0; i < arguments.length - 1; i++ ) {
            var reg = new RegExp( "\\{" + i + "\\}", "gm" );
            s       = s.replace( reg, arguments[ i + 1 ] );
        }
        return s;
    };
    self.getNumberOccurence          = function ( string, to_find ) {
        if ( to_find.length <= 0 ) {
            return (string.length + 1);
        }
        
        var n    = 0;
        var pos  = 0;
        var step = to_find.length;
        
        while ( true ) {
            pos = string.indexOf( to_find, pos );
            if ( pos >= 0 ) {
                ++n;
                pos += step;
            }
            else {
                break;
            }
        }
        return n;
    };
    self.startsWith                  = function ( string, to_find ) {
        if ( !string ) {
            return false;
        }
        return string.substr( 0, to_find.length ) === to_find;
    };
    self.endsWith                    = function ( string, to_find ) {
        if ( !string ) {
            return false;
        }
        var _start_index = string.length - to_find.length;
        return string.substr( _start_index ) === to_find;
    };
    self.buildS4                     = function () {
        return Math.floor( (1 + Math.random()) * 0x10000 )
                   .toString( 16 )
                   .substring( 1 );
    };
    self.buildUUID                   = function () {
        return self.buildS4() + self.buildS4() + '-' + self.buildS4() + '-' + self.buildS4() + '-' +
               self.buildS4() + '-' + self.buildS4() + self.buildS4() + self.buildS4();
    };
    self.getCharCodes                = function ( string ) {
        var _size      = string.length;
        var _to_return = [];
        for ( var i = 0; i < _size; i++ ) {
            _to_return[ i ] = string.charCodeAt( i );
        }
        return _to_return;
    };
    self.b64Encode                   = function ( str ) {
        return btoa( encodeURIComponent( str ).replace( /%([0-9A-F]{2})/g, function ( match, p1 ) {
            return String.fromCharCode( parseInt( p1, 16 ) );
        } ) );
    };
    self.b64Decode                   = function ( str ) {
        return decodeURIComponent( Array.prototype.map.call( atob( str ), function ( c ) {
            return '%' + ('00' + c.charCodeAt( 0 ).toString( 16 )).slice( -2 );
        } ).join( '' ) );
    };
    self.urlEncode                   = function ( str ) {
        return encodeURIComponent( str );
    };
    self.urlEncodeForEscapeNavigator = function ( str ) {
        var to_return = encodeURIComponent( str );
        to_return     = self.replaceAll( to_return, '%', '__' );
        to_return     = self.replaceAll( to_return, '!', '__21' );
        to_return     = self.replaceAll( to_return, '(', '__28' );
        to_return     = self.replaceAll( to_return, ')', '__29' );
        to_return     = self.replaceAll( to_return, '*', '__2A' );
        to_return     = self.replaceAll( to_return, '~', '__7E' );
        return to_return;
    };
    self.urlDecode                   = function ( str ) {
        return decodeURIComponent( str );
    };
    self.isEmpty                     = function ( string ) {
        if ( !string ) {
            return true;
        }
        var s = string.replace( /\s/g, '' );
        return s.length === 0;
    };
    self.isEmptyHtml                 = function ( string ) {
        if ( !string ) {
            return true;
        }
        var dom = DOM.Service.createElement( 'div', '', string );
        return self.isEmpty( dom.innerText );
    };
    self.indexesOf                   = function ( string, to_find ) {
        var _to_return = [];
        
        var _length         = string.length;
        var _length_to_find = to_find.length;
        
        var _current;
        for ( var i = 0; i <= _length - _length_to_find; i++ ) {
            _current = string.substring( i, i + _length_to_find );
            if ( _current === to_find ) {
                _to_return.push( i );
            }
        }
        return _to_return;
    };
    self.indexesOfNotBetween         = function ( string, to_find, to_ignore ) {
        var _to_return = self.indexesOf( string, to_find );
        return self.splicesindexesOfNotBetween( _to_return, to_ignore );
    };
    self.splicesindexesOfNotBetween  = function ( indexes, to_ignore ) {
        var _to_return = indexes;
        var _current_index;
        for ( var i = _to_return.length - 1; i >= 0; i-- ) {
            _current_index = _to_return[ i ];
            for ( var j = 0, _size_j = to_ignore.length; j < _size_j; j = j + 2 ) {
                if ( _current_index > to_ignore[ j ] && _current_index < to_ignore[ j + 1 ] ) {
                    _to_return.splice( i, 1 );
                    break;
                }
            }
        }
        return _to_return;
    };
    self.extraTextNotBetween         = function ( text, indexes_to_ignore ) {
        var _to_return = [];
        if ( !Array.isArray( indexes_to_ignore ) || !indexes_to_ignore.length ) {
            return _to_return;
        }
        var _split = self.splitWithIndexes( text, indexes_to_ignore, 1 );
        var _keep  = true;
        for ( var i = 0, _size_i = _split.length; i < _size_i; i++ ) {
            if ( _keep ) {
                _to_return.push( _split[ i ] );
            }
            _keep = !_keep;
        }
        return _to_return;
    };
    self.isInteger                   = function ( string ) {
        var pattern = /^\d+$/;
        return pattern.test( string );
    };
    self.splitWithIndexes            = function ( string, indexes, size_split_label ) {
        var _to_return = [];
        if ( !size_split_label ) {
            size_split_label = 1;
        }
        var _size_index = indexes.length;
        if ( !_size_index ) {
            _to_return[ 0 ] = string;
            return _to_return;
        }
        
        for ( var i = 0; i <= _size_index; i++ ) {
            if ( i === 0 ) {
                _to_return[ i ] = string.substring( 0, indexes[ i ] );
            }
            else if ( i === _size_index ) {
                _to_return[ i ] = string.substring( indexes[ i - 1 ] + size_split_label );
            }
            else {
                _to_return[ i ] = string.substring( indexes[ i - 1 ] + size_split_label, indexes[ i ] );
            }
        }
        
        return _to_return;
        
    };
    self.prefix_by_zero              = function ( str, max ) {
        str = str.toString();
        return str.length < max ? self.prefix_by_zero( "0" + str, max ) : str;
    };
    self.getSubStringUntil           = function ( string, start, end ) {
        var _size = string.length;
        return string.substr( start, _size - end );
    };
    self.getAllIndexOf               = function ( string, to_find, to_return, start_index ) {
        if ( !to_return ) {
            to_return   = [];
            start_index = 0;
        }
        var _index = string.substr( start_index ).indexOf( to_find );
        if ( _index !== -1 ) {
            to_return.push( _index + start_index );
            return self.getAllIndexOf( string, to_find, to_return, _index + to_find.length + start_index );
        }
        return to_return;
    };
    self.escapeRegExp                = function ( string ) {
        return string.replace( /[.*+?^${}()|[\]\\]/g, '\\$&' );
    };
    self.isMatchingStarRegexTab      = function ( to_test, tab_to_test ) {
        for ( var i = 0, _size_i = tab_to_test.length; i < _size_i; i++ ) {
            if ( self.isMatchingStarRegex( to_test, tab_to_test[ i ].trim() ) ) {
                return true;
            }
        }
        return false;
    };
    self.isMatchingStarRegex         = function ( to_test, regex_star ) {
        var _contains_star = self.getAllIndexOf( regex_star, "*" );
        if ( !_contains_star.length ) {
            return to_test.trim() === regex_star.trim();
        }
        var _replaced = SHINKEN.TOOLS.STRING.replaceAll( regex_star, "**", "*" );
        if ( regex_star !== _replaced ) {
            return self.isMatchingStarRegex( to_test, _replaced );
        }
        regex_star         = self.escapeRegExp( regex_star );
        var _current       = new RegExp( SHINKEN.TOOLS.STRING.replaceAll( SHINKEN.TOOLS.STRING.trim( regex_star ), "\\*", ".*" ) );
        var _current_match = to_test.match( _current );
        if ( _current_match && _current_match[ 0 ] === to_test ) {
            return true;
        }
        return false;
    };
    self.toBool                      = function ( value ) {
        if ( value !== "false" && value !== "true" ) {
            return null;
        }
        return value === "true";
    };
    return self;
})( SHINKEN.TOOLS.STRING || {} );
SHINKEN.TOOLS.STRING.PARENTHESIS = (function ( self ) {
    "use strict";
    self.isValid          = function ( indexes_opening, indexes_closing ) {
        var _size_open  = indexes_opening.length;
        var _size_close = indexes_closing.length;
        if ( _size_open !== _size_close ) {
            return _( "validator.parenthesis.not_same_number" );
        }
        for ( var i = 0; i < _size_open; i++ ) {
            if ( indexes_opening[ i ] > indexes_closing[ i ] ) {
                return _( "validator.parenthesis.not_good_order" );
            }
        }
    };
    self.getActiveIndexes = function ( indexes_opening, indexes_closing ) {
        var _to_return = [];
        var _size      = indexes_opening.length;
        var _concat    = [];
        for ( var i = 0; i < _size; i++ ) {
            _concat.push( { index: indexes_opening[ i ], is_open: true } );
        }
        for ( var i = 0; i < _size; i++ ) {
            _concat.push( { index: indexes_closing[ i ], is_open: false } );
        }
        _concat = SHINKEN.TOOLS.ARRAY.sortArray( _concat, "index" );
        if ( !_concat.length ) {
            return _to_return;
        }
        _to_return.push( _concat[ 0 ].index );
        var _current;
        var _search_close = 1;
        for ( var i = 1, _size_i = _concat.length; i < _size_i; i++ ) {
            _current = _concat[ i ];
            if ( _search_close ) {
                if ( _current.is_open ) {
                    _search_close++;
                }
                else {
                    _search_close--;
                    if ( !_search_close ) {
                        _to_return.push( _current.index );
                    }
                }
            }
            else {
                _to_return.push( _current.index );
                _search_close++;
            }
        }
        return _to_return;
    };
    return self;
})( SHINKEN.TOOLS.STRING.PARENTHESIS || {} );
SHINKEN.TOOLS.STRING.JSON        = (function ( self ) {
    "use strict";
    self.isFormatJsonInvalid    = function ( json_to_test ) {
        try {
            JSON.parse( json_to_test );
        }
        catch ( json_error ) {
            return json_error;
        }
        return false;
    };
    self.getFormattedLineNumber = function ( dict ) {
        return SHINKEN.TOOLS.STRING.getNumberOccurence( JSON.stringify( dict, null, 2 ), "\n" );
    };
    return self;
})( SHINKEN.TOOLS.STRING.JSON || {} );
SHINKEN.TOOLS.MD5 = (function ( self ) {
    "use strict";
    self.MD5 = function ( d ) {
        var result = M( V( Y( X( d ), 8 * d.length ) ) );
        return result.toLowerCase();
    };
    
    function M ( d ) {
        for ( var _, m = "0123456789ABCDEF", f = "", r = 0; r < d.length; r++ ) {
            _ = d.charCodeAt( r ), f += m.charAt( _ >>> 4 & 15 ) + m.charAt( 15 & _ );
        }
        return f;
    }
    
    function X ( d ) {
        for ( var _ = Array( d.length >> 2 ), m = 0; m < _.length; m++ ) {
            _[ m ] = 0;
        }
        for ( m = 0; m < 8 * d.length; m += 8 ) {
            _[ m >> 5 ] |= (255 & d.charCodeAt( m / 8 )) << m % 32;
        }
        return _;
    }
    
    function V ( d ) {
        for ( var _ = "", m = 0; m < 32 * d.length; m += 8 ) {
            _ += String.fromCharCode( d[ m >> 5 ] >>> m % 32 & 255 );
        }
        return _;
    }
    
    function Y ( d, _ ) {
        d[ _ >> 5 ] |= 128 << _ % 32, d[ 14 + (_ + 64 >>> 9 << 4) ] = _;
        for ( var m = 1732584193, f = -271733879, r = -1732584194, i = 271733878, n = 0; n < d.length; n += 16 ) {
            var h = m,
                t = f,
                g = r,
                e = i;
            f = md5_ii( f = md5_ii( f = md5_ii( f = md5_ii( f = md5_hh( f = md5_hh( f = md5_hh( f = md5_hh( f = md5_gg( f = md5_gg( f = md5_gg( f = md5_gg( f = md5_ff( f = md5_ff( f = md5_ff( f = md5_ff( f, r = md5_ff( r, i = md5_ff( i, m = md5_ff( m, f, r, i, d[ n + 0 ], 7, -680876936 ), f, r, d[ n + 1 ], 12, -389564586 ), m, f, d[ n + 2 ], 17, 606105819 ), i, m, d[ n + 3 ], 22, -1044525330 ), r = md5_ff( r, i = md5_ff( i, m = md5_ff( m, f, r, i, d[ n + 4 ], 7, -176418897 ), f, r, d[ n + 5 ], 12, 1200080426 ), m, f, d[ n + 6 ], 17, -1473231341 ), i, m, d[ n + 7 ], 22, -45705983 ), r = md5_ff( r, i = md5_ff( i, m = md5_ff( m, f, r, i, d[ n + 8 ], 7, 1770035416 ), f, r, d[ n + 9 ], 12, -1958414417 ), m, f, d[ n + 10 ], 17, -42063 ), i, m, d[ n + 11 ], 22, -1990404162 ), r = md5_ff( r, i = md5_ff( i, m = md5_ff( m, f, r, i, d[ n + 12 ], 7, 1804603682 ), f, r, d[ n + 13 ], 12, -40341101 ), m, f, d[ n + 14 ], 17, -1502002290 ), i, m, d[ n + 15 ], 22, 1236535329 ), r = md5_gg( r, i = md5_gg( i, m = md5_gg( m, f, r, i, d[ n + 1 ], 5, -165796510 ), f, r, d[ n + 6 ], 9, -1069501632 ), m, f, d[ n + 11 ], 14, 643717713 ), i, m, d[ n + 0 ], 20, -373897302 ), r = md5_gg( r, i = md5_gg( i, m = md5_gg( m, f, r, i, d[ n + 5 ], 5, -701558691 ), f, r, d[ n + 10 ], 9, 38016083 ), m, f, d[ n + 15 ], 14, -660478335 ), i, m, d[ n + 4 ], 20, -405537848 ), r = md5_gg( r, i = md5_gg( i, m = md5_gg( m, f, r, i, d[ n + 9 ], 5, 568446438 ), f, r, d[ n + 14 ], 9, -1019803690 ), m, f, d[ n + 3 ], 14, -187363961 ), i, m, d[ n + 8 ], 20, 1163531501 ), r = md5_gg( r, i = md5_gg( i, m = md5_gg( m, f, r, i, d[ n + 13 ], 5, -1444681467 ), f, r, d[ n + 2 ], 9, -51403784 ), m, f, d[ n + 7 ], 14, 1735328473 ), i, m, d[ n + 12 ], 20, -1926607734 ), r = md5_hh( r, i = md5_hh( i, m = md5_hh( m, f, r, i, d[ n + 5 ], 4, -378558 ), f, r, d[ n + 8 ], 11, -2022574463 ), m, f, d[ n + 11 ], 16, 1839030562 ), i, m, d[ n + 14 ], 23, -35309556 ), r = md5_hh( r, i = md5_hh( i, m = md5_hh( m, f, r, i, d[ n + 1 ], 4, -1530992060 ), f, r, d[ n + 4 ], 11, 1272893353 ), m, f, d[ n + 7 ], 16, -155497632 ), i, m, d[ n + 10 ], 23, -1094730640 ), r = md5_hh( r, i = md5_hh( i, m = md5_hh( m, f, r, i, d[ n + 13 ], 4, 681279174 ), f, r, d[ n + 0 ], 11, -358537222 ), m, f, d[ n + 3 ], 16, -722521979 ), i, m, d[ n + 6 ], 23, 76029189 ), r = md5_hh( r, i = md5_hh( i, m = md5_hh( m, f, r, i, d[ n + 9 ], 4, -640364487 ), f, r, d[ n + 12 ], 11, -421815835 ), m, f, d[ n + 15 ], 16, 530742520 ), i, m, d[ n + 2 ], 23, -995338651 ), r = md5_ii( r, i = md5_ii( i, m = md5_ii( m, f, r, i, d[ n + 0 ], 6, -198630844 ), f, r, d[ n + 7 ], 10, 1126891415 ), m, f, d[ n + 14 ], 15, -1416354905 ), i, m, d[ n + 5 ], 21, -57434055 ), r = md5_ii( r, i = md5_ii( i, m = md5_ii( m, f, r, i, d[ n + 12 ], 6, 1700485571 ), f, r, d[ n + 3 ], 10, -1894986606 ), m, f, d[ n + 10 ], 15, -1051523 ), i, m, d[ n + 1 ], 21, -2054922799 ), r = md5_ii( r, i = md5_ii( i, m = md5_ii( m, f, r, i, d[ n + 8 ], 6, 1873313359 ), f, r, d[ n + 15 ], 10, -30611744 ), m, f, d[ n + 6 ], 15, -1560198380 ), i, m, d[ n + 13 ], 21, 1309151649 ), r = md5_ii( r, i = md5_ii( i, m = md5_ii( m, f, r, i, d[ n + 4 ], 6, -145523070 ), f, r, d[ n + 11 ], 10, -1120210379 ), m, f, d[ n + 2 ], 15, 718787259 ), i, m, d[ n + 9 ], 21, -343485551 ), m = safe_add( m, h ), f = safe_add( f, t ), r = safe_add( r, g ), i = safe_add( i, e );
        }
        return Array( m, f, r, i );
    }
    
    function md5_cmn ( d, _, m, f, r, i ) {
        return safe_add( bit_rol( safe_add( safe_add( _, d ), safe_add( f, i ) ), r ), m );
    }
    
    function md5_ff ( d, _, m, f, r, i, n ) {
        return md5_cmn( _ & m | ~_ & f, d, _, r, i, n );
    }
    
    function md5_gg ( d, _, m, f, r, i, n ) {
        return md5_cmn( _ & f | m & ~f, d, _, r, i, n );
    }
    
    function md5_hh ( d, _, m, f, r, i, n ) {
        return md5_cmn( _ ^ m ^ f, d, _, r, i, n );
    }
    
    function md5_ii ( d, _, m, f, r, i, n ) {
        return md5_cmn( m ^ (_ | ~f), d, _, r, i, n );
    }
    
    function safe_add ( d, _ ) {
        var m = (65535 & d) + (65535 & _);
        return (d >> 16) + (_ >> 16) + (m >> 16) << 16 | 65535 & m;
    }
    
    function bit_rol ( d, _ ) {
        return d << _ | d >>> 32 - _;
    }
    
    return self;
})( SHINKEN.TOOLS.MD5 || {} );
String.prototype.startsWith = String.prototype.startsWith || function ( pattern ) {
    return this.indexOf( pattern ) === 0;
};
String.prototype.endsWith   = String.prototype.endsWith || function ( pattern ) {
    var d = this.length - pattern.length;
    return d >= 0 && this.lastIndexOf( pattern ) === d;
};
SHINKEN.TOOLS.CLASS = (function ( self ) {
    "use strict";
    self.CONST        = {
        COMPONENT: {
            SELECT: "component-select"
        }
    };
    self.addPrototype = function ( object_to_add_in, object_to_add_from ) {
        var _current;
        var _keys = Object.keys( object_to_add_from.prototype );
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current = _keys[ i ];
            if ( !object_to_add_in.prototype[ _current ] ) {
                object_to_add_in.prototype[ _current ] = object_to_add_from.prototype[ _current ];
            }
        }
    };
    return self;
})( SHINKEN.TOOLS.CLASS || {} );
var COMPONENT = {};
COMPONENT.CONST = {
    NOT_FOUND               : -1,
    BTN_STATE               : {
        DISABLED           : -1,
        OFF                : 0,
        ON                 : 1,
        DISCREET           : 2,
        INIT               : 3,
        ENABLED_WITH_ERRORS: 4
    },
    BTN_STATUS              : {
        NONE   : 0,
        WARNING: 1,
        ERROR  : 2
    },
    AUTO_SELECT_ACTION_TYPE : {
        MOVE_DOWN: 'move_down',
        MOVE_UP  : 'move_up',
        MOUSE    : 'mouse',
        KEY_INPUT: 'key_input'
    },
    BTN_NAME                : {
        SAVE: 'save'
    },
    SELECT                  : {
        SELECTOR                  : 'shinken-select-selector',
        SELECTOR_TEXT             : 'shinken-selector-label',
        SELECTOR_LIST             : 'shinken-list-select',
        SELECTOR_LIST_OPTION      : 'shinken-option',
        OPTION_ACTIVE_STAGING     : 'shinken-active-option-staging',
        OPTION_ACTIVE_WORKING_AREA: 'shinken-active-option-working-area',
        DATA_STATE_SELECTOR       : 'stateSelector',
        TIMER_DELAY_BUILD_HTML    : 100
    },
    BTN_INHERITANCE         : {
        TIMER_DELAY_BUILD_HTML: 100
    },
    INHERITANCE_ARBORESCENCE: {},
    TAG                     : {
        STATE: {
            WORKING         : 'working_area',
            NEW             : 'new',
            STAGGING        : 'stagging',
            DISABLED        : 'disabled',
            UNKNOWN         : 'unknown',
            HIDDEN          : 'hidden',
            INHERITED       : 'inherited',
            FORCE_TO_NULL   : 'force-to-null',
            OVERRIDE_NEW    : 'override-new',
            OVERRIDE_UNKNOWN: 'override-unknown',
            IT_SELF         : 'shinken-itself'
        }
    },
    FILTER                  : {
        TYPES_VALIDATION: {
            HAS_FOCUS: "has_focus",
            NOT_FOCUS: "not_focus"
        }
    },
    INPUT                   : {
        TYPES: {
            SINGLE_SELECT: 'single-select'
        }
    },
    LIST_SELECT             : {
        CLASS: {
            NO_RESULT   : 'shinken-no-result',
            FILTERING_ON: 'shinken-filtering-on'
        }
    },
    LIST_SELECT_ELEMENT     : {
        CLASS: {
            HIDDEN: 'shinken-hidden'
        }
    },
    STATUS                  : {
        NONE    : 'shinken-no-status',
        INFO    : 'shinken-info',
        ERROR   : 'shinken-error-status',
        WARNING : 'shinken-warning-status',
        BEWARE  : 'shinken-beware-status'
    },
    TAG_INFORMATION         : {
        STATUS: {
            NONE                 : 'none',
            ALL_DISABLED         : 'all-disabled',
            ALL_DISABLED_OVERRIDE: 'all-disabled-override',
            NOT_VALID_FOR_ARBITER: 'not-arbiter-valid',
            USER_GROUP_COHERENCY : 'user-group-coherency',
            IN_SHELL             : 'in_shell',
            CHECK_DUPLICATE      : 'check_duplicate'
        }
    }
};
var SHINKEN_LIST          = {};
SHINKEN_LIST.FACTORY_HTML = {};
SHINKEN_LIST.CONST = {
    MASS_ACTION     : {
        NAME          : 'mass-action',
        WORK_AREA_NAME: 'mass-action-work-area'
    },
    STRUCTURE_FORMAT: {
        GENERIC        : "GENERIC",
        WITH_HEADER_FIX: "WITH_HEADER_FIX"
    },
    TYPE            : {
        CHECK_IN_HOST       : "CHECK_IN_HOST",
        MASS_CHANGE_SUM_FULL: "MASS_CHANGE_SUM_FULL",
        DATA_PROP           : "DATA_PROP"
    },
    FILTER          : {
        HAS_CHILDREN: "**SHINKEN_HAS_CHILDREN**",
        ALL         : "___ALL___",
        EMPTY       : "___EMPTY___",
        NOT_EMPTY   : "___NOT_EMPTY___",
        STATUS      : {
            DISABLED    : -1,
            OFF         : 0,
            ON          : 1,
            HAS_CHILDREN: 2
        },
        TYPE        : {
            INPUT_STRING_ARRAY: "input_string_array"
        }
    },
    SELECTION       : {
        STATUS: {
            DISABLED: -1,
            OFF     : 0,
            ON      : 1
        }
    }
};
"use strict";
var MANAGER = {};
MANAGER.CONST = {
    STATE          : {
        WORK_FLOW: {
            STAGING     : "save-direct-in-staging",
            WORKING_AREA: "save-in-working-area"
        }
    },
    DRAG_N_DROP    : {
        CLASS: {
            HOVER    : "hover",
            DRAGGABLE: "draggable",
            DRAGGING : "shinken-dragging-on"
        }
    },
    HELP           : {
        STATUS: {
            INACTIVE: 1,
            ACTIVE  : 2,
            FORCED  : 3
        }
    },
    AFTER_ACTION   : {
        CLICK_ON_SERVICE_OVERRIDE       : 0,
        UPDATE_VIEW_ON_WINDOW_PROPERTIES: 1
    },
    CONTROLLER     : {
        SHINKEN_ELEMENT: "shinken-element",
        LIST_ALL       : "list-all",
        MASS_CHANGE    : "mass-change",
        SOURCES        : "sources",
        MAIN           : "main",
        WEATHER        : "weather",
        COMMON_UI      : "common_ui"
    },
    USER_PREFS_KEYS: {
        SHOW_SOURCE_CONFIGURATION_TAB_OLD_RUN: "show_source_configuration_tab_old_run"
    }
};
SHINKEN.OBJECT.ShinkenObject           = function () {
    this.__class_name__ = 'SHINKEN.OBJECT.ShinkenObject';
};
SHINKEN.OBJECT.ShinkenObject.prototype = {
    setShinkenDebug : function ( to_set ) {
        this.is_shinken_debug = to_set;
        var _components       = this.getChildrenObject();
        for ( var i = 0, _size_i = _components.length; i < _size_i; i++ ) {
            if ( _components[ i ] ) {
                _components[ i ].setShinkenDebug( to_set );
            }
        }
    },
    isShinkenDebugOn: function () {
        return this.is_shinken_debug;
    },
    getChildrenObject    : function () {
        return [];
    },
    getChildrenObjectDict: function () {
        return {};
    },
    setMessages          : function ( to_set ) {
        this.messages = new OBJECT.Messages();
        if ( !to_set ) {
            return;
        }
        var _keys = Object.keys( to_set );
        var _current_key;
        for ( var i = 0, _size_i = _keys.length; i < _size_i; i++ ) {
            _current_key = _keys[ i ];
            for ( var j = 0, _size_j = to_set[ _current_key ].length; j < _size_j; j++ ) {
                this.messages.addMessage( OBJECT.MessageService.parseBackendStatus( _current_key ), to_set[ _current_key ][ j ] );
            }
        }
    },
    setNeedValidation: function ( to_set ) {
        this.need_validation = to_set;
        var _components      = this.getChildrenObject();
        for ( var i = 0, _size_i = _components.length; i < _size_i; i++ ) {
            _components[ i ].setNeedValidation( to_set );
        }
    },
    getObjectClassName: function () {
        return this.__class_name__;
    }
};
SHINKEN.OBJECT.ShinkenObjectJson           = function () {
    this.__class_name__ = 'SHINKEN.OBJECT.ShinkenObjectJson';
};
SHINKEN.OBJECT.ShinkenObjectJson.prototype = {
    parseToJson               : function () {
        var _to_return = this.getObjectToJson();
        
        var _components = this.getChildrenObjectDict();
        
        
        if ( Array.isArray( _components ) ) {
            _to_return = [];
            for ( var i = 0, _size_i = _components.length; i < _size_i; i++ ) {
                _to_return.push( _components[ i ].parseToJson() );
            }
        }
        else {
            var _keys = Object.keys( _components );
            var _current_key;
            for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
                _current_key = _keys[ i ];
                if ( Array.isArray( _components[ _current_key ] ) ) {
                    _to_return[ _current_key ] = [];
                    for ( var j = 0, _size_j = _components[ _current_key ].length; j < _size_j; j++ ) {
                        _to_return[ _current_key ].push( _components[ _current_key ][ j ].parseToJson() );
                    }
                }
                else if ( _components[ _current_key ] ) {
                    _to_return[ _current_key ] = _components[ _current_key ].parseToJson();
                }
            }
        }
        this.computeJsonLength( _to_return );
        return _to_return;
    },
    computeJsonLength         : function ( dict ) {
        this.json_length = SHINKEN.TOOLS.STRING.JSON.getFormattedLineNumber( dict );
    },
    getAllMessagesWithLineJson: function ( index_parent ) {
        var to_return = [];
        var _index    = index_parent ? index_parent + 1 : 1;
        if ( this.messages ) {
            var _message_current = this.messages.getAllMessages();
            for ( var i = 0, _size_i = _message_current.length; i < _size_i; i++ ) {
                _message_current[ i ].setLineIndex( _index );
            }
            to_return = _message_current;
        }
        var _components = this.getChildrenObject();
        for ( var j = 0, _size_j = _components.length; j < _size_j; j++ ) {
            if ( _components[ j ] ) {
                to_return = SHINKEN.TOOLS.ARRAY.concat( to_return, _components[ j ].getAllMessagesWithLineJson( _index ) );
                _index    = _index + _components[ j ].json_length;
            }
        }
        return to_return;
    },
    getUnknownValue           : function () {
        return this.unknown_property;
    },
    setUnknownValue           : function ( key, value ) {
        if ( !this.unknown_property ) {
            this.unknown_property = {};
        }
        this.unknown_property[ key ] = value;
    },
    getObjectToJson           : function () {
        var _to_return = this._getObjectToJson() || {};
        if ( this.unknown_property ) {
            SHINKEN.TOOLS.DICT.assign( _to_return, this.unknown_property );
        }
        return _to_return;
    },
    _getObjectToJson          : function () {
        return {};
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.ShinkenObjectJson, SHINKEN.OBJECT.ShinkenObject );
SHINKEN.OBJECT.InterfaceHtml           = function () {
};
SHINKEN.OBJECT.InterfaceHtml.prototype = {
    addClass: function ( toAdd ) {
        if ( !this.class ) {
            this.class = toAdd;
        }
        else {
            this.class = this.class + " " + toAdd;
        }
    }
};
var OBJECT = {};
OBJECT.CONST = {
    TEMPLATE             : {
        FIELD : {
            UUID             : 'uuid',
            _ID              : '_id',
            _SYNC_KEYS       : '_SYNC_KEYS',
            NAME             : 'name',
            IS_TEMPLATE      : 'is_template',
            IS_TOP_LEVEL     : 'is_top_level',
            ITEM_TYPE        : 'item_type',
            LAST_MODIFICATION: 'last_modification',
            REGISTER         : 'register',
            SOURCES          : 'sources',
            USE              : 'use',
            ENABLED          : 'enabled',
            UNCONFIGURED     : 'unconfigured',
            STATUS           : 'template-status',
            IS_NEW           : 'is_new',
            LOOP             : 'loop',
            WORK_AREA_INFO   : 'work_area_info',
            METADATA         : '@metadata'
        },
        STATUS: {
            USEFUL  : 'useful-template',
            USELESS : 'useless-template',
            BADLOOP : 'badloop-template',
            NEW     : 'new-template',
            UNKNOWN : 'unknown-template',
            DISABLED: 'disabled-template'
        }
    },
    ELEMENT_LIST         : {
        TYPE: {
            USER       : 'user',
            INHERITANCE: 'inheritance',
            SEARCHING  : 'searching'
        }
    },
    MACRO                : {
        TYPE: {
            HOST_LOCAL        : '_HOST',
            SERVICE_LOCAL     : '_SERVICE',
            HOST_PROPERTY     : 'macros_host_properties',
            SERVICE_PROPERTY  : 'macros_service_properties',
            GLOBAL            : 'macros_global',
            GLOBAL_INTERPRETED: 'macros_global_interpreted',
            UNKNOWN           : 'unknown',
            VALUE_DFE         : 'VALUE_DFE',
            DFE_KEY           : '$KEY$'
        }
    },
    CHECK_IN_HOST        : {
        STATUS: {
            NONE                           : "",
            DFE_STRUCTURE                  : 'dfe-structure',
            ALREADY_EXISTING_NAME          : "already_existing_name",
            ALREADY_EXISTING_NAME_IN_SAME  : "already_existing_name_in_same_host",
            ALREADY_EXISTING_NAME_DUPLICATE: "already_existing_name_duplicate"
        }
    },
    ELEMENT              : {
        PHASE           : {
            INIT         : 0,
            VIEWING      : 1,
            EDITING      : 2,
            ON_SAVING    : 3,
            SAVING_FAILED: 4,
            RELOADING    : 5
        },
        FIELD           : {
            ID                    : '_id',
            UUID                  : 'uuid',
            SOURCES               : 'sources',
            IMPORT_DATE           : 'import_date',
            SERVICE_OVERRIDES     : 'service_overrides',
            SERVICE_EXCLUDES_BY_ID: 'service_excludes_by_id',
            WORK_AREA_INFO        : 'work_area_info',
            SYNC_KEYS             : '_SYNC_KEYS ',
            LAST_MODIFICATION     : 'last_modification',
            ENABLED               : 'enabled',
            STATUS                : 'status',
            ITEM_TYPE             : 'item_type'
        },
        FIELD_UI        : {
            UUID                      : 'uuid',
            ITEM_NAME                 : 'item_name',
            ITEM_TYPE                 : 'item_type',
            ITEM_UUID                 : 'item_uuid',
            STATUS                    : 'status',
            CONTEXT                   : 'context',
            CONTEXT_OR_STATUS         : 'context_or_status',
            SLA                       : {
                __KEY__           : "sla",
                VALUE             : 'value',
                TENDENCY          : 'tendency',
                WARNING_THRESHOLD : 'warning_threshold',
                CRITICAL_THRESHOLD: 'critical_threshold'
            },
            IS_EXISTING               : 'exists',
            IS_NOT_AUTHORIZED_FOR_USER: 'is_not_authorized_for_user',
            NAME                      : 'name',
            VISUALISATION_NAME        : 'visualisation_name'
        },
        MODULATION      : {
            TYPE: {
                NONE_FORCED: -1,
                NONE       : 0,
                PLUS       : 1,
                EXISTING   : 2,
                ERROR      : 3
            }
        },
        TYPE            : {
            CLUSTERS                  : 'clusters',
            CLUSTER_TPLS              : 'clustertpls',
            DISCOVERY                 : 'discovery',
            HOSTS                     : 'hosts',
            HOST_GROUPS               : 'hostgroups',
            HOST_TPLS                 : 'hosttpls',
            CHECK_ON_HOST             : 'serviceshosts',
            CHECK_ON_TPL_HOST         : 'serviceshosttpls',
            CHECK_ON_CLUSTER          : 'servicesclusters',
            CHECK_ON_TPL_CLUSTER      : 'servicesclustertpls',
            CHECK_TPLS                : 'servicetpls',
            COMMANDS                  : 'commands',
            CONTACT_GROUPS            : 'contactgroups',
            CONTACT_TPLS              : 'contacttpls',
            CONTACTS                  : 'contacts',
            ESCALATIONS               : 'escalations',
            MODULATION_BUSINESS_IMPACT: 'businessimpactmodulations',
            MODULATION_DATA           : 'macromodulations',
            MODULATION_RESULT         : 'resultmodulations',
            NOTIFICATION_WAYS         : 'notificationways',
            TIME_PERIODS              : 'timeperiods',
            SYNCHRONIZER_LINKER       : 'sync'
        },
        WORK_AREA_STATUS: {
            PROPOSED : 'PROPOSED',
            WORKING  : 'WORKING',
            REJECTED : 'REJECTED',
            VALIDATED: 'VALIDATED'
            
        },
        STATUS          : {
            NEW: 'new'
        },
        SLA             : {
            TENDENCY: {
                STAGNANT  : 'stagnant',
                DECRASING : 'decreasing',
                INCREASING: 'increasing'
            }
        },
        SAVE            : {
            TYPE: {
                LINK: "LINK"
            }
        }
    },
    OVERRIDE_STATUS      : {
        OFF     : "0",
        ON      : "1",
        DISABLED: "2"
    },
    MODE_OVERRIDE_EXCLUDE: {
        NORMAL  : "0",
        OVERRIDE: "1",
        EXCLUDE : "2"
    },
    EXCLUDE_STATUS       : {
        OFF    : "0",
        BY_ID  : "1",
        BY_NAME: "2"
    }
};
SHINKEN.OBJECT.CONST.VALIDATION = {
    FIELD: {
        MESSAGES: 'validation_messages',
        ERRORS  : 'errors',
        CRITICAL: 'critical',
        WARNINGS: 'warnings'
    }
};
SHINKEN.TOOLS.DICT = (function ( self ) {
    "use strict";
    self.CONST   = {};
    self.assign  = function ( dest, src ) {
        var _keys = Object.keys( src );
        var _current_key;
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current_key         = _keys[ i ];
            dest[ _current_key ] = src[ _current_key ];
        }
        return dest;
    };
    self.assigns = function ( dest, srcs ) {
        return srcs.reduce( self.assign, dest );
    };
    self.clone  = function (to_clone) {
        var json = JSON.stringify(to_clone);
        var to_return = JSON.parse(json);
        
        return to_return;
    }
    return self;
})( SHINKEN.TOOLS.DICT || {} );
var WINDOW = {};
WINDOW.CONST = {
    ELEMENT: {
        GENERIC      : "generic",
        DATAS        : "datas",
        CHECKS       : "checks",
        MONITORING   : "monitoring",
        NOTIFICATIONS: "notifications",
        ADVANCED     : "advanced",
        USER_RIGHTS  : "user-rights",
        AUTHORIZATION: "authorization",
        PROPOSED     : "proposed"
    },
    CLASS  : {
        WINDOW_GROUP: "shinken-window-group",
        WINDOW_TAB  : "shinken-window-element"
    },
    ID     : {
        WINDOW_TAB: "id-shinken-window-",
        TAB_PANE  : "tab-pane-"
    },
    GROUP  : {
        MASS_CHANGE: "mass-change"
    }
};
var CONTROLLER = {};
CONTROLLER.CONST = {
    MASS_CHANGE: {
        NAME      : "mass-change",
        TYPE      : {
            PROPERTIES     : 'properties',
            DATAS          : 'datas',
            LOCAL_DATAS    : 'local_datas',
            DFE_DATAS      : 'dfe_datas',
            CHECKS         : 'checks',
            CHECKS_OVERRIDE: 'overrides',
            CHECKS_EXCLUDE : 'excludes'
        },
        GROUP_DATA: {
            ALL  : "___ALL___",
            LOCAL: "___LocalData___"
        }
    },
    PHASE      : {
        ACTIVE: 1
    }
};
var SHINKEN_TOOLTIP = (function ( self ) {
    "use strict";
    
    self.PLACEMENT                = {};
    self.PLACEMENT.LEFT           = 'left';
    self.PLACEMENT.RIGHT          = 'right';
    self.PLACEMENT.TOP            = 'top';
    self.PLACEMENT.TOP_LEFT       = 'top-left';
    self.PLACEMENT.TOP_RIGHT      = 'top-right';
    self.PLACEMENT.BOTTOM         = 'bottom';
    self.PLACEMENT.BOTTOM_LEFT    = 'bottom-left';
    self.PLACEMENT.BOTTOM_RIGHT   = 'bottom-right';
    self.TYPE                     = {};
    self.TYPE.ERROR               = 'shinken-error';
    self.TYPE.ERROR_BORDER        = 'shinken-error-border';
    self.TYPE.WARNING             = 'shinken-warning';
    self.TYPE.WARNING_BORDER      = 'shinken-warning-border';
    self.TYPE.BEWARE_BORDER       = 'shinken-beware-border';
    self.TYPE.NORMAL_DISCREET     = 'shinken-normal-discreet';
    self.TYPE.NORMAL_ON_BLACK     = 'shinken-normal-on-black';
    self.TYPE.DISPLAY_TEXT        = 'shinken-normal-text';
    self.CONDITION                = {};
    self.CONDITION.SHIFT          = 'shinken-shift';
    self.CONDITION.CTRL_SHIFT     = 'shinken-ctrl-shift';
    self.CONDITION.ELLIPSIS       = 'shinken-ellipsis';
    self.STYLE                    = {};
    self.STYLE.PADDING_HORIZONTAL = 8;
    self.STYLE.PADDING_VERTICAL   = 4;
    self.STYLE.MIN_WIDTH_TEXT     = 60;
    self.STYLE.HEIGHT_TEXT_LINE   = 20;
    self.STYLE.ARROW_SIZE         = 5;
    self.DEFAULT                  = {};
    self.DEFAULT.TIMER_POP        = 100;
    self.MAX_TRY_IN_SCREEN        = 10;
    
    self.CONDITION_TYPE = {
        HAS_CLASS    : "has_class",
        HAS_NOT_CLASS: "has_not_class"
    };
    
    
    self.CONDITION_TYPE = {
        HAS_CLASS    : "has_class",
        HAS_NOT_CLASS: "has_not_class"
    };
    
    
    var __container;
    var __text_container;
    var __type;
    var __condition;
    var __arrow;
    var __placement;
    var __placement_origin;
    var __try;
    var __try_container;
    var __innerText;
    var __innerHtml;
    var __width;
    var __height;
    var __timer_pop;
    var __parent_container;
    var __classes_added;
    var __timeout_pop;
    var __interval_pop_out;
    var __interval_auto_scroll;
    var __timeout_auto_scroll;
    var __pos_top;
    var __pos_left;
    
    self.showTooltipIf = function ( element, condition_type, condition_value ) {
        if ( !condition_value || !condition_type ) {
            return;
        }
        switch ( condition_type ) {
            case self.CONDITION_TYPE.HAS_CLASS:
                if ( !element.classList.contains( condition_value ) ) {
                    return false;
                }
                break;
            case  self.CONDITION_TYPE.HAS_NOT_CLASS :
                var _splitted = condition_value.split( ',' );
                for ( var i = 0, _size = _splitted.length; i < _size; i++ ) {
                    if ( element.classList.contains( _splitted[ i ] ) ) {
                        return false;
                    }
                }
                break;
            default:
                console.log( "Type not manage" );
                return false;
        }
        _showTooltip( element );
    };
    
    self.showTooltip = function ( element ) {
        if ( !element ) {
            return;
        }
        if ( !__container ) {
            initDomElement();
        }
        if ( !__container ) {
            return;
        }
        var _condition_type = element.getAttribute( "shi-tip-condition-type" );
        if ( _condition_type ) {
            return self.showTooltipIf( element, _condition_type, element.getAttribute( "shi-tip-condition-value" ) );
        }
        
        _showTooltip( element );
    };
    
    self.hideTooltip   = function () {
        if ( __container ) {
            setActive( false );
            clean();
        }
    };
    self.updateTooltip = function ( element ) {
        if ( !DOM.Service.isVisible( __container ) ) {
            self.showTooltip( element );
            return;
        }
        _showTooltip( element, true );
    };
    
    function _showTooltip ( element, skip_clean ) {
        __try           = 0;
        __try_container = 0;
        if ( !skip_clean ) {
            clean();
        }
        setTimerPop( element );
        setText( element );
        setHTML( element );
        setType( element );
        setCondition( element );
        setParentContainer( element );
        if ( __innerText || __innerHtml ) {
            setClass( element );
            getSize();
            setPlacement( element );
            setPosition( element, skip_clean );
            setArrow();
            launchIntervalPopOut( element );
            launchIntervalAutoScroll( element );
        }
    }
    
    function setPlacement ( element ) {
        cleanArrow();
        __placement        = element.getAttribute( 'shi-tip-placement' ) || self.PLACEMENT.TOP;
        __placement_origin = __placement;
    }
    
    function setActive ( _bool ) {
        if ( _bool ) {
            __container.classList.add( 'shinken-tooltip-active' );
        }
        else {
            __container.classList.remove( 'shinken-tooltip-active' );
        }
    }
    
    function setArrow () {
        __container.classList.add( __placement );
    }
    
    function cleanIntervalPopOut () {
        if ( __interval_pop_out ) {
            clearInterval( __interval_pop_out );
            __interval_pop_out = null;
        }
    }
    
    function cleanIntervalAutoScroll () {
        __text_container.scrollTop = -400;
        if ( __timeout_auto_scroll ) {
            clearTimeout( __timeout_auto_scroll );
            __timeout_auto_scroll = null;
        }
        if ( __interval_auto_scroll ) {
            clearInterval( __interval_auto_scroll );
            __interval_auto_scroll = null;
        }
    }
    
    function launchIntervalPopOut ( element ) {
        cleanIntervalPopOut();
        var _data_timer                = new Date().getTime();
        var _selector                  = "[data-shinken-tooltip='" + _data_timer + "']";
        element.dataset.shinkenTooltip = _data_timer;
        __interval_pop_out             = setInterval( function () {
            var _elements = document.querySelector( _selector );
            if ( !_elements ) {
                setActive( false );
                cleanIntervalPopOut();
            }
        }, 1000 );
    }
    
    function launchIntervalAutoScroll ( element ) {
        cleanIntervalAutoScroll();
        if ( __text_container.clientHeight < __text_container.scrollHeight ) {
            __timeout_auto_scroll = setTimeout( function () {
                __interval_auto_scroll = setInterval( function () {
                    __text_container.scrollTop = __text_container.scrollTop + 1;
                    if ( __text_container.scrollTop >= __text_container.scrollHeight - __text_container.clientHeight ) {
                        __timeout_auto_scroll = setTimeout( function () {
                            launchIntervalAutoScroll();
                        }, 2000 );
                    }
                }, 100 );
            }, 2000 );
            
        }
        
    }
    
    function cleanArrow () {
        __container.classList.remove( __placement );
    }
    
    function cleanRectWidth ( _rect ) {
        var _to_return = Math.min( _rect.width, 600 );
        if ( __classes_added ) {
            if ( __classes_added.indexOf( '300' ) !== -1 ) { //BGL  A REFAIRE PROPRE
                _to_return = Math.min( _to_return, 300 );
            }
        }
        return _to_return;
    }
    
    function setPosition ( element_to_bind, skip_clean ) {
        if ( !skip_clean ) {
            clean();
        }
        var _rect       = element_to_bind.getBoundingClientRect();
        var _width_rect = cleanRectWidth( _rect );
        if ( !_width_rect ) {
            return; //ELEMENT NOT DISPLAYED
        }
        computePosition(_rect, _width_rect);
        
        if ( isInScreen() ) {
            if ( __try > self.MAX_TRY_IN_SCREEN ){
                computePosition(_rect, _width_rect);
            }
            __timeout_pop = setTimeout( function () {
                __container.style.top  = __pos_top + 'px';
                __container.style.left = __pos_left + 'px';
            }, __timer_pop );
        }
        else {
            setPosition( element_to_bind, skip_clean );
        }
    }
    
    function computePosition (_rect, _width_rect) {
        switch ( __placement ) {
            case self.PLACEMENT.TOP:
                __pos_top  = (_rect.top - __height + self.STYLE.ARROW_SIZE);
                __pos_left = (_rect.left + _width_rect / 2 - __width / 2);
                break;
            case self.PLACEMENT.TOP_LEFT:
                __pos_top  = (_rect.top - __height + self.STYLE.ARROW_SIZE);
                __pos_left = _rect.left - __width + _width_rect + 2 * self.STYLE.ARROW_SIZE;
                break;
            case self.PLACEMENT.TOP_RIGHT:
                __pos_top  = (_rect.top - __height + self.STYLE.ARROW_SIZE);
                __pos_left = _rect.left - 2 * self.STYLE.ARROW_SIZE;
                break;
            case self.PLACEMENT.LEFT:
                __pos_top  = (_rect.top + _rect.height / 2 - __height / 2);
                __pos_left = (_rect.left - __width);
                break;
            case self.PLACEMENT.RIGHT:
                __pos_top  = (_rect.top + _rect.height / 2 - __height / 2);
                __pos_left = (_rect.left + _width_rect);
                break;
            case self.PLACEMENT.BOTTOM:
                __pos_top  = (_rect.bottom - self.STYLE.ARROW_SIZE);
                __pos_left = (_rect.left + _width_rect / 2 - __width / 2);
                break;
            case self.PLACEMENT.BOTTOM_LEFT:
                __pos_top  = (_rect.bottom - self.STYLE.ARROW_SIZE);
                __pos_left = _rect.left - __width + _width_rect + 2 * self.STYLE.ARROW_SIZE;
                break;
            case self.PLACEMENT.BOTTOM_RIGHT:
                __pos_top  = (_rect.bottom - self.STYLE.ARROW_SIZE);
                __pos_left = _rect.left - 2 * self.STYLE.ARROW_SIZE;
                break;
        }
    }
    
    function isInScreen () {
        var _to_return       = true;
        var _bounding_parent = __parent_container ? __parent_container.getBoundingClientRect() : false;
        var _left_parent     = _bounding_parent ? _bounding_parent.left : -10;
        var _right_parent    = _bounding_parent ? _bounding_parent.right : window.innerWidth - 10;
        var _top_parent      = _bounding_parent ? _bounding_parent.top : -10;
        var _bottom_parent   = _bounding_parent ? _bounding_parent.bottom : window.innerHeight - 10;
        
        
        if ( __pos_left < _left_parent ) {
            _to_return = false;
            switch ( __placement ) {
                case self.PLACEMENT.TOP:
                    __placement = self.PLACEMENT.TOP_RIGHT;
                    break;
                case self.PLACEMENT.TOP_RIGHT:
                case self.PLACEMENT.LEFT:
                case self.PLACEMENT.BOTTOM_RIGHT:
                    __placement = self.PLACEMENT.RIGHT;
                    break;
                case self.PLACEMENT.TOP_LEFT:
                    __placement = self.PLACEMENT.TOP;
                    break;
                case self.PLACEMENT.BOTTOM:
                    __placement = self.PLACEMENT.BOTTOM_RIGHT;
                    break;
                case self.PLACEMENT.BOTTOM_LEFT:
                    __placement = self.PLACEMENT.BOTTOM;
                    break;
            }
        }
        else if ( (__pos_left + __width) > _right_parent ) {
            _to_return = false;
            switch ( __placement ) {
                case self.PLACEMENT.TOP:
                    __placement = self.PLACEMENT.TOP_LEFT;
                    break;
                case self.PLACEMENT.TOP_LEFT:
                case self.PLACEMENT.RIGHT:
                case self.PLACEMENT.BOTTOM_LEFT:
                    __placement = self.PLACEMENT.LEFT;
                    break;
                case self.PLACEMENT.TOP_RIGHT:
                    __placement = self.PLACEMENT.TOP;
                    break;
                case self.PLACEMENT.BOTTOM:
                    __placement = self.PLACEMENT.BOTTOM_LEFT;
                    break;
                case self.PLACEMENT.BOTTOM_RIGHT:
                    __placement = self.PLACEMENT.BOTTOM;
                    break;
            }
        }
        else if ( __pos_top < _top_parent ) {
            _to_return = false;
            switch ( __placement ) {
                case self.PLACEMENT.TOP:
                    __placement = self.PLACEMENT.BOTTOM;
                    break;
                case self.PLACEMENT.LEFT:
                case self.PLACEMENT.TOP_LEFT:
                    __placement = self.PLACEMENT.BOTTOM_LEFT;
                    break;
                case self.PLACEMENT.TOP_RIGHT:
                case self.PLACEMENT.RIGHT:
                    __placement = self.PLACEMENT.BOTTOM_RIGHT;
                    break;
            }
        }
        else if ( (__pos_top + __height) > _bottom_parent ) {
            _to_return = false;
            switch ( __placement ) {
                case self.PLACEMENT.BOTTOM:
                    __placement = self.PLACEMENT.TOP;
                    break;
                case self.PLACEMENT.LEFT:
                case self.PLACEMENT.BOTTOM_LEFT:
                    __placement = self.PLACEMENT.TOP_LEFT;
                    break;
                case self.PLACEMENT.BOTTOM_RIGHT:
                case self.PLACEMENT.RIGHT:
                    __placement = self.PLACEMENT.TOP_RIGHT;
                    break;
            }
        }
        __try++;
        if ( __try > self.MAX_TRY_IN_SCREEN ) { //CASE WHERE THE TOOLTIP HAS NO PLACE TO BE DISPLAYED
            __placement = __placement_origin;
            _to_return  = true;
        }
        return _to_return;
    }
    
    function createDomElement () {
        var _html             = '<table><tr><td></td><td><div class="shi-tip-arrow tooltip-arrow-top" id="tooltip-arrow-top-left"></div></td><td><div class="shi-tip-arrow tooltip-arrow-top" id="tooltip-arrow-top-middle"></div></td><td><div class="shi-tip-arrow tooltip-arrow-top" id="tooltip-arrow-top-right"></div></td><td></td></tr><tr><td><div class="shi-tip-arrow tooltip-arrow-left" id="tooltip-arrow-left-middle"></div></td><td colspan="3"><div class="shi-tip-text"></div></td><td><div class="shi-tip-arrow tooltip-arrow-right" id="tooltip-arrow-right-middle"></div></td></tr><tr><td></td><td><div class="shi-tip-arrow tooltip-arrow-bottom" id="tooltip-arrow-bottom-left"></div></td><td><div class="shi-tip-arrow tooltip-arrow-bottom" id="tooltip-arrow-bottom-middle"></div></td><td><div class="shi-tip-arrow tooltip-arrow-bottom" id="tooltip-arrow-bottom-right"></div></td><td></td></tr></table>';
        __container           = document.createElement( 'div' );
        __container.id        = 'shi-tip';
        __container.innerHTML = _html;
        document.body.appendChild( __container );
    }
    
    function initDomElement () {
        __container = document.getElementById( 'shi-tip' );
        if ( !__container ) {
            createDomElement();
        }
        
        if ( __container ) {
            __text_container = __container.querySelector( '.shi-tip-text' );
            __arrow          = __container.querySelector( '.shi-tip-arrow' );
        }
    }
    
    function setText ( element ) {
        __innerText = element.getAttribute( 'shi-tip-text' );
        if ( __innerText ) {
            __text_container.innerHTML = __innerText;
        }
    }
    
    function setHTML ( element ) {
        __innerHtml = element.getAttribute( 'shi-tip-html' );
        if ( __innerHtml ) {
            __text_container.innerHTML = replaceAll( __innerHtml, '___', '&' );
        }
    }
    
    function setType ( element ) {
        __type                   = element.getAttribute( 'shi-tip-type' ) || false;
        __container.dataset.type = __type;
    }
    
    function setCondition ( element ) {
        __condition = element.getAttribute( 'shi-tip-condition' ) || false;
        
        __container.dataset.condition = __condition;
    }
    
    function setTimerPop ( element ) {
        __timer_pop = element.getAttribute( 'shi-tip-timer-pop' ) || self.DEFAULT.TIMER_POP;
    }
    
    function setParentContainer ( element ) {
        var _selector_parent_container = element.getAttribute( 'shi-tip-parent-container' );
        if ( _selector_parent_container ) {
            __parent_container = findParentElementWithClass( element, _selector_parent_container, 50 );
        }
        else {
            __parent_container = false;
        }
    }
    
    function setClass ( element ) {
        __classes_added = element.getAttribute( 'shi-tip-class' );
        
        __container.className = __classes_added;
    }
    
    function getSize () {
        setActive( true );
        var _sizes = __container.getBoundingClientRect();
        __width    = _sizes.width;
        __height   = _sizes.height;
    }
    
    function clean () {
        __container.style.top  = '-5000px';
        __container.style.left = '-5000px';
        clearTimeout( __timeout_pop );
        cleanIntervalPopOut();
        cleanIntervalAutoScroll();
    }
    
    function replaceAll ( string, target, replacement ) {
        return string.split( target ).join( replacement || '' );
    }
    
    function findParentElementWithClass ( element, class_tag, deepLimit ) {
        if ( deepLimit < 0 ) {
            return null;
        }
        if ( !element ) {
            return null;
        }
        if ( element.classList.contains( class_tag ) ) {
            return element;
        }
        deepLimit--;
        return findParentElementWithClass( element.parentElement, class_tag, deepLimit );
    }
    
    return self;
    
})( {} );
var common_ui_en = {
 "common" : {
 "not_valid_format_value" : "Bad format key : <span class='shinken-data-user'>{0}</span>",
 "unknown_value" : "Unknown key : <span class='shinken-data-user'>{0}</span>"
 },
 "json_editor" : {
 "not_valid_format_value" : "The content of the key <span class='shinken-data-user'>{0}</span> is not in the correct format",
 "unknown_value" : "The key <span class='shinken-data-user'>{0}</span> is unknown"
 },
 "progress_bar" : {
 "saving_failed" : "Failed saved",
 "saving_in_progress" : "Save in progress...",
 "saving_succeed" : "Successfully saved",
 "toggle_display_message_label" : "See details"
 }
};
var common_ui_fr = {
 "common" : {
 "not_valid_format_value" : "Clé avec un mauvais format : <span class='shinken-data-user'>{0}</span>",
 "unknown_value" : "Clé inconnue : <span class='shinken-data-user'>{0}</span>"
 },
 "json_editor" : {
 "not_valid_format_value" : "Le contenu de la clé <span class='shinken-data-user'>{0}</span> n'est pas au bon format",
 "unknown_value" : "La clé <span class='shinken-data-user'>{0}</span> n'est pas connue"
 },
 "progress_bar" : {
 "saving_failed" : "Enregistrement échoué",
 "saving_in_progress" : "Sauvegarde en cours...",
 "saving_succeed" : "Enregistrement réussi",
 "toggle_display_message_label" : "Voir le détail"
 }
};
SHINKEN.OBJECT.Counter           = function ( dom_element, show_if_null ) {
    this.__class_name__ = 'SHINKEN.OBJECT.Counter';
    this._counter_final         = 0;
    this.label                  = "";
    this._is_label_before       = false;
    this._has_animation         = false;
    this._show_if_null          = !!show_if_null;
    this._is_string             = false;
    this._counter_parent_list   = [];
    this._elements_mapping      = {};
    this.uuid                   = SHINKEN.TOOLS.STRING.buildUUID();
    this.timeout_html           = null;
    this.type                   = '';
    this.dom_class_selector     = '';
    this._targets_dom_element   = [];
    this._show_to_parent        = true;
    this.toggle_parent_activity = false;
    this._data_target_name      = 'number';
    if ( dom_element ) {
        this.init( dom_element );
    }
};
SHINKEN.OBJECT.Counter.prototype = {
    init            : function ( dom_element, update_with_dom ) {
        this.dom_element = dom_element;
        this.setDiscreet( !this.dom_element );
        if ( this.dom_element ) {
            this.dom_element_label = dom_element.querySelector( '.shinken-counter-label' );
            var _name_parent       = this.dom_element.dataset.parent;
            if ( _name_parent ) {
                this._counter_parent_list.push( MANAGER.__instance_counter_distributor.findCounter( _name_parent ) );
            }
            var _label = this.dom_element_label.querySelector( '.shinken-counter-extra-label' );
            if ( _label ) {
                this.label            = _label.outerHTML;
                this._is_label_before = !!this.dom_element_label.dataset.isBefore;
            }
            var _is_string = this.dom_element_label.dataset.isString;
            if ( _is_string ) {
                this._is_string = true;
            }
            if ( this.dom_element.dataset.showIfNull ) {
                this._show_if_null = true;
            }
            if ( this.dom_element.dataset.isDiscreet ) {
                this.setDiscreet( true );
            }
            if ( update_with_dom ) {
                this.initValueWithDom();
            }
        }
    },
    initFromParent  : function ( parent, update_with_dom ) {
        this.init( DOM.Service.askFindChildElementWithClass( parent.dom_element, this.getDomSelector(), 'shinken-counter-candidate', 30 ), update_with_dom );
    },
    initValueWithDom: function () {
        if ( !this.dom_element ) {
            return;
        }
        if ( !this.dom_element.dataset.number ) {
            return;
        }
        this.update( "init_with_dom" + this.uuid, parseInt( this.dom_element.dataset.number ) );
    },
    getValue              : function () {
        return this._counter_final;
    },
    has                   : function ( name ) {
        return !!this._elements_mapping[ name ];
    },
    setDiscreet           : function ( to_set ) {
        this.is_discreet = !!to_set;
    },
    hasCounter            : function () {
        return !!this._counter_final;
    },
    setShowIfNull         : function ( to_set ) {
        this._show_if_null = !!to_set;
    },
    setAnimation          : function ( to_set ) {
        this._has_animation = !!to_set;
    },
    reset                 : function () {
        this._elements_mapping = {};
        this._counter_final    = 0;
        this.showForParent( true );
        this.updateTargetDomElement();
        this._updateHTML();
    },
    showForParent         : function ( show ) {
        this._show_to_parent = !!show;
        this.updateParents();
    },
    updateParents         : function () {
        for ( var i = 0, _size_i = this._counter_parent_list.length; i < _size_i; i++ ) {
            this._counter_parent_list[ i ].update( this.uuid, this._show_to_parent ? this._counter_final : 0 );
        }
    },
    update                : function ( name, nb_counter, tooltip, retry_update_html, is_force ) {
        if ( !nb_counter ) {
            delete this._elements_mapping[ name ];
        }
        else {
            if ( !is_force && this._elements_mapping[ name ] === nb_counter ) {
                return;
            }
            this._elements_mapping[ name ] = nb_counter;
            
        }
        if ( tooltip ) {
            this.setTooltip( tooltip );
        }
        this._counter_final = this._is_string ? "" : 0;
        var _keys           = Object.keys( this._elements_mapping );
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            this._counter_final = this._counter_final + this._elements_mapping[ _keys[ i ] ];
        }
        
        this.updateTargetDomElement();
        this.updateParents();
        return this._askUpdateHTML( retry_update_html );
    },
    setParent             : function ( to_add ) {
        if ( !to_add ) {
            return;
        }
        
        this._counter_parent_list.push( to_add );
        this.updateParents();
        this._updateHTML();
    },
    setDataTargetName     : function ( to_set ) {
        this._data_target_name = to_set;
    },
    addTargetsDomElement  : function ( to_set ) {
        this._targets_dom_element.push( to_set );
        this.updateTargetDomElement();
    },
    updateTargetDomElement: function () {
        for ( var i = 0, _size_i = this._targets_dom_element.length; i < _size_i; i++ ) {
            DOM.Service.setDataSet( this._targets_dom_element[ i ], this._data_target_name, this._counter_final || '' );
        }
    },
    setLabel              : function ( to_set, is_before ) {
        this.label            = DOM.Service.createElement( 'span', { class: 'shinken-counter-extra-label' }, to_set ).outerHTML;
        this._is_label_before = !!is_before;
    },
    isString              : function ( to_set ) {
        this._is_string = to_set;
    },
    _askUpdateHTML        : function ( retry_update_html ) {
        if ( this.timeout_html ) {
            clearTimeout( this.timeout_html );
        }
        var self          = this;
        this.timeout_html = setTimeout( function () {
            self._updateHTML( retry_update_html );
            self.timeout_html = null;
        }, 50 );
    },
    _updateHTML           : function ( retry_update_html ) {
        if ( this.is_discreet ) {
            return false;
        }
        if ( !this.dom_element_label ) {
            if ( retry_update_html ) {
                var self = this;
                setTimeout( function () {
                    self._updateHTML();
                }, 100 );
            }
            return false;
        }
        if ( this._counter_final ) {
            this.dom_element_label.innerHTML = (this.label ? this._is_label_before ? this.label + this._counter_final : this._counter_final + this.label : this._counter_final);
            DOM.Service.setDataSet( this.dom_element, 'number', this._counter_final );
        }
        else if ( this._show_if_null ) {
            this.dom_element_label.innerHTML = '0';
            DOM.Service.setDataSet( this.dom_element, 'number', '0' );
        }
        else {
            this.dom_element_label.innerHTML = '';
            DOM.Service.setDataSet( this.dom_element, 'number', '' );
        }
        var _parent_dom_element;
        if ( this.has_animation ) {
            _parent_dom_element = DOM.Service.findParentElementWithClass( this.dom_element, 'shinken-pulsate-parent', 10 );
            if ( _parent_dom_element ) {
                DOM.Service.askAddClass( _parent_dom_element, 'shinken-pulsate', 2000 );
            }
        }
        if ( this.toggle_parent_activity ) {
            _parent_dom_element = DOM.Service.findParentElementWithClass( this.dom_element, 'shinken-counter-parent', 10 );
            if ( _parent_dom_element ) {
                if ( this._counter_final ) {
                    _parent_dom_element.classList.add( 'shinken-active' );
                }
                else {
                    _parent_dom_element.classList.remove( 'shinken-active' );
                }
            }
        }
        return true;
    },
    setTooltip            : function ( label, type ) {
        if ( !label ) {
            return;
        }
        this.dom_element.setAttribute( 'onmouseenter', 'SHINKEN_TOOLTIP.showTooltip(this)' );
        this.dom_element.setAttribute( 'onmouseleave', 'SHINKEN_TOOLTIP.hideTooltip()' );
        this.dom_element.setAttribute( 'shi-tip-html', label );
        this.dom_element.setAttribute( 'shi-tip-type', type );
    },
    getDomSelector        : function () {
        switch ( this.type ) {
            case "error":
                return ".shinken-error-counter";
            case "warning":
                return ".shinken-warning-counter";
            case "user_set":
                return ".shinken-user-set-counter";
            case "total":
                return ".shinken-window-total-counter";
            default:
                return this.dom_class_selector;
        }
    },
    pulsate: function () {
        if ( !this.hasCounter() ) {
            return;
        }
        if ( this.object_parent && this.object_parent.dom_element ) {
            DOM.Service.askAddClass( this.object_parent.dom_element, 'shinken-pulsate', 2000 );
        }
        else {
            DOM.Service.askAddClass( this.dom_element, 'shinken-pulsate', 2000 );
        }
        for ( var i = 0, _size_i = this._counter_parent_list.length; i < _size_i; i++ ) {
            this._counter_parent_list[ i ].pulsate();
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.Counter, SHINKEN.OBJECT.ShinkenObject );
SHINKEN.OBJECT.CounterInterface           = function () {
};
SHINKEN.OBJECT.CounterInterface.prototype = {
    addExtraCounter      : function ( to_add, type, dom_class_selector, data_target_name ) {
        to_add.type                 = type;
        to_add.container_class_name = this.getObjectClassName();
        if ( dom_class_selector ) {
            to_add.dom_class_selector = "." + dom_class_selector;
        }
        if ( data_target_name ) {
            to_add.setDataTargetName( data_target_name );
        }
        this.getExtraCounters()[ type ] = to_add;
    },
    initCounters         : function ( parent, update_with_dom ) {
        this.errors                      = new SHINKEN.OBJECT.Counter();
        this.errors.type                 = "error";
        this.errors.container_class_name = this.getObjectClassName();
        this.errors.object_parent        = this;
        
        this.warnings                      = new SHINKEN.OBJECT.Counter();
        this.warnings.type                 = "warning";
        this.warnings.container_class_name = this.getObjectClassName();
        
        this.user_set                      = new SHINKEN.OBJECT.Counter();
        this.user_set.type                 = "user_set";
        this.user_set.container_class_name = this.getObjectClassName();
        
        this.total                      = new SHINKEN.OBJECT.Counter();
        this.total.type                 = "total";
        this.total.container_class_name = this.getObjectClassName();
        this.initCountersDom( update_with_dom );
        if ( parent ) {
            this.setParentCounter( parent );
        }
    },
    initCountersDom      : function ( update_with_dom ) {
        if ( this.dom_element ) {
            this.errors.initFromParent( this, update_with_dom );
            this.warnings.initFromParent( this, update_with_dom );
            this.user_set.initFromParent( this, update_with_dom );
            this.total.initFromParent( this, update_with_dom );
            var _keys = Object.keys( this.getExtraCounters() );
            for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
                this.getExtraCounterByName( _keys[ i ] ).initFromParent( this, update_with_dom );
            }
        }
    },
    resetCounters        : function () {
        this.warnings.reset();
        this.errors.reset();
        this.user_set.reset();
        this.total.reset();
        var _keys = Object.keys( this.getExtraCounters() );
        var _current_key;
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current_key = _keys[ i ];
            this.getExtraCounterByName( _current_key ).reset();
        }
    },
    hideCountersForParent: function () {
        this.warnings.showForParent( false );
        this.errors.showForParent( false );
        this.user_set.showForParent( false );
        this.total.showForParent( false );
        
        var _keys = Object.keys( this.getExtraCounters() );
        var _current_key;
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current_key = _keys[ i ];
            this.getExtraCounterByName( _current_key ).showForParent( false );
        }
    },
    showCountersForParent: function () {
        this.warnings.showForParent( true );
        this.errors.showForParent( true );
        this.user_set.showForParent( true );
        this.total.showForParent( true );
        
        var _keys = Object.keys( this.getExtraCounters() );
        var _current_key;
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current_key = _keys[ i ];
            this.getExtraCounterByName( _current_key ).showForParent( true );
        }
    },
    hasError             : function () {
        return this.errors.hasCounter();
    },
    hasWarning           : function () {
        return this.warnings.hasCounter();
    },
    setError             : function ( data_name, nb ) {
        this.errors.update( data_name, nb );
    },
    setWarning           : function ( data_name, nb ) {
        this.warnings.update( data_name, nb );
    },
    setUserSet           : function ( data_name, nb ) {
        this.user_set.update( data_name, nb );
    },
    setTotal             : function ( data_name, nb ) {
        this.total.update( data_name, nb );
    },
    getCounterError      : function () {
        return this.errors;
    },
    getCounterWarning    : function () {
        return this.warnings;
    },
    getCounterUserSet    : function () {
        return this.user_set;
    },
    getCounterTotal      : function () {
        return this.total;
    },
    getExtraCounters     : function () {
        if ( !this.extraCounters ) {
            this.extraCounters = {};
        }
        return this.extraCounters;
    },
    getExtraCounterByName: function ( name ) {
        return this.extraCounters[ name ];
    },
    findExtraCounter     : function ( name ) {
        var _counter = this.getExtraCounterByName( name );
        if ( _counter ) {
            return _counter;
        }
        this.addExtraCounter( new SHINKEN.OBJECT.Counter(), name );
        return this.getExtraCounterByName( name );
    },
    setParentCounter     : function ( to_set ) {
        var _parent = to_set || this.parent_container;
        if ( _parent ) {
            this.getCounterError().setParent( _parent.getCounterError() );
            this.getCounterWarning().setParent( _parent.getCounterWarning() );
            this.getCounterUserSet().setParent( _parent.getCounterUserSet() );
            this.getCounterTotal().setParent( _parent.getCounterTotal() );
        }
        else {
            this.getCounterError().setParent();
            this.getCounterWarning().setParent();
            this.getCounterUserSet().setParent();
            this.getCounterTotal().setParent();
        }
        this.setParentExtraCounter( _parent );
    },
    setParentExtraCounter: function ( _parent ) {
        var _keys = Object.keys( this.getExtraCounters() );
        var _current;
        var _current_key;
        var _parent_counter;
        var _parent_dom_counter;
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current_key = _keys[ i ];
            _current     = this.getExtraCounterByName( _current_key );
            if ( _parent ) {
                _parent_counter = _parent.findExtraCounter( _current_key );
                _parent_counter.setShinkenDebug( _parent.isShinkenDebugOn() );
                _parent_counter.dom_class_selector = _current.dom_class_selector;
                _parent_dom_counter                = DOM.Service.askFindChildElementWithClass( _parent.dom_element, _parent_counter.getDomSelector(), 'shinken-counter-candidate', 20 );
                if ( _parent_dom_counter ) {
                    _parent_counter.init( _parent_dom_counter, false );
                }
                else {
                    _parent_counter.setDataTargetName( _current._data_target_name );
                    _parent_counter.addTargetsDomElement( _parent.dom_element );
                }
                _current.setParent( _parent_counter );
                _parent.setParentCounter();
            }
            else {
                _current.setParent();
            }
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.CounterInterface, SHINKEN.OBJECT.ShinkenObject );
SHINKEN.TOOLS.ARRAY = (function ( self ) {
    "use strict";
    
    self.concat                     = function ( array_1, array_2 ) {
        var toReturn = array_1.concat( array_2 );
        return toReturn;
    };
    self.concatUnique               = function ( array_1, array_2, key_for_unique ) {
        var toReturn = [];
        var _size    = array_1.length;
        for ( var i = 0; i < _size; i++ ) {
            toReturn[ i ] = array_1[ i ];
        }
        _size = array_2.length;
        for ( var i = 0; i < _size; i++ ) {
            if ( !key_for_unique ) {
                self.addElement( toReturn, array_2[ i ] );
            }
            else if ( !self.containsElementWith( toReturn, array_2[ i ][ key_for_unique ], key_for_unique ) ) {
                toReturn.push( array_2[ i ] );
            }
        }
        return toReturn;
    };
    self.concatUniqueIfNotPresentIn = function ( array_1, array_2, array_3 ) {
        var toReturn = [];
        var _size    = array_1.length;
        for ( var i = 0; i < _size; i++ ) {
            if ( !self.contains( array_3, array_1[ i ] ) ) {
                toReturn[ i ] = array_1[ i ];
            }
        }
        _size = array_2.length;
        for ( i = 0; i < _size; i++ ) {
            if ( !self.contains( array_3, array_2[ i ] ) ) {
                self.addElement( toReturn, array_2[ i ] );
            }
        }
        return toReturn;
    };
    self.sortNumber                 = function ( array ) {
        if ( !array ) {
            return array;
        }
        return array.sort( function ( a, b ) {
            return a - b;
        } );
    };
    self.sortArray                  = function ( array, comparator_value, first_index_to_sort, reverse ) {
        if ( reverse === undefined ) {
            reverse = false;
        }
        
        if ( !array ) {
            return array;
        }
        if ( !comparator_value ) {
            return array.sort();
        }
        var size      = array.length;
        var fix_array = [];
        var to_sort   = array;
        if ( first_index_to_sort ) {
            fix_array = array.slice( 0, first_index_to_sort );
            to_sort   = array.slice( first_index_to_sort, size );
        }
        to_sort.sort( function ( a, b ) {
            if ( a[ comparator_value ] < b[ comparator_value ] ) {
                return reverse ? 1 : -1;
            }
            else if ( a[ comparator_value ] > b[ comparator_value ] ) {
                return reverse ? -1 : 1;
            }
            return 0;
        } );
        return fix_array.concat( to_sort );
    };
    self.sortArrayMultiple          = function ( array, comparator_values ) {
        if ( !array ) {
            return array;
        }
        if ( !comparator_values ) {
            return array;
        }
        var size      = array.length;
        var fix_array = [];
        var to_sort   = array;
        to_sort.sort(
            function ( a, b ) {
                return self._comparator( a, b, comparator_values, 0 );
            }
        );
        return fix_array.concat( to_sort );
    };
    self.getMapValues               = function ( map ) {
        if ( !map ) {
            return null;
        }
        return Object.keys( map ).map( function ( e ) {
            return map[ e ];
        } );
    };
    self._comparator                = function ( a, b, comparators, index ) {
        if ( index >= comparators.length ) {
            return 0;
        }
        if ( a[ comparators[ index ] ] < b[ comparators[ index ] ] ) {
            return -1;
        }
        else if ( a[ comparators[ index ] ] > b[ comparators[ index ] ] ) {
            return 1;
        }
        return self._comparator( a, b, comparators, (index + 1) );
    };
    self.filterWith                 = function ( array, key, value ) {
        if ( !array ) {
            return [];
        }
        if ( !key || !value ) {
            return null;
        }
        var size = array.length;
        if ( !size ) {
            return [];
        }
        var toReturn = [];
        var _current;
        for ( var i = 0; i < size; i++ ) {
            _current = array[ i ];
            if ( _current[ key ] === value ) {
                toReturn.push( _current );
            }
        }
        return toReturn;
    };
    self.filterWithDeeply           = function ( array, keys, value ) {
        if ( !array || !keys || !value ) {
            return null;
        }
        var size = array.length;
        if ( !size ) {
            return null;
        }
        var _to_return = [];
        var _current;
        for ( var i = 0; i < size; i++ ) {
            _current = array[ i ];
            if ( self.findValueDeeply( _current, keys ) === value ) {
                _to_return.push( _current );
            }
        }
        return _to_return;
    };
    self.findValueDeeply            = function ( dict, keys ) {
        if ( !dict || !keys ) {
            return null;
        }
        var _size = keys.length;
        if ( _size < 1 ) {
            return null;
        }
        var _to_return = dict[ keys[ 0 ] ];
        if ( _size === 1 ) {
            return _to_return;
        }
        return self.findValueDeeply( _to_return, SHINKEN.TOOLS.ARRAY.clone( keys ).splice( -1, 1 ) );
    };
    self.findFirstElementWith       = function ( array, key, value ) {
        if ( !array || !key || typeof value === 'undefined' ) {
            return null;
        }
        var size = array.length;
        if ( !size ) {
            return null;
        }
        var _current;
        for ( var i = 0; i < size; i++ ) {
            _current = array[ i ];
            if ( _current[ key ] === value ) {
                return _current;
            }
        }
        return null;
    };
    self.findFirstIndexWith         = function ( array, key, value ) {
        if ( !array || !key || typeof value === 'undefined' ) {
            return null;
        }
        var size = array.length;
        if ( !size ) {
            return null;
        }
        var _current;
        for ( var i = 0; i < size; i++ ) {
            _current = array[ i ];
            if ( _current[ key ] === value ) {
                return i;
            }
        }
        return -1;
    };
    self.getLengthWith              = function ( array, key, value ) {
        var _filtered = self.filterWith( array, key, value );
        if ( !_filtered ) {
            return 0;
        }
        return _filtered.length;
    };
    self.extractKey                 = function ( array, key, ignoreEmpty ) {
        if ( !array || !key ) {
            return null;
        }
        var toReturn = [];
        var size     = array.length;
        if ( !size ) {
            return toReturn;
        }
        var _current;
        for ( var i = 0; i < size; i++ ) {
            _current = array[ i ];
            if ( !_current && !ignoreEmpty ) {
                toReturn[ i ] = null;
            }
            else {
                if ( _current[ key ] || !ignoreEmpty ) {
                    toReturn[ i ] = _current[ key ];
                }
            }
        }
        return toReturn;
    };
    self.extractKeys                = function ( array, keys ) {
        var _keys_size = keys.length;
        if ( !array || !_keys_size ) {
            return null;
        }
        var toReturn = [];
        var size     = array.length;
        if ( !size ) {
            return toReturn;
        }
        var _current;
        for ( var i = 0; i < size; i++ ) {
            _current = array[ i ];
            if ( !_current ) {
                toReturn[ i ] = self.initEmptyArray( _keys_size );
            }
            else {
                toReturn[ i ] = [];
                for ( var j = 0; j < _keys_size; j++ ) {
                    toReturn[ i ].push( _current[ keys[ j ] ] );
                }
            }
        }
        return toReturn;
    };
    self.removeDuplicate            = function ( array ) {
        if ( !array ) {
            return null;
        }
        var toReturn = [];
        var size     = array.length;
        if ( !size ) {
            return toReturn;
        }
        var _current;
        for ( var i = 0; i < size; i++ ) {
            _current = array[ i ];
            if ( toReturn.indexOf( _current ) !== -1 ) {
                continue;
            }
            toReturn.push( _current );
        }
        return toReturn;
    };
    self.removeDuplicateArray       = function ( array ) {
        if ( !array ) {
            return null;
        }
        var toReturn = [];
        var size     = array.length;
        if ( !size ) {
            return toReturn;
        }
        var _current;
        var _to_add;
        for ( var i = 0; i < size; i++ ) {
            _current = array[ i ];
            _to_add  = true;
            for ( var j = 0, _size_j = toReturn.length; j < _size_j; j++ ) {
                if ( self.areEquals( toReturn[ j ], _current ) ) {
                    _to_add = false;
                }
            }
            if ( _to_add ) {
                toReturn.push( _current );
            }
        }
        return toReturn;
    };
    self.hasSameKeyContent          = function ( array1, array2, key ) {
        if ( !key ) {
            return false;
        }
        if ( !array1 && !array2 ) {
            return true;
        }
        if ( !array1 || !array2 ) {
            return false;
        }
        
        var _extract1 = self.extractKey( array1, key );
        var _extract2 = self.extractKey( array2, key );
        if ( _extract1 === null && _extract2 === null ) {
            return true;
        }
        else if ( _extract1 === null || _extract2 === null ) {
            return false;
        }
        
        var _size1 = _extract1.length;
        var _size2 = _extract2.length;
        
        if ( _size1 !== _size2 ) {
            return false;
        }
        
        for ( var i = 0; i < _extract1; i++ ) {
            if ( _extract1[ i ] !== _extract2[ i ] ) {
                return false;
            }
        }
        return true;
    };
    self.getElementFromTo           = function ( array, indexBegin, indexEnd ) {
        return array.slice( indexBegin, indexEnd );
    };
    self.getElement                 = function ( array, key, value_to_find ) {
        var _size = self.getLength( array );
        var _current_element;
        for ( var i = 0; i < _size; i++ ) {
            _current_element = array[ i ];
            if ( _current_element[ key ] === value_to_find ) {
                return _current_element;
            }
        }
    };
    self.reverseArrayClone          = function ( array ) {
        var toReturn = Array.prototype.slice.call( array );
        toReturn.reverse();
        return toReturn;
    };
    self.initEmptyArray             = function ( length ) {
        var toReturn = [];
        for ( var i = 0; i <= length; i++ ) {
            toReturn.push( null );
        }
        return toReturn;
    };
    self.initConstantArray          = function ( to_add, length ) {
        var toReturn = [];
        for ( var i = 0; i < length; i++ ) {
            toReturn.push( to_add );
        }
        return toReturn;
    };
    self.initIntegerArray           = function ( indexBegin, indexEnd ) {
        var toReturn = [];
        for ( var i = indexBegin; i <= indexEnd; i++ ) {
            toReturn.push( i );
        }
        return toReturn;
    };
    self.initIntegerArrayToString   = function ( indexBegin, indexEnd ) {
        var toReturn = [];
        for ( var i = indexBegin; i <= indexEnd; i++ ) {
            toReturn.push( i + "" );
        }
        return toReturn;
    };
    self.indexOf                    = function ( array, key, value ) {
        var size = array.length;
        var _current;
        for ( var i = 0; i < size; i++ ) {
            _current = array[ i ][ key ];
            if ( _current && _current === value ) {
                return i;
            }
        }
        return -1;
    };
    self.indexOfCollection          = function ( array, to_find ) {
        var size = array.length;
        var _current;
        for ( var i = 0; i < size; i++ ) {
            if ( array[ i ] === to_find ) {
                return i;
            }
        }
        return -1;
    };
    self.search                     = function ( array, key, value ) {
        var index = self.indexOf( array, key, value );
        if ( index === -1 ) {
            return null;
        }
        return array[ index ];
    };
    self.join                       = function ( array, separator ) {
        if ( Array.isArray( array ) ) {
            return array.join( separator );
        }
        return array.toString();
    };
    self.getLength                  = function ( array ) {
        if ( array ) {
            return array.length;
        }
        return 0;
    };
    self.clone                      = function ( array ) {
        return array.slice( 0 );
    };
    self.swap                       = function ( array, index_1, index_2 ) {
        if ( !array ) {
            return;
        }
        var b            = array[ index_1 ];
        array[ index_1 ] = array[ index_2 ];
        array[ index_2 ] = b;
        return array;
    };
    self.contains                   = function ( array, toSearch ) {
        if ( !array ) {
            return false;
        }
        return array.indexOf( toSearch ) !== -1;
    };
    self.containsAtLeastOne                   = function ( array1, array2 ) {
        if ( !array1 || !array2 ) {
            return false;
        }
        for ( var i = 0, _size_i = array2.length; i < _size_i; i++ ) {
            if ( self.contains (array1, array2[i] ) ){
                return true;
            }
        }
        return false;
    };
    self.addElement                 = function ( array, toAdd ) {
        if ( self.contains( array, toAdd ) ) {
            return -1;
        }
        return array.push( toAdd );
    };
    self.removeElement              = function ( array, toRemove ) {
        var index = array.indexOf( toRemove );
        if ( index === -1 ) {
            return false;
        }
        array.splice( index, 1 );
        return true;
    };
    self.parseToArray               = function ( obj ) {
        if ( !obj ) {
            return null;
        }
        
        var _keys      = Object.keys( obj );
        var _size      = _keys.length;
        var _to_return = [];
        for ( var i = 0; i < _size; i++ ) {
            _to_return[ i ] = obj[ _keys[ i ] ];
        }
        return _to_return;
    };
    self.containsElementWith        = function ( array, toSearch, key ) {
        if ( !array ) {
            return false;
        }
        if ( !key ) {
            return false;
        }
        
        var _size = array.length;
        for ( var i = 0; i < _size; i++ ) {
            if ( array[ i ][ key ] === toSearch ) {
                return true;
            }
        }
        return false;
    };
    self.areEquals                  = function ( array1, array2 ) {
        return JSON.stringify( array1 ) === JSON.stringify( array2 );
    };
    self.getMedianIndex             = function ( array, round_up ) {
        if ( !array ) {
            return SHINKEN.TOOLS.ARRAY.NOT_FOUND;
        }
        return round_up ? Math.ceil( array.length / 2 ) : Math.floor( array.length / 2 );
    };
    self.getFirstPartOf             = function ( array ) {
        return array.slice( 0, self.getMedianIndex( array ) + 1 );
    };
    self.getLastPartOf              = function ( array ) {
        return array.slice( self.getMedianIndex( array ), array.length );
    };
    self.minNumber                  = function ( array ) {
        if ( !array ) {
            return null;
        }
        return array.reduce( function ( a, b ) {
            return Math.min( a, b );
        }, array[ 0 ] );
    };
    self.maxNumber                  = function ( array ) {
        if ( !array ) {
            return null;
        }
        return array.reduce( function ( a, b ) {
            return Math.max( a, b );
        }, array[ 0 ] );
    };
    self.medianNumber               = function ( array ) {
        if ( !array ) {
            return null;
        }
        var sorted = array.slice().sort();
        var half   = Math.floor( array.length / 2 );
        
        if ( array.length % 2 ) {
            return sorted[ half ];
        }
        
        return (sorted[ half - 1 ] + sorted[ half ]) / 2.0;
    };
    self.take                       = function ( arr, n ) {
        return arr.filter( function ( _, i ) {
            return i < n;
        } );
    };
    self.takeLast                   = function ( arr, n ) {
        var _len = arr.length;
        return arr.filter( function ( _, i ) {
            return _len - i <= n;
        });
    };
    return self;
})( SHINKEN.TOOLS.ARRAY || {} );
SHINKEN.TOOLS.ARRAY.NOT_FOUND = -1;
var DATE_TIME = {};
var __traduction;
DATE_TIME.FORMAT = {
    TIME           : {
        DEFAULT: "HH:MM:SS",
        HH_MM  : "HH:MM"
    },
    DATE           : {
        DEFAULT   : "YYYY-MM-DD",
        WITH_SLASH: "YYYY/MM/DD",
        NO_YEAR   : "MM-DD"
    },
    TIME_PERIOD    : {
        YEAR   : {
            NB_MS    : 1000 * 60 * 60 * 24 * 30 * 355,
            KEY      : 'year',
            SHORT_KEY: 'short_year'
        },
        MONTH  : {
            NB_MS    : 1000 * 60 * 60 * 24 * 30,
            KEY      : 'month',
            SHORT_KEY: 'short_month'
        },
        WEEK   : {
            NB_MS    : 1000 * 60 * 60 * 24 * 7,
            KEY      : 'week',
            SHORT_KEY: 'short_week'
        },
        DAY    : {
            NB_MS    : 1000 * 60 * 60 * 24,
            KEY      : 'day',
            SHORT_KEY: 'short_day'
        },
        HOUR   : {
            NB_MS    : 1000 * 60 * 60,
            KEY      : 'hour',
            SHORT_KEY: 'short_hour'
        },
        MINUTE : {
            NB_MS    : 1000 * 60,
            KEY      : 'minute',
            SHORT_KEY: 'short_minute'
        },
        SECONDE: {
            NB_MS    : 1000,
            KEY      : 'second',
            SHORT_KEY: 'short_second'
        }
    },
    NOW            : 'now',
    TYPE_VALIDATION: {
        HOUR: "hour",
        MIN : "min"
    }
};
DATE_TIME.now = function() {
    return new Date();
};
DATE_TIME.buildDate = function(day_delta) {
    var _to_return = new Date();
    _to_return.setDate(_to_return.getDate()+day_delta);
    return _to_return;
};
DATE_TIME.getTimestampNow = function() {
    return Date.now();
};
DATE_TIME.FORMAT.getTime = function( date, format ) {
    if ( !format ) {
        format = DATE_TIME.FORMAT.TIME.DEFAULT;
    }
    format = format.toUpperCase();
    switch ( format ) {
        case DATE_TIME.FORMAT.TIME.DEFAULT:
            return SHINKEN.TOOLS.STRING.prefix_by_zero( date.getHours(), 2 ) + ':' + SHINKEN.TOOLS.STRING.prefix_by_zero( date.getMinutes(), 2 ) + ':' + SHINKEN.TOOLS.STRING.prefix_by_zero( date.getSeconds(), 2 );
        case DATE_TIME.FORMAT.TIME.HH_MM:
            return SHINKEN.TOOLS.STRING.prefix_by_zero( date.getHours(), 2 ) + ':' + SHINKEN.TOOLS.STRING.prefix_by_zero( date.getMinutes(), 2 );
        default:
            return SHINKEN.TOOLS.STRING.prefix_by_zero( date.getHours(), 2 ) + ':' + SHINKEN.TOOLS.STRING.prefix_by_zero( date.getMinutes(), 2 ) + ':' + SHINKEN.TOOLS.STRING.prefix_by_zero( date.getSeconds(), 2 );
    }
    
};
DATE_TIME.FORMAT.get_date = function( date, format ) {
    if ( !format ) {
        format = DATE_TIME.FORMAT.DATE.DEFAULT;
    }
    
    switch ( format ) {
        case DATE_TIME.FORMAT.DATE.DEFAULT:
            return date.getFullYear() +  '-' + SHINKEN.TOOLS.STRING.prefix_by_zero( date.getMonth() + 1, 2 ) + '-' + SHINKEN.TOOLS.STRING.prefix_by_zero( date.getDate(), 2 );
        case DATE_TIME.FORMAT.DATE.NO_YEAR:
            return SHINKEN.TOOLS.STRING.prefix_by_zero( date.getMonth() + 1, 2 ) + '-' + SHINKEN.TOOLS.STRING.prefix_by_zero( date.getDate(), 2 );
        case DATE_TIME.FORMAT.DATE.WITH_SLASH:
            return date.getFullYear() + '/' + SHINKEN.TOOLS.STRING.prefix_by_zero( date.getMonth() + 1, 2 ) + '/' + SHINKEN.TOOLS.STRING.prefix_by_zero( date.getDate(), 2 );
        default:
            return  date.getFullYear() + '-' + SHINKEN.TOOLS.STRING.prefix_by_zero( date.getMonth() + 1, 2 ) + '-' + SHINKEN.TOOLS.STRING.prefix_by_zero( date.getDate(), 2 );
    }
    
};
DATE_TIME.FORMAT.get_date_from_timestamp = function( timestamp, format ) {
    return DATE_TIME.FORMAT.get_date(new Date(timestamp*1000), format);
};
DATE_TIME.FORMAT.get_time_from_timestamp = function( timestamp, format ) {
    return DATE_TIME.FORMAT.getTime(new Date(timestamp*1000), format);
};
DATE_TIME.initTraduction = function() {
    __traduction = [];
    var keys = Object.keys( DATE_TIME.FORMAT.TIME_PERIOD );
    var _key,
        _label,
        _short_label;
    for ( var i = 0, size = keys.length; i < size; i++ ) {
        _key = keys[ i ];
        _label = DATE_TIME.FORMAT.TIME_PERIOD[ _key ][ 'KEY' ];
        _short_label = DATE_TIME.FORMAT.TIME_PERIOD[ _key ][ 'SHORT_KEY' ];
        __traduction[ _label ] = [_( 'timeperiods.' + _label ), _( 'timeperiods.' + _label + 's' )];
        __traduction[ _short_label ] = [_( 'timeperiods.' + _short_label ), _( 'timeperiods.' + _short_label + 's' )];
    }
    __traduction[ DATE_TIME.NOW ] = [_( 'timeperiods.now' ), ''];
};
DATE_TIME.getTraduction = function( key, is_plural ) {
    if ( !__traduction ) {
        this.initTraduction();
    }
    return __traduction[ key ][ is_plural ? 1 : 0 ];
};
DATE_TIME.durationToString = function( timestamp, is_short_name, limit ) {
    if ( !timestamp ) {
        return DATE_TIME.getTraduction( DATE_TIME.NOW, false );
    }
    
    var in_the_past = false;
    if ( timestamp < 0 ) {
        in_the_past = true;
        timestamp = -timestamp;
    }
    
    if ( !limit ) {
        limit = 9999;
    }
    var toReturn = '';
    var _nb;
    var keys = Object.keys( DATE_TIME.FORMAT.TIME_PERIOD );
    var _key,
        _label,
        _nb_sec;
    for ( var i = 0, size = keys.length; i < size; i++ ) {
        _key = keys[ i ];
        if ( is_short_name ) {
            _label = DATE_TIME.FORMAT.TIME_PERIOD[ _key ][ 'SHORT_KEY' ];
        }
        else {
            _label = DATE_TIME.FORMAT.TIME_PERIOD[ _key ][ 'KEY' ];
        }
        
        _nb_sec = DATE_TIME.FORMAT.TIME_PERIOD[ _key ][ 'NB_MS' ];
        
        if ( timestamp >= _nb_sec ) {
            _nb = parseInt( timestamp / _nb_sec );
            if ( toReturn ) {
                toReturn += " ";
            }
            toReturn += _nb + " " + DATE_TIME.getTraduction( _label, _nb > 1 );
            timestamp = timestamp - _nb * _nb_sec;
            limit--;
        }
        if ( limit <= 0 ) {
            break;
        }
    }
    if ( !toReturn ) {
        toReturn = DATE_TIME.getTraduction( DATE_TIME.NOW, false );
    }
    else if ( in_the_past ) {
        toReturn = _( 'timeperiods.agoMoment' ) + ' ' + toReturn;
    }
    else {
        toReturn = _( 'timeperiods.inMoment' ) + ' ' + toReturn;
    }
    return toReturn;
};
DATE_TIME.relativeTime = function( elapsed ) {
    if ( elapsed < 0 ) {
        return relativeTime( -elapsed ) + ' ago';
    }
    var msPerSecond = DATE_TIME.FORMAT.TIME_PERIOD[ 'SECONDE' ][ 'NB_MS' ];
    var msPerMinute = DATE_TIME.FORMAT.TIME_PERIOD[ 'MINUTE' ][ 'NB_MS' ];
    var msPerHour = DATE_TIME.FORMAT.TIME_PERIOD[ 'HOUR' ][ 'NB_MS' ];
    var msPerDay = DATE_TIME.FORMAT.TIME_PERIOD[ 'DAY' ][ 'NB_MS' ];
    var msPerMonth = DATE_TIME.FORMAT.TIME_PERIOD[ 'MONTH' ][ 'NB_MS' ];
    var msPerYear = DATE_TIME.FORMAT.TIME_PERIOD[ 'YEAR' ][ 'NB_MS' ];
    
    if ( elapsed < msPerMinute ) {
        return Math.round( elapsed / msPerSecond );
    }
    else if ( elapsed < msPerHour ) {
        return Math.round( elapsed / msPerMinute );
    }
    else if ( elapsed < msPerDay ) {
        return Math.round( elapsed / msPerHour );
    }
    else if ( elapsed < msPerMonth ) {
        return Math.round( elapsed / msPerDay );
    }
    else if ( elapsed < msPerYear ) {
        return Math.round( elapsed / msPerMonth );
    }
    else {
        return Math.round( elapsed / msPerYear );
    }
};
DATE_TIME.isValid = function( type, string_value ) {
    if ( isNaN( string_value ) ) {
        return false;
    }
    var _value_splitted = string_value.split( '' );
    var _size = _value_splitted.length;
    var value;
    switch ( type ) {
        case DATE_TIME.FORMAT.TYPE_VALIDATION.HOUR:
            if ( _size !== 2 ) {
                return false;
            }
            if ( isNaN( _value_splitted[ 0 ] ) || isNaN( _value_splitted[ 1 ] ) ) {
                return false;
            }
            value = parseInt( string_value );
            if ( value < 0 || value > 23 ) {
                return false;
            }
            break;
        case DATE_TIME.FORMAT.TYPE_VALIDATION.MIN:
            if ( _size !== 2 ) {
                return false;
            }
            if ( isNaN( _value_splitted[ 0 ] ) || isNaN( _value_splitted[ 1 ] ) ) {
                return false;
            }
            value = parseInt( string_value );
            if ( value < 0 || value > 59 ) {
                return false;
            }
            break;
        default:
            console.warn( "DATE_TIME.isValid : unknown format =>", type );
    }
    return true;
};
DATE_TIME.isValidRangeTimeperiod = function( time1, time2 ) {
    return (DATE_TIME.getTimeperiodLabel( PROPERTY.CONST.TIMEPERIOD.FORMAT_LABEL.HOUR, time1 ) <= DATE_TIME.getTimeperiodLabel( PROPERTY.CONST.TIMEPERIOD.FORMAT_LABEL.HOUR, time2 ));
};
DATE_TIME.splitTimeperiodDay = function( value ) {
    var _to_return = [];
    var _timeperiod_ranges = value.split( PROPERTY.CONST.TIMEPERIOD.SEPARATOR.RANGES );
    for ( var i = 0, _size = _timeperiod_ranges.length; i < _size; i++ ) {
        _to_return.push( DATE_TIME.splitTimeperiodRanges( _timeperiod_ranges[ i ] ) );
    }
    return _to_return;
};
DATE_TIME.splitTimeperiodRanges = function( value ) {
    var ranges = value.split( PROPERTY.CONST.TIMEPERIOD.SEPARATOR.HOURS );
    var _size_ranges = ranges.length;
    var _to_return = [];
    for ( var i = 0; i < _size_ranges; i++ ) {
        _to_return.push( DATE_TIME.splitTimeperiodTime( ranges[ i ] ) );
    }
    return _to_return;
};
DATE_TIME.splitTimeperiodTime = function( value ) {
    var _to_return = {};
    var _time_splitted = value.split( PROPERTY.CONST.TIMEPERIOD.SEPARATOR.HOUR_MIN );
    if ( _time_splitted.length !== 2 ) {
        _to_return.invalid = true;
        return _to_return;
    }
    _to_return.hour = _time_splitted[ 0 ].trim();
    _to_return.min = _time_splitted[ 1 ].trim();
    
    return _to_return;
};
DATE_TIME.getTimeperiodLabel = function( type, value ) {
    switch ( type ) {
        case PROPERTY.CONST.TIMEPERIOD.FORMAT_LABEL.HOUR:
            return value.hour + PROPERTY.CONST.TIMEPERIOD.SEPARATOR.HOUR_MIN + value.min;
        case PROPERTY.CONST.TIMEPERIOD.FORMAT_LABEL.RANGE:
            return DATE_TIME.getTimeperiodLabel( PROPERTY.CONST.TIMEPERIOD.FORMAT_LABEL.HOUR, value[ 0 ] ) + PROPERTY.CONST.TIMEPERIOD.SEPARATOR.HOURS + DATE_TIME.getTimeperiodLabel( PROPERTY.CONST.TIMEPERIOD.FORMAT_LABEL.HOUR, value[ 1 ] );
        case PROPERTY.CONST.TIMEPERIOD.FORMAT_LABEL.FULL:
            var _current_range;
            var _to_return = "";
            var _size = value.length;
            for ( var i = 0; i < _size; i++ ) {
                _current_range = value[ i ];
                _to_return += DATE_TIME.getTimeperiodLabel( PROPERTY.CONST.TIMEPERIOD.FORMAT_LABEL.RANGE, value[ i ] );
                if ( (value + 1) !== _size ) {
                    _to_return += PROPERTY.CONST.TIMEPERIOD.SEPARATOR.RANGES;
                }
            }
            return _to_return;
    }
};
DATE_TIME.initHistoricArrayTimeStamp             = function ( length ) {
        var toReturn = [];
        for ( var i = length - 1; i>=0; i-- ) {
            toReturn.push( DATE_TIME.buildDate(- i).getTime()/1000 );
        }
        return toReturn;
    };
DOM.BodyService = (function ( self ) {
    "use strict";
    
    var __body_element;
    var __list_to_remove = {};
    var __time_out_add;
    var __bouding_rect;
    
    self.load            = function () {
        if ( !__body_element ) {
            __body_element = document.querySelector( 'body' );
        }
    };
    self.hasChildWithID  = function ( id ) {
        var _child = self.getDomElement().querySelector( "#" + id );
        return _child;
    };
    self.askAddClass     = function ( to_add, time_out ) {
        self.getDomElement().classList.add( to_add );
        if ( time_out ) {
            __list_to_remove[ to_add ] = true;
            clearTimeout( __time_out_add );
            __time_out_add = setTimeout( function () {
                var _keys = Object.keys( __list_to_remove );
                for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
                    self.getDomElement().classList.remove( _keys[ i ] );
                }
                __list_to_remove = {};
            }, time_out );
        }
    };
    self.removeClass     = function ( to_remove ) {
        self.getDomElement().classList.remove( to_remove );
        __list_to_remove[ to_remove ] = false;
    };
    self.addChild        = function ( dom_element ) {
        DOM.Service.addElementTo( dom_element, self.getDomElement() );
    };
    self.getDomElement   = function () {
        if ( !__body_element ) {
            self.load();
        }
        return __body_element;
    };
    self.cleanDomElement = function () {
        __body_element = null;
    };
    self.getWidth = function () {
        if ( !__bouding_rect ){
            __bouding_rect = DOM.Service.getBoundingClientRect(this.getDomElement());
        }
        return __bouding_rect[DOM.CONST.STYLE.WIDTH] ;
    };
    self.reset = function () {
        __bouding_rect = undefined;
    };
    return self;
})( DOM.BodyService || {} );
window.addEventListener( "resize", function () {
    DOM.BodyService.reset()
} );
DOM.ScrollService = (function ( self ) {
    "use strict";
    
    self.getMiddleScrollPosition       = function ( dom_element_container ) {
        var _top    = DOM.Service.getBoundingClientRect( dom_element_container, DOM.CONST.STYLE.TOP );
        var _bottom = DOM.Service.getBoundingClientRect( dom_element_container, DOM.CONST.STYLE.BOTTOM );
        
        return ((_bottom - _top) / 2) + _top;
    };
    self.getFirstVisibleDom            = function ( dom_element_container, css_selector_children, move_down ) {
        var _position = DOM.Service.getBoundingClientRect( dom_element_container, move_down ? DOM.CONST.STYLE.TOP : DOM.CONST.STYLE.BOTTOM );
        var _list       = SHINKEN.TOOLS.ARRAY.parseToArray( dom_element_container.querySelectorAll( css_selector_children ) );
        var _size       = _list.length;
        if ( !_size ) {
            return null;
        }
        return self.getCloserVisibleDomFrom( _list, _position, move_down, dom_element_container );
    };
    self.getCloserVisibleDomFromMiddle = function ( dom_element_container, css_selector_children, move_down ) {
        var _middle_pos = DOM.ScrollService.getMiddleScrollPosition( dom_element_container );
        var _list       = SHINKEN.TOOLS.ARRAY.parseToArray( dom_element_container.querySelectorAll( css_selector_children ) );
        var _size       = _list.length;
        if ( !_size ) {
            return null;
        }
        return self.getCloserVisibleDomFrom( _list, _middle_pos, move_down, dom_element_container );
    };
    self.getCloserVisibleDomFrom       = function ( list, position, move_down, dom_element_container ) {
        var _size  = list.length;
        var _index = move_down ? _size - 1 : 0;
        var _delta = move_down ? -1 : 1;
        
        var _closer_index     = _index;
        var _last_closer_diff = 9999;
        var _current;
        for ( ; _index < _size && _index >= 0; _index = _index + _delta ) {
            _current = list[ _index ];
            if ( !DOM.Service.isVisible( _current ) ) {
                continue;
            }
            if ( DOM.Service.getMissingScrollPositionToBeVisible( _current, dom_element_container ) ) {
                continue;
            }
            var _median = DOM.Service.getBoundingClientRect( _current, DOM.CONST.SPECIAL.MEDIAN_TOP_BOTTOM );
            if ( Math.abs( _median - position ) < _last_closer_diff ) {
                _last_closer_diff = Math.abs( _median - position );
                _closer_index     = _index;
                continue;
            }
            else {
                break;
            }
        }
        return list[ _closer_index ];
    };
    self.isVisible                     = function ( dom_element_container, dom_element_to_test, marge, action_type ) {
        if ( !dom_element_to_test ) {
            return false;
        }
        marge               = marge || 0;
        var _rect_to_test   = dom_element_to_test.getBoundingClientRect();
        var _rect_container = dom_element_container.getBoundingClientRect();
        
        if ( action_type ) {
            if ( _rect_to_test.bottom - _rect_container.top <= marge ) {
                return action_type === DOM.CONST.ATTRIBUTE.SCROLL_DOWN;
            }
            if ( _rect_container.bottom - _rect_to_test.top <= marge ) {
                return action_type === DOM.CONST.ATTRIBUTE.SCROLL_TOP;
            }
            return true;
        }
        else {
            return _rect_to_test.bottom - _rect_container.top >= marge && _rect_container.bottom - _rect_to_test.top >= marge;
        }
    };
    self.bindWith                      = function ( dom_element, dom_element_to_bind_with, previous_position_vertical, action_type ) {
        switch ( action_type ) {
            case DOM.CONST.ATTRIBUTE.SCROLL_TOP:
            case DOM.CONST.ATTRIBUTE.SCROLL_DOWN:
                if ( self.isVisible( dom_element, dom_element_to_bind_with, 3 * DOM.Service.getBoundingClientRect( dom_element_to_bind_with, DOM.CONST.STYLE.HEIGHT ), action_type ) ) {
                    return;
                }
                else {
                    var _delta = DOM.Service.getBoundingClientRect( dom_element_to_bind_with, DOM.CONST.STYLE.HEIGHT );
                    if ( previous_position_vertical ) {
                        _delta = previous_position_vertical - DOM.Service.getBoundingClientRect( dom_element_to_bind_with, DOM.CONST.SPECIAL.MEDIAN_TOP_BOTTOM );
                    }
                    self.changeVerticaly( dom_element, _delta, action_type );
                }
                break;
        }
    };
    self.changeVerticaly               = function ( dom_element, delta, action_type ) {
        dom_element[ DOM.CONST.ATTRIBUTE.SCROLL_TOP ] = Math.ceil( dom_element[ DOM.CONST.ATTRIBUTE.SCROLL_TOP ] - delta );
    };
    
    return self;
})( DOM.ScrollService || {} );
DOM.Service = (function ( self ) {
    "use strict";
    
    var __previous_scrollLeft = 0;
    
    self.findParentElementWithDataSet              = function ( element, key, deepLimit ) {
        if ( !element ) {
            deepLimit = -1;
        }
        if ( deepLimit < 0 ) {
            return null;
        }
        if ( self.hasKeyInDataSet( element, key ) ) {
            return element;
        }
        deepLimit--;
        return this.findParentElementWithDataSet( element.parentElement, key, deepLimit );
    };
    self.findParentElementWithClass                = function ( element, class_tag, deepLimit ) {
        if ( deepLimit < 0 || !element ) {
            return null;
        }
        if ( element.classList.contains( class_tag ) ) {
            return element;
        }
        deepLimit--;
        return this.findParentElementWithClass( element.parentElement, class_tag, deepLimit );
    };
    self.findParentElementByClassWithClassExcluded = function ( element, class_tag, class_exclude, deepLimit ) {
        if ( deepLimit < 0 || !element ) {
            return null;
        }
        if ( element.classList.contains( class_exclude ) ) {
            return null;
        }
        if ( element.classList.contains( class_tag ) ) {
            return element;
        }
        deepLimit--;
        return this.findParentElementByClassWithClassExcluded( element.parentElement, class_tag, class_exclude, deepLimit );
    };
    self.askFindChildElementWithClass              = function ( element, class_tag, class_exclude, deepLimit ) {
        if ( deepLimit < 0 || !element ) {
            return null;
        }
        if ( SHINKEN.TOOLS.STRING.startsWith( class_tag, '.' ) ) {
            class_tag = class_tag.substring( 1 );
        }
        if ( SHINKEN.TOOLS.STRING.startsWith( class_exclude, '.' ) ) {
            class_exclude = class_exclude.substring( 1 );
        }
        if ( element.classList.contains( class_tag ) ) {
            return element;
        }
        return this.findChildElementWithClass( element.children, class_tag, class_exclude, deepLimit );
    };
    self.findChildElementWithClass                 = function ( elements, class_tag, class_exclude, deepLimit ) {
        if ( deepLimit < 0 || !elements.length ) {
            return null;
        }
        var children = [];
        for ( var i = 0, _size = elements.length; i < _size; i++ ) {
            if ( elements[ i ].classList.contains( class_tag ) ) {
                return elements[ i ];
            }
            if ( !elements[ i ].classList.contains( class_exclude ) || !elements[ i ].childElementCount ) {
                children = SHINKEN.TOOLS.ARRAY.concat( children, SHINKEN.TOOLS.ARRAY.parseToArray( elements[ i ].children ) );
            }
        }
        deepLimit--;
        return this.findChildElementWithClass( children, class_tag, class_exclude, deepLimit );
        
    };
    self.querySelectorAllWithOutChild              = function ( dom_element, class_tag, class_exclude ) {
        var _to_return = [];
        var _current;
        if ( dom_element ) {
            for ( var i = 0, _size_i = dom_element.children.length; i < _size_i; i++ ) {
                _current = dom_element.children[ i ];
                if ( _current.classList.contains( class_exclude ) ) {
                    continue;
                }
                if ( _current.classList.contains( class_tag ) ) {
                    _to_return.push( _current );
                    continue;
                }
                _to_return = SHINKEN.TOOLS.ARRAY.concat( _to_return, self.querySelectorAllWithOutChild( _current, class_tag, class_exclude ) );
            }
        }
        return _to_return;
    };
    self.isExisting                                = function ( dom_element ) {
        var elements = document.querySelectorAll( self.getSelector( dom_element ) );
        for ( var i = 0, _size_i = elements.length; i < _size_i; i++ ) {
            if ( elements[ i ] === dom_element ) {
                return true;
            }
        }
        return false;
    };
    self.isInDom                                   = function ( dom_element ) {
        var isElementInDom = dom_element.getRootNode
                             ? dom_element.getRootNode( { composed: true } ) === document
                             : document.body.contains( dom_element );
    };
    self.getSelector                               = function ( dom_element ) {
        var _class_selector = SHINKEN.TOOLS.ARRAY.join( dom_element.classList, "." );
        if ( _class_selector ) {
            _class_selector = "." + _class_selector;
        }
        return dom_element.tagName + _class_selector;
    };
    self.hasKeyInDataSet                           = function ( element, key ) {
        return typeof element.dataset[ key ] !== "undefined";
    };
    self.hasKeyInDataSetAndKeyNotEmpty             = function ( element, key ) {
        return self.hasKeyInDataSet( element, key ) && element.dataset[ key ];
    };
    self.createElement                             = function ( tag, attributes, innerHTML ) {
        var toReturn = document.createElement( tag );
        if ( attributes ) {
            var keys = Object.keys( attributes );
            var size = keys.length;
            for ( var i = 0; i < size; i++ ) {
                toReturn.setAttribute( keys[ i ], attributes[ keys[ i ] ] );
            }
        }
        if ( innerHTML ) {
            toReturn.innerHTML = innerHTML;
        }
        return toReturn;
    };
    self.cloneElement                              = function ( dom_element_to_clone, attributes ) {
        var _to_return = dom_element_to_clone.cloneNode( true );
        if ( attributes ) {
            var keys = Object.keys( attributes );
            var size = keys.length;
            for ( var i = 0; i < size; i++ ) {
                _to_return.setAttribute( keys[ i ], attributes[ keys[ i ] ] );
            }
        }
        return _to_return;
    };
    self.addTooltip                                = function ( element, attributes ) {
        if ( !attributes ) {
            return;
        }
        element.setAttribute( 'onmouseenter', "SHINKEN_TOOLTIP.showTooltip(this)" );
        element.setAttribute( 'onmouseleave', "SHINKEN_TOOLTIP.hideTooltip()" );
        var _keys = Object.keys( attributes );
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            element.setAttribute( _keys[ i ], attributes[ _keys[ i ] ] );
        }
        return element;
    };
    self.removeElement                   = function ( element ) {
        if ( !element ) {
            return;
        }
        var parent = element.parentNode;
        
        try {
            var _to_return = parent.removeChild( element );
            return _to_return;
        }
        catch ( e ) {
            return false;
        }
    };
    self.removeParentIfHasClassOrElement = function ( element, class_to_test ) {
        if ( !element ) {
            return;
        }
        var parent = element.parentNode;
        if ( !parent ) {
            return;
        }
        
        if ( parent.classList.contains( class_to_test ) ) {
            var _grand_parent = parent.parentNode;
            if ( !_grand_parent ) {
                return;
            }
            _grand_parent.removeChild( parent );
        }
        
        return parent.removeChild( element );
    };
    self.setDataSet                      = function ( element, attr, value ) {
        if ( !element ) {
            return;
        }
        element.dataset[ attr ] = value;
        element.classList.toggle( "IE-PATCH" );
    };
    self.getInnerText                    = function ( element ) {
        if ( !element ) {
            return;
        }
        return element.innerText.trim();
    };
    self.toggleClass                     = function ( element, to_toggle ) {
        if ( element.classList.contains( to_toggle ) ) {
            element.classList.remove( to_toggle );
        }
        else {
            element.classList.add( to_toggle );
        }
    };
    self.removeElementIfHasClass         = function ( element, class_to_test ) {
        if ( !element ) {
            return;
        }
        if ( !element.classList.contains( class_to_test ) ) {
            return false;
        }
        var parent = element.parentNode;
        return parent.removeChild( element );
    };
    self.addElementAtIndex               = function ( element, parent, index ) {
        if ( !parent || !element ) {
            return;
        }
        if ( !index ) {
            index = 0;
        }
        if ( parent.childElementCount <= index ) {
            self.addElementTo( element, parent );
        }
        else {
            self.insertElementBefore( element, parent.children[ index ] );
        }
    };
    self.addElementTo                    = function ( element, parent ) {
        if ( parent && element ) {
            parent.appendChild( element );
        }
    };
    self.addElementAfterTo               = function ( element, target ) {
        var _next = target.nextSibling.nextSibling;
        if ( _next ) {
            target.parentNode.insertBefore( element, _next );
        }
        else {
            self.addElementTo( element, target.parentNode );
        }
    };
    self.switchElementParent             = function ( element_1, element_2 ) {
        if ( !element_1 || !element_2 ) {
            return;
        }
        var parent_1 = element_1.parentNode;
        var parent_2 = element_2.parentNode;
        
        parent_1.removeChild( element_1 );
        parent_2.removeChild( element_2 );
        
        parent_1.appendChild( element_2 );
        parent_2.appendChild( element_1 );
    };
    self.switchElement                   = function ( element_1, element_2 ) {
        if ( !element_1 || !element_2 ) {
            return;
        }
        var parent_1 = element_1.parentNode;
        var parent_2 = element_2.parentNode;
        
        var _index_1 = SHINKEN.TOOLS.ARRAY.indexOfCollection( parent_1.children, element_1 );
        var _index_2 = SHINKEN.TOOLS.ARRAY.indexOfCollection( parent_2.children, element_2 );
        self.insertElementBefore( element_2, element_1 );
        self.addElementAtIndex( element_1, parent_2, _index_2 );
    };
    self.insertElementBefore             = function ( element_existing, element_to_insert ) {
        if ( !element_existing || !element_to_insert ) {
            return;
        }
        var _parent = element_existing.parentNode;
        _parent.insertBefore( element_to_insert, element_existing );
    };
    self.addLoadingFrame                 = function ( dom_parent, text, parent_scrollable ) {
        if ( !dom_parent ) {
            return;
        }
        if ( DOM.Service.getComputedStyle( dom_parent, DOM.CONST.STYLE.POSITION ) === 'absolute' ) {
            console.error( "NOT SUPPORTED addLoadingFrame" );
            return;
        }
        self.setStyle( dom_parent, DOM.CONST.STYLE.POSITION, 'relative' );
        var _to_add = self.createElement( "div", { class: "shinken-loading-frame" }, '' );
        if ( text ) {
            var _dom_text = self.createElement( "div", { class: "shinken-loading-frame-text" }, text );
            self.addElementTo( _dom_text, _to_add );
            
            var _interval = setInterval( function () {
                if ( self.isExisting( _to_add ) ) {
                    if ( !parent_scrollable ) {
                        var _new_top = (self.getBoundingClientRect( _to_add )[ 'height' ] - self.getBoundingClientRect( _dom_text )[ 'height' ]) / 2;
                        self.setStyle( _dom_text, DOM.CONST.STYLE.TOP, _new_top );
                    }
                    else {
                        var _scrolling_needed = self.getMissingScrollPositionToBeVisible( _dom_text, parent_scrollable );
                        if ( _scrolling_needed ) {
                            self.setStyle( _dom_text, DOM.CONST.STYLE.TOP, Math.max( 0, self.getComputedStyle( _dom_text, DOM.CONST.STYLE.TOP ) + _scrolling_needed ) );
                        }
                    }
                }
                else {
                    clearInterval( _interval );
                }
            }, 200 );
        }
        self.addElementTo( _to_add, dom_parent );
    };
    
    self.getPositionToPercentFull        = function ( dom_element, forbid_negative_value ) {
        var _rect = self.getBoundingClientRect( dom_element );
        DOM.Service.removeStyles( dom_element, [DOM.CONST.STYLE.HEIGHT, DOM.CONST.STYLE.WIDTH] );
        var _to_return                       = {};
        _to_return[ DOM.CONST.STYLE.TOP ]    = self.getPercentCompareToWindowHeight( _rect[ DOM.CONST.STYLE.TOP ], forbid_negative_value );
        _to_return[ DOM.CONST.STYLE.BOTTOM ] = self.getPercentCompareToWindowHeight( window.innerHeight - _rect[ DOM.CONST.STYLE.TOP ] - _rect[ DOM.CONST.STYLE.HEIGHT ], forbid_negative_value );
        _to_return[ DOM.CONST.STYLE.LEFT ]   = self.getPercentCompareToWindowWidth( _rect[ DOM.CONST.STYLE.LEFT ], forbid_negative_value );
        _to_return[ DOM.CONST.STYLE.RIGHT ]  = self.getPercentCompareToWindowWidth( window.innerWidth - _rect[ DOM.CONST.STYLE.LEFT ] - _rect[ DOM.CONST.STYLE.WIDTH ], forbid_negative_value );
        return _to_return;
    };
    self.parsePositionToPercent          = function ( dom_element, forbid_negative_value ) {
        var _rect                         = self.getBoundingClientRect( dom_element );
        var _styles                       = {};
        _styles[ DOM.CONST.STYLE.TOP ]    = 'auto';
        _styles[ DOM.CONST.STYLE.BOTTOM ] = 'auto';
        _styles[ DOM.CONST.STYLE.LEFT ]   = 'auto';
        _styles[ DOM.CONST.STYLE.RIGHT ]  = 'auto';
        
        _rect.left < window.innerWidth / 2 ?
        _styles[ DOM.CONST.STYLE.LEFT ] = self.getPercentCompareToWindowWidth( _rect[ DOM.CONST.STYLE.LEFT ], forbid_negative_value ) :
        _styles[ DOM.CONST.STYLE.RIGHT ] = self.getPercentCompareToWindowWidth( window.innerWidth - _rect[ DOM.CONST.STYLE.LEFT ] - _rect[ DOM.CONST.STYLE.WIDTH ], forbid_negative_value );
        
        _rect.top < window.innerHeight / 2 ?
        _styles[ DOM.CONST.STYLE.TOP ] = self.getPercentCompareToWindowHeight( _rect[ DOM.CONST.STYLE.TOP ], forbid_negative_value ) :
        _styles[ DOM.CONST.STYLE.BOTTOM ] = self.getPercentCompareToWindowHeight( window.innerHeight - _rect[ DOM.CONST.STYLE.TOP ] - _rect[ DOM.CONST.STYLE.HEIGHT ], forbid_negative_value );
        
        DOM.Service.setStyles( dom_element, _styles );
    };
    self.getPercentCompareToWindowHeight = function ( value, forbid_negative_value ) {
        var _to_return = (value * 100) / window.innerHeight;
        if ( forbid_negative_value && _to_return < 0 ) {
            _to_return = 0;
        }
        return _to_return + '%';
    };
    self.getPercentCompareToWindowWidth  = function ( value, forbid_negative_value ) {
        var _to_return = (value * 100) / window.innerWidth;
        if ( forbid_negative_value && _to_return < 0 ) {
            _to_return = 0;
        }
        return _to_return + '%';
    };
    self.parsePositionForDragStart       = function ( dom_element, ignore_size ) {
        var _rect = DOM.Service.getBoundingClientRect( dom_element );
        DOM.Service.removeStyles( dom_element, [DOM.CONST.STYLE.BOTTOM, DOM.CONST.STYLE.RIGHT] );
        var _new_styles                     = {};
        _new_styles[ DOM.CONST.STYLE.TOP ]  = _rect[ DOM.CONST.STYLE.TOP ];
        _new_styles[ DOM.CONST.STYLE.LEFT ] = _rect[ DOM.CONST.STYLE.LEFT ];
        if ( !ignore_size ) {
            _new_styles[ DOM.CONST.STYLE.WIDTH ]  = _rect[ DOM.CONST.STYLE.WIDTH ];
            _new_styles[ DOM.CONST.STYLE.HEIGHT ] = _rect[ DOM.CONST.STYLE.HEIGHT ];
        }
        DOM.Service.setStyles( dom_element, _new_styles );
    };
    self.getPositionsForSaveInPercent    = function ( dom_element, keys ) {
        var _to_return = {};
        var _current_key;
        for ( var i = 0, _size = keys.length; i < _size; i++ ) {
            _current_key                = keys[ i ];
            _to_return [ _current_key ] = self.getPositionForSaveInPercent( dom_element, _current_key );
        }
        return _to_return;
    };
    self.getPositionForSaveInPercent     = function ( dom_element, key ) {
        var _value = self.getBoundingClientRect( dom_element, key );
        switch ( key ) {
            case DOM.CONST.STYLE.TOP:
            case DOM.CONST.STYLE.BOTTOM:
            case DOM.CONST.STYLE.HEIGHT:
                return self.getPercentCompareToWindowHeight( _value );
            case DOM.CONST.STYLE.LEFT:
            case DOM.CONST.STYLE.RIGHT:
            case DOM.CONST.STYLE.WIDTH:
                return self.getPercentCompareToWindowWidth( _value );
        }
    };
    
    self.updateWithComputedWidthClass = function ( dom_element ) {
        var _with         = self.getBoundingClientRect( dom_element, DOM.CONST.STYLE.WIDTH );
        var _class_to_add = self.computedWidthClass( _with );
        var _classes      = dom_element.classList;
        for ( var i = 0, _size_i = _classes.length; i < _size_i; i++ ) {
            if ( SHINKEN.TOOLS.STRING.startsWith( _classes[ i ], "shinken-width-for-responsive-" ) ) {
                dom_element.classList.remove( _classes[ i ] );
            }
        }
        dom_element.classList.add( _class_to_add );
    };
    self.computedWidthClass           = function ( width ) {
        var _width_compute = Math.floor( width / 50 );
        return "shinken-width-for-responsive-" + _width_compute * 50;
    };
    self.askAddClass                  = function ( element, to_add, time_out ) {
        element.classList.add( to_add );
        if ( time_out ) {
            setTimeout( function () {
                element.classList.remove( to_add );
            }, time_out );
        }
    };
    self.addClasses                   = function ( dom_element, class_to_add ) {
        if ( !dom_element){
            return;
        }
        if ( typeof class_to_add === 'string' ) {
            class_to_add = class_to_add.split( ' ' );
        }
        for ( var i = 0, _size_i = class_to_add.length; i < _size_i; i++ ) {
            dom_element.classList.add( class_to_add[ i ] );
        }
    };
    self.removeClasses                = function ( dom_element, class_to_remove ) {
        if ( typeof class_to_remove === 'string' ) {
            class_to_remove = class_to_remove.split( ' ' );
        }
        for ( var i = 0, _size_i = class_to_remove.length; i < _size_i; i++ ) {
            dom_element.classList.remove( class_to_remove[ i ] );
        }
    };
    self.addOrRemoveClasses           = function ( dom_element, boolean, _class ) {
        boolean ? self.addClasses( dom_element, _class ) : self.removeClasses( dom_element, _class );
    };
    self.applySiblingSettings         = function ( dom_element, dom_element_ref ) {
        dom_element.className = dom_element_ref.className;
    };
    self.getComputedStyle             = function ( dom_element, key ) {
        if ( !dom_element ) {
            return {};
        }
        var _to_return = dom_element.currentStyle || getComputedStyle( dom_element );
        if ( key ) {
            _to_return = _to_return[ key ];
            if ( SHINKEN.TOOLS.STRING.endsWith( _to_return, 'px' ) ) {
                _to_return = parseInt( _to_return );
            }
        }
        return _to_return;
    };
    self.cleanAllStyles               = function ( dom_element ) {
        dom_element.removeAttribute( "style" );
    };
    self.setStyle                     = function ( dom_element, key, value ) {
        if ( !dom_element || !key ) {
            return;
        }
        dom_element.style[ key ] = self._parseStyle( key, value );
    };
    self._parseStyle                  = function ( key, value ) {
        switch ( key ) {
            case DOM.CONST.STYLE.LEFT:
            case DOM.CONST.STYLE.TOP:
            case DOM.CONST.STYLE.HEIGHT:
            case DOM.CONST.STYLE.WIDTH:
            case DOM.CONST.STYLE.LINE_HEIGHT:
            case DOM.CONST.STYLE.MAX_HEIGHT:
            case DOM.CONST.STYLE.MAX_WIDTH:
            case DOM.CONST.STYLE.PADDING:
                if ( !isNaN( value ) ) {
                    value = value + 'px';
                }
                break;
            default:
                break;
        }
        return value;
    };
    self.setStyles                    = function ( dom_element, styles ) {
        var keys = Object.keys( styles );
        for ( var i = 0, size = keys.length; i < size; i++ ) {
            self.setStyle( dom_element, keys[ i ], styles[ keys[ i ] ] );
        }
    };
    self.removeStyles                 = function ( dom_element, styles ) {
        for ( var i = 0, size = styles.length; i < size; i++ ) {
            self.removeStyle( dom_element, styles[ i ] );
        }
    };
    self.removeStyle                  = function ( dom_element, style ) {
        dom_element.style.removeProperty( style );
    };
    self.styleToHtml                  = function ( styles ) {
        var _keys      = Object.keys( styles );
        var _current_key;
        var _to_return = "";
        for ( let i = 0, _size = _keys.length; i < _size; i++ ) {
            _current_key = _keys[ i ];
            _to_return += _current_key + ':' + self._parseStyle( _current_key, styles[ _current_key ] ) + ';';
        }
        return _to_return;
    };
    self.attributeStyleToDict         = function ( dom_element ) {
        var attribute_style = dom_element.getAttribute( "style" );
        var _to_return      = {};
        var split_1         = attribute_style.split( ";" );
        for ( var i = 0, _size_i = split_1.length; i < _size_i; i++ ) {
            if ( !split_1[ i ] ) {
                continue;
            }
            var split_2                = split_1[ i ].split( ":" );
            _to_return[ split_2[ 0 ] ] = split_2[ 1 ];
        }
        return _to_return;
    };
    self.getBoundingClientRect        = function ( dom_element, key ) {
        if ( !dom_element ) {
            return;
        }
        var _rect = dom_element.getBoundingClientRect();
        if ( !key ) {
            return _rect;
        }
        if ( key === DOM.CONST.SPECIAL.MEDIAN_TOP_BOTTOM ) {
            return parseInt( (_rect[ DOM.CONST.STYLE.TOP ] + _rect[ DOM.CONST.STYLE.BOTTOM ]) / 2 );
        }
        return parseInt( _rect[ key ] );
    };
    self.hasScrollHeight                     = function ( dom_element ) {
        return dom_element.clientHeight < dom_element.scrollHeight;
    };
    self.hasScrollWidth               = function ( dom_element ) {
        return dom_element.clientWidth < dom_element.scrollWidth;
    };
    self.setHtmlOrHide                = function ( dom_element, to_set ) {
        if ( !dom_element ) {
            return;
        }
        if ( to_set ) {
            dom_element.innerHTML = to_set;
            dom_element.classList.remove( 'shinken-hidden' );
        }
        else {
            dom_element.classList.add( 'shinken-hidden' );
        }
    };
    self.replaceChild                 = function ( element_to_replace, element_replace_with ) {
        var _parent_node = element_to_replace.parentNode;
        _parent_node.replaceChild( element_replace_with, element_to_replace );
    };
    self.empty                        = function ( dom_element ) {
        if ( !dom_element ) {
            return;
        }
        while ( dom_element.firstChild ) {
            dom_element.removeChild( dom_element.firstChild );
        }
    };
    self.addAttribute                 = function ( dom_element, attribute_name, to_set ) {
        dom_element.setAttribute( attribute_name, to_set );
    };
    self.removeAttribute              = function ( dom_element, attribute_name ) {
        dom_element.removeAttribute( attribute_name );
    };
    
    self.getHeight                           = function ( dom_element ) {
        if ( !dom_element ) {
            return 0;
        }
        return dom_element.offsetHeight;
    };
    self.getHeightWithMargin                 = function ( dom_element ) {
        if ( !dom_element ) {
            return 0;
        }
        return dom_element.offsetHeight + self.getComputedStyle( dom_element, 'marginTop' ) + self.getComputedStyle( dom_element, 'marginBottom' );
    };
    self.isVisible                           = function ( elem, deepness ) {
        if ( !elem ) {
            return false;
        }
        if ( !deepness ) {
            deepness = 0;
        }
        try {
            var styles = self.getComputedStyle( elem );
        }
        catch ( ex ) {
            throw Error( 'DOM.Service: elem is not an element.' );
        }
        
        if ( styles.display === 'none' ) {
            return false;
        }
        if ( styles.visibility !== 'visible' && styles.visibility !== 'inherit' ) {
            return false;
        }
        if ( styles.opacity < 0.1 ) {
            return false;
        }
        if ( elem.parentElement && deepness > 0 ) {
            return self.isVisible( elem.parentElement, deepness-- );
        }
        return true;
    };
    self.getMissingScrollPositionToBeVisible = function ( dom_element, dom_parent ) {
        var _parent_rect  = self.getBoundingClientRect( dom_parent );
        var _element_rect = self.getBoundingClientRect( dom_element );
        if ( _element_rect[ DOM.CONST.STYLE.TOP ] < _parent_rect[ DOM.CONST.STYLE.TOP ] ) {
            return _parent_rect[ DOM.CONST.STYLE.TOP ] - _element_rect[ DOM.CONST.STYLE.TOP ];
        }
        if ( _element_rect[ DOM.CONST.STYLE.BOTTOM ] > _parent_rect[ DOM.CONST.STYLE.BOTTOM ] ) {
            return _parent_rect[ DOM.CONST.STYLE.BOTTOM ] - _element_rect[ DOM.CONST.STYLE.BOTTOM ];
        }
        return 0;
    };
    self.setInputValue                       = function ( dom_element, to_set ) {
        if ( SHINKEN.NAVIGATOR.isNavigator( 'isIE' ) ) {
            dom_element.setAttribute( 'value', to_set );
            dom_element.classList.toggle( "IE-PATCH" );
            dom_element.value = to_set;
            return;
        }
        dom_element.value = to_set;
    };
    self.hasFocus                            = function ( dom_element ) {
        return dom_element === document.activeElement;
    };
    self.generateDomElementFromString        = function ( string ) {
        var _to_return = self.createElement( "div", "", string );
        return _to_return.children;
    };
    self.hasHrefHost                         = function ( url ) {
        var _dom_url = self.createElement( "a", { href: url } );
        return !!_dom_url.host;
    };
    self.isMatchingMedianDomElementTopWith   = function ( list, y ) {
        var _median_index = SHINKEN.TOOLS.ARRAY.getMedianIndex( list, true );
        if ( _median_index === SHINKEN.TOOLS.ARRAY.NOT_FOUND ) {
            return DOM.CONST.VALUE.NONE;
        }
        var _median  = list[ _median_index ];
        var _compare = self.compareCoordinates( _median, null, y );
        if ( _compare === 0 ) {
            return _median;
        }
        return _compare;
    };
    self.compareCoordinates                  = function ( dom_element, x, y ) {
        var _rect = self.getBoundingClientRect( dom_element );
        if ( x ) {
            if ( _rect.left < x ) {
                return -1;
            }
            if ( _rect.left + _rect.width > x ) {
                return 1;
            }
        }
        if ( y ) {
            if ( _rect.top > y ) {
                return -1;
            }
            if ( _rect.top + _rect.height < y ) {
                return 1;
            }
        }
        return 0;
    };
    self.show                                = function ( dom_element ) {
        dom_element.classList.remove( "shinken-hidden" );
    };
    self.hide                                = function ( dom_element ) {
        dom_element.classList.add( "shinken-hidden" );
    };
    self.setEditable                         = function ( edit_content, dom_container, dom_to_edit ) {
        dom_to_edit.contentEditable = edit_content;
        if ( edit_content === true ) {
            self.focusAtTheEnd( dom_to_edit );
        }
        self.setDataSet( dom_container, 'statusEdit', edit_content ? "1" : "0" );
    };
    self.focusAtTheEnd                       = function ( dom_element ) {
        dom_element.focus();
        var range = document.createRange();
        range.selectNodeContents( dom_element );
        range.collapse( false );
        var sel = window.getSelection();
        sel.removeAllRanges();
        sel.addRange( range );
    };
    self.scrollbarIsVisible                  = function ( dom_element, axe ) {
        switch ( axe ) {
            case 'height':
                return dom_element.scrollHeight > dom_element.clientHeight;
            case 'width':
                return dom_element.scrollWidth > dom_element.clientWidth;
        }
    };
    self.getNavigatorZoom                    = function () {
        return Math.round( window.devicePixelRatio * 100 );
    };
    self.saveCursorPosition                  = function ( dom_element ) {
        return dom_element.selectionStart;
    };
    self.focusAndSetCursorPosition           = function ( dom_element, cursor_position ) {
        dom_element.selectionStart = cursor_position;
        dom_element.selectionEnd   = cursor_position;
        dom_element.blur();
        dom_element.focus();
    };
    self.SimulateAction                      = {
        _doDispatch: function ( event_name, dom_element ) {
            if ( !dom_element ) {
                return;
            }
            var evt = document.createEvent( "HTMLEvents" );
            evt.initEvent( event_name, false, true );
            dom_element.dispatchEvent( evt );
        },
        mouseUp    : function ( dom_element ) {
            self.SimulateAction._doDispatch( "mouseup", dom_element );
        },
        keyUp      : function ( dom_element ) {
            self.SimulateAction._doDispatch( "keyup", dom_element );
        },
        click      : function ( dom_element ) {
            self.SimulateAction._doDispatch( "click", dom_element );
        }
    };
    self.computeHasScrollVertical            = function ( dom_element ) {
        if ( !dom_element ) {
            return;
        }
        self.addOrRemoveClasses( dom_element, self.hasScrollHeight( dom_element ), 'shinken-scroll-vertical-active' );
    };
    self.computeHasScrollVerticals           = function ( selector, dom_element ) {
        if ( !selector ) {
            return;
        }
        if ( !dom_element ) {
            dom_element = document;
        }
        var _dom_s = dom_element.querySelectorAll( selector );
        for ( var i = 0, _size_i = _dom_s.length; i < _size_i; i++ ) {
            self.computeHasScrollVertical( _dom_s[ i ] );
        }
    };
    self.focusUrlAnchor                      = function ( selector_id ) {
        var dom_element = document.getElementById( selector_id );
        if ( !dom_element ) {
            return;
        }
        dom_element.scrollIntoView();
    };
    
    return self;
})( DOM.Service || {} );
DOM.CONST = {
    STYLE                   : {
        LEFT            : 'left',
        RIGHT           : 'right',
        TOP             : 'top',
        BOTTOM          : 'bottom',
        HEIGHT          : 'height',
        MAX_HEIGHT      : 'max-height',
        MAX_WIDTH       : 'max-width',
        LINE_HEIGHT     : 'line-height',
        WIDTH           : 'width',
        Z_INDEX         : 'z-index',
        DISPLAY         : 'display',
        POSITION        : 'position',
        BACKGROUND_COLOR: 'background-color',
        PADDING         : 'padding'
    },
    ATTRIBUTE               : {
        SCROLL_DOWN: 'scrollDown',
        SCROLL_TOP : 'scrollTop',
        SCROLL_LEFT: 'scrollLeft'
    },
    VALUE                   : {
        NONE: 'none'
    },
    SPECIAL                 : {
        MEDIAN_TOP_BOTTOM: 'MEDIAN_TOP_BOTTOM'
    },
    WAITING_TIME_BEFORE_EXEC: {
        INPUT: 200
    }
};
SHINKEN.NAVIGATOR = (function ( self ) {
    "use strict";
    
    var navigator = {
        isChrome : false,
        isFireFox: false,
        isIE     : false,
        isHidden : false
    };
    
    
    setInterval( function () {
        setDocumentHidden();
    }, 2000 );
    
    function setDocumentHidden () {
        navigator.isHidden = document.hidden;
    }
    
    self.isNavigator          = function ( type ) {
        return navigator[ type ];
    };
    self.isNavigatorHidden    = function () {
        return navigator.isHidden;
    };
    self.init                 = function ( nb_try ) {
        var _navigator_class = '';
        if ( window.navigator.userAgent.indexOf( 'Firefox' ) !== -1 ) {
            navigator.isFireFox = true;
            _navigator_class    = 'shinken-navigator-is-firefox';
        }
        else if ( window.navigator.userAgent.indexOf( 'Chrome' ) !== -1 ) {
            navigator.isChrome = true;
            _navigator_class   = 'shinken-navigator-is-chrome';
        }
        else if ( window.navigator.userAgent.indexOf( 'Trident' ) !== -1 ) {
            navigator.isIE   = true;
            _navigator_class = 'shinken-navigator-is-IE';
        }
        if ( document.body ) {
            document.body.classList.add( _navigator_class );
        }
        else if ( nb_try ) {
            setTimeout( function () {
                nb_try = nb_try - 1;
                SHINKEN.NAVIGATOR.init( nb_try );
            }, 1000 );
        }
    };
    self.shinken_beforeunload = function ( page_name ) {
        switch ( page_name ) {
            case 'page-analyzer-job':
                return analyzer_beforeunload();
            default:
                return '';
        }
    };
    self.shinken_unload       = function ( page_name ) {
        switch ( page_name ) {
            case 'page-analyzer-job':
                return analyzer_unload();
            default:
                return '';
        }
    };
    
    
    return self;
})( SHINKEN.NAVIGATOR || {} );
SHINKEN.NAVIGATOR.init( 50 );
SHINKEN.TOOLS.NUMBER = (function ( self ) {
    "use strict";
    self.roundTo                 = function ( number, precision ) {
        if ( !precision ) {
            precision = 0;
        }
        var _number = Number( number );
        return _number.toFixed( precision );
    };
    self.parseFloat              = function ( number ) {
        if ( typeof number === "string" ) {
            number = number.replace( ',', '.' );
        }
        return parseFloat( number );
    };
    self.percent                 = function ( number ) {
        return self.roundTo( number * 100, 2 );
    };
    self.getRandom               = function ( min, max ) {
        return Math.floor( Math.random() * (max - min + 1) + min );
    };
    self.percent_no_extem        = function ( number ) {
        var toReturn = self.percent( number );
        if ( toReturn === '100.00' ) {
            toReturn = 100;
            if ( number !== 1 ) //IN ORDER TO NOT BE AT 100% WHEN THE PERCENT IS ROUNDED
            {
                toReturn = 99.99;
            }
        }
        else if ( toReturn === '-100.00' ) {
            toReturn = -100;
        }
        else if ( toReturn === '0.00' ) {
            toReturn = 0;
        }
        return toReturn;
    };
    self.getPathIconSla          = function ( sla_percent, critical_threshold, warning_threshold ) {
        sla_percent        = parseFloat( sla_percent );
        critical_threshold = parseFloat( critical_threshold );
        warning_threshold  = parseFloat( warning_threshold );
        var _path          = "";
        if ( sla_percent < critical_threshold ) {
            _path = "assets/images/widget/sla/storm.svg";
        }
        else if ( sla_percent >= critical_threshold && sla_percent < warning_threshold ) {
            _path = "assets/images/widget/sla/cloud.svg";
        }
        else {
            _path = 'assets/images/widget/sla/sun.svg';
        }
        return _path;
    };
    self.getDateToFormatedNumber = function ( number_date ) {
        if ( number_date > 9 ) {
            return number_date;
        }
        return "0" + number_date;
    };
    self.getValueInInterval      = function ( value, min, max ) {
        return Math.max( Math.min( value, max ), min );
    };
    return self;
})( SHINKEN.TOOLS.NUMBER || {} );
var CLIPBOARD_SERVICE = (function ( self ) {
    "use strict";
    self.dom_textarea     = null;
    self.dom_parent       = null;
    self.dom_button       = null;
    self.dom_text_to_copy = null;
    self.type             = null;
    
    self.TYPE      = {};
    self.TYPE.TEXT = 'text';
    self.TYPE.HTML = 'html';
    
    self.setContent = function ( dom_event, value ) {
        var _dom_button = DOM.Service.findParentElementWithClass( dom_event, 'shinken-button', 10 );
        setValueTextArea( value );
        self.dom_textarea.select();
        var status = false;
        try {
            status = document.execCommand( 'copy' );
            displayResult( status, _dom_button );
            setValueTextArea( '' );
        }
        catch ( err ) {
            console.log( 'Unable to copy.' );
        }
    };
    init();
    
    function init () {
        setTimeout( function () {
            createDomTextArea();
        }, 1000 );
    }
    
    function createDomTextArea () {
        self.dom_textarea    = document.createElement( 'textarea' );
        self.dom_textarea.id = 'id-shinken-copy-clipboard-container';
        var _body            = document.querySelector( 'body' );
        _body.appendChild( self.dom_textarea );
    }
    
    
    function setValueTextArea ( to_set ) {
        self.dom_textarea.value = to_set;
    }
    
    
    function displayResult ( status, dom_button ) {
        var _text     = status ? _( 'copy_service.copySuccess' ) : _( 'copy_service.copyFail' );
        var _state    = status ? SHINKEN.OBJECT.NOTIFICATION.CONST.STATUS.COPY_SUCCESS : SHINKEN.OBJECT.NOTIFICATION.CONST.STATUS.COPY_FAILED;
        var _position = status ? SHINKEN.OBJECT.NOTIFICATION.CONST.PLACEMENT.COPY_NOTIFICATION_SUCCESS : SHINKEN.OBJECT.NOTIFICATION.CONST.PLACEMENT.COPY_NOTIFICATION_FAILED;
        SHINKEN.TOOLS.NOTIFICATION.addNotification( _text, _state, dom_button, _position, 2000 );
    }
    
    
    return self;
    
})( {} );
var __lang_obj        = {};
var DICTIONARY_COMMON = "common";
var DICTIONARY_COMMON_UI = "common_ui";
var __dictionary_active_name__ = __dictionary_active_name__ || "lang_";
function __gup ( name, url ) {
    if ( !url ) {
        url = location.href;
    }
    name        = name.replace( /[\[]/, "\\\[" ).replace( /[\]]/, "\\\]" );
    var regexS  = "[\\?&]" + name + "=([^&#]*)";
    var regex   = new RegExp( regexS );
    var results = regex.exec( url );
    return results == null ? null : results[ 1 ];
}
function _load_lang_obj_array ( dictionary_origin_array ) {
    for ( var i = 0, _size_i = dictionary_origin_array.length; i < _size_i; i++ ) {
        _load_lang_obj( dictionary_origin_array[ i ] );
    }
}
function _load_lang_obj ( dictionary_origin ) {
    if ( __lang_obj[ dictionary_origin ] ) {
        return;
    }
    var lang                        = __gup( 'lang' );
    lang                            = !lang ? __shinken_lang__ : lang;
    var _to_return                  = dictionary_origin !== DICTIONARY_COMMON ? __dictionary_active_name__ + dictionary_origin + '_' : __dictionary_active_name__;
    if ( dictionary_origin === DICTIONARY_COMMON_UI ){
        _to_return = DICTIONARY_COMMON_UI + "_";
    }
    _to_return += lang === 'fr' ? lang : 'en';
    __lang_obj[ dictionary_origin ] = eval( _to_return );
}
function _ ( to_trad, dictionary_origin ) {
    var elts                    = to_trad.split( '.' );
    var dictionary_origin_array = !dictionary_origin ? [ DICTIONARY_COMMON ] : dictionary_origin;
    _load_lang_obj_array( dictionary_origin_array );
    
    for ( var j = 0, _size_j = dictionary_origin_array.length; j < _size_j; j++ ) {
        var _to_return = __lang_obj[ dictionary_origin_array[ j ] ][ elts[ 0 ] ];
        var _found     = true;
        for ( var i = 0, _size = elts.length; i < _size; i++ ) {
            _to_return = i !== 0 ? _to_return[ elts[ i ] ] : _to_return;
            if ( typeof _to_return === 'undefined' ) {
                _found = false;
                break;
            }
        }
        if ( _found ) {
            return _to_return;
        }
    }
    return 'TO_TRAD(' + to_trad + ')';
}
SHINKEN.TOOLS.InterfaceRefreshComponent           = function () {
};
SHINKEN.TOOLS.InterfaceRefreshComponent.prototype = {
    update      : function () {
    },
    phaseUpdated: function ( phase ) {
        switch ( phase ) {
            case SHINKEN.OBJECT.CONST.PHASE.READY :
                this.eventIsReady();
                break;
            case SHINKEN.OBJECT.CONST.PHASE.STARTING :
                this.eventIsStarting();
                break;
            case SHINKEN.OBJECT.CONST.PHASE.RUNNING :
                this.eventIsRunning();
                break;
            case SHINKEN.OBJECT.CONST.PHASE.REFRESHING :
                this.eventIsRefreshing();
                break;
            case SHINKEN.OBJECT.CONST.PHASE.STOPPING :
                this.eventIsStopping();
                break;
        }
    },
    setLastComputeDate   : function ( to_set ) {
    },
    eventIsReady     : function () {
    },
    eventIsStarting  : function () {
    },
    eventIsRunning   : function () {
    },
    eventIsRefreshing: function () {
    },
    eventIsStopping  : function () {
    },
    updateCountdown  : function () {
    }
};
SHINKEN.OBJECT.NOTIFICATION       = {};
SHINKEN.OBJECT.NOTIFICATION.CONST = {
    CONTAINER : {
        ID: 'shinken-notification-popup-container'
    },
    NOTICATION: {
        CLASS: 'shinken-notification-popup'
    },
    STATUS    : {
        ERROR       : 'error',
        WARNING     : 'warning',
        INFO        : 'info',
        SUCCESS     : 'success',
        COPY_SUCCESS: 'copy_success',
        COPY_FAILED : 'copy_failed'
    },
    PLACEMENT : {
        TOP                      : 0,
        RIGHT                    : 1,
        BOTTOM                   : 2,
        LEFT                     : 3,
        SPECIFIC_TITLE_HIVE      : 4,
        SPECIFIC_TITLE_LIST      : 5,
        COPY_NOTIFICATION_SUCCESS: 6,
        COPY_NOTIFICATION_FAILED : 7
    }
};
COMPONENT.Interface = function() {
};
COMPONENT.Interface.prototype = {
    initInterface: function() {
        this.url_param_key = this.dom_element.dataset.urlParamKey;
    },
    doExtraAction: function() {
        if ( this.url_param_key ) {
            this.updateUrlWithValue()
        }
    },
    updateUrlWithValue: function() {
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.Interface, SHINKEN.OBJECT.CounterInterface );
SHINKEN.OBJECT.CONST.PHASE = {
    RUNNING                 : 0,
    REFRESHING              : 1,
    INIT                    : 2,
    EDITING                 : 3,
    SAVING                  : 4,
    WAITING_FOR_START_IMPORT: 5,
    WAITING_FOR_IMPORT      : 6,
    WAITING_FOR_MERGE       : 7,
    WAITING_FOR_UPDATE      : 8,
    READY                   : 9,
    WAITING_FOR_READY       : 10,
    STOPPING                : 11,
    STARTING                : 12,
    STUCK                   : 13,
    HIDDEN                  : 14,
    ASKING_ENTER_PREVIEWING : 15,
    PREVIEWING              : 16,
    ASKING_ENTER_EDITING    : 17,
    ASK_FOR_REFRESH         : 18,
    RUNNING_OK              : 19,
    RUNNING_NOK             : 20
};
SHINKEN.OBJECT.CONST.CALLBACK_PHASE_TIMEOUT = 0;
SHINKEN.OBJECT.Phase           = function ( parent_object ) {
    this.previous_phase             = null;
    this.current_phase              = SHINKEN.OBJECT.CONST.PHASE.INIT;
    this.next_phase                 = null;
    this.parent_object              = parent_object;
    this.timeout_set_phase_callback = null;
    this.timeout_phase              = null;
};
SHINKEN.OBJECT.Phase.prototype = {
    setPhase           : function ( to_set ) {
        if ( this.timeout_phase ) {
            clearTimeout( this.timeout_phase );
        }
        this.previous_phase = this.current_phase;
        this.current_phase  = to_set;
        if ( this.dom_element ) {
            DOM.Service.setDataSet( this.dom_element, 'currentPhase', this.current_phase );
        }
        this.next_phase = null;
        if ( this.parent_object ) {
            
            var _self = this;
            if ( _self.timeout_set_phase_callback ) {
                clearTimeout( _self.timeout_set_phase_callback );
            }
            _self.timeout_set_phase_callback = setTimeout( function () {
                _self.parent_object.callbackForPhase();
                _self.timeout_set_phase_callback = null;
            }, SHINKEN.OBJECT.CONST.CALLBACK_PHASE_TIMEOUT );
        }
    },
    setPhaseWithTimeOut: function ( to_set, timeout ) {
        if ( !timeout ) {
            timeout = 0;
        }
        var self = this;
        this.timeout_phase = setTimeout( function () {
            self.setPhase( to_set );
        }, timeout );
    },
    isPhase            : function ( to_test ) {
        return this.current_phase === to_test;
    },
    isPreviousPhase    : function ( to_test ) {
        if ( !this.previous_phase ) {
            return false;
        }
        return this.previous_phase === to_test;
    },
    setParent          : function ( parent_object ) {
        this.parent_object = parent_object;
    },
    setDomElement      : function ( to_set ) {
        this.dom_element = to_set;
    }
};
SHINKEN.OBJECT.PhaseInterface           = function () {
};
SHINKEN.OBJECT.PhaseInterface.prototype = {
    initPhase          : function ( dom_element ) {
        this.phase = new SHINKEN.OBJECT.Phase( this );
        if ( dom_element ) {
            this.phase.setDomElement( dom_element );
        }
    },
    isPhase            : function ( to_test ) {
        return this.phase.isPhase( to_test );
    },
    setPhase           : function ( to_set ) {
        this.phase.setPhase( to_set );
    },
    setPhaseParent     : function ( to_set ) {
        this.phase.setParent( to_set );
    },
    setPhaseIfNotPhase : function ( to_set, if_not ) {
        if ( this.phase.isPhase( if_not ) ) {
            return;
        }
        this.phase.setPhase( to_set );
    },
    setPhaseWithTimeOut: function ( to_set, timeout ) {
        this.phase.setPhaseWithTimeOut( to_set, timeout );
    },
    getCurrentPhase    : function () {
        return this.phase.current_phase;
    },
    hasPreviousPhase   : function ( to_test ) {
        return this.phase.isPreviousPhase( to_test );
    },
    callbackForPhase   : function () {
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.PhaseInterface, SHINKEN.OBJECT.ShinkenObject );
SHINKEN.COMUNICATION = (function ( self ) {
    "use strict";
    self.requestGet     = function ( url, success, error, not_found_callback, unauthorized_callback ) {
        var request = new XMLHttpRequest();
        
        request.open( 'GET', url, true );
        request.onload  = self.onRequestSuccess( success, not_found_callback, unauthorized_callback );
        request.onerror = error || self.onRequestError;
        request.send();
    };
    self.requestPost    = function ( url, data, success, error, not_found_callback, unauthorized_callback ) {
        var request            = new XMLHttpRequest();
        self._success_callback = success;
        
        request.open( 'POST', url, true );
        request.setRequestHeader( 'Content-Type', 'charset=UTF-8' );
        request.onload  = self.onRequestSuccess( success, not_found_callback, unauthorized_callback );
        request.onerror = error || self.onRequestError;
        request.send( data );
    };
    self.onRequestError = function () {
        SHINKEN.TOOLS.NOTIFICATION.addNotification( "error", SHINKEN.OBJECT.NOTIFICATION.CONST.STATUS.ERROR );
    };
    
    self.onRequestSuccess = function ( success, not_found_callback, unauthorized_callback ) {
        return function () {
            var _data = JSON.parse( this.response );
            switch ( _data.rc ) {
                case COMMUNICATION.CODE.UNAUTHORIZED:
                    if ( unauthorized_callback ) {
                        unauthorized_callback( this.status, _data );
                        return;
                    }
                    window.parent.location.reload();
                    return;
                case COMMUNICATION.CODE.NOT_FOUND:
                    if ( not_found_callback ) {
                        not_found_callback( this.status, _data );
                        return;
                    }
                    break;
            }
            success( this.status, _data );
        };
    };
    return self;
})( SHINKEN.COMUNICATION || {} );
SHINKEN.HIGHWAY = (function ( self ) {
    "use strict";
    self.goToParentUrl                  = function () {
        var _floors        = location.pathname.split( '/' );
        var _new_path_name = "";
        var _size          = _floors.length;
        for ( var i = 1; i < _size - 1; i++ ) {
            _new_path_name += "/";
            _new_path_name += _floors[ i ];
        }
        switch ( _new_path_name ) {
            case "":
            case "/elements/my_working_area":
            case "/elements/working_area":
            case "/elements":
            case "/analyzers":
            case "/tagger":
            case "/elements/add":
                _new_path_name = "/main";
                break;
            case "/sources":
                _new_path_name = "/main";
                var _params    = this.getParams();
                if ( _params[ 'conf-id' ] || _params[ 'synchronizer-id' ] ) {
                    delete _params[ 'conf-id' ];
                    delete _params[ 'synchronizer-id' ];
                    delete _params[ 'source-name' ];
                    _new_path_name = this.getPathWithoutOrigin() + window.SHINKEN.HIGHWAY.buildParamsToUrl( _params );
                }
                break;
            case "/elements/add/working_area":
                _new_path_name = "/elements/working_area/hosts";
                break;
            case "/sources/server-analyzer/discovery":
                _new_path_name = "/sources/server-analyzer?tab=tab-network-scan";
                break;
            case "/sources/discovery/discovery":
                _new_path_name = "/sources/discovery?tab=tab-network-scan";
                break;
            case "/sources/server-analyzer/discovery/add":
                _new_path_name = "/sources/server-analyzer?tab=tab-network-scan";
                break;
            case "/sources/discovery/discovery/add":
                _new_path_name = "/sources/discovery?tab=tab-network-scan";
                break;
        }
        switch ( location.pathname ) {
            case "/elements/add/cluster":
            case "/elements/add/clustertpl":
            case "/elements/add/hosttpl":
            case "/elements/add/hostgroup":
            case "/elements/add/serviceshost":
            case "/elements/add/serviceshosttpl":
            case "/elements/add/servicescluster":
            case "/elements/add/servicesclustertpl":
            case "/elements/add/servicetpl":
            case "/elements/add/contact":
            case "/elements/add/contacttpl":
            case "/elements/add/contactgroup":
            case "/elements/add/escalation":
            case "/elements/add/notificationway":
            case "/elements/add/command":
            case "/elements/add/businessimpactmodulation":
            case "/elements/add/macromodulation":
            case "/elements/add/resultmodulation":
            case "/elements/add/timeperiod":
                _new_path_name = "/elements/" + _floors[ _size - 1 ] + 's';
                break;
        }
        window.location = location.origin + _new_path_name;
    };
    self.goToElementTab                 = function ( tab_name ) {
        var _path     = self.getPath();
        var _params   = self.getParams();
        var _old_name = _params[ 'tab' ];
        if ( _old_name === tab_name ) {
            return;
        }
        _params[ 'tab' ]       = tab_name;
        var _new_params_string = self.buildParamsToUrl( _params );
        self.changeUrl( _path + _new_params_string );
    };
    self.changeUrl                      = function ( new_url ) {
        new_url = new_url || location.pathname;
        window.history.pushState( "object or string", "Title", new_url );
    };
    self.getOrigin                      = function () {
        return location.origin;
    };
    self.getHostName                    = function () {
        return location.hostname;
    };
    self.getPath                        = function () {
        return location.origin + this.getPathWithoutOrigin();
    };
    self.getPathOrigin                  = function () {
        return location.origin;
    };
    self.getPathWithoutOrigin           = function () {
        return location.pathname;
    };
    self.getPathWithParamsWithoutOrigin = function () {
        return location.pathname + self.buildParamsToUrl( self.getParams() );
    };
    self.buildParamsToUrl               = function ( params ) {
        var _keys = Object.keys( params );
        var _size = _keys.length;
        if ( !_size ) {
            return '';
        }
        var _to_return = COMMUNICATION.QUERY.GET.SEPARATOR.GET_BEGINNER;
        for ( var i = 0; i < _size; i++ ) {
            if ( i ) {
                _to_return += COMMUNICATION.QUERY.GET.SEPARATOR.GET_ADD;
            }
            _to_return += _keys[ i ] + COMMUNICATION.QUERY.GET.SEPARATOR.PARAM_SETTER + params[ _keys[ i ] ];
        }
        return _to_return;
    };
    self.getParams                      = function ( param ) {
        var vars = {};
        window.location.href.replace( location.hash, '' ).replace(
            /[?&]+([^=&]+)=?([^&]*)?/gi, // regexp
            function ( m, key, value ) { // callback
                vars[ key ] = value !== undefined ? value : '';
            }
        );
        
        if ( param ) {
            return vars[ param ] ? vars[ param ] : null;
        }
        return vars;
    };
    self.is                             = function ( type ) {
        switch ( type ) {
            case COMMUNICATION.PAGE_TYPE.LIST_ALL_ELEMENT: //PATCH BUG 4022 TO REMOVE
                return location.pathname === "/elements/elements";
            case COMMUNICATION.PAGE_TYPE.LIST_WORKING_AREA:
                return location.pathname === "/elements/working_area/hosts" || location.pathname === "/elements/my_working_area/hosts";
        }
    };
    self.getListType                    = function () {
        var _to_return = self.getPath().split( "/" );
        return _to_return[ _to_return.length - 1 ];
    };
    self.goTo                           = function ( url, event ) {
        if ( event ) {
            event.stopPropagation();
            event.preventDefault();
        }
        if ( event && event.ctrlKey ) {
            self.goToBlank( url );
        }
        else {
            window.location = url;
        }
    };
    self.goToBlank                      = function ( url ) {
        window.open( url, '_blank' );
    };
    self.refreshCurrentPage             = function () {
        location.reload();
    };
    self.removeItemIdFromHistory        = function ( item_id ) {
        var histories = App.HistoryManager.histories();
        for ( var i = histories.length - 1; i >= 0; i-- ) {
            var _previousUrl = histories[ i ];
            if ( SHINKEN.TOOLS.STRING.contains( _previousUrl, item_id ) ) {
                histories.splice( i, 1 );
            }
        }
        App.HistoryManager.setHandlers();
    };
    self.setParam                       = function ( param_key, param_value ) {
        var params = self.getParams();
        if ( param_value ) {
            params[ param_key ] = SHINKEN.TOOLS.STRING.urlEncode( param_value );
        }
        else {
            delete params[ param_key ];
        }
        self.changeUrl( self.buildParamsToUrl( params ) );
    };
    self.handleResponse                 = function ( status ) {
        switch ( status ) {
            case COMMUNICATION.CODE.UNAUTHORIZED:
                SHINKEN.HIGHWAY.goTo( '/user/login?error=' + _('login.invalid_user') );
                break;
            default:
                break;
        }
    };
    return self;
})( SHINKEN.HIGHWAY || {} );
"use strict";
CONTROLLER.CommonUI = (function ( self ) {
    "use strict";
    self.controller_name = MANAGER.CONST.CONTROLLER.COMMON_UI;
    self.init            = function () {
    };
    self.clickOnButton   = function ( event, event_name, param ) {
        switch ( event_name ) {
            case "close_popup_progress_bar":
                var _dom_element_parent = DOM.Service.findParentElementWithClass( event.target, "shinken-popup-progress-bar-container", 10 );
                DOM.Service.setDataSet( _dom_element_parent, 'currentPhase', SHINKEN.OBJECT.CONST.PHASE.HIDDEN );
                break;
            case "toggle_display_popup_progress_bar_message":
                var _dom_element_parent   = DOM.Service.findParentElementWithClass( event.target, "shinken-popup-progress-bar-container", 10 );
                var _is_message_displayed = _dom_element_parent.dataset.messageDisplayed === "1";
                DOM.Service.setDataSet( _dom_element_parent, 'messageDisplayed', _is_message_displayed ? "0" : "1" );
                break;
        }
        if ( event_name ) {
            event.stopPropagation();
        }
    };
    
    
    return self;
})
( CONTROLLER.CommonUI || {} );
COMPONENT.Button           = function ( dom_element, name ) {
    this.__class_name__ = 'COMPONENT.Button';
    this.uuid   = SHINKEN.TOOLS.STRING.buildUUID();
    this.state  = COMPONENT.CONST.BTN_STATE.OFF;
    this.status = COMPONENT.CONST.BTN_STATUS.NONE;
    this.name   = name;
    this.value  = '';
    this.init( dom_element );
};
COMPONENT.Button.prototype = {
    init             : function ( dom_element ) {
        this.dom_element = dom_element;
        if ( this.dom_element ) {
            this.initDomElement();
        }
        else {
            this.state = COMPONENT.CONST.BTN_STATE.DISABLED;
        }
        this._computeState();
    },
    initDomElement   : function () {
        this.value = this.dom_element.value;
        if ( this.dom_element.classList.contains( 'shinken-error' ) ) {
            this.status = COMPONENT.CONST.BTN_STATUS.ERROR;
        }
        else if ( this.dom_element.classList.contains( 'shinken-warning' ) ) {
            this.status = COMPONENT.CONST.BTN_STATUS.WARNING;
        }
    },
    setState         : function ( to_set ) {
        this.state = to_set;
        if ( !this.dom_element ) {
            return;
        }
        this.resetStateClass();
        switch ( this.state ) {
            case COMPONENT.CONST.BTN_STATE.ON:
                this.dom_element.classList.add( "shinken-active" );
                break;
            case COMPONENT.CONST.BTN_STATE.DISABLED:
                this.dom_element.classList.add( "shinken-disabled" );
                break;
            case COMPONENT.CONST.BTN_STATE.ENABLED_WITH_ERRORS:
                this.dom_element.classList.add( "shinken-enabled-with-errors" );
                break;
        }
    },
    resetStateClass  : function () {
        if ( !this.dom_element ) {
            return;
        }
        this.dom_element.classList.remove( "shinken-active" );
        this.dom_element.classList.remove( "shinken-disabled" );
        this.dom_element.classList.remove( "shinken-enabled-with-errors" );
    },
    getValue         : function () {
        return this.value;
    },
    getState         : function () {
        return this.state;
    },
    isOn             : function () {
        return this.state === COMPONENT.CONST.BTN_STATE.ON;
    },
    setInheritedLabel: function ( to_set ) {
        this.dom_element.querySelector( '.shinken-inherited-value' ).innerHTML = to_set;
    },
    addClass         : function ( to_add ) {
        this.dom_element.classList.add( to_add );
    },
    removeClass      : function ( to_remove ) {
        this.dom_element.classList.remove( to_remove );
    },
    setTooltip       : function ( to_set, type ) {
        if ( to_set ) {
            this.dom_element.setAttribute( "onmouseenter", "SHINKEN_TOOLTIP.showTooltip(this)" );
            this.dom_element.setAttribute( "onmouseleave", "SHINKEN_TOOLTIP.hideTooltip()" );
            this.dom_element.setAttribute( 'shi-tip-html', to_set );
            if ( type ) {
                this.dom_element.setAttribute( 'shi-tip-type', type );
            }
        }
        else {
            this.dom_element.setAttribute( 'shi-tip-html', '' );
        }
    },
    computeCounters  : function () {
        switch ( this.status ) {
            case COMPONENT.CONST.BTN_STATUS.ERROR:
                this.getCounterError().update( this.uuid, 1 );
                break;
            case COMPONENT.CONST.BTN_STATUS.WARNING:
                this.getCounterWarning().update( this.uuid, 1 );
                break;
        }
    },
    _computeState    : function () {
        if ( this.state === COMPONENT.CONST.BTN_STATE.DISABLED ) {
            return;
        }
        if ( this.dom_element.classList.contains( "shinken-active" ) ) {
            this.setState( COMPONENT.CONST.BTN_STATE.ON );
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.Button, COMPONENT.Interface );
COMPONENT.Checkbox           = function ( dom_element, parent ) {
    this.init( dom_element, parent );
};
COMPONENT.Checkbox.prototype = {
    init                       : function ( dom_element, parent ) {
        this.dom_element = dom_element;
        this.initCounters( parent );
        this.checkbox_user      = new OBJECT.ElementCheckbox( dom_element.querySelector( ".shinken-checkbox-user" ), this );
        this.checkbox_inherited = new OBJECT.ElementCheckbox( dom_element.querySelector( ".shinken-checkbox-inherited" ), this );
        this.checkbox_default   = new OBJECT.ElementCheckbox( dom_element.querySelector( ".shinken-checkbox-default" ), this );
        this.initInterface();
    },
    toggleCheckedUser          : function () {
        var _value = !this.isCheckedUser();
        this.setCheckedUser( _value );
    },
    isCheckedUser              : function () {
        return this.checkbox_user.isChecked();
    },
    isCheckedInheritance       : function () {
        return this.checkbox_inherited.isChecked();
    },
    isCheckedDefault           : function () {
        return this.checkbox_default.isChecked();
    },
    setCheckedUser             : function ( to_set ) {
        this.checkbox_user.setChecked( to_set );
        this.doExtraAction();
    },
    setCheckedInheritance      : function ( to_set ) {
        this.checkbox_inherited.setChecked( to_set );
    },
    getChildrenObject              : function () {
        return [this.checkbox_user, this.checkbox_inherited, this.checkbox_default];
    },
    updateUrlWithValue         : function () {
        var _value = this.isCheckedUser() ? '1' : '';
        SHINKEN.HIGHWAY.setParam( this.url_param_key, _value );
    }
    
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.Checkbox, COMPONENT.Interface );
COMPONENT.InputRange           = function ( dom_element, property ) {
    this.init( dom_element, property );
};
COMPONENT.InputRange.prototype = {
    init                 : function ( dom_element, property ) {
        this.type_range      = dom_element.dataset.type;
        this.dom_input_range = dom_element.querySelector( ".shinken-range-container input" );
        switch ( property.type ) {
            case PROPERTY.CONST.TYPES.RANGE_WITH_INPUT:
                this.component_input = new COMPONENT.Input( dom_element.querySelector( ".shinken-input-table" ), property );
                if ( property.is_mass_change ) {
                    this.component_input.setPlaceholder( _( "mass-change.label.enter_a_value" ) );
                }
                this.value = this.dom_input_range.dataset.lastValueFromUser;
                break;
            
            default:
                this.component_label_input = new COMPONENT.Label( dom_element.querySelector( ".shinken-label-input-range" ) );
                this.value                 = parseInt( this.dom_input_range.dataset.lastValueFromUser ) + "";
                break;
        }
        this.value_from_user = property.is_mass_change ? '' : this.value;
        this.min             = this.dom_input_range.getAttribute( 'min' );
        this.max             = this.dom_input_range.getAttribute( 'max' );
        this.unit            = dom_element.dataset.unit;
        this.property_name   = property.getName();
        this.is_mass_change  = property.is_mass_change;
    },
    askComputeAfterChange: function ( dom_element, parent ) {
        if ( this.is_disabled ) {
            return;
        }
        this.component_input.askComputeAfterChange( dom_element, parent || this );
    },
    setValue             : function ( to_set, updateInputField ) {
        if ( typeof(updateInputField) === "undefined" ) { // IE Hack
            updateInputField = false;
        }
        this.value                 = to_set;
        this.dom_input_range.value = to_set;
        if ( this.component_input ) {
            if ( updateInputField && this.component_input.getValue() !== to_set ) {
                this.updateInput();
            }
            else if ( !updateInputField ) {
                this.emptyInput();
            }
        }
        else {
            this.updateLabel();
        }
    },
    setValueFromUser     : function ( to_set, updateInputField ) {
        if ( typeof(updateInputField) === "undefined" ) { // IE Hack
            updateInputField = true;
        }
        if ( to_set === null || to_set === undefined ) {
            to_set = this.dom_input_range.value;
            if ( this.component_input && to_set !== "0" && to_set !== "100" ) {
                to_set += ".000";
            }
        }
        to_set               = to_set + '';
        this.value_from_user = to_set;
        this.setValue( to_set, updateInputField );
    },
    updateInput          : function () {
        this.component_input.dom_element_input.value = this.value;
        this.component_input.setValueFromInput();
        this.component_input.validateValueInput();
    },
    emptyInput           : function () {
        this.component_input.dom_element_input.value = '';
        this.component_input.setValueFromInput();
        this.component_input.resetCounters();
        this.component_input.setStatus( COMPONENT.CONST.STATUS.NONE );
        this.component_input.validateValueInput();
    },
    updateLabel          : function () {
        var _to_set;
        if ( this.is_mass_change && this.value === '' ) {
            _to_set = _( "mass-change.label.enter_a_value" );
        }
        else {
            switch ( this.type_range ) {
                case PROPERTY.CONST.TYPES.RANGE:
                    _to_set = this.value + this.unit;
                    break;
                case PROPERTY.CONST.TYPES.RANGE_BUSINESS_IMPACT:
                    _to_set = _( "element.business_impact_" + this.value );
                    break;
            }
        }
        this.component_label_input.updateLabel( _to_set );
    },
    getValue             : function () {
        return this.value;
    },
    getValueFromUser     : function () {
        return this.value_from_user;
    },
    getChildrenObject        : function () {
        var _to_return = [];
        if ( this.component_input ) {
            _to_return.push( this.component_input );
        }
        return _to_return;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.InputRange, SHINKEN.OBJECT.CounterInterface );
COMPONENT.InputWithDropDown           = function ( dom_element, parent, use_quotes, type ) {
    this.init( dom_element, parent, use_quotes, type );
};
COMPONENT.InputWithDropDown.prototype = {
    init                       : function ( dom_element, parent, use_quotes, type ) {
        this.parent = parent;
        this.initCounters( parent );
        this.type            = type;
        this.dom_element     = dom_element;
        this.uuid            = SHINKEN.TOOLS.STRING.buildUUID();
        this.input           = new COMPONENT.Input( this.dom_element.querySelector( '.shinken-input-table' ), parent || this, true );
        this.select          = new COMPONENT.Select( this.dom_element.querySelector( '.shinken-select-container' ), PROPERTY.CONST.TYPES.SINGLE_SELECT, false, this, false, true );
        this.separators      = this.dom_element.dataset.separator.split( "$^$" );
        this.separator_regex = new RegExp( "[" + this.separators.join( "" ) + "]" );
        if ( use_quotes == undefined ) {
            use_quotes = false;
        }
        this.use_quotes = !!use_quotes;
    },
    keydown                    : function ( event, key_code ) {
        switch ( key_code ) {
            case SHINKEN.CONST.KEY_CODE.DOWN:
                this.select.moveAutoSelectCursor( true );
                event.preventDefault();
                break;
            case SHINKEN.CONST.KEY_CODE.UP:
                this.select.moveAutoSelectCursor( false );
                event.preventDefault();
                break;
            case SHINKEN.CONST.KEY_CODE.ENTER:
                this.select.validSelectedOrFirstElement();
                event.preventDefault();
                event.stopPropagation();
                break;
            default:
                if ( SHINKEN.TOOLS.ARRAY.contains( this.separators, key_code ) ) {
                    event.preventDefault();
                    event.stopPropagation();
                }
        }
    },
    askComputeAfterChange      : function ( dom_element, parent ) {
        this.input.askComputeAfterChange( dom_element, parent || this );
    },
    clickOnItemSelector        : function ( parent_name, key_name, event ) {
        if ( event ) {
            event.stopPropagation();
        }
        var _previous_value     = this.input.getValue();
        var first_part          = _previous_value.substring( 0, this.first_separator );
        var second_part         = _previous_value.substring( this.last_separator, _previous_value.length );
        var _is_specific_option = false;
        if ( event ) {
            var _parent_dom = DOM.Service.findParentElementWithDataSet( event.target, 'type', 10 );
            if ( _parent_dom && _parent_dom.dataset.type === 'is-always-visible' ) {
                _is_specific_option = true;
            }
        }
        if ( _is_specific_option ) {
            this.input.setValueFromJs( key_name );
        }
        else {
            this.input.setValueFromJs( first_part + key_name + second_part );
        }
        this.setCurrentFilter( true );
    },
    clickOnInput               : function () {
        this.setCurrentFilter();
    },
    setIsProtected             : function ( to_set ) {
        this.is_protected = to_set;
        this.dom_element.setAttribute( "type", (this.is_protected && SHINKEN.TOOLS.ENCRYPTION.isProtectedFieldsActivated()) ? "password" : this.type );
    },
    setPlaceholder             : function ( to_set ) {
        if ( !to_set ) {
            to_set = this.placeholder_no_template || '';
        }
        this.placeholder = to_set;
        this.input.setPlaceholder( to_set );
    },
    setValidationRules         : function ( _to_set ) {
        this.input.setValidationRules( _to_set );
    },
    hasBeenChanged             : function () {
        return this.current_value !== this.original_value;
    },
    getParentName              : function () {
        return this.parent.getParentName();
    },
    getChildrenObject              : function () {
        return [ this.input ];
    },
    getValue                   : function () {
        return this.input.getValue();
    },
    setValueFromJs             : function ( to_set ) {
        this.input.setValueFromJs( to_set );
    },
    getFinalValue              : function () {
        if ( this.timeout_ask_compute_after_change ) {
            clearTimeout( this.timeout_ask_compute_after_change );
            this.computeAfterChange();
        }
        return this.getValue();
    },
    setCurrentFilter           : function ( focus_on_last_separator, bypass_do_filter, validation_done ) {
        if ( this.select.list_element.list.length > 0 ) {
            this.select.openSelector();
        }
        var _value           = this.input.getValue();
        var _previous_filter = this.current_filter ? this.current_filter : "";
        var _cursor_position = this.input.dom_element.selectionStart;
        this.first_separator = 0;
        this.last_separator  = _value.length;
        
        var _in_quotes = false;
        for ( var i = 0; i < _cursor_position; i++ ) {
            if ( SHINKEN.TOOLS.ARRAY.contains( this.separators, _value[ i ] ) && !this.isReallyInQuotes( _in_quotes ) ) {
                this.first_separator = i + 1;
            }
            if ( _value[ i ] === '"' ) {
                _in_quotes = !_in_quotes;
            }
        }
        for ( i = _cursor_position; i < _value.length; i++ ) {
            if ( SHINKEN.TOOLS.ARRAY.contains( this.separators, _value[ i ] ) && !this.isReallyInQuotes( _in_quotes ) ) {
                this.last_separator = i;
                break;
            }
            if ( _value[ i ] === '"' ) {
                _in_quotes = !_in_quotes;
            }
        }
        
        if ( (this.first_separator) >= this.last_separator ) {
            this.current_filter = "";
        }
        else {
            this.current_filter = _value.substring( this.first_separator, this.last_separator ).trim();
        }
        if ( focus_on_last_separator ) {
            this.input.restoreCursorLocation( this.last_separator );
        }
        
        if ( SHINKEN.TOOLS.STRING.startsWith( this.current_filter, "=" ) ) {
            this.current_filter = this.current_filter.substring( 1 );
        }
        if ( this.use_quotes ) {
            this.current_filter = this.current_filter.replace( /"/g, '' );
        }
        this.select.setResearchDisplay( this.current_filter );
        if ( !bypass_do_filter || this.current_filter !== _previous_filter ) {
            this.select.doFilter( this.current_filter );
        }
        if ( !validation_done ) {
            this.validateValueInput();
        }
    },
    hasAutoSelect              : function () {
        return this.select.hasAutoSelect();
    },
    getDataSetLink             : function () {
        return this.select.getDataSetLink();
    },
    getListElement             : function () {
        return this.select.getListElement();
    },
    getStatus                  : function () {
        return this.input.getStatus();
    },
    addValidationRule          : function ( to_add, type ) {
        this.input.addValidationRule( to_add, type );
    },
    computeAfterChange         : function ( validation_done ) {
        this.setCurrentFilter( false, !this.input.need_validation, validation_done );
    },
    hidePopup                  : function () {
        this.select.hidePopup();
    },
    validSelectedOrFirstElement: function () {
        this.select.validSelectedOrFirstElement();
    },
    validateValueInput         : function () {
        this.input.validateValueInput();
    },
    finishActionBeforeReload   : function () {
        this.input.finishActionBeforeReload();
    },
    doActionAfterChange        : function () {
        this.computeAfterChange();
    },
    isReallyInQuotes           : function ( in_quotes ) {
        return this.use_quotes ? in_quotes : false;
    },
    applySiblingSettings : function (component) {
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.InputWithDropDown, SHINKEN.OBJECT.CounterInterface );
COMPONENT.Input           = function ( dom_element, parent, no_auto_valid, extra_key_validation ) {
    this.__class_name__ = 'COMPONENT.Input';
    this.init( dom_element, parent, extra_key_validation );
};
COMPONENT.Input.prototype = {
    init: function ( dom_element, parent, extra_key_validation ) {
        this.initCounters( parent );
        this.dom_element = dom_element;
        
        if ( this.dom_element.classList.contains( 'shinken-input' ) || this.dom_element.classList.contains( 'shinken-input-key' ) || this.dom_element.classList.contains( 'shinken-input-search' ) ) {
            this.dom_element_input = dom_element;
        }
        else {
            this.dom_element_input = dom_element.querySelector( '.shinken-input' );
        }
        this.uuid                    = SHINKEN.TOOLS.STRING.buildUUID();
        this.current_value           = this.dom_element_input.getAttribute( 'value' );
        this.type                    = this.dom_element_input.getAttribute( 'type' );
        this.original_value          = this.current_value;
        this.placeholder_no_template = this.dom_element_input.placeholder;
        this.placeholder             = this.placeholder_no_template;
        this.is_resizable            = this.dom_element_input.tagName === 'TEXTAREA';
        this.need_validation         = true;
        this.key_validation          = {
            "prop_name"     : parent ? parent.getParentName() : '',
            "component_name": extra_key_validation || ''
        };
        this.initInterface();
        this.time_out_compute_after_change = 200;
    },
    hasFocus         : function () {
        return DOM.Service.hasFocus( this.dom_element_input );
    },
    getDomValue      : function () {
        return this.dom_element_input.value;
    },
    getValue         : function () {
        return this.current_value;
    },
    setValueFromJs   : function ( to_set ) {
        this.current_value = to_set;
        this.computeNeedValidation();
        DOM.Service.setInputValue( this.dom_element_input, to_set );
        this.validateValueInput();
        this.updateView();
        this.doExtraAction();
    },
    setValueFromInput: function () {
        this.computeNeedValidation();
        this.current_value = this.getDomValue();
        if ( this.need_validation ) {
            this.updateView();
        }
        this.doExtraAction();
    },
    setStatus        : function ( to_set ) {
        this.status = to_set;
        DOM.Service.setDataSet( this.dom_element, 'status', to_set );
    },
    getStatus        : function () {
        return this.status;
    },
    setIsProtected   : function ( to_set ) {
        this.is_protected = to_set;
        this.dom_element_input.setAttribute( "type", (this.is_protected && SHINKEN.TOOLS.ENCRYPTION.isProtectedFieldsActivated()) ? SHINKEN.NAVIGATOR.isNavigator( 'isIE' ) ? "password" : "shinken-password" : this.type );
    },
    setDisabled      : function ( to_set ) {
        if ( to_set ) {
            this.dom_element_input.setAttribute( "readonly", '' );
        }
        else {
            this.dom_element_input.removeAttribute( "readonly", '' );
        }
    },
    setPlaceholder   : function ( to_set ) {
        if ( !to_set ) {
            to_set = this.placeholder_no_template || '';
        }
        to_set                             = SHINKEN.TOOLS.STRING.unescape_xss( to_set );
        this.placeholder                   = to_set;
        this.dom_element_input.placeholder = this.placeholder;
    },
    hasBeenChanged   : function () {
        return this.getValue() !== this.original_value;
    },
    setTooltip       : function ( to_set ) {
        this.dom_element.setAttribute( 'shi-tip-html', to_set );
    },
    setExtraTooltip  : function ( to_set ) {
        this.extra_tooltip = to_set;
    },
    addShinkenTooltip: function ( type, text ) {
        if ( this.extra_tooltip && this.hasBeenChanged() ) {
            if ( text ) {
                text += "<br>";
            }
            text += this.extra_tooltip;
            if ( type === "shinken-success-border" ) {
                type = SHINKEN_TOOLTIP.TYPE.BEWARE_BORDER;
            }
            SHINKEN_TOOLTIP.showTooltip( this.dom_element );
        }
        this.dom_element.setAttribute( 'shi-tip-type', type );
        this.dom_element.setAttribute( 'shi-tip-text', text );
        
        text && this.hasFocus() ? SHINKEN_TOOLTIP.showTooltip( this.dom_element ) : SHINKEN_TOOLTIP.hideTooltip();
    },
    setMessage       : function ( message ) {
        var _status  = COMPONENT.CONST.STATUS.NONE;
        this.message = message;
        if ( message ) {
            _status = message.getStatus();
        }
        var _counter = [0, 0];
        this.setStatus( _status );
        switch ( _status ) {
            case COMPONENT.CONST.STATUS.ERROR:
                this.addShinkenTooltip( SHINKEN_TOOLTIP.TYPE.ERROR_BORDER, message.buildMessage() );
                _counter[ 0 ] = 1;
                break;
            case COMPONENT.CONST.STATUS.BEWARE:
                this.addShinkenTooltip( SHINKEN_TOOLTIP.TYPE.BEWARE_BORDER, message.buildMessage() );
                break;
            case COMPONENT.CONST.STATUS.WARNING:
                this.addShinkenTooltip( SHINKEN_TOOLTIP.TYPE.WARNING_BORDER, message.buildMessage() );
                _counter[ 1 ] = 1;
                break;
            case COMPONENT.CONST.STATUS.NONE:
                this.addShinkenTooltip( "shinken-success-border", message ? message.buildMessage() : "" );
                break;
        }
        this.setError( this.uuid, _counter[ 0 ] );
        this.setWarning( this.uuid, _counter[ 1 ] );
    },
    restoreCursorLocation: function ( location ) {
        this.dom_element_input.focus();
        if ( location ) {
            this.last_cursor_location = location;
        }
        if ( !this.last_cursor_location ) {
            this.last_cursor_location = this.current_value.length;
        }
        this.dom_element_input.selectionStart = this.last_cursor_location;
        this.dom_element_input.selectionEnd   = this.last_cursor_location;
    },
    saveCursorLocation   : function () {
        this.last_cursor_location = this.getCursorLocation();
    },
    getCursorLocation    : function () {
        return this.dom_element_input.selectionStart;
    },
    updateView           : function ( is_inherited, update, keep_cursor_pos, has_inheritance ) {
        var _to_write = this.current_value;
        if ( this.current_value === 'null' && has_inheritance ) {
            _to_write = '';
        }
        if ( keep_cursor_pos ) {
            this.saveCursorLocation();
        }
        
        if ( update ) {
            this.computeNeedValidation();
            DOM.Service.setInputValue( this.dom_element_input, is_inherited ? '' : _to_write );
        }
        else {
            this.current_value = this.getDomValue();
        }
        if ( this.dom_element_input.value ) {
            this.dom_element.classList.remove( 'shinken-empty-input' );
        }
        else {
            this.dom_element.classList.add( 'shinken-empty-input' );
        }
        this.askComputeHeight();
        if ( keep_cursor_pos ) {
            this.restoreCursorLocation();
        }
    },
    askComputeHeight     : function () {
        var self = this;
        if ( self.timeout_ask_compute_height ) {
            clearTimeout( self.timeout_ask_compute_height );
        }
        self.timeout_ask_compute_height = setTimeout( function () {
            if ( self.is_resizable && DOM.Service.hasScrollHeight( self.dom_element_input ) && DOM.Service.getBoundingClientRect( self.dom_element_input, 'height' ) < 150 ) {
                self.dom_element_input.style.height = Math.min( 150, self.dom_element_input.scrollHeight + 6 ) + 'px';
            }
        }, 200 );
    },
    askComputeAfterChange   : function ( dom_element, parent, arg ) {
        var self = this;
        if ( self.timeout_ask_compute_after_change ) {
            clearTimeout( self.timeout_ask_compute_after_change );
        }
        self.timeout_ask_compute_after_change = setTimeout( function () {
            self.computeAfterChange( dom_element, parent, arg );
        }, self.time_out_compute_after_change );
    },
    finishActionBeforeReload: function () {
        if ( this.timeout_ask_compute_after_change ) {
            this.computeAfterChange();
        }
    },
    computeAfterChange      : function ( dom_element, parent, args ) {
        this.setValueFromInput();
        if ( !args ) {
            args = {};
        }
        args[ 'validation_done' ] = this.validateValueInput();
        args[ 'input_object' ]    = this;
        if ( parent ) {
            parent.doActionAfterChange( args );
        }
    },
    validateValueInput   : function ( forced, ignore_focus ) {
        if ( !SHINKEN.TOOLS.SHINKEN_VALIDATOR ) {
            return false;
        }
        if ( this.need_validation || forced ) {
            var _validation_rules = this.getValidationRules( ignore_focus );
            var _validator;
            if ( _validation_rules ) {
                _validator = SHINKEN.TOOLS.SHINKEN_VALIDATOR._compute_validation( _validation_rules, SHINKEN.TOOLS.STRING.trimExtented( this.getValue() ) );
            }
            else {
                _validator = SHINKEN.TOOLS.SHINKEN_VALIDATOR.init_with_name( this.key_validation, this.getValue() );
            }
            this.setMessage( _validator );
            this.need_validation = false;
            return true;
        }
        return false;
    },
    addValidationRule    : function ( to_add, type ) {
        switch ( type ) {
            case COMPONENT.CONST.FILTER.TYPES_VALIDATION.HAS_FOCUS:
                if ( !this.validation_rules ) {
                    this.validation_rules = [];
                }
                this.validation_rules.push( to_add );
                break;
            case COMPONENT.CONST.FILTER.TYPES_VALIDATION.NOT_FOCUS:
                if ( !this.validation_rules_not_focus ) {
                    this.validation_rules_not_focus = [];
                }
                this.validation_rules_not_focus.push( to_add );
                break;
        }
        
    },
    setValidationRules   : function ( to_set, type ) {
        switch ( type ) {
            case COMPONENT.CONST.FILTER.TYPES_VALIDATION.HAS_FOCUS:
                this.validation_rules = to_set;
                break;
            case COMPONENT.CONST.FILTER.TYPES_VALIDATION.NOT_FOCUS:
                this.validation_rules_not_focus = to_set;
                break;
        }
    },
    computeNeedValidation: function () {
        if ( this.need_validation ) {
            return;
        }
        if ( this.current_value !== this.getDomValue() ) {
            this.need_validation = true;
        }
    },
    getValidationRules   : function ( ignore_focus ) {
        if ( !this.validation_rules && !this.validation_rules_not_focus ) {
            return null;
        }
        if ( ignore_focus ) {
            return this.validation_rules_not_focus || this.validation_rules;
        }
        if ( !this.hasFocus() && this.validation_rules_not_focus ) {
            return this.validation_rules_not_focus;
        }
        return this.validation_rules;
    },
    updateUrlWithValue: function () {
        var _value = this.current_value ? this.current_value : '';
        SHINKEN.HIGHWAY.setParam( this.url_param_key, _value );
    },
    applySiblingSettings: function ( input ) {
        if ( this.current_value === input.current_value ) {
            return;
        }
        this.simulateUserInteractionWriting(input.current_value);
    },
    simulateUserInteractionWriting: function (value) {
        this.setValueFromJs( value );
        this.time_out_compute_after_change = 0;
        DOM.Service.SimulateAction.keyUp( this.dom_element_input );
        this.time_out_compute_after_change = 200;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.Input, SHINKEN.OBJECT.CounterInterface );
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.Input, COMPONENT.Interface );
COMPONENT.Label           = function ( dom_element ) {
    this.init( dom_element );
};
COMPONENT.Label.prototype = {
    init       : function ( dom_element ) {
        this.dom_element = dom_element;
        this.label       = dom_element.outerText;
    },
    updateLabel: function ( to_set ) {
        this.label                 = to_set;
        this.dom_element.innerHTML = this.label;
    }
};
COMPONENT.ListSelectElement           = function ( dom_element ) {
    this.init( dom_element );
};
COMPONENT.ListSelectElement.prototype = {
    init               : function ( dom_element ) {
        this.dom_element = dom_element;
        this.is_filtered   = false;
        this.reason_to_set = [];
        this.element = new OBJECT.ElementList();
        if ( dom_element ) {
            this.dom_title   = dom_element.querySelector( '.' + 'shinken-option-title' );
            this.initElement();
            this.is_selected = dom_element.classList.contains( 'shinken-selected' );
        }
    },
    initElement        : function () {
        this.element.setName( this.dom_element.dataset.keyName, this.dom_element );
        this.element.setLabel( this.dom_element.dataset.keyLabel );
        this.element.setState( this.dom_element.dataset.state );
        this.element.setIsDisabled( this.dom_element.dataset.isDisabled );
        this.element.setIsForceToNull( this.dom_element.dataset.forceToNull );
        this.element.setType( this.dom_element.dataset.type );
        this.element.setUUID( this.dom_element.dataset.uuid );
        this.element.setItemType( this.dom_element.dataset.itemType );
        this.element.setIsHiddenForAdminSi( this.dom_element.dataset.isHiddenForAdminSi );
    },
    getElement         : function () {
        return this.element;
    },
    getDomElement      : function () {
        return this.dom_element;
    },
    getName            : function () {
        return this.element.getName();
    },
    getLabel           : function () {
        return this.element.getLabel();
    },
    getState           : function () {
        return this.element.getState();
    },
    getTextContent     : function () {
        return this.dom_title.textContent;
    },
    getTextContentShort: function () {
        return this.dom_title.dataset.label;
    },
    setSelected        : function ( _to_set, extra_class, reason ) {
        if ( !reason ) {
            reason = "shinken-main-selector";
        }
        if ( _to_set ) {
            SHINKEN.TOOLS.ARRAY.addElement( this.reason_to_set, reason );
            this.dom_element.classList.add( 'shinken-selected' );
            if ( extra_class ) {
                DOM.Service.addClasses( this.dom_element, extra_class );
            }
        }
        else {
            SHINKEN.TOOLS.ARRAY.removeElement( this.reason_to_set, reason );
            if ( this.reason_to_set.length ) {
                return;
            }
            this.dom_element.classList.remove( 'shinken-selected' );
            this.dom_element.classList.remove( 'shinken-select-focused' );
            this.dom_element.classList.remove( 'shinken-select-no-events' );
            if ( extra_class ) {
                DOM.Service.removeClasses( this.dom_element, extra_class );
            }
        }
        this.is_selected = _to_set;
    },
    isSelected         : function () {
        return this.is_selected;
    },
    setIsFiltered      : function ( to_set ) {
        this.is_filtered = to_set;
        if ( to_set ) {
            this.dom_element.classList.add( COMPONENT.CONST.LIST_SELECT_ELEMENT.CLASS.HIDDEN );
        }
        else {
            this.dom_element.classList.remove( COMPONENT.CONST.LIST_SELECT_ELEMENT.CLASS.HIDDEN );
        }
    },
    doFilter           : function ( filter ) {
        if ( !MANAGER.__instance_element_distributor.current_user.is_admin && this.element.is_hidden_for_admin_si ) {
            return false;
        }
        if ( !filter ) {
            this.setIsFiltered( false );
            return this.element.type === OBJECT.CONST.ELEMENT_LIST.TYPE.USER;
        }
        if ( this.element.type !== OBJECT.CONST.ELEMENT_LIST.TYPE.USER ) {
            this.setIsFiltered( true );
            return false;
        }
        if ( SHINKEN.TOOLS.STRING.containsIgnoreCase( this.element.getName(), filter ) ) {
            this.setIsFiltered( false );
            return true;
        }
        else {
            this.setIsFiltered( true );
            return false;
        }
    },
    updateHtmlLabel    : function ( label ) {
        this.element.setLabel( label );
        this.dom_element.innerHTML = this.getLabel();
    }
};
COMPONENT.ListSelect           = function ( dom_element, parent_name, allow_multiple_select ) {
    this.init( dom_element, parent_name, allow_multiple_select );
};
COMPONENT.ListSelect.prototype = {
    init                     : function ( dom_element, parent_name, allow_multiple_select ) {
        allow_multiple_select = !!allow_multiple_select;
        this.dom_element      = dom_element;
        if ( !this.dom_element ) {
            return;
        }
        this.dom_element_counter_research      = dom_element.querySelector( '.shinken-counter-current' );
        this.dom_element_counter_total         = dom_element.querySelector( '.shinken-counter-total' );
        this.dom_element_input_research        = dom_element.querySelector( '.shinken-input-search' );
        this.dom_element_display_research      = dom_element.querySelector( '.shinken-display-search .shinken-value' );
        this.dom_element_select_content        = dom_element.querySelector( '.list-select-content' );
        this.current_index_auto_select_element = COMPONENT.CONST.NOT_FOUND;
        this.state                             = COMPONENT.CONST.BTN_STATE.OFF;
        this.parent_name                       = parent_name;
        this.allow_multiple_select             = allow_multiple_select;
        this.initListElement();
    },
    initListElement          : function () {
        this.list                     = [];
        this.list_mapping             = {};
        this.list_mapping_lower_case  = {};
        this.nbr_in_list_after_filter = 0;
        var _list_element             = this.dom_element.querySelectorAll( '.' + COMPONENT.CONST.SELECT.SELECTOR_LIST_OPTION );
        this.size_list                = _list_element.length;
        for ( var i = 0; i < this.size_list; i++ ) {
            this.list[ i ]                                = new COMPONENT.ListSelectElement( _list_element[ i ] );
            this.list_mapping[ this.list[ i ].getName() ] = i;
            this.list_mapping_lower_case[ this.list[ i ].getName().toLowerCase() ] = i;
        }
    },
    toggleStateSelectedInList: function ( key_name, class_to_add ) {
        var _list_select_element = this.list[ this._getIndexElementInMapping(key_name) ];
        _list_select_element.setSelected( !_list_select_element.is_selected, class_to_add );
        return _list_select_element.getElement();
    },
    unselectAllElement       : function ( extra_class ) {
        var _current;
        for ( var i = 0; i < this.size_list; i++ ) {
            _current = this.list[ i ];
            _current.setSelected( false, extra_class );
        }
    },
    doChangeFilterSelect     : function () {
    
    },
    addNewElementUnknown     : function ( key_name, prop_name ) {
        var _to_add    = DOM.Service.createElement( 'div', {
                class               : COMPONENT.CONST.SELECT.SELECTOR_LIST_OPTION,
                "data-state"        : "unknown",
                "data-key-name"     : key_name,
                "data-key-label"    : key_name,
                "data-type"         : "user",
                "data-is-disabled"  : "false",
                "data-force-to-null": "false",
                "data-uuid"         : "",
                onmouseup           : "MANAGER.EventManager.clickOnItemSelector('event','" + prop_name + "', this)"
            },
            "<span class='shinken-space'>" + key_name + " ( " + _( 'element.unknown' ) + " )" + "</span>"
        );
        var _to_return = new COMPONENT.ListSelectElement( _to_add );
        this.addNewElement( key_name, _to_return );
        return _to_return;
    },
    addNewElement            : function ( key_name, list_select_element ) {
        this.list[ this.size_list ]              = list_select_element;
        this.list_mapping[ key_name ]            = this.size_list;
        this.list_mapping_lower_case[ key_name.toLowerCase() ]            = this.size_list;
        this.dom_element_counter_total.innerHTML = parseInt( this.dom_element_counter_total.innerHTML ) + 1;
        this.size_list++;
        this.dom_element_select_content.appendChild( list_select_element.dom_element );
    },
    _getIndexElementInMapping             : function ( key_name ) {
        if ( !key_name ){
            return;
        }
        var _index = this.list_mapping[ key_name ];
        if ( _index === undefined ) {
            _index = this.list_mapping_lower_case[ key_name.toLowerCase() ];
        }
        return _index;
    },
    getElement                          : function ( key_name ) {
        var _index = this._getIndexElementInMapping(key_name);
        if ( _index === undefined ) {
            return null;
        }
        return this.list[ _index ].getElement();
    },
    getListSelectElement   : function ( key_name ) {
        var _index = this._getIndexElementInMapping(key_name);
        return this.list[ _index ];
    },
    getSelectedElements    : function () {
        var _to_return = [];
        var _current_element;
        for ( var i = 0; i < this.size_list; i++ ) {
            _current_element = this.list[ i ];
            if ( _current_element.is_selected ) {
                _to_return.push( _current_element );
            }
        }
        return _to_return;
    },
    getFirstSelectedElement: function ( exclude_hidden ) {
        var _current_element;
        for ( var i = 0; i < this.size_list; i++ ) {
            _current_element = this.list[ i ];
            if ( _current_element.is_selected ) {
                if ( exclude_hidden && _current_element.dom_element.classList.contains( "shinken-hidden" ) ) {
                    continue;
                }
                return _current_element;
            }
        }
        return null;
    },
    setState               : function ( state ) {
        this.state = state;
        this.setLastAutoSelectElement( false );
        return this.state;
    },
    focusOnResearchInput: function () {
        if ( this.dom_element_input_research ) {
            this.dom_element_input_research.focus();
            if ( this.state === COMPONENT.CONST.BTN_STATE.ON ) {
                this.doFilter( this.current_filter );
            }
        }
    },
    setResearchDisplay  : function ( value ) {
        if ( this.dom_element_display_research ) {
            this.dom_element_display_research.innerHTML = value;
        }
    },
    toggleState         : function () {
        switch ( this.state ) {
            case COMPONENT.CONST.BTN_STATE.ON:
                this.setState( COMPONENT.CONST.BTN_STATE.OFF );
                break;
            case COMPONENT.CONST.BTN_STATE.OFF:
                this.setState( COMPONENT.CONST.BTN_STATE.ON );
                break;
            case COMPONENT.CONST.BTN_STATE.DISABLED:
                break;
            default:
                console.error( "Error::toggleState is outside its perimeter" );
        }
        return this.state;
    },
    doFilter         : function ( filter ) {
        if ( this.current_filter && filter === this.current_filter ) {
            return;
        }
        this.current_filter           = filter;
        this.nbr_in_list_after_filter = 0;
        var _current;
        for ( var i = 0; i < this.size_list; i++ ) {
            _current = this.list[ i ];
            if ( _current.doFilter( filter ) ) {
                this.nbr_in_list_after_filter++;
            }
        }
        if ( filter ) {
            this.dom_element.classList.add( COMPONENT.CONST.LIST_SELECT.CLASS.FILTERING_ON );
        }
        else {
            this.dom_element.classList.remove( COMPONENT.CONST.LIST_SELECT.CLASS.FILTERING_ON );
        }
        if ( this.nbr_in_list_after_filter ) {
            this.dom_element.classList.remove( COMPONENT.CONST.LIST_SELECT.CLASS.NO_RESULT );
        }
        else {
            this.dom_element.classList.add( COMPONENT.CONST.LIST_SELECT.CLASS.NO_RESULT );
        }
        if ( this.dom_element_counter_research ) {
            this.dom_element_counter_research.innerHTML = this.nbr_in_list_after_filter;
        }
        this.setLastAutoSelectElement( false );
        
    },
    cleanFilter      : function () {
        this.dom_element_input_research.value = "";
        this.doFilter( '' );
    },
    addNewElementList: function ( value ) {
        var _to_add = new COMPONENT.ListSelectElement( _list_element[ i ] );
    },
    hasAutoSelect                       : function () {
        return this.current_index_auto_select_element !== COMPONENT.CONST.NOT_FOUND;
    },
    setLastAutoSelectElement            : function ( to_set, action_type, avoid ) {
        if ( to_set ) {
            DOM.ScrollService.bindWith( this.dom_element_select_content, this.list[ this.current_index_auto_select_element ].dom_element, this.previous_position_vertical, action_type );
            this.list[ this.current_index_auto_select_element ].dom_element.classList.add( 'shinken-select-focused' );
        }
        else {
            if ( !avoid ) {
                this.previous_position_vertical = 0;
            }
            if ( this.current_index_auto_select_element !== COMPONENT.CONST.NOT_FOUND ) {
                if ( !avoid ) {
                    this.previous_position_vertical = DOM.Service.getBoundingClientRect( this.list[ this.current_index_auto_select_element ].dom_element, DOM.CONST.SPECIAL.MEDIAN_TOP_BOTTOM );
                }
                this.list[ this.current_index_auto_select_element ].dom_element.classList.remove( 'shinken-select-focused' );
            }
            this.current_index_auto_select_element = COMPONENT.CONST.NOT_FOUND;
        }
    },
    selectSelectedOrFirstFilteredElement: function () {
        if ( this.current_index_auto_select_element === COMPONENT.CONST.NOT_FOUND ) {
            this.updateLastAutoSelectIndex( SHINKEN.TOOLS.ARRAY.findFirstIndexWith( this.list, "is_filtered", false ), COMPONENT.CONST.AUTO_SELECT_ACTION_TYPE.KEY_INPUT );
        }
    },
    validAutoSelect                     : function () {
        if ( this.current_index_auto_select_element === COMPONENT.CONST.NOT_FOUND ) {
            return false;
        }
        DOM.Service.SimulateAction.mouseUp( this.list[ this.current_index_auto_select_element ].dom_element );
        this.setLastAutoSelectElement( false );
        return true;
    },
    moveAutoSelectCursor                : function ( move_down ) {
        if ( this.state !== COMPONENT.CONST.BTN_STATE.ON ) {
            return;
        }
        if ( !this.size_list ) {
            return;
        }
        var action_type = move_down ? COMPONENT.CONST.AUTO_SELECT_ACTION_TYPE.MOVE_DOWN : COMPONENT.CONST.AUTO_SELECT_ACTION_TYPE.MOVE_UP;
        var _dom_target = this.current_index_auto_select_element === COMPONENT.CONST.NOT_FOUND ? null : this.list[ this.current_index_auto_select_element ].dom_element;
        
        if ( !DOM.ScrollService.isVisible( this.dom_element_select_content, _dom_target, 0, action_type ) ) {
            var _dom_element;
            if ( this.current_index_auto_select_element === COMPONENT.CONST.NOT_FOUND ) {
                _dom_element = DOM.ScrollService.getFirstVisibleDom( this.dom_element_select_content, ".shinken-option:not(.shinken-hidden):not(.shinken-selected)", move_down );
            }
            else {
                _dom_element = DOM.ScrollService.getCloserVisibleDomFromMiddle( this.dom_element_select_content, ".shinken-option:not(.shinken-hidden):not(.shinken-selected)", move_down );
            }
            if ( _dom_element ) {
                this.previous_position_vertical = DOM.Service.getBoundingClientRect( this.dom_element_select_content, DOM.CONST.SPECIAL.MEDIAN_TOP_BOTTOM );
                this.updateLastAutoSelectIndex( this._getIndexElementInMapping( _dom_element.dataset.keyName ), action_type, true );
            }
            return;
        }
        var _current_counter = this.current_index_auto_select_element;
        var _current;
        var _found           = false;
        
        while ( move_down ? _current_counter < this.size_list : _current_counter >= COMPONENT.CONST.NOT_FOUND ) {
            move_down ? _current_counter++ : _current_counter--;
            _current = this.list[ _current_counter ];
            if ( !_current ) {
                this.updateLastAutoSelectIndex( this.current_index_auto_select_element, action_type );
                continue;
            }
            var _display = DOM.Service.getComputedStyle( _current.dom_element, DOM.CONST.STYLE.DISPLAY );
            if ( _display === DOM.CONST.VALUE.NONE ) {
                continue;
            }
            if ( _current.isSelected() && !this.allow_multiple_select ) {
                continue;
            }
            _found = true;
            break;
        }
        if ( _found ) {
            this.updateLastAutoSelectIndex( _current_counter, action_type );
        }
    },
    updateLastAutoSelectIndex           : function ( index, action_type, avoid ) {
        var _type = "";
        switch ( action_type ) {
            case COMPONENT.CONST.AUTO_SELECT_ACTION_TYPE.MOUSE:
                if ( this.prevent_mouse_enter ) {
                    return;
                }
                break;
            case COMPONENT.CONST.AUTO_SELECT_ACTION_TYPE.MOVE_DOWN:
                _type                    = DOM.CONST.ATTRIBUTE.SCROLL_DOWN;
                this.prevent_mouse_enter = true;
                break;
            case COMPONENT.CONST.AUTO_SELECT_ACTION_TYPE.MOVE_UP:
                this.prevent_mouse_enter = true;
                _type                    = DOM.CONST.ATTRIBUTE.SCROLL_TOP;
                break;
        }
        if ( this.prevent_mouse_enter ) {
            var _self = this;
            if ( this.timeout_mouse_down ) {
                clearTimeout( this.timeout_mouse_down );
            }
            this.timeout_mouse_down = setTimeout( function () {
                _self.prevent_mouse_enter = false;
                _self.timeout_mouse_down  = null;
            }, 200 );
        }
        this.setLastAutoSelectElement( false, _type, avoid );
        this.current_index_auto_select_element = index;
        this.setLastAutoSelectElement( true, _type );
    }
};
COMPONENT.Select           = function ( dom_element, type, is_override, parent, datasetLink, allow_multiple_select ) {
    this.__class_name__ = 'COMPONENT.Select';
    this.type                  = type;
    this.is_override           = is_override;
    this.allow_multiple_select = !!allow_multiple_select;
    this.is_editable           = true;
    this.init( dom_element, parent );
    this.setDataSetLink( datasetLink );
    this.__class = SHINKEN.TOOLS.CLASS.CONST.COMPONENT.SELECT;
};
COMPONENT.Select.prototype = {
    init                      : function ( dom_element, parent ) {
        this.uuid        = SHINKEN.TOOLS.STRING.buildUUID();
        this.dom_element = dom_element;
        this.dom_select  = dom_element.querySelector( '.' + COMPONENT.CONST.SELECT.SELECTOR );
        if ( this.dom_select ) {
            this.dom_link_icon_container = this.dom_select.querySelector( '.shinken-link-icon-container' );
            this.dom_link_icon_button    = this.dom_select.querySelector( '.shinken-link-icon-button' );
        }
        else {
            this.is_editable = false;
        }
        var _dom_list_select = dom_element.querySelector( '.' + COMPONENT.CONST.SELECT.SELECTOR_LIST );
        this.list_element    = new COMPONENT.ListSelect( _dom_list_select, parent.getParentName(), this.allow_multiple_select );
        this.initSearchElement();
        switch ( this.type ) {
            case PROPERTY.CONST.TYPES.MULTI_SELECT:
                var _dom_list_selected       = dom_element.querySelector( '.shinken-list-selected-in-select' );
                var _dom_list_inherited      = dom_element.querySelector( '.shinken-list-inherited' );
                var _dom_list_override       = dom_element.querySelector( '.shinken-list-override' );
                this.list_element_selected   = new COMPONENT.ListTag( _dom_list_selected, parent.name );
                this.list_elements_inherited = new COMPONENT.ListTag( _dom_list_inherited );
                this.list_element_override   = new COMPONENT.ListTag( _dom_list_override );
                break;
            case PROPERTY.CONST.TYPES.MULTI_SELECT_BASIC:
                var _dom_list_selected     = dom_element.querySelector( '.shinken-list-selected-in-select' );
                this.list_element_selected = new COMPONENT.ListTag( _dom_list_selected, parent.name );
                break;
        }
        this.initCounters( parent );
    },
    initSearchElement         : function () {
        var _dom = this.dom_element.querySelector( ".shinken-input-search" );
        if ( _dom ) {
            this.component_input_search = new COMPONENT.Input( _dom );
        }
    },
    updateWithTemplateSpecific: function ( tags ) {
        this.list_elements_inherited.addTags( tags );
    },
    hidePopup                 : function () {
        DOM.Service.setDataSet( this.dom_element, COMPONENT.CONST.SELECT.DATA_STATE_SELECTOR, COMPONENT.CONST.BTN_STATE.OFF );
        this.list_element.setState( COMPONENT.CONST.BTN_STATE.OFF );
    },
    openSelector              : function () {
        if ( this.list_element.state === COMPONENT.CONST.BTN_STATE.OFF ) {
            this.clickOnSelector();
        }
    },
    clickOnSelector          : function () {
        DOM.Service.setDataSet( this.dom_element, COMPONENT.CONST.SELECT.DATA_STATE_SELECTOR, this.list_element.toggleState() );
        this.list_element.focusOnResearchInput();
    },
    clickOnItemSelector      : function ( parent_name, key_name, class_to_add ) {
        this.setLastSelectedElementName( key_name );
        switch ( this.type ) {
            case PROPERTY.CONST.TYPES.MULTI_SELECT:
            case PROPERTY.CONST.TYPES.MULTI_SELECT_BASIC:
                var _element = this.list_element.toggleStateSelectedInList( key_name, class_to_add );
                this.list_element.setState( COMPONENT.CONST.BTN_STATE.OFF );
                this.getActiveListForUser().addTag( parent_name, _element );
                break;
            case PROPERTY.CONST.TYPES.SINGLE_SELECT:
            case PROPERTY.CONST.TYPES.SINGLE_SELECT_WITH_INPUT:
                break;
            case PROPERTY.CONST.TYPES.STRING_INPUT_WITH_DROPDOWN:
                this.list_element.clickOnItemSelector( key_name );
                break;
        }
        if ( MANAGER.__instance_property_distributor ) {
            MANAGER.__instance_property_distributor.hidePopups();
        }
    },
    clickOnDeleteItemSelector: function ( key_name ) {
        var _element = this.list_element.toggleStateSelectedInList( key_name );
        this.getActiveListForUser().deleteTag( _element );
    },
    askComputeAfterChange    : function ( dom_element ) {
        switch ( dom_element.name ) {
            case 'multi-search':
                this.component_input_search.askComputeAfterChange( dom_element, this );
                break;
        }
    },
    doActionAfterChange      : function ( args ) {
        this.doFilter( this.component_input_search.getValue() );
    },
    simulateClickOnItem      : function ( key_name ) {
        DOM.Service.SimulateAction.mouseUp(this.list_element.getListSelectElement(key_name).dom_element);
    },
    dragStartShinken: function ( type_element, key_name ) {
        switch ( type_element ) {
            case PROPERTY.CONST.DRAG_N_DROP.TYPE.SELECTED_ITEM:
                return this.getActiveListForUser().dragStartShinken( key_name );
        }
    },
    resetDragging   : function () {
        this.list_element_selected.resetDragging();
    },
    setTitle                  : function ( _to_set ) {
        if ( !this.is_editable ) {
            return;
        }
        var _dom_text       = this.dom_select.querySelector( '.' + COMPONENT.CONST.SELECT.SELECTOR_TEXT );
        this.title          = _to_set;
        _dom_text.innerHTML = this.title;
    },
    setResearchDisplay        : function ( _to_set ) {
        this.list_element.setResearchDisplay( _to_set );
    },
    isSet                     : function () {
        return !this.getActiveListForUser().isEmpty();
    },
    cleanAllTags              : function () {
        this.getActiveListForUser().emptyList();
    },
    getActiveListForUser      : function () {
        if ( this.is_override ) {
            return this.list_element_override;
        }
        else {
            return this.list_element_selected;
        }
    },
    cleanAllItemsSelected     : function ( extra_class ) {
        this.list_element.unselectAllElement( extra_class );
    },
    getValue                  : function () {
        switch ( this.type ) {
            case PROPERTY.CONST.TYPES.MULTI_SELECT:
            case PROPERTY.CONST.TYPES.MULTI_SELECT_BASIC:
                return this.getActiveListForUser().getValue();
            case PROPERTY.CONST.TYPES.SINGLE_SELECT:
            case PROPERTY.CONST.TYPES.SINGLE_SELECT_WITH_INPUT:
                return this.getLastSelectedElementName();
        }
    },
    getValueToSave            : function () {
        switch ( this.type ) {
            case PROPERTY.CONST.TYPES.MULTI_SELECT:
            case PROPERTY.CONST.TYPES.MULTI_SELECT_BASIC:
                return this.getTagsValueToSave();
            case PROPERTY.CONST.TYPES.SINGLE_SELECT:
            case PROPERTY.CONST.TYPES.SINGLE_SELECT_WITH_INPUT:
                if ( this.last_selected_key_name ) {
                    return this.getLastSelectedElement().getElement().getValueFinal();
                }
                return;
        }
    },
    getTagsValueToSave        : function () {
        var _to_return = [];
        var _tags      = this.getActiveListForUser().getTags();
        for ( var i = 0, size = _tags.length; i < size; i++ ) {
            _to_return.push( _tags[ i ].getValueFinal() );
        }
        return _to_return;
    },
    computeTitle              : function ( add_extra, extra_label ) {
        if ( this.last_selected_key_name === undefined ) {
            var _selected = this.list_element.getSelectedElements();
            if ( _selected[ 0 ] !== undefined ) {
                this.setLastSelectedElementName( _selected[ 0 ].element.name );
            }
        }
        var _selected_element = this.getLastSelectedElement();
        var _title_to_set     = '';
        if ( _selected_element ) {
            _title_to_set = _selected_element.element.getLabel();
        }
        if ( extra_label ) {
            _title_to_set += extra_label;
        }
        this.setTitle( _title_to_set );
    },
    getLastSelectedElement    : function () {
        return this.list_element.getListSelectElement( this.last_selected_key_name );
    },
    getLastSelectedElementName: function () {
        return this.last_selected_key_name || '';
    },
    setLastSelectedElementName: function ( to_set ) {
        if ( this.last_selected_key_name ) {
            this.previous_selected_key_name = this.last_selected_key_name;
        }
        this.last_selected_key_name = to_set;
    },
    hasTag                    : function ( name ) {
        return !this.list_element_selected.hasTag( name ) || !this.list_elements_inherited.hasTag( name );
    },
    getMissingItemSelectorWith: function ( property ) {
        return this.list_element_selected.getMissingItemSelectorWith( property );
    },
    getExtraItemSelectorWith  : function ( property ) {
        return this.list_element_selected.getExtraItemSelectorWith( property );
    },
    setMaximumSelected        : function ( to_set ) {
        this.maximum_selected = to_set;
    },
    getMaximumSelected        : function () {
        return this.maximum_selected;
    },
    isLimitReached            : function () {
        return (this.getActiveListForUser().getSizeTags() + this.list_elements_inherited.getSizeTags() - this.maximum_selected);
    },
    isLimitReachedForSelected : function () {
        return (this.getActiveListForUser().getSizeTags() - this.maximum_selected);
    },
    disabledTagsOutOfLimit    : function ( limit ) {
        this.list_elements_inherited.disabledTagsOutOfLimit( limit );
    },
    getErrors                 : function ( state, prop_name ) {
        var _to_return = 0;
        switch ( this.type ) {
            case PROPERTY.CONST.TYPES.MULTI_SELECT:
                switch ( state ) {
                    case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE_AND_USER:
                        _to_return = this.list_element_selected.getErrors( prop_name ) + this.list_elements_inherited.getErrors( prop_name );
                        break;
                    case PROPERTY.CONST.STATE_PROPERTY.USER_SET:
                        _to_return = this.list_element_selected.getErrors( prop_name );
                        break;
                    case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE:
                        _to_return = this.list_elements_inherited.getErrors( prop_name );
                        break;
                    case PROPERTY.CONST.STATE_PROPERTY.OVERRIDE_AND_PLUS:
                    case PROPERTY.CONST.STATE_PROPERTY.OVERRIDE:
                        _to_return = this.list_element_override.getErrors( prop_name ) + this.list_elements_inherited.getErrors( prop_name );
                        break;
                    case PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT:
                    case PROPERTY.CONST.STATE_PROPERTY.OVERRIDE_FORCED_DEFAULT:
                        break;
                }
                break;
        }
        _to_return += this.getCounterError().getValue();
        return _to_return;
    },
    getWarnings               : function ( state, prop_name ) {
        var _to_return = 0;
        switch ( this.type ) {
            case PROPERTY.CONST.TYPES.MULTI_SELECT:
                switch ( state ) {
                    case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE_AND_USER:
                        _to_return = this.list_element_selected.getWarnings( prop_name ) + this.list_elements_inherited.getWarnings( prop_name );
                        break;
                    case PROPERTY.CONST.STATE_PROPERTY.USER_SET:
                        _to_return = this.list_element_selected.getWarnings( prop_name );
                        break;
                    case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE:
                        _to_return = this.list_elements_inherited.getWarnings( prop_name );
                        break;
                    case PROPERTY.CONST.STATE_PROPERTY.OVERRIDE_AND_PLUS:
                    case PROPERTY.CONST.STATE_PROPERTY.OVERRIDE:
                        _to_return = this.list_element_override.getWarnings( prop_name ) + this.list_elements_inherited.getWarnings( prop_name );
                        break;
                    case PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT:
                    case PROPERTY.CONST.STATE_PROPERTY.OVERRIDE_FORCED_DEFAULT:
                        break;
                }
                break;
        }
        _to_return += this.getCounterWarning().getValue();
        return _to_return;
    },
    setMessage                : function ( message ) {
        var _status = COMPONENT.CONST.STATUS.NONE;
        if ( typeof message === 'string' ) {
            _status = COMPONENT.CONST.STATUS.INFO;
        }
        else if ( message ) {
            _status = message.getStatus();
        }
        var _counter = [0, 0];
        this.setStatus( _status );
        switch ( _status ) {
            case COMPONENT.CONST.STATUS.INFO:
                this.addShinkenTooltip( "", message );
                break;
            case COMPONENT.CONST.STATUS.ERROR:
                this.addShinkenTooltip( SHINKEN_TOOLTIP.TYPE.ERROR_BORDER, message.buildMessage() );
                _counter[ 0 ] = 1;
                break;
            case COMPONENT.CONST.STATUS.BEWARE:
                this.addShinkenTooltip( SHINKEN_TOOLTIP.TYPE.BEWARE_BORDER, message.buildMessage() );
                break;
            case COMPONENT.CONST.STATUS.WARNING:
                this.addShinkenTooltip( SHINKEN_TOOLTIP.TYPE.WARNING_BORDER, message.buildMessage() );
                _counter[ 1 ] = 1;
                break;
            case COMPONENT.CONST.STATUS.NONE:
                this.addShinkenTooltip( "shinken-success-border", "" );
                break;
        }
        this.setError( this.uuid, _counter[ 0 ] );
        this.setWarning( this.uuid, _counter[ 1 ] );
    },
    addShinkenTooltip         : function ( type, message ) {
        this.dom_element.setAttribute( 'shi-tip-type', type );
        this.dom_element.setAttribute( 'shi-tip-text', message );
        message ? SHINKEN_TOOLTIP.showTooltip( this.dom_element ) : SHINKEN_TOOLTIP.hideTooltip();
    },
    setStatus                 : function ( to_set ) {
        this.status = to_set;
        DOM.Service.setDataSet( this.dom_element, 'status', to_set );
    },
    setDataSetLink            : function ( to_set ) {
        this.dataSetLink = to_set;
        if ( this.dataSetLink ) {
            this.computeTitle();
        }
    },
    getDataSetLink            : function () {
        return this.dataSetLink;
    },
    getListElement            : function () {
        return this.list_element;
    },
    doFilter            : function ( filter ) {
        this.list_element.doFilter( filter );
    },
    doChangeFilterSelect: function () {
        switch ( this.type ) {
            case PROPERTY.CONST.TYPES.MULTI_SELECT:
            case PROPERTY.CONST.TYPES.MULTI_SELECT_BASIC:
            case PROPERTY.CONST.TYPES.SINGLE_SELECT:
            case PROPERTY.CONST.TYPES.SINGLE_SELECT_WITH_INPUT:
                break;
            case PROPERTY.CONST.TYPES.STRING_INPUT_WITH_DROPDOWN:
                this.list_element.doChangeFilterSelect();
                break;
        }
    },
    cleanFilter         : function () {
        
        this.list_element.cleanFilter();
    },
    validOrCreateTag    : function ( name_element, prop_name ) {
        var _existing = this.list_element.getListSelectElement( name_element );
        if ( _existing ) {
            return _existing;
        }
        return this.list_element.addNewElementUnknown( name_element, prop_name );
    },
    buildLinkOpenNewTab: function ( link, id ) {
        var _span_link                         = '<span class="shinken-link-icon-button"><span class="shinken-link-icon shinicon shinicon-open"></span></span>';
        this.dom_link_icon_container.innerHTML = SHINKEN.TOOLS.buildLinkDomElementDependIfAdmin( link, id, _span_link, "shinken-link" ).outerHTML;
    },
    pulsateTag: function ( name ) {
        var _existing = this.getActiveListForUser().getTagByName( name );
        if ( _existing ) {
            _existing.pulsateTag();
        }
        else if ( this.list_elements_inherited ) {
            _existing = this.list_elements_inherited.getTagByName( name );
            if ( _existing ) {
                _existing.pulsateTag();
            }
        }
    },
    hasAutoSelect                 : function () {
        return this.list_element.hasAutoSelect();
    },
    moveAutoSelectCursor          : function ( move_down ) {
        this.list_element.moveAutoSelectCursor( move_down );
    },
    validAutoSelect               : function () {
        return this.list_element.validAutoSelect();
    },
    isAllElementsSelectedDisabled : function () {
        return this.getActiveListForUser().isAllElementsSelectedDisabled();
    },
    hasInvalidElementForProduction: function () {
        return this.getActiveListForUser().hasInvalidElementForProduction();
    },
    validSelectedOrFirstElement   : function () {
        this.list_element.selectSelectedOrFirstFilteredElement();
        this.validAutoSelect();
    },
    applySiblingSettings: function ( select_comp ) {
        switch ( this.type ) {
            case PROPERTY.CONST.TYPES.SINGLE_SELECT:
            case PROPERTY.CONST.TYPES.SINGLE_SELECT_WITH_INPUT:
                var _value = select_comp.getValue();
                if ( _value ) {
                    this.simulateClickOnItem(_value);
                } else {
                    this.cleanAllItemsSelected();
                }
                break;
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.Select, SHINKEN.OBJECT.CounterInterface );
SHINKEN_LIST.Filter           = function ( dom_element, type ) {
    this.setType( type );
    this.init( dom_element );
};
SHINKEN_LIST.Filter.prototype = {
    init                   : function ( dom_element ) {
        this.dom_element = dom_element;
        this.name        = this.dom_element.dataset.name;
        this._is_active  = false;
        if ( this.dom_element.dataset.type ) {
            this.setType( this.dom_element.dataset.type );
        }
        this.initComponents();
    },
    initComponents         : function () {
        switch ( this.type ) {
            case PROPERTY.CONST.TYPES.SINGLE_SELECT:
                this.component = new COMPONENT.Select( this.dom_element, PROPERTY.CONST.TYPES.SINGLE_SELECT, false, this );
                break;
            case PROPERTY.CONST.TYPES.STRING_INPUT:
            case SHINKEN_LIST.CONST.FILTER.TYPE.INPUT_STRING_ARRAY:
                this.component = new COMPONENT.Input( this.dom_element.querySelector( ".shinken-input" ), this );
                break;
            case PROPERTY.CONST.TYPES.STRING_INPUT_WITH_DROPDOWN:
                this.component = new COMPONENT.InputWithDropDown( this.dom_element, this, true );
                this.component.addValidationRule( PROPERTY.CONST.VALIDATOR.TYPE.SELECT_INPUT_WITH_CONDITION_FOCUS, COMPONENT.CONST.FILTER.TYPES_VALIDATION.HAS_FOCUS );
                this.component.addValidationRule( PROPERTY.CONST.VALIDATOR.TYPE.SELECT_INPUT_WITH_CONDITION_NOT_FOCUS, COMPONENT.CONST.FILTER.TYPES_VALIDATION.NOT_FOCUS );
                break;
        }
    },
    setType                : function ( to_set ) {
        switch ( to_set ) {
            case SHINKEN_LIST.CONST.TYPE.CHECK_IN_HOST:
                to_set = PROPERTY.CONST.TYPES.SINGLE_SELECT;
                break;
        }
        this.type = to_set;
    },
    getUuid                : function () {
        return this.name;
    },
    isValid                : function () {
        return (this.name && this.type);
    },
    isSet                  : function () {
        this._computeState();
        return this.isActive();
    },
    getParentName          : function () {
        return this.name;
    },
    getValue               : function () {
        return this.component.getValue();
    },
    getName                : function () {
        return this.name;
    },
    getFinalValue          : function () {
        return this.component.getFinalValue();
    },
    setActive              : function ( to_set ) {
        to_set = !!to_set;
        if ( to_set ) {
            this.dom_element.classList.add( 'shinken-active' );
        }
        else {
            this.dom_element.classList.remove( 'shinken-active' );
        }
        this._is_active = to_set;
    },
    isActive               : function () {
        return !!this._is_active;
    },
    setValue               : function ( to_set ) {
        this.component.setValueFromJs( to_set );
    },
    getListElement         : function () {
        return this.component.getListElement();
    },
    getComponents          : function () {
        return [ this.component ];
    },
    initWhenInputReady     : function () {
        var self = this;
        setTimeout( function () {
            self.component.validateValueInput();
            self._computeState();
            DOM.Service.setDataSet( self.dom_element, 'inputStatus', self.component.getStatus() );
        }, 300 );
    },
    clickOnSelector        : function () {
        this.component.clickOnSelector();
    },
    clickOnItemSelector    : function ( key_name, dom_element, selector, event ) {
        this.component.clickOnItemSelector( '', key_name, event );
        this._computeState();
        this.hidePopup();
        
        switch ( this.type ) {
            case PROPERTY.CONST.TYPES.SINGLE_SELECT:
                this.component.computeTitle();
                break;
            case PROPERTY.CONST.TYPES.STRING_INPUT_WITH_DROPDOWN:
                var forced = !(key_name !== '');
                CONTROLLER.List.getFilterAndReload( forced );
                break;
        }
    },
    doChangeFilterSelect   : function () {
        this.component.doChangeFilterSelect();
    },
    askComputeAfterChange  : function ( dom_element, parent, args ) {
        this.component.askComputeAfterChange( dom_element, parent || this, args );
    },
    doActionAfterChange    : function ( args ) {
        switch ( this.type ) {
            case PROPERTY.CONST.TYPES.SINGLE_SELECT:
                return;
        }
        this.component.computeAfterChange();
        this._computeState();
        DOM.Service.setDataSet( this.dom_element, 'inputStatus', this.component.getStatus() );
        switch ( args.controller_name ) {
            case MANAGER.CONST.CONTROLLER.LIST_ALL:
                CONTROLLER.List.updateCleanButtonStatus();
                break;
        }
    },
    clickChangeFilterSelect: function () {
        this.component.clickChangeFilterSelect();
    },
    clickOnInput           : function () {
        this.component.clickOnInput();
    },
    hidePopup              : function () {
        this.setNeedValidation( true );
        this.doActionAfterChange({});
        switch ( this.type ) {
            case PROPERTY.CONST.TYPES.SINGLE_SELECT:
                this.component.hidePopup();
                break;
            case PROPERTY.CONST.TYPES.STRING_INPUT:
                break;
            case PROPERTY.CONST.TYPES.STRING_INPUT_WITH_DROPDOWN:
                this.component.hidePopup();
                break;
        }
    },
    _computeState          : function () {
        var _value = this.getValue();
        if ( _value === SHINKEN_LIST.CONST.FILTER.ALL ) {
            _value = false;
        }
        this.setActive( !!_value );
    },
    validateValueInput     : function () {
        this.component.validateValueInput();
    },
    keydown                : function ( event, key_code ) {
        switch ( key_code ) {
            case SHINKEN.CONST.KEY_CODE.ENTER:
                if ( this.component.hasAutoSelect() ) {
                    event.stopPropagation();
                    event.preventDefault();
                    this.component.validSelectedOrFirstElement();
                }
                else {
                    this.component.finishActionBeforeReload();
                    CONTROLLER.List.getFilterAndReload( true );
                }
                break;
            default:
                this.component.keydown( event, key_code );
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.Filter, SHINKEN.OBJECT.CounterInterface );
SHINKEN_LIST.Filters           = function ( dom_element, type ) {
    this.type = type;
    this.init( dom_element );
};
SHINKEN_LIST.Filters.prototype = {
    init        : function ( dom_element ) {
        this.initContents( dom_element.querySelectorAll( '.shinken-list-filter' ) );
    },
    initContents: function ( dom_elements ) {
        this.contents = {};
        var _current;
        for ( var i = 0, _size_i = dom_elements.length; i < _size_i; i++ ) {
            _current = new SHINKEN_LIST.Filter( dom_elements[ i ], this.type );
            if ( _current.isValid() ) {
                this.contents[ _current.getName() ] = _current;
            }
        }
    },
    getFilter       : function ( name ) {
        return this.contents[ name ];
    },
    getActiveFilters: function () {
        var _to_return = [];
        var _keys      = Object.keys( this.contents );
        var _current_key;
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current_key = _keys[ i ];
            if ( this.contents[ _current_key ].isSet() ) {
                _to_return.push( this.contents[ _current_key ] );
            }
        }
        return _to_return;
    },
    askComputeAfterChange: function ( dom_element, parent ) {
        var _parent_dom_element = DOM.Service.findParentElementWithDataSet( dom_element, 'name', 10 );
        var _type               = _parent_dom_element.dataset.objectType;
        switch ( _type ) {
            case 'shinken-list-filter':
                this.getFilter( _parent_dom_element.dataset.name ).askComputeAfterChange( dom_element, parent || this, { 'type': _type } );
                break;
        }
    },
    clickOnSelector      : function ( event ) {
        var _parent_dom_element = DOM.Service.findParentElementWithDataSet( event.target, 'name', 10 );
        var _type               = _parent_dom_element.dataset.objectType;
        switch ( _type ) {
            case 'shinken-list-filter':
                var _to_return = this.getFilter( _parent_dom_element.dataset.name );
                _to_return.clickOnSelector( _parent_dom_element );
                return _to_return;
        }
    },
    clickOnItemSelector  : function ( event ) {
        var _option             = DOM.Service.findParentElementWithDataSet( event.target, 'keyName', 10 );
        var _parent_dom_element = DOM.Service.findParentElementWithDataSet( event.target, 'name', 20 );
        var _type               = _parent_dom_element.dataset.objectType;
        switch ( _type ) {
            case 'shinken-list-filter':
                this.getFilter( _parent_dom_element.dataset.name ).clickOnItemSelector( _option.dataset.keyName, _parent_dom_element, false, event );
                break;
        }
    },
    hidePopup: function ( exception ) {
        var _keys = Object.keys( this.contents );
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            if ( exception !== this.contents[ _keys[ i ] ] ) {
                this.contents[ _keys[ i ] ].hidePopup();
            }
        }
    }
};
SHINKEN_LIST.Header           = function ( type, dom_element ) {
    this.type = type;
    this.init( dom_element );
};
SHINKEN_LIST.Header.prototype = {
    init: function ( dom_element ) {
        this.dom_element = dom_element;
        if ( dom_element ) {
            this.name  = dom_element.dataset.headerName;
            this.label = dom_element.innerText;
        }
    }
};
SHINKEN_LIST.Line           = function ( dom_element, type ) {
    this.type = type;
    this.init( dom_element );
};
SHINKEN_LIST.Line.prototype = {
    init          : function ( dom_element ) {
        this.dom_element = dom_element;
        this.is_filtered = this.dom_element.classList.contains( "shinken-is-filtered" ) ? SHINKEN_LIST.CONST.FILTER.STATUS.ON : SHINKEN_LIST.CONST.FILTER.STATUS.OFF;
        this.is_collapse = false;
        this.uuid        = this.dom_element.dataset.uuid;
        switch ( this.type ) {
            case SHINKEN_LIST.CONST.TYPE.CHECK_IN_HOST:
                this.host    = MANAGER.__instance_element_distributor.getElement( OBJECT.ShinkenElement.generateSEUUID( this.dom_element.dataset.typeItem, this.dom_element.dataset.uuidItem ) );
                this.parent  = MANAGER.__instance_element_distributor.getElement( OBJECT.ShinkenElement.generateSEUUID( this.dom_element.dataset.typeItem, this.dom_element.dataset.uuidParent ) );
                this.check   = MANAGER.__instance_element_distributor.getElement( OBJECT.ShinkenElement.generateSEUUID( this.dom_element.dataset.typeCheck, this.dom_element.dataset.uuidCheck ) );
                this.dfe_key = this.dom_element.dataset.dfeKey;
                break;
            case SHINKEN_LIST.CONST.TYPE.MASS_CHANGE_SUM_FULL:
                this.parent_uuid           = this.dom_element.dataset.uuidParent;
                this.parent_select_element = DOM.Service.findParentElementWithClass( this.dom_element, this.dom_element.dataset.parentSelectClass, 20 );
                break;
            case SHINKEN_LIST.CONST.TYPE.DATA_PROP:
                this.uuid = this.dom_element.dataset.name;
                break;
        }
        this.initIsSelected();
        this.initCellsValue();
    },
    initIsSelected: function () {
        if ( this.dom_element.classList.contains( "shinken-selected-disabled" ) ) {
            this.is_selected = SHINKEN_LIST.CONST.SELECTION.STATUS.DISABLED;
        }
        else if ( this.dom_element.classList.contains( "shinken-selected" ) ) {
            this.is_selected = SHINKEN_LIST.CONST.SELECTION.STATUS.ON;
        }
        else {
            this.is_selected = SHINKEN_LIST.CONST.SELECTION.STATUS.OFF;
        }
        this.is_selected_counter = new SHINKEN.OBJECT.Counter();
        switch ( this.type ) {
            case SHINKEN_LIST.CONST.TYPE.MASS_CHANGE_SUM_FULL:
                if ( !this.parent_uuid ) {
                    this.is_selected_counter.setParent( CONTROLLER.MassChange.mass_change_element_selected );
                }
                this.updateSelectionCounter();
                if ( this.is_selected === SHINKEN_LIST.CONST.SELECTION.STATUS.ON ) {
                    this.initCounters( CONTROLLER.MassChange.steps.get().button_next, true );
                }
                break;
            case SHINKEN_LIST.CONST.TYPE.CHECK_IN_HOST:
                this.is_selected_counter.setParent( CONTROLLER.MassChange.mass_change_checks_selected );
                break;
        }
    },
    initCellsValue: function () {
        this.cell_value = {};
        var _cells      = this.dom_element.querySelectorAll( ".shinken-list-cell" );
        var _current;
        for ( var i = 0, _size_i = _cells.length; i < _size_i; i++ ) {
            _current = _cells[ i ];
            if ( _current.dataset.filterValueArray ) {
                this.cell_value[ _current.dataset.filter ] = _current.dataset.filterValueArray.split( "," );
            }
            else if ( _current.dataset.filterValue ) {
                this.cell_value[ _current.dataset.filter ] = _current.dataset.filterValue;
            }
            else {
                if ( _current.dataset.filter ) {
                    this.cell_value[ _current.dataset.filter ] = DOM.Service.getInnerText( _current );
                }
                else {
                    this.cell_value[ i ] = DOM.Service.getInnerText( _current );
                }
            }
        }
        switch ( this.type ) {
            case SHINKEN_LIST.CONST.TYPE.DATA_PROP:
                this.cell_value[ 'data_name_array' ] = this.uuid;
                break;
        }
    },
    applyFilter: function ( filters ) {
        var _filter = SHINKEN_LIST.CONST.FILTER.STATUS.OFF;
        for ( var i = 0, _size_i = filters.length; i < _size_i; i++ ) {
            var _value_filter = filters[ i ].getValue();
            var _value_cell   = this.cell_value[ filters[ i ].getName() ];
            switch ( _value_cell ) {
                case SHINKEN_LIST.CONST.FILTER.HAS_CHILDREN:
                    _filter = SHINKEN_LIST.CONST.FILTER.STATUS.HAS_CHILDREN;
                    continue;
            }
            var _type_filter = filters[ i ].type;
            switch ( _type_filter ) {
                case PROPERTY.CONST.TYPES.SINGLE_SELECT:
                    if ( _value_filter === SHINKEN_LIST.CONST.FILTER.ALL ) {
                        break;
                    }
                    else if ( _value_filter === SHINKEN_LIST.CONST.FILTER.NOT_EMPTY ) {
                        if ( Array.isArray( _value_cell ) ) {
                            if ( SHINKEN.TOOLS.ARRAY.contains( _value_cell, SHINKEN_LIST.CONST.FILTER.EMPTY ) ) {
                                _filter = SHINKEN_LIST.CONST.FILTER.STATUS.ON;
                            }
                        }
                        else if ( _value_cell === SHINKEN_LIST.CONST.FILTER.EMPTY ) {
                            _filter = SHINKEN_LIST.CONST.FILTER.STATUS.ON;
                        }
                        break;
                    }
                    if ( Array.isArray( _value_cell ) ) {
                        if ( !SHINKEN.TOOLS.ARRAY.contains( _value_cell, _value_filter ) ) {
                            _filter = SHINKEN_LIST.CONST.FILTER.STATUS.ON;
                        }
                    }
                    else if ( _value_cell !== _value_filter ) {
                        _filter = SHINKEN_LIST.CONST.FILTER.STATUS.ON;
                    }
                    break;
                case PROPERTY.CONST.TYPES.STRING_INPUT:
                    if ( !SHINKEN.TOOLS.STRING.containsIgnoreCase( _value_cell, _value_filter ) ) {
                        _filter = SHINKEN_LIST.CONST.FILTER.STATUS.ON;
                    }
                    break;
                case SHINKEN_LIST.CONST.FILTER.TYPE.INPUT_STRING_ARRAY:
                    var _list  = _value_filter.split( "," );
                    var _found = false;
                    for ( var j = 0, _size_j = _list.length; j < _size_j; j++ ) {
                        if ( _list[ j ] === _value_cell ) {
                            _found = true;
                            break;
                        }
                    }
                    if ( !_found ) {
                        _filter = SHINKEN_LIST.CONST.FILTER.STATUS.ON;
                    }
                    break;
            }
        }
        this.setFilter( _filter );
    },
    setFilter  : function ( to_set ) {
        this.is_filtered = to_set;
        switch ( this.is_filtered ) {
            case SHINKEN_LIST.CONST.FILTER.STATUS.ON:
                this.dom_element.classList.add( "shinken-is-filtered" );
                break;
            case SHINKEN_LIST.CONST.FILTER.STATUS.OFF:
                this.dom_element.classList.remove( "shinken-is-filtered" );
                break;
        }
    },
    isFiltered : function () {
        return this.is_filtered === SHINKEN_LIST.CONST.FILTER.STATUS.ON;
    },
    getUUID               : function () {
        return this.uuid;
    },
    toggleSelect          : function () {
        switch ( this.is_selected ) {
            case SHINKEN_LIST.CONST.SELECTION.STATUS.ON:
                this.setIsSelected( SHINKEN_LIST.CONST.SELECTION.STATUS.OFF );
                break;
            case SHINKEN_LIST.CONST.SELECTION.STATUS.OFF:
                this.setIsSelected( SHINKEN_LIST.CONST.SELECTION.STATUS.ON );
                break;
        }
    },
    setIsSelected         : function ( to_set ) {
        if ( this.is_filtered ) {
            return;
        }
        if ( this.is_selected === SHINKEN_LIST.CONST.SELECTION.STATUS.DISABLED ) {
            return;
        }
        this.is_selected = to_set;
        this.updateSelectionCounter();
        switch ( this.is_selected ) {
            case SHINKEN_LIST.CONST.SELECTION.STATUS.ON:
                this.dom_element.classList.add( "shinken-selected" );
                if ( this.parent_select_element ) {
                    this.parent_select_element.classList.add( "shinken-selected-parent" );
                }
                break;
            case SHINKEN_LIST.CONST.SELECTION.STATUS.OFF:
                this.dom_element.classList.remove( "shinken-selected" );
                if ( this.parent_select_element ) {
                    this.parent_select_element.classList.remove( "shinken-selected-parent" );
                }
                break;
        }
        
        switch ( this.type ) {
            case SHINKEN_LIST.CONST.TYPE.MASS_CHANGE_SUM_FULL:
                switch ( this.is_selected ) {
                    case SHINKEN_LIST.CONST.SELECTION.STATUS.ON:
                        this.showCountersForParent();
                        break;
                    default:
                        this.hideCountersForParent();
                        break;
                }
        }
        
    },
    updateSelectionCounter: function () {
        switch ( this.type ) {
            case SHINKEN_LIST.CONST.TYPE.CHECK_IN_HOST:
            case SHINKEN_LIST.CONST.TYPE.MASS_CHANGE_SUM_FULL:
                this.is_selected_counter.update( this.uuid, this.isSelected() ? 1 : 0 );
                break;
        }
    },
    setDataSet            : function ( datakey, data_value, if_key, if_values, else_data_value, if_function ) {
        if ( if_key ) {
            if ( if_function === "matching_regex" ) {
                if ( !SHINKEN.TOOLS.STRING.isMatchingStarRegexTab( this.cell_value[ if_key ], if_values ) ) {
                    data_value = else_data_value;
                }
            }
            else {
                if ( !SHINKEN.TOOLS.STRING.containsAny( this.cell_value[ if_key ], if_values ) ) {
                    data_value = else_data_value;
                }
            }
        }
        DOM.Service.setDataSet( this.dom_element, datakey, data_value );
    },
    isSelected            : function () {
        return this.is_selected === SHINKEN_LIST.CONST.SELECTION.STATUS.ON;
    },
    isSelectedOrFiltered  : function () {
        if ( this.is_filtered ) {
            return SHINKEN_LIST.CONST.SELECTION.STATUS.DISABLED;
        }
        if ( this.is_selected === SHINKEN_LIST.CONST.SELECTION.STATUS.DISABLED ) {
            return SHINKEN_LIST.CONST.SELECTION.STATUS.DISABLED;
        }
        return this.is_selected;
    },
    getData               : function ( key ) {
        return this.dom_element.dataset[ key ];
    },
    getCellValue          : function ( key ) {
        return this.cell_value[ key ];
    },
    changeElementValue    : function ( key, to_set ) {
        if ( this.getCellValue( key ) !== undefined ) {
            this.dom_element.querySelector( '.shinken-list-cell[data-filter="' + key + '"]' ).innerHTML = to_set;
        }
    },
    toggleCollapse        : function ( childrens ) {
        this.setIsCollapsed( !this.is_collapse );
        for ( var i = 0, _size_i = childrens.length; i < _size_i; i++ ) {
            childrens[ i ].setIsCollapsed( this.is_collapse );
        }
    },
    setIsCollapsed        : function ( to_set, childrens ) {
        this.is_collapse = to_set;
        if ( this.is_collapse ) {
            this.dom_element.classList.add( "shinken-collapsed" );
        }
        else {
            this.dom_element.classList.remove( "shinken-collapsed" );
        }
        if ( childrens ) {
            for ( var i = 0, _size_i = childrens.length; i < _size_i; i++ ) {
                childrens[ i ].setIsCollapsed( this.is_collapse );
            }
        }
    },
    getDataToSave  : function ( type ) {
        var _to_return;
        switch ( this.type ) {
            case SHINKEN_LIST.CONST.TYPE.CHECK_IN_HOST:
                switch ( type ) {
                    case CONTROLLER.CONST.MASS_CHANGE.TYPE.CHECKS_EXCLUDE:
                        _to_return       = {};
                        _to_return.value = this.isSelected() ? true : false;
                        if ( this.dom_element.dataset.originalSelected === "1" ) {
                            _to_return.value = !_to_return.value;
                        }
                        _to_return.check_link = this.check.getDataToSave( OBJECT.CONST.ELEMENT.SAVE.TYPE.LINK );
                        break;
                    default:
                        _to_return      = [];
                        _to_return[ 0 ] = this.host.getDataToSave( OBJECT.CONST.ELEMENT.SAVE.TYPE.LINK );
                        _to_return[ 1 ] = this.parent.getDataToSave( OBJECT.CONST.ELEMENT.SAVE.TYPE.LINK );
                        _to_return[ 2 ] = this.check.getDataToSave( OBJECT.CONST.ELEMENT.SAVE.TYPE.LINK );
                        _to_return[ 3 ] = this.dfe_key;
                        break;
                }
            
        }
        return _to_return;
    },
    getDataToExport: function ( headers ) {
        var _to_return = [];
        var _current;
        for ( var i = 0, _size_i = headers.length; i < _size_i; i++ ) {
            _to_return.push( this.getCellValue( headers[ i ] ) || "" );
        }
        return _to_return;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.Line, SHINKEN.OBJECT.CounterInterface );
SHINKEN_LIST.FACTORY_HTML.Line = function ( uuid, line_data, headers ) {
    var _to_return = DOM.Service.createElement( "tr", { class: "shinken-list-line", "data-uuid": uuid } );
    for ( var i = 0, _size_i = line_data.length; i < _size_i; i++ ) {
        DOM.Service.addElementTo( DOM.Service.createElement( "td", { class: "shinken-list-cell", "data-filter": headers[ i ].name }, line_data[ i ] ), _to_return );
    }
    return _to_return;
};
SHINKEN_LIST.Lines           = function ( dom_element, type ) {
    this.type = type;
    this.init( dom_element );
};
SHINKEN_LIST.Lines.prototype = {
    init               : function ( dom_element ) {
        this.initContents( dom_element.querySelectorAll( '.shinken-list-line' ) );
    },
    initContents       : function ( dom_elements ) {
        this.contents        = [];
        this.mapping         = {};
        this.mapping_parents = {};
        for ( var i = 0, _size_i = dom_elements.length; i < _size_i; i++ ) {
            this.add( dom_elements[ i ] );
        }
    },
    addMappingParent   : function ( parent_uuid, uuid ) {
        if ( !parent_uuid ) {
            if ( !this.mapping_parents[ uuid ] ) {
                this.mapping_parents[ uuid ] = [];
            }
        }
        else {
            if ( !this.mapping_parents[ parent_uuid ] ) {
                this.mapping_parents[ parent_uuid ] = [];
            }
            this.mapping_parents[ parent_uuid ].push( this.mapping[ uuid ] );
        }
    },
    removeMappingParent: function ( parent_uuid, _to_remove ) {
        if ( parent_uuid ) {
            SHINKEN.TOOLS.ARRAY.removeElement( this.mapping_parents[ parent_uuid ], _to_remove );
        }
    },
    add                : function ( dom_element ) {
        var _to_add = new SHINKEN_LIST.Line( dom_element, this.type );
        this.contents.push( _to_add );
        this.mapping[ _to_add.getUUID() ] = _to_add;
        this.addMappingParent( _to_add.parent_uuid, _to_add.uuid );
    },
    remove             : function ( uuid ) {
        var _to_remove = this.mapping[ uuid ];
        delete this.mapping[ uuid ];
        this.removeMappingParent( _to_remove.parent_uuid, _to_remove );
        SHINKEN.TOOLS.ARRAY.removeElement( this.contents, _to_remove );
    },
    getByUUID          : function ( uuid ) {
        return this.mapping[ uuid ];
    },
    toggleCollapse      : function ( uuid ) {
        this.mapping[ uuid ].toggleCollapse( this.mapping_parents[ uuid ] );
    },
    setIsCollapseAllData: function ( to_set ) {
        var _keys = Object.keys( this.mapping_parents );
        var _current_key;
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current_key = _keys[ i ];
            this.mapping[ _current_key ].setIsCollapsed( to_set, this.mapping_parents[ _current_key ] );
        }
    },
    setSelectAllData       : function ( to_set ) {
        for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            this.contents[ i ].setIsSelected( to_set );
        }
    },
    getNbSelected          : function () {
        return this.getSelected().length;
    },
    getSelected            : function () {
        var _to_return = [];
        for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            if ( this.contents[ i ].isSelected() ) {
                _to_return.push( this.contents[ i ] );
            }
        }
        return _to_return;
    },
    getNotSelected         : function () {
        var _to_return = [];
        for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            if ( this.contents[ i ].is_selected !== SHINKEN_LIST.CONST.SELECTION.STATUS.ON ) {
                _to_return.push( this.contents[ i ] );
            }
        }
        return _to_return;
    },
    setAllLinesDataSet     : function ( datakey, data_value, if_key, if_values, else_data_value, if_function ) {
        for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            this.contents[ i ].setDataSet( datakey, data_value, if_key, if_values, else_data_value, if_function );
        }
    },
    isAllActiveLineSelected: function () {
        var _nb_active = 0;
        var _current;
        for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            _current = this.contents[ i ].isSelectedOrFiltered();
            switch ( _current ) {
                case SHINKEN_LIST.CONST.SELECTION.STATUS.ON:
                    _nb_active++;
                    break;
                case SHINKEN_LIST.CONST.SELECTION.STATUS.OFF:
                    return false;
            }
        }
        return !!_nb_active;
    },
    applyFilter               : function ( filters ) {
        for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            this.contents[ i ].applyFilter( filters );
        }
        switch ( this.type ) {
            case SHINKEN_LIST.CONST.TYPE.MASS_CHANGE_SUM_FULL:
                this.filterParentWithNoChildren();
                break;
        }
    },
    filterParentWithNoChildren: function () {
        var _current;
        var _filter;
        for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            _current = this.contents[ i ];
            if ( _current.is_filtered !== SHINKEN_LIST.CONST.FILTER.STATUS.HAS_CHILDREN ) {
                continue;
            }
            if ( _current.parent_uuid ) {
                continue;
            }
            _filter = SHINKEN_LIST.CONST.FILTER.STATUS.ON;
            for ( var j = 0, _size_j = this.contents.length; j < _size_j; j++ ) {
                if ( this.contents[ j ].parent_uuid === _current.getUUID() && this.contents[ j ].is_filtered === SHINKEN_LIST.CONST.FILTER.STATUS.OFF ) {
                    _filter = SHINKEN_LIST.CONST.FILTER.STATUS.OFF;
                    break;
                }
            }
            _current.setFilter( _filter );
        }
    },
    hideAllLines              : function () {
        for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            this.contents[ i ].setFilter( SHINKEN_LIST.CONST.FILTER.STATUS.ON );
        }
    },
    getNotFiltered            : function () {
        var _to_return = [];
        for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            if ( !this.contents[ i ].isFiltered() ) {
                _to_return.push( this.contents[ i ] );
            }
        }
        return _to_return;
    },
    getDataToSave  : function ( type ) {
        var _to_return = type === CONTROLLER.CONST.MASS_CHANGE.TYPE.CHECKS_EXCLUDE ? {} : [];
        var _current;
        var _current_data;
        for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            _current = this.contents[ i ];
            if ( _current.isSelected() ) {
                switch ( this.type ) {
                    case SHINKEN_LIST.CONST.TYPE.CHECK_IN_HOST:
                        switch ( type ) {
                            case CONTROLLER.CONST.MASS_CHANGE.TYPE.CHECKS_EXCLUDE:
                                _current_data = _current.getDataToSave( type );
                                if ( !_to_return[ _current.host.getUUID() ] ) {
                                    _to_return[ _current.host.getUUID() ] = [];
                                }
                                _to_return[ _current.host.getUUID() ].push( _current_data );
                                break;
                            
                            default:
                                _to_return.push( _current.getDataToSave( type ) );
                                break;
                        }
                        break;
                    default:
                        _to_return.push( _current.getDataToSave( type ) );
                        break;
                }
            }
        }
        return _to_return;
    },
    getDataToExport: function ( headers ) {
        var _to_return = [];
        var _to_add;
        var _current;
        var _current_data;
        for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            _current = this.contents[ i ];
            if ( _current.is_filtered ) {
                continue;
            }
            _to_return.push( _current.getDataToExport( headers ) );
        }
        return _to_return;
    }
};
SHINKEN_LIST.Set           = function ( dom_element, type ) {
    this.type = type;
    this.init( dom_element );
    this.edit_mode        = false;
};
SHINKEN_LIST.Set.prototype = {
    init               : function ( dom_element ) {
        this.dom_element = dom_element;
        this.initHeaders( this.dom_element.querySelectorAll( '.shinken-list-header' ) );
        this.filters               = new SHINKEN_LIST.Filters( dom_element, this.type );
        this.lines                 = new SHINKEN_LIST.Lines( dom_element, this.type );
        this.is_all_data_selected  = this.dom_element.classList.contains( "shinken-selected" ) ? SHINKEN_LIST.CONST.SELECTION.STATUS.ON : SHINKEN_LIST.CONST.SELECTION.STATUS.OFF;
        this.is_all_data_collapsed = false;
        this.updateHtml();
    },
    initHeaders          : function ( dom_elements ) {
        this.headers     = [];
        for ( var i = 0, _size_i = dom_elements.length; i < _size_i; i++ ) {
            this.headers[ i ] = new SHINKEN_LIST.Header( this.type, dom_elements[ i ] );
        }
    },
    askComputeAfterChange: function ( dom_element ) {
        this.filters.askComputeAfterChange( dom_element, this );
    },
    doActionAfterChange  : function ( args ) {
        var _type = args[ 'type' ];
        switch ( _type ) {
            case 'shinken-list-filter':
                this.lines.applyFilter( this.filters.getActiveFilters() );
                this.setSelectAllStatus();
                break;
            case 'shinken-hide-all-element':
                this.lines.hideAllLines();
                break;
        }
    },
    clickOnCheckboxInput : function ( name ) {
        if ( name === "shinken-all-elements" ) {
            this.selectAllData( this.is_all_data_selected === SHINKEN_LIST.CONST.SELECTION.STATUS.ON ? SHINKEN_LIST.CONST.SELECTION.STATUS.OFF : SHINKEN_LIST.CONST.SELECTION.STATUS.ON );
            return;
        }
        this.lines.mapping[ name ].toggleSelect();
        this.setSelectAllStatus();
    },
    clickOnCollapseButton: function ( uuid ) {
        if ( uuid === "shinken-all-elements" ) {
            this.collapseAllData( !this.is_all_data_collapsed );
            return;
        }
        this.setIsCollapseAllData( false );
        this.lines.toggleCollapse( uuid );
    },
    clickOnSelector      : function ( event ) {
        var _filter = this.filters.clickOnSelector( event );
        this.hidePopup( _filter );
    },
    clickOnItemSelector  : function ( event ) {
        this.filters.clickOnItemSelector( event );
        var _parent_dom_element = DOM.Service.findParentElementWithDataSet( event.target, 'name', 20 );
        this.doActionAfterChange( { 'type': _parent_dom_element.dataset.objectType } );
    },
    setIsCollapseAllData: function ( to_set ) {
        this.is_all_data_collapsed = to_set;
        if ( this.is_all_data_collapsed ) {
            this.dom_element.classList.add( "shinken-collapsed" );
        }
        else {
            this.dom_element.classList.remove( "shinken-collapsed" );
        }
    },
    collapseAllData     : function ( to_set ) {
        this.setIsCollapseAllData( to_set );
        this.lines.setIsCollapseAllData( this.is_all_data_collapsed );
    },
    setSelectAllStatus  : function ( to_set ) {
        if ( to_set === undefined ) {
            to_set = this.lines.isAllActiveLineSelected() ? SHINKEN_LIST.CONST.SELECTION.STATUS.ON : SHINKEN_LIST.CONST.SELECTION.STATUS.OFF;
        }
        this.is_all_data_selected = to_set;
        if ( this.is_all_data_selected === SHINKEN_LIST.CONST.SELECTION.STATUS.ON ) {
            this.dom_element.classList.add( "shinken-selected" );
        }
        else {
            this.dom_element.classList.remove( "shinken-selected" );
        }
    },
    selectAllData       : function ( to_set ) {
        this.setSelectAllStatus( to_set );
        this.lines.setSelectAllData( this.is_all_data_selected );
    },
    getSelectedLines    : function () {
        return this.lines.getSelected();
    },
    getFirstSelectedLine: function () {
        var _to_return = this.getSelectedLines();
        if ( _to_return.length ) {
            return _to_return[ 0 ];
        }
        return null;
    },
    getNotSelectedLines : function () {
        return this.lines.getNotSelected();
    },
    setAllLinesDataSet  : function ( datakey, data_value, if_key, if_values, else_data_value, if_function ) {
        return this.lines.setAllLinesDataSet( datakey, data_value, if_key, if_values, else_data_value, if_function );
    },
    addLine             : function ( dom_element ) {
        this.lines.add( dom_element );
        this.updateHtml();
    },
    removeLine          : function ( uuid ) {
        this.lines.remove( uuid );
        this.updateHtml();
    },
    getLineByUUID       : function ( uuid ) {
        return this.lines.getByUUID( uuid );
    },
    getSum              : function ( header_name ) {
        var _to_return = 0;
        var _lines     = this.lines.getNotFiltered();
        for ( var i = 0, _size_i = _lines.length; i < _size_i; i++ ) {
            _to_return += parseInt( _lines[ i ].getCellValue( header_name ) || 0 );
        }
        return _to_return;
    },
    getSumBy            : function ( header_name, header_value ) {
        var _to_return = {};
        var _lines     = this.lines.getNotFiltered();
        var _current;
        for ( var i = 0, _size_i = _lines.length; i < _size_i; i++ ) {
            _current = _lines[ i ].getCellValue( header_name );
            if ( !_to_return[ _current ] ) {
                _to_return[ _current ] = 0;
            }
            _to_return[ _current ] += parseInt( _lines[ i ].getCellValue( header_value ) || 0 );
        }
        return _to_return;
    },
    toggleEditionMode   : function () {
        this.edit_mode = !this.edit_mode;
        this.selectAllData( this.edit_mode ? SHINKEN_LIST.CONST.SELECTION.STATUS.ON : SHINKEN_LIST.CONST.SELECTION.STATUS.OFF );
    },
    
    hidePopup: function ( _filter ) {
        this.filters.hidePopup( _filter );
    },
    updateHtml: function () {
        DOM.Service.setDataSet( this.dom_element, "numberLines", this.lines.contents.length );
    },
    getDataToSave  : function ( type ) {
        return this.lines.getDataToSave( type );
    },
    getDataToExport: function () {
        var _to_return     = [];
        var _headers_name  = [];
        var _headers_label = [];
        for ( var i = 0, _size_i = this.headers.length; i < _size_i; i++ ) {
            _headers_name.push( this.headers[ i ].name );
            _headers_label.push( this.headers[ i ].label );
        }
        _to_return.push( _headers_label );
        return SHINKEN.TOOLS.ARRAY.concat( _to_return, this.lines.getDataToExport( _headers_name ) );
    }
};
MANAGER.DistributorControllerManager = (function ( self ) {
    "use strict";
    self.findControllerByEvent     = function ( event, controller_name ) {
        var _controller_name = controller_name || self.findControllerName(event);
        if ( !_controller_name ) {
            return;
        }
        return MANAGER.DistributorControllerManager.getController( _controller_name );
    };
    self.findControllerName = function ( event, dom_element ) {
        if ( !event && !dom_element) {
            return;
        }
        var _target             = dom_element || event.target;
        var _parent_dom_element = DOM.Service.findParentElementWithClass( _target, "shinken-parent-event-listener", 500 );
        if ( !_parent_dom_element ) {
            return;
        }
        return _parent_dom_element.dataset.controller;
    };
    self.getController             = function ( _controller ) {
        switch ( _controller ) {
            case MANAGER.CONST.CONTROLLER.MASS_CHANGE:
                return CONTROLLER.MassChange;
            case MANAGER.CONST.CONTROLLER.LIST_ALL:
                return CONTROLLER.List;
            case MANAGER.CONST.CONTROLLER.SHINKEN_ELEMENT:
                return CONTROLLER.ShinkenElement;
            case MANAGER.CONST.CONTROLLER.SOURCES:
                return CONTROLLER.Source;
            case MANAGER.CONST.CONTROLLER.MAIN:
                return CONTROLLER.Main;
            case MANAGER.CONST.CONTROLLER.WEATHER:
                return CONTROLLER.Weather;
            case MANAGER.CONST.CONTROLLER.COMMON_UI:
                return CONTROLLER.CommonUI;
            case "SHINKEN-TODO":
                break;
            default:
                console.warn( "NO CONTROLLER FOUND FOR ", "[" + _controller + "]" );
        }
    };
    return self;
})( MANAGER.DistributorControllerManager || {} );
MANAGER.DistributorElementManager           = function () {
    this.elements        = {};
    this.mapping_by_name = {};
};
MANAGER.DistributorElementManager.prototype = {
    createElement                 : function ( data ) {
        var _to_return = new SHINKEN.OBJECT.ShinkenElement();
        _to_return.updateData( data );
        this.addElement( _to_return );
        return _to_return;
    },
    findElement                   : function ( uuid, data ) {
        if ( !uuid ) {
            return;
        }
        var _to_return = this.getElement( uuid );
        if ( !_to_return ) {
            _to_return = this.createElement( data );
        }
        else {
            _to_return.updateData( data );
        }
        return _to_return;
    },
    getElement                    : function ( uuid ) {
        return this.elements[ uuid ];
    },
    addElement                    : function ( element ) {
        this.elements[ element.getUUID() ]      = element;
        this.mapping_by_name[ element.getName() ] = element.getUUID();
    },
};
MANAGER.__instance_element_distributor      = new MANAGER.DistributorElementManager();
MANAGER.DistributorObjectManager           = function () {
    this.objects = {};
};
MANAGER.DistributorObjectManager.prototype = {
    addObject : function ( _id, object ) {
        this.objects[ _id ] = object;
    },
    findObject: function ( _id ) {
        return this.objects[ _id ];
    },
    reset     : function () {
        this.objects = {};
    }
};
MANAGER.__instance_object_distributor      = new MANAGER.DistributorObjectManager();
MANAGER.DistributorWindowManager           = function () {
    this.windows        = {};
    this.parent_windows = {};
};
MANAGER.DistributorWindowManager.prototype = {
    createWindow                      : function ( name, is_menu, has_properties ) {
        var _id          = WINDOW.CONST.ID.WINDOW_TAB + name;
        var _dom_element = document.getElementById( _id );
        if ( !_dom_element ) {
            return;
        }
        var _to_return = has_properties ? new WINDOW.ElementWithProperties( name, _dom_element, is_menu ) : new WINDOW.Element( name, _dom_element, is_menu );
        this.setWindow( name, _to_return );
        MANAGER.__instance_object_distributor.addObject( _to_return.getID(), _to_return );
        return _to_return;
    },
    createParentWindow                : function ( name ) {
        var _to_return = new WINDOW.ElementGroup( name );
        this.setParentWindow( name, _to_return );
        return _to_return;
    },
    findWindow                        : function ( name, is_menu, parent_id, has_properties ) {
        if ( !name ) {
            return;
        }
        if ( parent_id ) {
            var _parent = this.findParentWindow( parent_id );
            if ( _parent ) {
                return _parent.getElementByName( name );
            }
        }
        var _to_return = this.getWindow( name );
        if ( !_to_return ) {
            _to_return = this.createWindow( name, is_menu, has_properties );
        }
        return _to_return;
    },
    findParentWindow                  : function ( name ) {
        if ( !name ) {
            return;
        }
        var _to_return = this.getParentWindow( name );
        if ( !_to_return ) {
            _to_return = this.createParentWindow( name );
        }
        return _to_return;
    },
    setWindow                         : function ( name, window ) {
        this.windows[ name ] = window;
    },
    setParentWindow                   : function ( name, parent_window ) {
        this.parent_windows[ name ] = parent_window;
    },
    getWindow                         : function ( name ) {
        return this.windows[ name ];
    },
    clickOnFirstWindowInParentWithName: function ( name ) { //FOR DOCUMENTATION
        var _keys = Object.keys( this.parent_windows );
        this.parent_windows[ _keys[ 0 ] ].clickOnWindow( name );
    },
    getParentWindow                   : function ( name ) {
        return this.parent_windows[ name ];
    },
    reset                             : function () {
        this.windows        = {};
        this.parent_windows = {};
    }
};
MANAGER.__instance_window_distributor      = new MANAGER.DistributorWindowManager();
MANAGER.DragNDropManager = (function ( self ) {
    "use strict";
    self.last_element_hovered    = null;
    self.current_parent_name     = null;
    self.type_drag_start         = null;
    self.list_element            = null;
    self.single_element_drag     = null;
    self.options                 = null;
    self._name_origin_controller = null;
    
    self.dragStartSingle           = function ( event ) {
        self.single_element_drag = DOM.Service.findParentElementByClassWithClassExcluded( event.target, "shinken-draggable", 'shinken-drag-exclude', 50 );
        if ( !self.single_element_drag ) {
            return;
        }
        self.single_element_drag.classList.add( "shinken-drag-active" );
        self._bounding_origin = self.single_element_drag.getBoundingClientRect();
        self._mouse_x_origin  = parseInt( event.clientX );
        self._mouse_y_origin  = parseInt( event.clientY );
        var _body = document.querySelector( 'body' );
        _body.classList.add( "shinken-has-drag-in-progress" );
        _body.addEventListener( 'mouseleave', self.dragEndSingle, false );
        document.documentElement.addEventListener( 'mousemove', self.dragSingle, false );
        document.documentElement.addEventListener( 'mouseup', self.dragEndSingle, false );
        self._initParametersIsInWindow();
        self._callbackDragStart();
        event.stopPropagation();
    };
    self.dragSingle                = function ( event ) {
        var _delta_x = parseInt( event.clientX ) - self._mouse_x_origin + self._bounding_origin.left;
        var _delta_y = parseInt( event.clientY ) - self._mouse_y_origin + self._bounding_origin.top;
        
        if ( self.options._is_in_screen ) {
            var _result = self._computeIsInScreen( _delta_x, _delta_y );
            _delta_x    = _result.x;
            _delta_y    = _result.y;
        }
        DOM.Service.setStyles( self.single_element_drag, { "top": _delta_y + 'px', "left": _delta_x + 'px' } );
        self._callbackDragMove();
    };
    self.dragEndSingle             = function () {
        document.documentElement.removeEventListener( 'mousemove', self.dragSingle, false );
        document.documentElement.removeEventListener( 'mouseup', self.dragEndSingle, false );
        var _body = document.querySelector( 'body' );
        _body.removeEventListener( 'mouseleave', self.dragEndSingle, false );
        document.querySelector( 'body' ).classList.remove( "shinken-has-drag-in-progress" );
        self.single_element_drag.classList.remove( "shinken-drag-active" );
        self._callbackDragStop();
        self.single_element_drag     = null;
        self._name_origin_controller = null;
    };
    self.dragStartShinken          = function ( e, type, parent_name, key_name ) {
        var _object = MANAGER.__instance_property_distributor.findElement( parent_name, true );
        if ( _object.is_disabled ) {
            return false;
        }
        e.dataTransfer.setData( 'text', 'anything' );
        self.type_drag_start      = type;
        self.current_parent_name  = parent_name;
        self.list_element         = _object.dragStartShinken( type, key_name );
        self.last_element_hovered = self.list_element.getDragged().getDomElement().parentNode;
        self.last_index           = self.last_element_hovered.dataset.index;
        self.last_element_hovered.classList.add( MANAGER.CONST.DRAG_N_DROP.CLASS.HOVER );
        
        var _list_droppable = _object.dom_element.querySelectorAll( '.droppable' );
        for ( var i = 0, _size_i = _list_droppable.length; i < _size_i; i++ ) {
            _list_droppable[ i ].style.width = _list_droppable[ i ].getBoundingClientRect().width + 'px';
        }
    };
    self.dragOverShinken           = function ( e, type, parent_name, dom_element ) {
        e.preventDefault();
        if ( self.current_parent_name !== parent_name ) {
            return false;
        }
        if ( self.type_drag_start !== type ) {
            return false;
        }
        var _current_index_hovered = dom_element.dataset.index;
        if ( _current_index_hovered === self.last_index ) {
            return false;
        }
        
        self.list_element.changeElementPosition( self.last_index, _current_index_hovered );
        self.last_index = _current_index_hovered;
        self.last_element_hovered.classList.remove( MANAGER.CONST.DRAG_N_DROP.CLASS.HOVER );
        self.last_element_hovered = dom_element;
        self.last_element_hovered.classList.add( MANAGER.CONST.DRAG_N_DROP.CLASS.HOVER );
    };
    self.dragEndShinken            = function ( e, type ) {
        var _list_droppable = MANAGER.__instance_property_distributor.last_element_focus.dom_element.querySelectorAll( '.droppable' );
        for ( var i = 0, _size_i = _list_droppable.length; i < _size_i; i++ ) {
            _list_droppable[ i ].style.width = '';
        }
        
        if ( MANAGER.__instance_property_distributor.last_element_focus.is_disabled ) {
            return false;
        }
        e.preventDefault();
        MANAGER.__instance_property_distributor.last_element_focus.resetDragging();
        
        if ( self.last_element_hovered ) {
            self.last_element_hovered.classList.remove( MANAGER.CONST.DRAG_N_DROP.CLASS.HOVER );
        }
        self.last_element_hovered = null;
        self.current_parent_name  = null;
        self.type_drag_start      = null;
        self.list_element         = null;
        self.pause_timeout        = null;
    };
    self.dropShinken               = function ( e, type, parent_name, dom_element ) {
        e.preventDefault();
    };
    self._computeIsInScreen        = function ( _delta_x, _delta_y ) {
        var _to_return = { x: _delta_x, y: _delta_y };
        if ( _delta_x < 0 ) {
            _to_return.x = 0;
        }
        else if ( (_delta_x + self._bounding_origin.width) > self.options._is_in_screen.parameters.window_width ) {
            _to_return.x = self.options._is_in_screen.parameters.window_width - self._bounding_origin.width - self.options._is_in_screen.parameters.scrollbar_x_width;
        }
        
        if ( _delta_y < 0 ) {
            _to_return.y = 0;
        }
        else if ( (_delta_y + self._bounding_origin.height) > self.options._is_in_screen.parameters.window_height ) {
            _to_return.y = self.options._is_in_screen.parameters.window_height - self._bounding_origin.height - self.options._is_in_screen.parameters.scrollbar_y_height;
        }
        return _to_return;
    };
    self._initParametersIsInWindow = function () {
        self.options = {
            _is_in_screen: {
                is_active : false,
                parameters: {}
            }
        };
        if ( !self.single_element_drag ) {
            return;
        }
        if ( !DOM.Service.hasKeyInDataSet( self.single_element_drag, 'dragIsInScreen' ) ) {
            return;
        }
        self.options._is_in_screen.is_active = true;
        
        var _body                             = document.querySelector( 'body' );
        self.options._is_in_screen.parameters = {
            window_width      : window.innerWidth,
            window_height     : window.innerHeight,
            scrollbar_x_width : DOM.Service.scrollbarIsVisible( _body, 'width' ) ? 17 : 0,
            scrollbar_y_height: DOM.Service.scrollbarIsVisible( _body, 'height' ) ? 17 : 0
        };
    };
    self._getDragNameForCallback   = function () {
        var _name = self.single_element_drag.dataset[ 'dragResizeElementName' ];
        if ( _name ) {
            return _name;
        }
    };
    self._callbackDragStart        = function () {
        if ( MANAGER && MANAGER.DistributorControllerManager ) {
            self._name_origin_controller = MANAGER.DistributorControllerManager.findControllerName( "", self.single_element_drag );
        }
        if ( MANAGER && MANAGER.EventManager && self._name_origin_controller ) {
            MANAGER.EventManager.onDragStart( self._name_origin_controller, self._getDragNameForCallback() );
        }
    };
    self._callbackDragMove         = function () {
        if ( MANAGER && MANAGER.EventManager && self._name_origin_controller ) {
            MANAGER.EventManager.onDragMove( self._name_origin_controller, self._getDragNameForCallback() );
        }
    };
    self._callbackDragStop         = function () {
        if ( MANAGER && MANAGER.EventManager && self._name_origin_controller ) {
            MANAGER.EventManager.onDragStop( self._name_origin_controller, self._getDragNameForCallback() );
        }
    };
    return self;
})
( MANAGER.DragNDropManager || {} );
MANAGER.EventManager = {
    last_element_hovered: null,
    stop_propagation    : false,
    mouse_down_target   : null,
    mouse_on_target     : null,
    openIframeModal      : function ( url, id ) {
        MANAGER.__instance_window_modal_manager.setIframe( url, id );
    },
    closeModal           : function () {
        MANAGER.__instance_window_modal_manager.close();
    },
    closeNotify          : function ( notify_id ) {
        MANAGER.__instance_notify_manager.close( notify_id );
    },
    clickOnToggleCollapse: function ( dom_element ) {
        var _parent_dom_element = DOM.Service.findParentElementWithClass( dom_element, "shinken-toggle-parent", 25 );
        if ( !_parent_dom_element ) {
            return;
        }
        _parent_dom_element.classList.toggle( "shinken-collapsed" );
    },
    logout: function () {
        window.location = '/logout';
        sessionStorage.removeItem( "user_id" );
    },
    onFocus        : function ( dom_element ) {
        var _parent_dom_element = DOM.Service.findParentElementWithClass( dom_element, PROPERTY.CONST.CLASS.SKINKEN_LINE, 25 );
        var parent_name         = _parent_dom_element.dataset.name;
        var _object             = MANAGER.__instance_property_distributor.findElement( parent_name, true );
        _object.onFocus();
    },
    onFocusOut     : function ( event ) {
        var _controller = MANAGER.DistributorControllerManager.findControllerByEvent( event );
        _controller.onFocusOut( event );
    },
    stopPropagation: function ( event ) {
        if ( event ) {
            event.stopPropagation();
        }
        else {
            this.stop_propagation = true;
            var self              = this;
            setTimeout( function () {
                self.stop_propagation = false;
            }, 50 );
        }
    },
    clickOnRadioBtn: function ( event ) {
        var _controller = MANAGER.DistributorControllerManager.findControllerByEvent( event );
        _controller.clickOnRadioBtn( event );
    },
    clickOnButton  : function ( event, event_name, param ) {
        var _controller = MANAGER.DistributorControllerManager.findControllerByEvent( event );
        if ( !_controller ){
            console.warn("[EventManager - clickOnButton]", "Controller not found", event.target );
            return;
        }
        if ( !event_name ) {
            var _parent_dom_element = DOM.Service.findParentElementWithDataSet( event.target, 'name', 50 );
            if ( !_parent_dom_element ) {
                console.warn("[EventManager - clickOnButton]", "not element with data set 'name' found", event.target );
                return;
            }
            event_name = _parent_dom_element.dataset.name;
        }
        _controller.clickOnButton( event, event_name, param );
    },
    focusOnAnchor  : function ( event, uuid ) {
        var _controller = MANAGER.DistributorControllerManager.findControllerByEvent( event );
        _controller.focusOnAnchor( uuid );
    },
    onKeyUp        : function ( event ) {
        var _controller = MANAGER.DistributorControllerManager.findControllerByEvent( event );
        _controller.onKeyUp( event );
    },
    onKeyDown      : function ( event ) {
        var _controller = MANAGER.DistributorControllerManager.findControllerByEvent( event );
        _controller.onKeyDown( event );
    },
    onPaste        : function ( event ) {
        var _controller = MANAGER.DistributorControllerManager.findControllerByEvent( event );
        _controller.onPaste( event );
    },
    onDragStart: function ( _controller_name, element_name ) {
        var _controller = MANAGER.DistributorControllerManager.getController( _controller_name );
        if ( _controller ) {
            _controller.onDragStart( element_name );
        }
    },
    onDragMove : function ( _controller_name, element_name ) {
        var _controller = MANAGER.DistributorControllerManager.getController( _controller_name );
        if ( _controller ) {
            _controller.onDragMove( element_name );
        }
    },
    onDragStop : function ( _controller_name, element_name ) {
        var _controller = MANAGER.DistributorControllerManager.getController( _controller_name );
        if ( _controller ) {
            _controller.onDragStop( element_name );
        }
    },
    onResizeStart: function ( _controller_name, element_name ) {
        var _controller = MANAGER.DistributorControllerManager.getController( _controller_name );
        if ( _controller ) {
            _controller.onResizeStart( element_name );
        }
    },
    onResizeMove : function ( _controller_name, element_name ) {
        var _controller = MANAGER.DistributorControllerManager.getController( _controller_name );
        if ( _controller ) {
            _controller.onResizeMove( element_name );
        }
    },
    onResizeStop : function ( _controller_name, element_name ) {
        var _controller = MANAGER.DistributorControllerManager.getController( _controller_name );
        if ( _controller ) {
            _controller.onResizeStop( element_name );
        }
    },
    onChangeOnInputKey           : function ( event ) {
        var _parent_dom_element = DOM.Service.findParentElementWithClass( event.target, PROPERTY.CONST.CLASS.SKINKEN_LINE, 25 );
        var parent_name         = _parent_dom_element.dataset.name;
        var _object             = MANAGER.__instance_property_distributor.findElement( parent_name, true );
        _object.askComputeKeyAfterChange( event.target );
    },
    clickOnAddNewLocalMacro      : function () {
        return App.Elements.DataTab.addNewData();
    },
    clickOnDeletePropertyBtn     : function ( dom_element ) {
        var _parent_dom_element = DOM.Service.findParentElementWithClass( dom_element, PROPERTY.CONST.CLASS.SKINKEN_LINE, 25 );
        var _name               = _parent_dom_element.dataset.name;
        var _object             = MANAGER.__instance_property_distributor.findElement( _name );
        _object.delete();
    },
    clickDataCollapseButtonGlobal: function () {
        App.Elements.DataTab.toggleCollapseButtonGlobal();
    },
    clickDataCollapseButton      : function ( dom_element ) {
        App.Elements.DataTab.toggleCollapseButton( dom_element );
    },
    goToDataView           : function ( data_name ) {
        MANAGER.EventManager.clickOnWindowNavigation( null, MANAGER.__instance_element_distributor.current_element.uuid, true, WINDOW.CONST.ELEMENT.DATAS );
        var _prop = MANAGER.__instance_property_distributor.getDataWithName( data_name );
        if ( _prop && _prop.group_data ) {
            MANAGER.EventManager.clickOnDataNavigation( _prop.group_data.uuid );
        }
    },
    clickOnDataNavigation  : function ( group_uuid ) {
        App.Elements.DataTab.clickOnDataNavigation( group_uuid );
    },
    clickOnWindowNavigation: function ( event, name, update_url, window_name ) {
        if ( !window_name ) {
            var _nav_tab = DOM.Service.findParentElementWithClass( event.target, WINDOW.CONST.CLASS.WINDOW_TAB, 10 );
            if ( !_nav_tab ) {
                return;
            }
            window_name = _nav_tab.dataset.name;
        }
        var _parent_window = MANAGER.__instance_window_distributor.findParentWindow( name );
        
        _parent_window.clickOnWindow( window_name );
        if ( update_url ) {
            SHINKEN.HIGHWAY.goToElementTab( window_name );
        }
        
        var _controller = MANAGER.DistributorControllerManager.findControllerByEvent( event );
        if ( _controller ) {
            _controller.computeSizes();
        }
    },
    clickOnCheckboxInput: function ( event ) {
        var _controller = MANAGER.DistributorControllerManager.findControllerByEvent( event );
        _controller.clickOnCheckboxInput( event );
    },
    onChangeOnInput: function ( event ) {
        var _controller = MANAGER.DistributorControllerManager.findControllerByEvent( event );
        _controller.onChangeOnInput( event );
    },
    onResize       : function ( dom_element ) {
        var _parent_dom_element = DOM.Service.findParentElementWithClass( dom_element, PROPERTY.CONST.CLASS.SKINKEN_LINE, 25 );
        var parent_name         = _parent_dom_element.dataset.name;
        var _object             = MANAGER.__instance_property_distributor.findElement( parent_name, true );
        _object.onResize( dom_element );
    },
    onMoveRangeCursor: function ( parent_name, ask_after_action, event ) {
        var _object = MANAGER.__instance_property_distributor.findElement( parent_name, true );
        _object.onMoveRangeCursor( null, event );
        if ( ask_after_action ) {
            MANAGER.ListenerEventManager.askAfterActionProperty( _object );
        }
    },
    clickOnBtnPlus           : function ( parent_name, event ) {
        this.stopPropagation();
        var _object = MANAGER.__instance_property_distributor.findElement( parent_name, true );
        _object.clickOnBtnPlus( event );
        MANAGER.ListenerEventManager.askAfterActionProperty( _object );
    },
    clickOnSelector          : function ( event, parent_name, controller_name ) {
        event.stopPropagation();
        var _controller = MANAGER.DistributorControllerManager.findControllerByEvent( event, controller_name );
        _controller.clickOnSelector( event, parent_name );
    },
    clickOnAllItemsSelector  : function ( parent_name, limit ) {
        var _object = MANAGER.__instance_property_distributor.findElement( parent_name, true );
        _object.clickOnAllItemsSelector( limit );
        MANAGER.ListenerEventManager.askAfterActionProperty( _object );
    },
    clickOnItemSelector      : function ( event, parent_name, element, controller_name ) {
        var _controller = MANAGER.DistributorControllerManager.findControllerByEvent( event, controller_name );
        _controller.clickOnItemSelector( event, parent_name, element );
    },
    clickOnDeleteItemSelector: function ( parent_name, key_name ) {
        var _object = MANAGER.__instance_property_distributor.findElement( parent_name, true );
        _object.clickOnDeleteItemSelector( key_name );
        MANAGER.ListenerEventManager.askAfterActionProperty( _object );
    },
    clickOnBtnInheritance: function ( parent_name ) {
        var _object = MANAGER.__instance_property_distributor.findElement( parent_name, true );
        _object.clickOnBtnInheritance();
    },
    clickOnInput         : function ( event ) {
        var _controller = MANAGER.DistributorControllerManager.findControllerByEvent( event );
        _controller.clickOnInput( event );
    },
    muteEvent            : function ( event ) {
        event.preventDefault();
        event.stopPropagation();
    },
    mutePropagation      : function ( event ) {
        event.stopPropagation();
    },
    clickOnToggleViewSource        : function ( event ) {
        var _controller = MANAGER.DistributorControllerManager.findControllerByEvent( event );
        _controller.clickOnToggleViewSource( event );
    },
    clickOnActivatedSource         : function ( event ) {
        if ( !MANAGER.__instance_element_distributor.current_user.is_admin ) {
            console.warn( "[clickOnActivatedSource]", "[not admin]", "refused" );
            return;
        }
        var _controller = MANAGER.DistributorControllerManager.findControllerByEvent( event );
        _controller.toggleSourceEnable( event );
    },
    clickOnActivatedDiscoverySource: function ( source_name, discovery_id ) {
        if ( MANAGER.__instance_element_distributor.current_user && !MANAGER.__instance_element_distributor.current_user.is_admin ) {
            console.warn( "[clickOnActivatedDiscoverySource]", "[not admin]", "refused" );
            return;
        }
        var _source    = MANAGER.__instance_source_distributor.findSource( source_name );
        var _discovery = _source[ SOURCE.CONST.FIELD.IP_RANGES ].getRangeById( discovery_id );
        _discovery.toggleEnable();
    },
    clickOnForceSource             : function ( name ) {
        if ( MANAGER.__instance_element_distributor.current_user && !MANAGER.__instance_element_distributor.current_user.is_admin ) {
            console.warn( "[clickOnForceSource]", "[not admin]", "refused" );
            return;
        }
        var _source = MANAGER.__instance_source_distributor.findSource( name );
        _source.askForceImport();
    },
    clickOnCleanSource             : function ( name ) {
        if ( MANAGER.__instance_element_distributor.current_user && !MANAGER.__instance_element_distributor.current_user.is_admin ) {
            console.warn( "[clickOnCleanSource]", "[not admin]", "refused" );
            return;
        }
        var _source = MANAGER.__instance_source_distributor.findSource( name );
        _source.cleanImport();
    },
    clickOnLastExecutionSource     : function ( name ) {
        if ( MANAGER.__instance_element_distributor.current_user && !MANAGER.__instance_element_distributor.current_user.is_admin ) {
            console.warn( "[clickOnLastExecutionSource]", "[not admin]", "refused" );
            return;
        }
        var _source = MANAGER.__instance_source_distributor.findSource( name );
        _source.redirectToSourceLastExecution();
    },
    clickOnWorkflowTab       : function ( name ) {
        var dom_element = document.querySelector( "#shinken-workflow-container" );
        DOM.Service.setDataSet( dom_element, 'selected', name );
        dom_element.classList.toggle( 'PATCH_IE' );
    },
    clickOpenNewWindow       : function ( event, link, id ) {
        var _path = "/elements/";
        _path += link + '/';
        _path += id;
        if ( event.ctrlKey ) {
            window.open( _path, '_blank' );
        }
        else {
            window.location = _path;
        }
    },
    clickOnLinkForWorkingArea: function ( event, id ) { //NE MARCHE QUE POUR LES HOSTS
        var _path = "/elements/working_area/hosts/" + id;
        if ( event.ctrlKey ) {
            window.open( _path, '_blank' );
        }
        else {
            window.location = _path;
        }
    },
    keydown                     : function ( event ) {
        var _key_code = event.keyCode;
        switch ( _key_code ) {
            case SHINKEN.CONST.KEY_CODE.F1:
                if ( SHINKEN.NAVIGATOR.isNavigator( 'isIE' ) ) {
                    window.onhelp = function () {
                        return false;
                    };
                }
                event.preventDefault();
                event.stopPropagation();
                break;
        }
        var _controller = MANAGER.DistributorControllerManager.findControllerByEvent( event );
        if ( _controller ) {
            _controller.keydown( event, _key_code );
        }
    },
    mouseEnter                  : function ( event ) {
        var _controller = MANAGER.DistributorControllerManager.findControllerByEvent( event );
        if ( _controller ) {
            _controller.mouseEnter( event );
        }
    },
    mouseLeave                  : function ( event ) {
        var _controller = MANAGER.DistributorControllerManager.findControllerByEvent( event );
        if ( _controller ) {
            _controller.mouseLeave( event );
        }
    },
    mouseMove                   : function ( event, controller_name ) {
        var _controller = MANAGER.DistributorControllerManager.findControllerByEvent( event, controller_name );
        if ( _controller ) {
            _controller.mouseMove( event );
        }
    },
    mouseWheel                  : function ( event, controller_name ) {
        var _controller = MANAGER.DistributorControllerManager.findControllerByEvent( event, controller_name );
        if ( _controller ) {
            _controller.mouseWheel( event );
        }
    },
    mouseDown                   : function ( event, controller_name ) {
        var _controller = MANAGER.DistributorControllerManager.findControllerByEvent( event, controller_name );
        if ( _controller ) {
            _controller.mouseDown( event );
        }
    },
    onClick                     : function ( event ) {
        if ( this.stop_propagation ) {
            this.stop_propagation = false;
            return;
        }
        var _controller = MANAGER.DistributorControllerManager.findControllerByEvent( event );
        if ( _controller ) {
            _controller.onClick( event );
        }
    },
    onScroll                    : function ( event, controller_name ) {
        var _controller = MANAGER.DistributorControllerManager.findControllerByEvent( event, controller_name );
        if ( _controller ) {
            _controller.onScroll( event );
        }
    },
    clickOnForcedHelpButton     : function ( event, dom_element ) {
        event.preventDefault();
        event.stopPropagation();
        var _parent_dom_element = DOM.Service.findParentElementWithClass( dom_element, PROPERTY.CONST.CLASS.SKINKEN_LINE, 20 );
        var name                = _parent_dom_element.dataset.name;
        var _object             = MANAGER.__instance_property_distributor.findElement( name );
        _object.clickOnForcedHelpButton();
    },
    clickOnForcedHelpButtonCheck: function ( event, dom_element ) {
        event.preventDefault();
        event.stopPropagation();
        MANAGER.HelpManager.setForced( 'help_title_try_checks', dom_element, true );
    },
    clickOnPaste                : function ( event ) {
        var _controller = MANAGER.DistributorControllerManager.findControllerByEvent( event );
        if ( _controller ) {
            _controller.clickOnPaste( event );
        }
    },
    clickOnModeTab              : function ( element, do_blink_animation ) {
        var _parent = document.getElementById( 'id-shinken-window-checks-target' );
        DOM.Service.setDataSet( _parent, 'tabSelected', element.dataset.value );
        if ( do_blink_animation ) {
            DOM.Service.askAddClass( element, 'shinken-pulsate', 2000 );
        }
        if ( element.dataset.value !== OBJECT.CONST.MODE_OVERRIDE_EXCLUDE.OVERRIDE ) {
            var _elements = document.querySelectorAll( '.shinken-tab-check-col-tags' );
            for ( var i = 0, _size = _elements.length; i < _size; i++ ) {
                _elements[ i ].classList.remove( "shinken-active" );
            }
            var _elements_tr = document.querySelectorAll( '.shinken-tr-check-override' );
            for ( var i = 0, _size = _elements_tr.length; i < _size; i++ ) {
                _elements_tr[ i ].classList.add( "shinken-hidden" );
            }
        }
        MANAGER.__instance_navigator_size.tab_data_exclude();
    },
    clickOnSetOverride          : function ( dom_uuid ) {
        var _element = document.getElementById( 'id-shinken-window-checks-target' );
        if ( _element.dataset.tabSelected !== OBJECT.CONST.MODE_OVERRIDE_EXCLUDE.OVERRIDE ) {
            this.clickOnModeTab( _element.querySelector( '.shinken-check-mode-menu-tab[data-value="' + OBJECT.CONST.MODE_OVERRIDE_EXCLUDE.OVERRIDE + '"]' ), true );
        }
        App.Elements.ChecksTab.getCheckOverrideData( dom_uuid );
        MANAGER.ListenerEventManager.afterAction( MANAGER.CONST.AFTER_ACTION.CLICK_ON_SERVICE_OVERRIDE );
    },
    clickOnSetExclude           : function ( dom_uuid, event, ignore_if_on_status_exclude ) {
        if ( event ) {
            event.stopPropagation();
        }
        var _element = document.getElementById( 'id-shinken-window-checks-target' );
        if ( _element.dataset.tabSelected !== OBJECT.CONST.MODE_OVERRIDE_EXCLUDE.EXCLUDE ) {
            this.clickOnModeTab( _element.querySelector( '.shinken-check-mode-menu-tab[data-value="' + OBJECT.CONST.MODE_OVERRIDE_EXCLUDE.EXCLUDE + '"]' ), true );
        }
        else if ( !ignore_if_on_status_exclude ) {
            var _check_in_host = App.Elements.ChecksTab.getCheckInHostElement( dom_uuid );
            _check_in_host.changeExcludeStatus();
        }
    },
    clickOnDeleteInvalidOverride: function ( type, name ) {
        MANAGER.__instance_override_unvalid.deleteOverride( type, name );
        App.Elements.ChecksTab.askUpdateOverrideFormatCfg();
    },
    clickOnCleanCheckOverrides  : function ( event, check_uuid ) {
        event.stopPropagation();
        var _confirm = confirm( _( 'element.confirm_remove_override' ) );
        if ( _confirm ) {
            var _check_in_page_host = App.Elements.ChecksTab.getCheckInHostElement( check_uuid );
            _check_in_page_host.cleanOverride();
            App.Elements.ChecksTab.askUpdateOverrideFormatCfg();
        }
    },
    clickOnFocusOnDuplicateCheck: function ( check_uuid ) {
        var _check_in_page_host = App.Elements.ChecksTab.getCheckByID( check_uuid );
        _check_in_page_host.dom_element.scrollIntoView( false );
        DOM.Service.askAddClass( _check_in_page_host.dom_element.querySelector( '.shinken-tab-check-col-name' ), 'shinken-pulsate-focus', 3000 );
    },
    clickOnTryCheck     : function ( check_uuid, is_exec, is_on_poller ) {
        var _check_in_page_host = App.Elements.ChecksTab.getCheckInHostElement( check_uuid );
        _check_in_page_host.askTryCheck( is_exec, is_on_poller );
    },
    clickOnCleanTryCheck: function ( check_uuid ) {
        var _check_in_page_host = App.Elements.ChecksTab.getCheckInHostElement( check_uuid );
        _check_in_page_host.hide_eval_check();
    },
    clickOnMultiLineObjectAdd: function ( parent_name ) {
        var _object = MANAGER.__instance_property_distributor.findElement( parent_name, true );
        _object.clickOnAddLine();
    },
    clickOnDeleteLine        : function ( dom_element ) {
        var _parent_dom_element = DOM.Service.findParentElementWithClass( dom_element, PROPERTY.CONST.CLASS.SKINKEN_LINE, 25 );
        var _name               = _parent_dom_element.dataset.name;
        var _object             = MANAGER.__instance_property_distributor.findElement( _name );
        _object.deleteLine( dom_element );
    },
    clickOnHooksPopup: function ( event, element ) {
        event.stopImmediatePropagation();
        var target    = element;
        var parent    = target.parentNode;
        var is_active = target.classList.contains( 'active' );
        if ( is_active ) {
            target.classList.remove( 'active' );
            parent.classList.remove( "shinken-force-display-block" );
        }
        else {
            target.classList.add( 'active' );
            parent.classList.add( "shinken-force-display-block" );
        }
    },
    clickOnCollapseButton: function ( event ) {
        var _controller = MANAGER.DistributorControllerManager.findControllerByEvent( event );
        _controller.clickOnCollapseButton( event );
    },
    simulateClickOnFilter: function ( event, header_name, value ) {
        var _controller = MANAGER.DistributorControllerManager.findControllerByEvent( event );
        _controller.simulateClickOnFilter( event, header_name, value );
    },
    clickOnForceImportInSource: function ( source_name ) {
        $.ajax( {
            url    : COMMUNICATION.QUERY.GET.SOURCE.FORCE_IMPORT.URL
                     + source_name
                     + COMMUNICATION.QUERY.GET.SOURCE.FORCE_IMPORT.OPTIONS.TIMESTAMP
                     + DATE_TIME.getTimestampNow(),
            success: function ( data ) {
                var _sources = MANAGER.__instance_source_distributor.findSources( SOURCE.CONST.TYPES.ALL );
                _sources.refresh();
            },
            error  : function ( data, txt ) {
                console.log( 'Got bad result for' + data );
            }
        } );
    },
    shinkenBroadcast: function ( key, value_object, event, controller_name ) {
        var _controller = MANAGER.DistributorControllerManager.findControllerByEvent( event, controller_name );
        if ( _controller ) {
            _controller.shinkenBroadcast( key, value_object );
        }
    }
};
MANAGER.ResizeManager = (function ( self ) {
    "use strict";
    self.dom_element_resize      = null;
    self._bounding_origin        = null;
    self._mouse_x_origin         = null;
    self._mouse_y_origin         = null;
    self._width_origin           = null;
    self._height_origin          = null;
    self._name_origin_controller = null;
    
    self.resizeStart               = function ( event ) {
        self.dom_element_resize = DOM.Service.findParentElementWithClass( event.target, "shinken-resizable", 50 );
        self._bounding_origin   = DOM.Service.getBoundingClientRect( self.dom_element_resize );
        self._min_width         = parseInt( event.target.dataset[ 'resizeMinWidth' ] );
        self._min_height         = parseInt( event.target.dataset[ 'resizeMinHeight' ] );
        self._mouse_x_origin    = parseInt( event.clientX );
        self._mouse_y_origin    = parseInt( event.clientY );
        self._width_origin      = self._bounding_origin.width;
        self._height_origin     = self._bounding_origin.height;
        self.dom_element_resize.classList.add( "shinken-resize-active" );
        
        var _body = document.querySelector( 'body' );
        _body.classList.add( "shinken-has-resize-in-progress" );
        _body.addEventListener( 'mouseleave', self.resizeEnd, false );
        
        document.documentElement.addEventListener( 'mousemove', self.doResize, false );
        document.documentElement.addEventListener( 'mouseup', self.resizeEnd, false );
        self._callbackResizeStart( event );
        event.stopPropagation();
    };
    self.doResize                  = function ( event ) {
        var _width  = (self._width_origin + event.clientX - self._mouse_x_origin);
        var _height = (self._height_origin + event.clientY - self._mouse_y_origin);
        if ( self._min_width && self._min_width > _width ) {
            _width = self._min_width;
        }
        if ( self._min_height && self._min_height > _height ) {
            _height = self._min_height;
        }
        DOM.Service.setStyles( self.dom_element_resize, { width: _width + 'px', height: _height + 'px' } );
        self._callbackResizeMove();
    };
    self.resizeEnd                 = function () {
        document.documentElement.removeEventListener( 'mousemove', self.doResize, false );
        document.documentElement.removeEventListener( 'mouseup', self.resizeEnd, false );
        var _body = document.querySelector( 'body' );
        _body.removeEventListener( 'mouseleave', self.resizeEnd, false );
        document.querySelector( 'body' ).classList.remove( "shinken-has-resize-in-progress" );
        self.dom_element_resize.classList.remove( "shinken-resize-active" );
        self._callbackResizeEnd();
        self.dom_element_resize = null;
        self._min_width         = null;
        self._min_height         = null;
    };
    self._getResizeNameForCallback = function () {
        var _name = self.dom_element_resize.dataset[ 'dragResizeElementName' ];
        if ( _name ) {
            return _name;
        }
        console.error( "MANAGER.DragNDropManager : The dataset callbackResizeElementName was not found " );
    };
    self._callbackResizeStart      = function (event) {
        if ( MANAGER && MANAGER.DistributorControllerManager ) {
            self._name_origin_controller = MANAGER.DistributorControllerManager.findControllerName( event );
        }
        if ( self._name_origin_controller && MANAGER && MANAGER.EventManager ) {
            MANAGER.EventManager.onResizeStart( self._name_origin_controller, self._getResizeNameForCallback() );
        }
    };
    self._callbackResizeMove       = function () {
        if ( self._name_origin_controller && MANAGER && MANAGER.EventManager ) {
            MANAGER.EventManager.onResizeMove( self._name_origin_controller, self._getResizeNameForCallback() );
        }
    };
    self._callbackResizeEnd        = function () {
        if ( self._name_origin_controller && MANAGER && MANAGER.EventManager ) {
            MANAGER.EventManager.onResizeStop( self._name_origin_controller, self._getResizeNameForCallback() );
        }
    };
    return self;
})
( MANAGER.ResizeManager || {} );
SHINKEN.OBJECT.DefaultConfiguration           = function ( default_configuration ) {
    this.init( default_configuration );
};
SHINKEN.OBJECT.DefaultConfiguration.prototype = {
    init: function ( default_configuration ) {
        this.children_object = [];
        this.children_dict   = {};
        this.own_property    = [];
        this.updateData( default_configuration );
    },
    getChildrenObject    : function () {
        return this.children_object;
    },
    getChildrenObjectDict: function () {
        return this.children_dict;
    },
    _getObjectToJson      : function () {
        var to_return = {};
        for ( var i = 0, _size_i = this.own_property.length; i < _size_i; i++ ) {
            to_return[ this.own_property[ i ] ] = this[ this.own_property[ i ] ];
        }
        return to_return;
    },
    updateData: function ( data ) {
        if ( !data ) {
            return;
        }
        
        var _keys     = Object.keys( data );
        var _sizeData = _keys.length;
        var _currentKey;
        for ( var i = 0; i < _sizeData; i++ ) {
            _currentKey = _keys[ i ];
            this.setData( _currentKey, data[ _currentKey ] );
        }
    },
    setData   : function ( key, value ) {
        switch ( key ) {
            case SHINKEN.OBJECT.CONST.VALIDATION.FIELD.MESSAGES:
                this.setMessages( value );
                break;
            default:
                if ( typeof value === 'object' ) {
                    this[ key ] = new SHINKEN.OBJECT.DefaultConfiguration( value );
                    this.children_object.push( this[ key ] );
                    this.children_dict[ key ] = this[ key ];
                }
                else {
                    this[ key ] = value;
                    this.own_property.push( key );
                }
                break;
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.DefaultConfiguration, SHINKEN.OBJECT.ShinkenObjectJson );
OBJECT.ElementCheckbox           = function ( dom_element, parent ) {
    this.uuid = SHINKEN.TOOLS.STRING.buildUUID();
    this.init( dom_element, parent );
};
OBJECT.ElementCheckbox.prototype = {
    init           : function ( dom_element, parent ) {
        this.initCounters( parent );
        this.dom_element = dom_element;
        if ( this.dom_element ) {
            this.is_checked = dom_element.classList.contains( 'shinken-checked' );
        }
        this.computeCounters();
    },
    setChecked     : function ( to_set ) {
        if ( to_set === '0' ) {
            to_set = false;
        }
        this.is_checked = !!to_set;
        this.updateView();
    },
    getValue       : function () {
        return this.is_checked ? '1' : '0';
    },
    isChecked      : function () {
        return this.is_checked;
    },
    computeCounters: function () {
        if ( !this.dom_element ) {
            return ;
        }
        var _number_error   = this.dom_element.classList.contains( "shinken-error" ) ? 0 : 0;
        var _number_warning = this.dom_element.classList.contains( "shinken-warning" ) ? 0 : 0;
        this.getCounterError().update( this.uuid, _number_error );
        this.getCounterWarning().update( this.uuid, _number_warning );
    },
    updateView     : function () {
        if ( this.is_checked ) {
            this.dom_element.classList.add( 'shinken-checked' );
        }
        else {
            this.dom_element.classList.remove( 'shinken-checked' );
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( OBJECT.ElementCheckbox, SHINKEN.OBJECT.CounterInterface );
OBJECT.ElementList           = function () {
    this.init();
};
OBJECT.ElementList.prototype = {
    init                 : function () {
        this.is_disabled = false;
        this.is_useless  = false;
    },
    getName              : function () {
        return this.name;
    },
    getState             : function () {
        return this.state;
    },
    getType              : function () {
        return this.type;
    },
    getItemType          : function () {
        return this.item_type ? this.item_type : '';
    },
    getLabel             : function () {
        return this.label;
    },
    setName              : function ( to_set, dom_element ) {
        this.name = to_set;
        this.setLabel( to_set, dom_element );
    },
    setLabel             : function ( to_set ) {
        this.label = to_set;
    },
    setState             : function ( to_set ) {
        this.state = to_set;
    },
    setIsDisabled        : function ( to_set ) {
        if ( to_set === 'false' ) {
            to_set = false;
        }
        this.is_disabled = !!to_set;
    },
    setIsUseless         : function ( to_set ) {
        if ( to_set === 'false' ) {
            to_set = false;
        }
        this.is_useless = !!to_set;
    },
    setIsForceToNull     : function ( to_set ) {
        if ( to_set === 'false' ) {
            to_set = false;
        }
        this.is_force_to_null = !!to_set;
    },
    setIsHiddenForAdminSi: function ( to_set ) {
        if ( to_set === 'false' ) {
            to_set = false;
        }
        this.is_hidden_for_admin_si = !!to_set;
    },
    setUUID              : function ( to_set ) {
        this.uuid = to_set;
        this.findShinkenElement();
    },
    findShinkenElement   : function () {
        if ( this.uuid && this.item_type ) {
            var _shinken_element = MANAGER.__instance_element_distributor.getElementByDict( this );
            if ( _shinken_element ) {
                this.setShinkenElement( _shinken_element );
            }
        }
    },
    setShinkenElement    : function ( to_set ) {
        this.shinken_element = to_set;
    },
    setType              : function ( to_set ) {
        this.type = to_set;
    },
    setItemType          : function ( to_set ) {
        this.item_type = to_set;
        this.findShinkenElement();
    },
    clone                : function () {
        var _to_return = new OBJECT.ElementList();
        var _keys      = Object.keys( this );
        var _current_key;
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current_key               = _keys[ i ];
            _to_return[ _current_key ] = this[ _current_key ];
        }
        return _to_return;
    },
    getClass             : function () {
        var _to_return = "";
        if ( this.state === COMPONENT.CONST.TAG.STATE.NEW ) {
            _to_return += " shinken-element-new";
        }
        else if ( this.state === COMPONENT.CONST.TAG.STATE.UNKNOWN ) {
            _to_return += " shinken-element-unknown";
        }
        else if ( this.is_disabled ) {
            _to_return += " shinken-element-disabled";
        }
        return _to_return;
    },
    getError             : function () {
        if ( this.state === COMPONENT.CONST.TAG.STATE.UNKNOWN ) {
            return 1;
        }
        if ( this.state === COMPONENT.CONST.TAG.STATE.NEW ) {
            return 1;
        }
        if ( this.state === COMPONENT.CONST.TAG.STATE.IT_SELF ) {
            return 1;
        }
        if ( this.is_disabled ) {
            return 1;
        }
        return 0;
    },
    getTooltip           : function () {
        var _to_return = "";
        if ( this.is_useless ) {
            switch ( this.type ) {
                case 'user' :
                    _to_return = _( 'element.tooltip_edition_contact_not_expert' );
                    break;
            }
        }
        if ( this.is_disabled ) {
            if ( _to_return ) {
                _to_return += "<br>";
            }
            _to_return += _( 'element.tooltip_disabled' );
        }
        switch ( this.state ) {
            case COMPONENT.CONST.TAG.STATE.NEW :
            case COMPONENT.CONST.TAG.STATE.OVERRIDE_NEW :
                if ( this.is_disabled ) {
                    _to_return = _( 'element.tooltip_new_disabled' );
                }
                else {
                    _to_return = _( 'element.tooltip_new' );
                }
                break;
            case COMPONENT.CONST.TAG.STATE.WORKING :
                if ( this.is_disabled ) {
                    _to_return = _( 'element.tooltip_working_disabled' );
                }
                else {
                    _to_return = _( 'element.tooltip_working' );
                }
                break;
            case COMPONENT.CONST.TAG.STATE.UNKNOWN :
            case COMPONENT.CONST.TAG.STATE.OVERRIDE_UNKNOWN :
                _to_return = _( 'element.tooltip_undefined' );
                break;
            case COMPONENT.CONST.TAG.STATE.IT_SELF :
                _to_return = _( 'element.tooltip_it_self' );
                break;
        }
        if ( this.is_force_to_null ) {
            if ( _to_return ) {
                _to_return += "<br>";
            }
            _to_return += SHINKEN.TOOLS.STRING.format( _( 'element.double_link_long_warning' ), this.getLabel() );
        }
        return _to_return;
    },
    getValueFinal        : function () {
        var _to_return = {};
        switch ( this.getState() ) {
            case OBJECT.CONST.TEMPLATE.STATUS.UNKNOWN:
            case OBJECT.CONST.TEMPLATE.STATUS.NEW:
            case COMPONENT.CONST.TAG.STATE.UNKNOWN:
            case COMPONENT.CONST.TAG.STATE.NEW:
                _to_return.name   = this.name;
                _to_return.exists = false;
                break;
            default:
                _to_return.name      = this.name;
                _to_return.item_type = this.getItemType();
                _to_return._id       = this.uuid;
                _to_return.exists    = true;
                break;
        }
        return _to_return;
    }
};
SHINKEN.OBJECT.JsonEditor           = function ( dom_element, json, default_tag ) {
    this.__class_name__ = 'SHINKEN.OBJECT.JsonEditor';
    this.dom_element    = dom_element;
    this.json           = json;
    this.content        = null;
    this.default_tag    = default_tag;
    this.init();
};
SHINKEN.OBJECT.JsonEditor.prototype = {
    init: function () {
        this.content = this.parseToHtml( this.json );
        this.updateHtml();
        this.computeErrorContent();
    },
    
    getCurrentContent: function () {
        return this.dom_element.innerText;
    },
    computeErrorContent: function () {
        this.data_with_error = {};
        var _error_contents  = this.dom_element.querySelectorAll( ".shinken-json-error" );
        for ( var i = 0, _size_i = _error_contents.length; i < _size_i; i++ ) {
            if ( _error_contents[ i ].dataset.idError ) {
                this.data_with_error[ _error_contents[ i ].dataset.idError ] = _error_contents[ i ].innerText;
            }
        }
    },
    parseToHtml            : function ( to_parse, shinken_json_tag ) {
        var _to_return = '';
        if ( typeof to_parse === 'string' ) {
            _to_return += this.parseStringToHtml( to_parse, shinken_json_tag );
        }
        else if ( typeof to_parse === 'number' ) {
            _to_return += this.parseNumberToHtml( to_parse, shinken_json_tag );
        }
        else if ( typeof to_parse === 'boolean' ) {
            _to_return += this.parseBooleanToHtml( to_parse, shinken_json_tag );
        }
        else if ( to_parse === null || to_parse === undefined ) {
            if ( this.default_tag ) {
                _to_return += this.parseStringToHtml( shinken_json_tag ? "" : this.default_tag, shinken_json_tag );
            }
        }
        else if ( to_parse instanceof Array ) {
            _to_return += this.parseArrayToHtml( to_parse, shinken_json_tag );
        }
        else if ( typeof to_parse === 'object' ) {
            _to_return += this.parseObjectToHtml( to_parse, shinken_json_tag );
        }
        else {
            _to_return += '{}';
        }
        return _to_return;
    },
    parseObjectToHtml      : function ( to_parse, shinken_json_tag ) {
        var _to_return;
        if ( to_parse instanceof SHINKEN.OBJECT.Param ) {
            return this.parseToHtml( to_parse.getValue(), to_parse.getJsonTag() );
        }
        if ( to_parse[ SHINKEN.OBJECT.JsonEditor.CONST.SHINKEN_JSON_UUID ] ) {
            if ( to_parse[ SHINKEN.OBJECT.JsonEditor.CONST.SHINKEN_JSON_UUID ] instanceof SHINKEN.OBJECT.Param ) {
                _to_return = '<span data-json-uuid-part="' + to_parse[ SHINKEN.OBJECT.JsonEditor.CONST.SHINKEN_JSON_UUID ].getValue() + '"><span class="shinken-json-object-start">{</span>';
            }
            else {
                _to_return = '<span data-json-uuid-part="' + to_parse[ SHINKEN.OBJECT.JsonEditor.CONST.SHINKEN_JSON_UUID ] + '"><span class="shinken-json-object-start">{</span>';
            }
        }
        else {
            _to_return = '<span><span class="shinken-json-object-start">{</span>';
        }
        if ( to_parse[ "__JSON_ERROR__UUID__" ] ) {
            _to_return += '<ul class="shinken-json-dict shinken-json-error" data-id-error="' + to_parse[ "__JSON_ERROR__UUID__" ] + '">';
            delete to_parse[ "__JSON_ERROR__UUID__" ];
        }
        else {
            _to_return += '<ul class="shinken-json-dict">';
        }
        var _keys = Object.keys( to_parse );
        var _current_key;
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current_key = _keys[ i ];
            _to_return += this.buildLineEntry( _current_key, to_parse[ _keys[ i ] ] );
            _to_return += '<span class="shinken-json-key">"' + _current_key + '"</span> : ';
            _to_return += this.parseToHtml( to_parse[ _keys[ i ] ] );
            if ( i < _keys.length - 1 ) {
                _to_return += ',';
            }
            _to_return += '</div></li>';
        }
        _to_return += '</ul>';
        _to_return += '<span class="shinken-json-object-end">}</span></span>';
        return _to_return;
    },
    parseArrayToHtml       : function ( to_parse, shinken_json_tag ) {
        if ( to_parse.length === 0 ) {
            return '[]';
        }
        
        var _to_return = '<span class="shinken-json-array-start">[</span>';
        _to_return += '<ol class="shinken-json-array">';
        
        for ( var i = 0, _size_i = to_parse.length; i < _size_i; i++ ) {
            _to_return += '<li>';
            _to_return += this.parseToHtml( to_parse[ i ] );
            if ( i < to_parse.length - 1 ) {
                _to_return += ',';
            }
            _to_return += '</li>';
        }
        _to_return += '</ol>';
        _to_return += '<span class="shinken-json-array-end">]</span>';
        return _to_return;
    },
    parseStringToHtml      : function ( to_parse, shinken_json_tag ) {
        if ( to_parse === this.default_tag && !shinken_json_tag ) {
            return '"<span class="shinken-default-value" data-default-value="' + this.default_tag + '">' + this.default_tag + '</span>"';
        }
        var to_parse_escape = SHINKEN.TOOLS.STRING.cleanXss( to_parse );
        return '<span class="shinken-json-string ' + this.parseJsonTagToClassCss( shinken_json_tag ) + '" ' + this.parseJsonTagToAttribute( shinken_json_tag ) + '>"' + to_parse_escape + '"</span>';
    },
    parseBooleanToHtml     : function ( to_parse, shinken_json_tag ) {
        return '<span class="shinken-json-boolean ' + this.parseJsonTagToClassCss( shinken_json_tag ) + '" ' + this.parseJsonTagToAttribute( shinken_json_tag ) + '>' + to_parse + '</span>';
    },
    parseNumberToHtml      : function ( to_parse, shinken_json_tag ) {
        return '<span class="shinken-json-number ' + this.parseJsonTagToClassCss( shinken_json_tag ) + '" ' + this.parseJsonTagToAttribute( shinken_json_tag ) + '>' + to_parse + '</span>';
    },
    parseJsonTagToClassCss : function ( to_parse ) {
        var _to_return = "";
        switch ( to_parse ) {
            case SHINKEN.OBJECT.JsonEditor.CONST.JSON_INVALID_VALUE:
                _to_return = "shinken-json-error";
                break;
        }
        return _to_return;
    },
    parseJsonTagToAttribute: function ( to_parse ) {
        var _to_return = "";
        switch ( to_parse ) {
            case SHINKEN.OBJECT.JsonEditor.CONST.JSON_INVALID_VALUE:
                _to_return = 'data-id-error="' + SHINKEN.TOOLS.STRING.buildUUID() + '"';
                break;
        }
        return _to_return;
    },
    buildLineEntry         : function ( key, value ) {
        var li_class_to_add  = "";
        var div_class_to_add = "";
        var div_attribute    = "";
        if ( value !== undefined ) {
            switch ( value.json_tag ) {
                case SHINKEN.OBJECT.JsonEditor.CONST.JSON_UNKNOWN_PROPERTY:
                    div_class_to_add = "shinken-json-error";
                    div_attribute    = 'onmouseenter="SHINKEN_TOOLTIP.showTooltip(this)" onmouseleave="SHINKEN_TOOLTIP.hideTooltip()" shi-tip-type="shinken-warning" shi-tip-placement="left" shi-tip-html="' + SHINKEN.TOOLS.STRING.format( _( "json_editor.unknown_value", [DICTIONARY_COMMON_UI] ), key ) + '"';
                    div_attribute += ' data-json-uuid-part="' + value.getUUID() + '"';
                    break;
                case SHINKEN.OBJECT.JsonEditor.CONST.JSON_BAD_FORMAT_IS_NOT_AN_OBJECT:
                    div_class_to_add = "shinken-json-error";
                    div_attribute    = 'onmouseenter="SHINKEN_TOOLTIP.showTooltip(this)" onmouseleave="SHINKEN_TOOLTIP.hideTooltip()" shi-tip-type="shinken-warning" shi-tip-placement="left" shi-tip-html="' + SHINKEN.TOOLS.STRING.format( _( "json_editor.not_valid_format_value", [DICTIONARY_COMMON_UI] ), key ) + '"';
                    div_attribute += ' data-json-uuid-part="' + value.getUUID() + '"';
                    break;
            }
        }
        if ( key === SHINKEN.OBJECT.JsonEditor.CONST.SHINKEN_JSON_UUID ) {
            li_class_to_add = "shinken-json-dissimulate";
        }
        return '<li class="' + li_class_to_add + '"><div class="shinken-div-inline-block ' + div_class_to_add + '" ' + div_attribute + '>';
    },
    updateHtml            : function () {
        this.dom_element.innerHTML = this.content;
        this.dom_element.classList.add( "shinken-json-editor-container" );
        this.dom_element.setAttribute( "contenteditable", "true" );
    },
    cleanHtmlAfterEdition : function () {
        this.updateDefaultValueHtml();
        this.removeErrorAfterUpdate();
    },
    updateDefaultValueHtml: function () {
        var _default_value_doms = this.dom_element.querySelectorAll( ".shinken-default-value" );
        for ( var i = 0, _size_i = _default_value_doms.length; i < _size_i; i++ ) {
            if ( _default_value_doms[ i ].innerText !== _default_value_doms[ i ].dataset.defaultValue ) {
                _default_value_doms[ i ].classList.remove( "shinken-default-value" );
            }
        }
    },
    removeErrorAfterUpdate: function () {
        var _keys = Object.keys( this.data_with_error );
        var _current_key;
        var _current_dom;
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current_key = _keys[ i ];
            _current_dom = this.dom_element.querySelector( '.shinken-json-error[data-id-error="' + _current_key + '"]' );
            if ( _current_dom && !this._is_same_text( _current_dom.innerText, this.data_with_error[ _current_key ] ) ) {
                _current_dom.classList.remove( "shinken-json-error" );
                delete this.data_with_error[ _current_key ];
            }
        }
        
    },
    _is_same_text         : function ( text_1, text_2 ) {
        return SHINKEN.TOOLS.STRING.replaceAll( text_1, "\n", "" ) === SHINKEN.TOOLS.STRING.replaceAll( text_2, "\n", "" );
    }
};
SHINKEN.OBJECT.JsonEditor.CONST = {
    SHINKEN_JSON_UUID                : "__SHINKEN_JSON_UUID__",
    JSON_UNKNOWN_PROPERTY            : "__JSON_UNKNOWN_PROPERTY__",
    JSON_BAD_FORMAT_IS_NOT_AN_OBJECT : "__JSON_BAD_FORMAT_IS_NOT_AN_OBJECT__",
    JSON_INVALID_VALUE               : "__JSON_INVALID_VALUE__",
    JSON_MODIFIED_VALUE_TO_FIT_FORMAT: "__JSON_MODIFIED_VALUE_TO_FIT_FORMAT__",
    JSON_DEFAULT_VALUE_IS_OK         : "__JSON_DEFAULT_VALUE_IS_OK__"
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.JsonEditor, SHINKEN.OBJECT.ShinkenObject );
SHINKEN.OBJECT.JsonEditorService = (function ( self ) {
    "use strict";
    var __LINE_TAG__       = "__SHINKEN_LINE_TAG__";
    self.computeValidation = function ( dom_element ) {
        var _text_parsed = _parseJsonDomElementToText( dom_element );
        _text_parsed     = SHINKEN.TOOLS.STRING.replaceAll( _text_parsed, __LINE_TAG__, "\n" );
        return [_text_parsed, SHINKEN.TOOLS.STRING.JSON.isFormatJsonInvalid( _text_parsed )];
    };
    self.computeLineNumber = function ( dom_element ) {
        var _padding_bottom = DOM.Service.getComputedStyle( dom_element, 'padding-bottom' );
        var _padding_top    = DOM.Service.getComputedStyle( dom_element, 'padding-top' );
        
        var number_line = (dom_element.scrollHeight - _padding_bottom - _padding_top) / 16;
        var _html       = '';
        for ( var i = 0, _size = number_line; i < _size; i++ ) {
            _html += '<div class="shinken-line-number" data-number="' + (i + 1) + '">' + (i + 1) + '</div>';
        }
        var _container       = document.querySelector( '.shinken-textarea-line-nums' );
        _container.innerHTML = _html;
    };
    
    var _parseJsonDomElementToText = function ( dom_element ) {
        var clone       = DOM.Service.cloneElement( dom_element );
        var dissimulate = clone.querySelectorAll( ".shinken-json-dissimulate" );
        for ( var i = 0, _size_i = dissimulate.length; i < _size_i; i++ ) {
            DOM.Service.removeElement( dissimulate[ i ] );
        }
        
        var _text    = clone.innerHTML;
        _text        = SHINKEN.TOOLS.STRING.replaceAll( _text, "<li class>", __LINE_TAG__ + "<li>" );
        _text        = SHINKEN.TOOLS.STRING.replaceAll( _text, "</ol>", __LINE_TAG__ + "</ol>" );
        _text        = SHINKEN.TOOLS.STRING.replaceAll( _text, "</ul>", __LINE_TAG__ + "</ul>" );
        _text        = SHINKEN.TOOLS.STRING.replaceAll( _text, "<ul class=\"shinken-json-dict\">", __LINE_TAG__ + "<ul class=\"shinken-json-dict\">" );
        var _new_dom = DOM.Service.createElement( "div", {}, _text );
        var _text_2  = _new_dom.innerText;
        return SHINKEN.TOOLS.STRING.replaceAll( _text_2, __LINE_TAG__, "\n" );
    };
    
    return self;
})( SHINKEN.OBJECT.JsonEditorService || {} );
OBJECT.Messages = function ( footer ) {
    this.messages_error   = [];
    this.messages_warning = [];
    this.messages_beware  = [];
    this.messages_info    = [];
    this.is_dfe           = false;
    this.is_dfe_protected = false;
    this.footer           = footer;
    this.no_duplicate     = false;
};
OBJECT.MESSAGE            = {
    ICON       : {
        ERROR  : '<span class="shinken-icon-error shinkon-warning"></span>',
        WARNING: '<span class="shinken-icon-warning shinkon-warning"></span>',
        BEWARE : '<span class="shinken-icon-warning shinkon-warning-light"></span>'
    },
    MAX_ERROR  : 5,
    MAX_WARNING: 5
};
OBJECT.Messages.prototype = {
    addMessage         : function ( type_message, text, line_index ) {
        switch ( type_message ) {
            case COMPONENT.CONST.STATUS.ERROR:
                this.messages_error.push( new OBJECT.Message( type_message, text, line_index ) );
                break;
            case COMPONENT.CONST.STATUS.WARNING:
                this.messages_warning.push( new OBJECT.Message( type_message, text, line_index ) );
                break;
            case COMPONENT.CONST.STATUS.BEWARE:
                this.messages_beware.push( new OBJECT.Message( type_message, text, line_index ) );
                break;
            default:
                this.messages_info.push( new OBJECT.Message( type_message, text, line_index ) );
                break;
        }
    },
    addMessages        : function ( messages ) {
        if ( !messages ) {
            return;
        }
        var _size = messages.length;
        var _current_message;
        for ( var i = 0; i < _size; i++ ) {
            _current_message = messages[ i ];
            this.addMessage( _current_message._type, _current_message._text, _current_message._line_index );
        }
    },
    hasMessage         : function () {
        return this.hasError() || this.hasWarning() || this.hasBeware() || this.hasInfo();
    },
    hasError           : function () {
        return this.messages_error.length > 0;
    },
    hasWarning         : function () {
        return this.messages_warning.length > 0;
    },
    hasBeware          : function () {
        return this.messages_beware.length > 0;
    },
    hasInfo            : function () {
        return this.messages_info.length > 0;
    },
    getStatus          : function () {
        if ( this.hasError() ) {
            return COMPONENT.CONST.STATUS.ERROR;
        }
        if ( this.hasWarning() ) {
            return COMPONENT.CONST.STATUS.WARNING;
        }
        if ( this.hasBeware() ) {
            return COMPONENT.CONST.STATUS.BEWARE;
        }
        return COMPONENT.CONST.STATUS.NONE;
    },
    buildMessage       : function ( is_default, template_name, has_no_max, skip_invalid_syntax ) {
        
        var _status = this.getStatus();
        if ( _status === COMPONENT.CONST.STATUS.NONE ) {
            return '';
        }
        var _to_return          = '<div class="shinken-tooltip-message text-left shinken-drag-exclude">';
        var _show_extra_message = false;
        if ( this.hasError() ) {
            _show_extra_message = true;
            if (!skip_invalid_syntax) {
                _to_return += '<span class="text-underline">' + _( 'element.tooltip_message_invalid_syntax' ) + '</span><br>';
            }
            _to_return += OBJECT.MESSAGE.ICON.ERROR + _( 'element.tooltip_message_tag_error' ) + '<br><ol>';
            _to_return += this.buildMessageForList( this.messages_error, has_no_max ? '' : OBJECT.MESSAGE.MAX_ERROR );
            _to_return += '</ol>';
        }
        if ( this.hasWarning() ) {
            _show_extra_message = true;
            _to_return += OBJECT.MESSAGE.ICON.WARNING + _( 'element.tooltip_message_tag_warning' ) + '<br><ol>';
            _to_return += this.buildMessageForList( this.messages_warning, has_no_max ? '' : OBJECT.MESSAGE.MAX_WARNING );
            _to_return += '</ol>';
        }
        if ( !this.is_dfe_protected && _show_extra_message && this.is_dfe ) {
            var _format_to_follow        = is_default ? _( 'element.tooltip_dfe_common_default_value' ) : _( 'element.tooltip_dfe_common' );
            var _note_to_update_template = template_name ? '<div class=\'container-legend \'>' + SHINKEN.TOOLS.STRING.format( _( 'element.tooltip_dfe_common_go_tpl' ), template_name ) + '</div>' : "";
            _to_return                   = _to_return +
                                           '<div class=\'container-legend\'>' + _format_to_follow + '</div>' +
                                           _note_to_update_template;
            
        }
        if ( this.hasBeware() && this.is_dfe ) {
            if ( !this.is_dfe_protected && _show_extra_message ) {
                _to_return += '<hr>';
            }
            _to_return += '<ol>' + OBJECT.MESSAGE.ICON.BEWARE + SHINKEN.TOOLS.STRING.format( _( 'element.tooltip_dfe_deleted_part_1' ), this.property_name );
            _to_return += this.buildMessageForList( this.messages_beware, 999 );
            _to_return += '</ol>';
        }
        else if ( this.hasBeware() ) {
            _to_return += OBJECT.MESSAGE.ICON.BEWARE + _( 'element.tooltip_message_tag_warning' ) + '<br>';
            _to_return += this.buildMessageForList( this.messages_beware, 999 );
        }
        if ( this.footer ) {
            _to_return += this.footer;
        }
        
        _to_return += '</div>';
        return _to_return;
    },
    buildMessageForList: function ( list, max ) {
        var _to_return = '';
        var _size      = list.length;
        if ( max ) {
            _size = Math.min( list.length, _size );
        }
        var _to_add;
        var _duplicate = {};
        for ( var i = 0; i < _size; i++ ) {
            _to_add = list[ i ].buildHtml();
            if ( this.no_duplicate ) {
                var _md5 = SHINKEN.TOOLS.MD5.MD5( _to_add );
                if ( _duplicate[ _md5 ] ) {
                    continue;
                }
                _duplicate[ _md5 ] = true;
            }
            _to_return += _to_add;
        }
        return _to_return;
    },
    getAllMessages     : function () {
        var to_return = [];
        to_return     = SHINKEN.TOOLS.ARRAY.concat( to_return, this.messages_error );
        to_return     = SHINKEN.TOOLS.ARRAY.concat( to_return, this.messages_warning );
        to_return     = SHINKEN.TOOLS.ARRAY.concat( to_return, this.messages_info );
        to_return     = SHINKEN.TOOLS.ARRAY.concat( to_return, this.messages_beware );
        return to_return;
    }
};
OBJECT.Message = function ( type, text, line_index ) {
    this._type       = type;
    this._text       = text;
    this._line_index = line_index | "";
};
OBJECT.Message.prototype = {
    buildHtml   : function () {
        return '<li class=\'' + this._type + '\'>' + this._text + '</li>';
    },
    setLineIndex: function ( to_set ) {
        this._line_index = to_set;
    }
};
OBJECT.MessageService = (function ( self ) {
    "use strict";
    self.parseBackendStatus = function ( status ) {
        switch ( status ) {
            case SHINKEN.OBJECT.CONST.VALIDATION.FIELD.WARNINGS:
                return COMPONENT.CONST.STATUS.WARNING;
            case SHINKEN.OBJECT.CONST.VALIDATION.FIELD.CRITICAL:
            case SHINKEN.OBJECT.CONST.VALIDATION.FIELD.ERRORS:
                return COMPONENT.CONST.STATUS.ERROR;
        }
    };
    return self;
})( OBJECT.MessageService || {} );
SHINKEN.OBJECT.NOTIFICATION.Container           = function () {
    this.__class_name__ = 'SHINKEN.OBJECT.NOTIFICATION.CONTAINER';
    this.dom_element    = null;
    this.notifications  = null;
};
SHINKEN.OBJECT.NOTIFICATION.Container.prototype = {
    init: function () {
        this.notifications = [];
    },
    
    addNotification            : function ( message, status, element_to_bind_with, notification_placement, time_before_remove ) {
        if ( !this.dom_element ) {
            this.createNotificationContainer();
        }
        
        var _user_notification = new SHINKEN.OBJECT.NOTIFICATION.User();
        
        this.cleanAllNotification();
        _user_notification.init();
        _user_notification.createNotification( message, status );
        _user_notification.setTimerToCloseNotification( this.dom_element, time_before_remove );
        if ( element_to_bind_with ) {
            _user_notification.bindToElement( element_to_bind_with, notification_placement );
        }
        
        this.notifications.push( _user_notification );
        DOM.Service.addElementTo( _user_notification.dom_element, this.dom_element );
        return _user_notification;
    },
    addNotificationStyled      : function ( message, status, styles, time_before_remove ) {
        var _user_notification = this.addNotification( message, status );
        
        if ( styles ) {
            _user_notification.addStyles( styles );
        }
    },
    createNotificationContainer: function () {
        this.dom_element = DOM.Service.createElement( "div", { id: "id-shinken-notification-popup-container" } );
        DOM.BodyService.addChild( this.dom_element );
    },
    cleanAllNotification       : function () {
        DOM.Service.empty( this.dom_element );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.NOTIFICATION.Container, SHINKEN.OBJECT.ShinkenObject );
SHINKEN.OBJECT.NOTIFICATION.User           = function () {
    this.__class_name__                = 'SHINKEN.OBJECT.NOTIFICATION.USER';
    this.dom_element                   = null;
    this.message                       = null;
    this.timeout_to_close_notification = null;
};
SHINKEN.OBJECT.NOTIFICATION.User.prototype = {
    init                       : function () {
    },
    createNotification         : function ( message, status, skip_close ) {
        this.createMessageDom();
        
        if ( !skip_close ) {
            var _cross = DOM.Service.createElement( 'div', { class: "shinkon shinkon-times-bold" } );
            this.dom_element.appendChild( _cross );
            var self = this;
            _cross.addEventListener( 'click', function () {
                self.close();
            } );
        }
        this.message = message;
        
        if ( status ) {
            this.addTypeToNotification( status );
        }
        var _dom_text_notification = DOM.Service.createElement( 'span', {}, this.message );
        DOM.Service.addElementTo( _dom_text_notification, this.dom_element );
        
    },
    addTypeToNotification      : function ( status ) {
        var _icon = DOM.Service.createElement( 'span', { 'class': "shinkon" } );
        switch ( status ) {
            case SHINKEN.OBJECT.NOTIFICATION.CONST.STATUS.ERROR:
                _icon.classList.add( 'shinkon-warning' );
                this.dom_element.classList.add( "notification-error" );
                break;
            case SHINKEN.OBJECT.NOTIFICATION.CONST.STATUS.WARNING:
                _icon.classList.add( 'shinkon-warning' );
                this.dom_element.classList.add( "notification-warning" );
                break;
            case SHINKEN.OBJECT.NOTIFICATION.CONST.STATUS.INFO:
                _icon.classList.add( 'info-circle' );
                this.dom_element.classList.add( "notification-info" );
                break;
            case SHINKEN.OBJECT.NOTIFICATION.CONST.STATUS.SUCCESS:
                _icon.classList.add( 'info-circle' );
                this.dom_element.classList.add( "notification-success" );
                break;
            case SHINKEN.OBJECT.NOTIFICATION.CONST.STATUS.COPY_SUCCESS:
                this.dom_element.classList.add( "shinken-notification-copy-success" );
                break;
            case SHINKEN.OBJECT.NOTIFICATION.CONST.STATUS.COPY_FAILED:
                this.dom_element.classList.add( "shinken-notification-copy-failed" );
                break;
        }
        DOM.Service.addElementTo( _icon, this.dom_element );
    },
    setTimerToCloseNotification: function ( parent_element, time_before_remove ) {
        time_before_remove              = time_before_remove || 8000;
        var self                        = this;
        this.timeoutToCloseNotification = setTimeout( function () {
            self.dom_element.classList.add( "shinken-removed" );
        }, time_before_remove );
    },
    bindToElement              : function ( element, notification_placement ) {
        var _size   = element.getBoundingClientRect();
        var _styles = {};
        switch ( notification_placement ) {
            case SHINKEN.OBJECT.NOTIFICATION.CONST.PLACEMENT.TOP:
                _styles[ DOM.CONST.STYLE.TOP ]  = _size[ DOM.CONST.STYLE.TOP ] - 60;
                _styles[ DOM.CONST.STYLE.LEFT ] = _size[ DOM.CONST.STYLE.LEFT ] - 50;
                break;
            case SHINKEN.OBJECT.NOTIFICATION.CONST.PLACEMENT.BOTTOM:
                _styles[ DOM.CONST.STYLE.TOP ]  = _size[ DOM.CONST.STYLE.TOP ] + 60;
                _styles[ DOM.CONST.STYLE.LEFT ] = _size[ DOM.CONST.STYLE.LEFT ] - 50;
                break;
            case SHINKEN.OBJECT.NOTIFICATION.CONST.PLACEMENT.SPECIFIC_TITLE_HIVE: // TODO Repenser le placement des notifs
                _styles[ DOM.CONST.STYLE.TOP ]  = _size[ DOM.CONST.STYLE.TOP ] + 60;
                _styles[ DOM.CONST.STYLE.LEFT ] = _size[ DOM.CONST.STYLE.LEFT ];
                break;
            case SHINKEN.OBJECT.NOTIFICATION.CONST.PLACEMENT.SPECIFIC_TITLE_LIST: // TODO Repenser le placement des notifs
                _styles[ DOM.CONST.STYLE.TOP ]  = _size[ DOM.CONST.STYLE.TOP ] + 55;
                _styles[ DOM.CONST.STYLE.LEFT ] = _size[ DOM.CONST.STYLE.LEFT ];
                break;
            case SHINKEN.OBJECT.NOTIFICATION.CONST.PLACEMENT.COPY_NOTIFICATION_SUCCESS: // TODO Repenser le placement des notifs
                _styles[ DOM.CONST.STYLE.TOP ] = _size[ DOM.CONST.STYLE.TOP ] - 35;
                if ( _styles[ DOM.CONST.STYLE.TOP ] < 0 ) {
                    _styles[ DOM.CONST.STYLE.TOP ] = _size[ DOM.CONST.STYLE.TOP ] + 35;
                }
                _styles[ DOM.CONST.STYLE.LEFT ] = _size[ DOM.CONST.STYLE.LEFT ] - 25;
                break;
            case SHINKEN.OBJECT.NOTIFICATION.CONST.PLACEMENT.COPY_NOTIFICATION_FAILED:// TODO Repenser le placement des notifs
                _styles[ DOM.CONST.STYLE.TOP ] = _size[ DOM.CONST.STYLE.TOP ] - 35;
                if ( _styles[ DOM.CONST.STYLE.TOP ] < 0 ) {
                    _styles[ DOM.CONST.STYLE.TOP ] = _size[ DOM.CONST.STYLE.TOP ] + 35;
                }
                _styles[ DOM.CONST.STYLE.LEFT ] = _size[ DOM.CONST.STYLE.LEFT ] - 100;
                break;
            default:
                _styles[ DOM.CONST.STYLE.TOP ]  = _size[ DOM.CONST.STYLE.TOP ];
                _styles[ DOM.CONST.STYLE.LEFT ] = _size[ DOM.CONST.STYLE.LEFT ] + 50;
                break;
        }
        DOM.Service.setStyles( this.dom_element, _styles );
    },
    createMessageDom           : function () {
        this.dom_element = DOM.Service.createElement( "div", { class: "shinken-notification-popup" } );
    },
    close                      : function () {
        clearTimeout( this.timeoutToCloseNotification );
        DOM.Service.removeElement( this.dom_element );
    }
    
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.NOTIFICATION.User, SHINKEN.OBJECT.ShinkenObject );
SHINKEN.OBJECT.Param = function () {
    this.user_value = null;
    this.default_value = null;
};
SHINKEN.OBJECT.Param.prototype = {
    setDefaultValue         : function ( to_set ) {
        this.default_value = to_set;
    },
    setUserValue         : function ( to_set ) {
        this.default_value = to_set;
    },
    getComputedValue         : function ( to_set ) {
        return this.user_value !== null ? this.user_value : this.default_value;
    },
    getFormValue         : function ( to_set ) {
        return this.user_value !== null ? this.user_value : 'default';
    }
};
"use strict";
SHINKEN.OBJECT.Progressbar           = function ( parent, nb_steps, min_timeout, dom_element_parent ) {
    this._parent                           = parent;
    this._nb_steps                         = nb_steps;
    this._min_timeout                      = min_timeout;
    __SHINKEN_TEMPLATE_HTML_PROGRESS_BAR__ = __SHINKEN_TEMPLATE_HTML_PROGRESS_BAR__.replace( "$$$$__COLLAPSE__TITLE__$$$$", _( "progress_bar.toggle_display_message_label", [DICTIONARY_COMMON_UI] ) );
    dom_element_parent.innerHTML           = __SHINKEN_TEMPLATE_HTML_PROGRESS_BAR__;
    this._dom_element                      = dom_element_parent.querySelector( ".shinken-popup-progress-bar-container" );
    this._dom_progress_bar                 = this._dom_element.querySelector( ".shinken-progress-bar" );
    this._dom_title                        = this._dom_element.querySelector( ".shinken-popup-title" );
    this._dom_message                      = this._dom_element.querySelector( ".shinken-progress-bar-message" );
    this.starting_time                     = null;
    this.initPhase( this._dom_element );
    this.setPhase( SHINKEN.OBJECT.CONST.PHASE.HIDDEN );
};
SHINKEN.OBJECT.Progressbar.prototype = {
    reset    : function () {
        this._timeout_run                          = null;
        this._current_step                         = 0;
        this._dom_element.dataset.messageDisplayed = "0";
        this.initSteps();
    },
    initSteps: function () {
        this._steps = [];
        for ( var i = 0; i <= this._nb_steps; i++ ) {
            this._steps.push( new SHINKEN.OBJECT.ProgressbarStep( i ) );
        }
    },
    setParamStep    : function ( step, to_set ) {
        this._steps[ step ].setParam( to_set );
    },
    setMessageStep  : function ( step, to_set ) {
        this._steps[ step ].setMessage( to_set );
    },
    setTitleStep    : function ( step, to_set ) {
        this._steps[ step ].setTitle( to_set );
    },
    callbackForPhase: function () {
        var _current = this.getCurrentPhase();
        switch ( _current ) {
            case SHINKEN.OBJECT.CONST.PHASE.HIDDEN:
                this.reset();
                break;
        }
    },
    kill    : function () {
        DOM.Service.removeElement(this._dom_element);
    },
    doProgress: function ( expected_step, phase, param, message, title ) {
        if ( expected_step === 1 ) {
            this.reset();
            this.setPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING );
        }
        var _step = this._steps[ expected_step ];
        _step.setPhase( phase );
        _step.setParam( param );
        _step.setMessage( message );
        _step.setTitle( title );
        _step.askForRun();
        this._run();
    },
    _run      : function () {
        if ( this._timeout_run ) {
            return;
        }
        if ( !this._steps[ this._current_step + 1 ].needToBeRun() ) {
            return;
        }
        if ( this.isPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING_NOK ) ) {
            return;
        }
        this._current_step++;
        var _current_step = this._steps[ this._current_step ];
        this._parent.doActionWhenProgressStart( this._current_step, _current_step.getParam(), this );
        this._updateHtml( _current_step );
        
        var self          = this;
        this._timeout_run = setTimeout( function () {
            self._parent.doActionWhenProgressEnd( self._current_step, _current_step.getParam(), self );
            self._timeout_run = null;
            if ( self._current_step < self._nb_steps ) {
                self._run();
            }
        }, this._min_timeout );
    },
    _updateHtml   : function ( current_step ) {
        if ( current_step.getPhase() ) {
            this.setPhase( current_step.getPhase() );
        }
        if ( current_step.getTitle() ) {
            this._dom_title.innerHTML = current_step.getTitle();
        }
        if ( current_step.getMessage() ) {
            this._dom_message.innerHTML = current_step.getMessage();
        }
        this._updateBarHtml();
    },
    _updateBarHtml: function () {
        DOM.Service.setStyle( this._dom_progress_bar, DOM.CONST.STYLE.WIDTH, (this._current_step / this._nb_steps * 100) + "%" );
        DOM.Service.setDataSet( this._dom_element, "isComplete", (this._current_step === this._nb_steps) ? "1" : "0" );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.Progressbar, SHINKEN.OBJECT.PhaseInterface );
SHINKEN.OBJECT.ProgressbarStep           = function ( index ) {
    this._index        = index;
    this._phase        = null;
    this._title        = null;
    this._message      = null;
    this._param        = null;
    this._run_expected = false;
};
SHINKEN.OBJECT.ProgressbarStep.prototype = {
    setPhase   : function ( to_set ) {
        if ( to_set !== undefined ) {
            this._phase = to_set;
        }
    },
    setMessage : function ( to_set ) {
        if ( to_set !== undefined ) {
            this._message = to_set;
        }
    },
    getTitle   : function ( to_set ) {
        return this._title;
    },
    setTitle   : function ( to_set ) {
        if ( to_set !== undefined ) {
            this._title = to_set;
        }
    },
    getMessage : function ( to_set ) {
        return this._message;
    },
    setParam   : function ( to_set ) {
        if ( to_set !== undefined ) {
            this._param = to_set;
        }
    },
    askForRun  : function () {
        this._run_expected = true;
    },
    needToBeRun: function () {
        return this._run_expected;
    },
    getParam   : function () {
        return this._param;
    },
    getPhase   : function () {
        return this._phase;
    }
};
SHINKEN.OBJECT.ProgressbarInterface           = function () {
};
SHINKEN.OBJECT.ProgressbarInterface.prototype = {
    doActionWhenProgressStart        : function ( current_step, param, progress_bar_object ) {
        if ( current_step === progress_bar_object._nb_steps ) {
            this.doActionWhenProgressionIsComplete( progress_bar_object );
        }
        this._doActionWhenProgressStart( current_step, param );
    },
    doActionWhenProgressEnd          : function ( current_step, param, progress_bar_object ) {
        if ( current_step === progress_bar_object._nb_steps - 1 && progress_bar_object.isPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING_OK ) ) {
            progress_bar_object.doProgress( progress_bar_object._nb_steps );
        }
        this._doActionWhenProgressEnd( current_step, param );
    },
    _doActionWhenProgressStart       : function ( current_step, param ) {
    },
    _doActionWhenProgressEnd         : function ( current_step, param ) {
    },
    doActionWhenProgressionIsComplete: function ( progress_bar_object ) {
        progress_bar_object.setPhaseWithTimeOut( SHINKEN.OBJECT.CONST.PHASE.HIDDEN, 2000 );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.PhaseInterface, SHINKEN.OBJECT.ShinkenObject );
var __SHINKEN_TEMPLATE_HTML_PROGRESS_BAR__ = '<div class="shinken-popup-progress-bar-container shinken-parent-event-listener" data-controller="common_ui" data-message-displayed="0">\n' +
                                             '    <div class="shinken-popup-title"></div>\n' +
                                             '    <div class="shinken-progress-bar-container">\n' +
                                             '        <div class="shinken-progress-bar"></div>\n' +
                                             '    </div>\n' +
                                             '    <div class="shinken-popup-success-icon shinicon shinicon-check-circle"></div>\n' +
                                             '    <div class="shinken-collapse-button-container">\n' +
                                             '        <div class="shinken-button-container">\n' +
                                             '            <div class="shinken-button shinken-popup-message-detail-collapse" onclick="MANAGER.EventManager.clickOnButton(event)" data-name="toggle_display_popup_progress_bar_message">\n' +
                                             '                <div class="shinken-display-table">\n' +
                                             '                    <div class="shinken-display-table-cell">\n' +
                                             '                        <span class="">$$$$__COLLAPSE__TITLE__$$$$</span>\n' +
                                             '                    </div>\n' +
                                             '                </div>\n' +
                                             '            </div>\n' +
                                             '        </div>\n' +
                                             '    </div>\n' +
                                             '    <div class="shinken-popup-close">\n' +
                                             '        <div class="shinken-button-container">\n' +
                                             '            <div class="shinken-button" onclick="MANAGER.EventManager.clickOnButton(event)" data-name="close_popup_progress_bar">\n' +
                                             '                <div class="shinken-display-table">\n' +
                                             '                    <div class="shinken-display-table-cell"><span class=""><span class="shinkon shinkon-times"></span></span></div>\n' +
                                             '                </div>\n' +
                                             '            </div>\n' +
                                             '        </div>\n' +
                                             '    </div>\n' +
                                             '    <div class="shinken-progress-bar-message"></div>\n' +
                                             '</div>';
SHINKEN.OBJECT.ShinkenElement           = function () {
};
SHINKEN.OBJECT.ShinkenElement.prototype = {
    init: function ( data ) {
        this.updateData( data );
    },
    getUUID             : function () {
        return this.uuid;
    },
    getName             : function () {
        return this.name;
    },
    setUUID             : function ( to_set ) {
        this.uuid = to_set;
    },
    setExists           : function ( to_set ) {
        if ( this[ OBJECT.CONST.ELEMENT.FIELD_UI.IS_EXISTING ] === to_set ) {
            return false;
        }
        this[ OBJECT.CONST.ELEMENT.FIELD_UI.IS_EXISTING ] = to_set;
        return true;
    },
    isNotAuthorized     : function ( to_set ) {
        if ( this[ OBJECT.CONST.ELEMENT.FIELD_UI.IS_NOT_AUTHORIZED_FOR_USER ] === to_set ) {
            return false;
        }
        this[ OBJECT.CONST.ELEMENT.FIELD_UI.IS_NOT_AUTHORIZED_FOR_USER ] = to_set;
        return true;
    },
    setName             : function ( to_set ) {
        if ( this.name === to_set ) {
            return false;
        }
        this.name = to_set;
        return true;
    },
    setVisualisationName: function ( to_set ) {
        if ( this.visualisation_name === to_set ) {
            return false;
        }
        this.visualisation_name = to_set;
        return true;
    },
    setContext          : function ( to_set ) {
        if ( this.context && this.context.isByCode( to_set ) ) {
            return false;
        }
        this.context = this.context || new SHINKEN.Status();
        this.context.setCode( to_set );
        return true;
    },
    setStatus           : function ( to_set ) {
        if ( this.status && this.status.isByCode( to_set ) ) {
            return false;
        }
        this.status = this.status || new SHINKEN.Status();
        this.status.setCode( to_set );
        return true;
    },
    setSlaValue         : function ( to_set ) {
        if ( this.sla_value === to_set ) {
            return false;
        }
        this.sla_value = to_set;
        return true;
    },
    setSlaTendency      : function ( to_set ) {
        if ( this.tendency === to_set ) {
            return false;
        }
        this.tendency = to_set;
        return true;
    },
    updateData: function ( data ) {
        if ( !data ) {
            return;
        }
        var _keys     = Object.keys( data );
        var _sizeData = _keys.length;
        var _currentKey;
        for ( var i = 0; i < _sizeData; i++ ) {
            _currentKey = _keys[ i ];
            this.setData( _currentKey, data[ _currentKey ] );
        }
    },
    setData   : function ( key, value ) {
        switch ( key ) {
            case OBJECT.CONST.ELEMENT.FIELD_UI.ITEM_UUID:
                this.setUUID( value );
                break;
            case OBJECT.CONST.ELEMENT.FIELD_UI.STATUS:
                this.setStatus( value );
                break;
            case OBJECT.CONST.ELEMENT.FIELD_UI.CONTEXT:
                this.setContext( value );
                break;
            case OBJECT.CONST.ELEMENT.FIELD_UI.SLA.__KEY__:
                this.updateData( value );
                break;
            case OBJECT.CONST.ELEMENT.FIELD_UI.SLA.VALUE:
                this.setSlaValue( value );
                break;
            case OBJECT.CONST.ELEMENT.FIELD_UI.SLA.TENDENCY:
                this.setSlaTendency( value );
                break;
            case OBJECT.CONST.ELEMENT.FIELD_UI.SLA.WARNING_THRESHOLD:
            case OBJECT.CONST.ELEMENT.FIELD_UI.SLA.CRITICAL_THRESHOLD:
                this[ "sla_" + key ] = value;
                break;
            case OBJECT.CONST.ELEMENT.FIELD_UI.ITEM_TYPE:
            case OBJECT.CONST.ELEMENT.FIELD_UI.ITEM_NAME:
            case OBJECT.CONST.ELEMENT.FIELD_UI.NAME:
            case OBJECT.CONST.ELEMENT.FIELD_UI.VISUALISATION_NAME:
                this[ key ] = value;
                break;
            default:
                console.warn( "[IGNORED DATA]", key, value );
                this.setUnknownValue(key, value);
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.ShinkenElement, SHINKEN.OBJECT.ShinkenObjectJson );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.ShinkenElement, SHINKEN.OBJECT.PhaseInterface );
SHINKEN.OBJECT.Refresh = function ( countdown, parent, do_once ) {
    this.parent_object     = parent;
    this.countdown         = countdown || 60000;
    this.countdown_tic     = 1000;
    this.current_countdown = this.countdown;
    this.do_once           = do_once || true;
    this.ui_components     = [];
    this.phase             = new SHINKEN.OBJECT.Phase( this );
    this.interval_tic_tac  = null;
};
SHINKEN.OBJECT.Refresh.prototype = {
    addUiComponent    : function ( to_add ) {
        this.ui_components.push( to_add );
    },
    getPercent        : function () {
        return (1 - this.current_countdown / this.countdown) * 100;
    },
    setLastComputeDate: function ( to_set ) {
        for ( var i = 0, _size_i = this.ui_components.length; i < _size_i; i++ ) {
            this.ui_components[ i ].setLastComputeDate( to_set );
        }
    },
    askParentPhaseUpdated: function () {
        if ( !this.ui_components ) {
            return;
        }
        for ( var i = 0, _size_i = this.ui_components.length; i < _size_i; i++ ) {
            this.ui_components[ i ].phaseUpdated( this.phase.current_phase );
        }
    },
    updateCountdown: function () {
        if ( this.phase.isPhase( SHINKEN.OBJECT.CONST.PHASE.STUCK ) ) {
            return;
        }
        this.current_countdown -= this.countdown_tic;
        this.current_countdown = Math.max( this.current_countdown, 0 );
        for ( var i = 0, _size_i = this.ui_components.length; i < _size_i; i++ ) {
            this.ui_components[ i ].updateCountdown( this );
        }
    },
    reset          : function () {
        clearInterval( this.interval_tic_tac );
        this.current_countdown = this.countdown;
    },
    tictac         : function () {
        var _phase_value = this.phase.current_phase;
        this.updateCountdown();
        if ( this.current_countdown <= 0 ) {
            switch ( _phase_value ) {
                case SHINKEN.OBJECT.CONST.PHASE.RUNNING:
                    this.phase.setPhase( SHINKEN.OBJECT.CONST.PHASE.REFRESHING );
                    break;
                case SHINKEN.OBJECT.CONST.PHASE.HIDDEN:
                    if ( !SHINKEN.NAVIGATOR.isNavigatorHidden() ) {
                        this.phase.setPhase( SHINKEN.OBJECT.CONST.PHASE.REFRESHING );
                    }
                    break;
            }
        }
    },
    callbackForPhase: function () {
        this.askParentPhaseUpdated();
        switch ( this.phase.current_phase ) {
            case SHINKEN.OBJECT.CONST.PHASE.RUNNING :
                var _self = this;
                if ( this.phase.previous_phase !== SHINKEN.OBJECT.CONST.PHASE.EDITING ) {
                    this.reset();
                }
                this.interval_tic_tac = setInterval( function () {
                    _self.tictac();
                }, this.countdown_tic );
                break;
            case SHINKEN.OBJECT.CONST.PHASE.REFRESHING :
                if ( SHINKEN.NAVIGATOR.isNavigatorHidden() ) {
                    this.phase.setPhase( SHINKEN.OBJECT.CONST.PHASE.HIDDEN );
                }
                else {
                    clearInterval( this.interval_tic_tac );
                    if ( this.parent_object ) {
                        this.parent_object.refresh();
                    }
                }
                break;
            case SHINKEN.OBJECT.CONST.PHASE.EDITING :
                clearInterval( this.interval_tic_tac );
                break;
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.Refresh, SHINKEN.OBJECT.PhaseInterface );
SHINKEN.TOOLS.ClockComponent           = function ( dom_element_parent ) {
    this.dom_element = dom_element_parent.querySelector(".shinken-clock-refresh");
    this.init();
};
SHINKEN.TOOLS.ClockComponent.prototype = {
    
    init: function () {
        this.color = '#5C5C5C';
    },
    
    setColor: function ( color ) {
        this.color = color;
    },
    
    set_refreshing_content  : function () {
        DOM.Service.addClasses( this.dom_element, 'shinken-clock-refreshing' );
    },
    unset_refreshing_content: function () {
        DOM.Service.removeClasses( this.dom_element, 'shinken-clock-refreshing' );
    },
    updateHtml              : function (percent) {
        var values = this.computeContent(percent);
        DOM.Service.setStyles( this.dom_element, {
            'background': 'linear-gradient(' + values.deg + 'deg, #ffffff 50%,transparent 0) 0/' + values.enabled_first_linear_gradiant + '%, '
                          + 'linear-gradient(' + values.deg + 'deg, transparent 50%, ' + this.color + ' 0) 0/' + values.enabled_second_linear_gradiant + '%, '
                          + 'linear-gradient(to right, #ffffff 50% ,' + this.color + ' 0)'
            
        } );
    },
    
    computeContent: function (percent) {
        
        var _deg = ((18 / 5) * percent - 90);
        
        var _to_compute_first  = (50 - percent) * 100;
        var _to_compute_second = (percent - 50) * 100;
        
        var _enabled_first_linear_gradiant  = 0;
        var _enabled_second_linear_gradiant = 0;
        
        if ( _to_compute_first === 100 || _to_compute_first > 100 ) {
            _enabled_first_linear_gradiant = 100;
        }
        if ( _to_compute_second === 100 || _to_compute_second > 100 ) {
            _enabled_second_linear_gradiant = 100;
        }
        return { deg: _deg, enabled_first_linear_gradiant: _enabled_first_linear_gradiant, enabled_second_linear_gradiant: _enabled_second_linear_gradiant };
    },
    
    eventIsRunning   : function () {
        this.unset_refreshing_content();
        this.updateHtml();
    },
    eventIsRefreshing: function () {
        this.set_refreshing_content();
    },
    updateCountdown       : function (parent_object ) {
        this.updateHtml( parent_object.getPercent() );
    },
    eventIsStopping  : function () {
        this.set_refreshing_content();
    }
    
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.TOOLS.ClockComponent, SHINKEN.TOOLS.InterfaceRefreshComponent );
SHINKEN.TOOLS.UpdateAtComponent           = function ( dom_element ) {
    this.dom_element = dom_element;
    this.dom_element_date = this.dom_element.querySelector(".shinken-time-label");
};
SHINKEN.TOOLS.UpdateAtComponent.prototype = {
    
    
    setLastComputeDate: function ( to_set ) {
        this.dom_element_date.innerHTML = DATE_TIME.FORMAT.get_time_from_timestamp( to_set );
    },
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.TOOLS.UpdateAtComponent, SHINKEN.TOOLS.InterfaceRefreshComponent );
SHINKEN.StatusService = (function( self ) {
    "use strict";
    
    self.buildPaths     = function ( status, context ) {
        var _to_return = {
            path      : null,
            path_extra: null
        };
        if ( context.is( SHINKEN.STATUS.DISABLED ) ) {
            _to_return.path = context.getPath();
        }
        else if ( !context.is( SHINKEN.STATUS.NOTHING ) ) {
            _to_return.path       = context.getPath();
            _to_return.path_extra = status.getPath();
        }
        else {
            _to_return.path = status.getPath();
        }
        return _to_return;
    };
    self.buildTilePaths = function ( status, context ) {
        return  {
            path      : status.getPath(),
            path_extra: context.getPath()
        };
    };
    self.parseToPartial = function ( code ) {
        var _to_return;
        switch ( code ) {
            case  SHINKEN.STATUS.ACKNOWLEDGED.CODE:
            case  SHINKEN.STATUS.INHERITED_ACKNOWLEDGED.CODE:
                _to_return = SHINKEN.STATUS.PARTIAL_ACKNOWLEDGED.CODE;
                break;
            case SHINKEN.STATUS.DOWNTIME.CODE:
            case SHINKEN.STATUS.INHERITED_DOWNTIME.CODE:
                _to_return = SHINKEN.STATUS.PARTIAL_DOWNTIME.CODE;
                break;
            case SHINKEN.STATUS.FLAPPING.CODE:
                _to_return = SHINKEN.STATUS.PARTIAL_FLAPPING.CODE;
                break;
            default:
                _to_return = code;
                break;
        }
        return _to_return;
    };
    self.isPartial      = function ( code ) {
        switch ( code ) {
            case SHINKEN.STATUS.PARTIAL_ACKNOWLEDGED.CODE:
            case SHINKEN.STATUS.PARTIAL_DOWNTIME.CODE:
            case SHINKEN.STATUS.PARTIAL_FLAPPING.CODE:
                return true;
        }
        return false;
    };
    self.isContext      = function ( context, type ) {
        var _code = context.getCode();
        switch ( type ) {
            case SHINKEN.STATUS.ACKNOWLEDGED:
                switch ( _code ) {
                    case SHINKEN.STATUS.ACKNOWLEDGED.CODE:
                    case SHINKEN.STATUS.INHERITED_ACKNOWLEDGED.CODE:
                    case SHINKEN.STATUS.PARTIAL_ACKNOWLEDGED.CODE:
                        return true;
                }
                break;
            case SHINKEN.STATUS.DOWNTIME:
                switch ( _code ) {
                    case SHINKEN.STATUS.DOWNTIME.CODE:
                    case SHINKEN.STATUS.INHERITED_DOWNTIME.CODE:
                    case SHINKEN.STATUS.PARTIAL_DOWNTIME.CODE:
                        return true;
                }
                break;
            case SHINKEN.STATUS.FLAPPING:
                switch ( _code ) {
                    case SHINKEN.STATUS.FLAPPING.CODE:
                    case SHINKEN.STATUS.PARTIAL_FLAPPING.CODE:
                        return true;
                }
                break;
            case SHINKEN.STATUS.DISABLED:
                switch ( _code ) {
                    case SHINKEN.STATUS.DISABLED.CODE:
                        return true;
                }
                break;
            case SHINKEN.STATUS.NOTHING:
                switch ( _code ) {
                    case SHINKEN.STATUS.NOTHING.CODE:
                        return true;
                }
                break;
        }
        return false;
    };
    
    return self;
})( SHINKEN.StatusService  || {} );
SHINKEN.Status = function () {
};
SHINKEN.Status.prototype = {
    setCode      : function ( toSet ) {
        this.code = toSet;
        this.key  = SHINKEN.STATUS.CODE_TO_KEY[ this.code ];
        this.initEnd();
    },
    setKey       : function ( toSet ) {
        this.key  = toSet;
        this.code = SHINKEN.STATUS[ this.key ].CODE;
        this.initEnd();
    },
    initEnd      : function ( toSet ) {
        this.setName();
        this.priority = SHINKEN.STATUS[ this.key ].PRIORITY;
        this.label    = this.name;
        this.buildPath();
    },
    getCode      : function () {
        return this.code;
    },
    getLabel     : function () {
        return this.label;
    },
    getName      : function () {
        return this.name;
    },
    getPriority  : function () {
        return this.priority;
    },
    is           : function ( type ) {
        return this.isByCode( type.CODE );
    },
    isByCode     : function ( code ) {
        return this.code === code;
    },
    getPath      : function () {
        return this.path;
    },
    setPathExtra : function ( name ) {
    },
    getClass     : function () {
        var _to_return = this.getName();
        if ( this.is_inherited ) {
            _to_return = 'inherited-' + _to_return;
        }
        return _to_return;
    },
    setName      : function () {
        this.name = SHINKEN.STATUS[ this.key ].NAME;
    },
    equals       : function ( status ) {
        if ( !status ) {
            return false;
        }
        if ( status.code !== this.code ) {
            return false;
        }
        if ( this.path_extra && status.path_extra && this.path_extra !== status.path_extra ) {
            return false;
        }
        return true;
    },
    buildPath    : function () {
        if ( this.name === SHINKEN.STATUS.NOTHING.NAME ) {
            this.path = '';
        }
        else  {
            this.path = '/static/' + __SHINKEN_HTTP_START_TIME__ + '/img/icons/' + this.name + '.svg';
        }
    },
    buildHtml    : function () {
    },
    getCodeSample: function () {
        switch ( this.code ) {
            case  SHINKEN.STATUS.INHERITED_DOWNTIME.CODE:
            case  SHINKEN.STATUS.PARTIAL_DOWNTIME.CODE:
                return SHINKEN.STATUS.DOWNTIME.CODE;
            case  SHINKEN.STATUS.INHERITED_ACKNOWLEDGED.CODE:
            case  SHINKEN.STATUS.PARTIAL_ACKNOWLEDGED.CODE:
                return SHINKEN.STATUS.ACKNOWLEDGED.CODE;
            case  SHINKEN.STATUS.PARTIAL_FLAPPING.CODE:
                return SHINKEN.STATUS.FLAPPING.CODE;
        }
        return this.code;
    },
    getNameSample: function () {
        switch ( this.code ) {
            case  SHINKEN.STATUS.INHERITED_DOWNTIME.CODE:
            case  SHINKEN.STATUS.PARTIAL_DOWNTIME.CODE:
                return SHINKEN.STATUS.DOWNTIME.NAME;
            case  SHINKEN.STATUS.INHERITED_ACKNOWLEDGED.CODE:
            case  SHINKEN.STATUS.PARTIAL_ACKNOWLEDGED.CODE:
                return SHINKEN.STATUS.ACKNOWLEDGED.NAME;
            case  SHINKEN.STATUS.PARTIAL_FLAPPING.CODE:
                return SHINKEN.STATUS.FLAPPING.NAME;
        }
        return this.name;
    }
};
SHINKEN.STATUS = {
    OK                        : {
        CODE    : 0,
        NAME    : 'ok',
        KEY     : 'OK',
        PRIORITY: 0,
        ORDER   : 0,
        TYPE    : 'status',
        PATH    : 'assets/images/status/ok.svg'
    },
    WARNING                   : {
        CODE    : 1,
        NAME    : 'warning',
        KEY     : 'WARNING',
        PRIORITY: 2,
        ORDER   : 1,
        TYPE    : 'status',
        PATH    : 'assets/images/status/warning.svg'
    },
    CRITICAL                  : {
        CODE    : 2,
        NAME    : 'critical',
        KEY     : 'CRITICAL',
        PRIORITY: 3,
        ORDER   : 2,
        TYPE    : 'status',
        PATH    : 'assets/images/status/critical.svg'
    },
    UNKNOWN                   : {
        CODE    : 3,
        NAME    : 'unknown',
        KEY     : 'UNKNOWN',
        PRIORITY: 1,
        ORDER   : 3,
        TYPE    : 'status',
        PATH    : 'assets/images/status/unknown.svg'
    },
    MISSING_DATA              : {
        CODE    : 4,
        NAME    : 'missing-data',
        KEY     : 'MISSING_DATA',
        PRIORITY: 0,
        ORDER   : 4,
        TYPE    : 'status'
    },
    PENDING                   : {
        CODE    : 4,
        NAME    : 'missing-data',
        KEY     : 'MISSING_DATA',
        PRIORITY: 0,
        ORDER   : 4,
        TYPE    : 'status'
    },
    SHINKEN_INACTIVE          : {
        CODE    : 5,
        NAME    : 'shinken-inactive',
        KEY     : 'SHINKEN_INACTIVE',
        PRIORITY: 0,
        ORDER   : 5,
        TYPE    : 'status'
    },
    NOTHING                   : {
        CODE    : 'NOTHING',
        NAME    : 'nothing',
        PRIORITY: 0,
        ORDER   : 0,
        TYPE    : 'context'
    },
    ACKNOWLEDGED              : {
        CODE    : 'ACKNOWLEDGED',
        NAME    : 'acknowledged',
        PRIORITY: 15,
        ORDER   : 1,
        TYPE    : 'context'
    },
    PARTIAL_ACKNOWLEDGED      : {
        CODE    : 'PARTIAL-ACKNOWLEDGED',
        NAME    : 'partial-acknowledged',
        PRIORITY: 19,
        ORDER   : 2,
        TYPE    : 'context'
    },
    INHERITED_ACKNOWLEDGED    : {
        CODE    : 'INHERITED-ACKNOWLEDGED',
        NAME    : 'inherited-acknowledged',
        PRIORITY: 10,
        ORDER   : 2,
        TYPE    : 'context'
    },
    DOWNTIME                  : {
        CODE    : 'DOWNTIME',
        NAME    : 'downtime',
        PRIORITY: 35,
        ORDER   : 3,
        TYPE    : 'context',
        PATH    : 'assets/images/status/downtime.svg'
    },
    PARTIAL_DOWNTIME          : {
        CODE    : 'PARTIAL-DOWNTIME',
        NAME    : 'partial-downtime',
        PRIORITY: 39,
        ORDER   : 3,
        TYPE    : 'context'
    },
    INHERITED_DOWNTIME        : {
        CODE    : 'INHERITED-DOWNTIME',
        NAME    : 'inherited-downtime',
        PRIORITY: 30,
        ORDER   : 3,
        TYPE    : 'context'
    },
    FLAPPING                  : {
        CODE    : 'FLAPPING',
        NAME    : 'flapping',
        PRIORITY: 25,
        ORDER   : 4,
        TYPE    : 'context'
    },
    PARTIAL_FLAPPING          : {
        CODE    : 'PARTIAL-FLAPPING',
        NAME    : 'partial-flapping',
        PRIORITY: 29,
        ORDER   : 5,
        TYPE    : 'context'
    },
    DISABLED                  : {
        CODE    : 'DISABLED',
        NAME    : 'disabled',
        PRIORITY: 404,
        ORDER   : 6,
        TYPE    : 'context'
    },
    STATUS_COUNT              : 6,
    CODE_TO_KEY               : {
        0                       : 'OK',
        1                       : 'WARNING',
        2                       : 'CRITICAL',
        3                       : 'UNKNOWN',
        4                       : 'MISSING_DATA',
        5                       : 'SHINKEN_INACTIVE',
        NOTHING                 : 'NOTHING',
        ACKNOWLEDGED            : 'ACKNOWLEDGED',
        'PARTIAL-ACKNOWLEDGED'  : 'PARTIAL_ACKNOWLEDGED',
        'INHERITED-ACKNOWLEDGED': 'INHERITED_ACKNOWLEDGED',
        DOWNTIME                : 'DOWNTIME',
        'PARTIAL-DOWNTIME'      : 'PARTIAL_DOWNTIME',
        'INHERITED-DOWNTIME'    : 'INHERITED_DOWNTIME',
        FLAPPING                : 'FLAPPING',
        'PARTIAL-FLAPPING'      : 'PARTIAL_FLAPPING',
        DISABLED                : 'DISABLED'
    },
    NAME_TO_CODE              : {
        ok      : 0,
        warning : 1,
        critical: 2,
        unknown : 3
    },
    LIST_CONTEXT_WIDGET_DETAIL: {
        0: 'NOTHING',
        1: 'ACKNOWLEDGED',
        2: 'FLAPPING',
        3: 'DOWNTIME'
    },
    TYPE                      : {
        STATUS : 'status',
        CONTEXT: 'context'
    }
    
};
CONTROLLER.Help = (function ( self ) {
    "use strict";
    self._dom_element_help = null;
    self.toggleHelp        = function ( event ) {
        event.preventDefault();
        event.stopPropagation();
        if ( !self._dom_element_help ) {
            self._dom_element_help = document.getElementById( 'id-shinken-help-pop-up' );
            self._dom_element_help.classList.remove( 'shinken-hidden' );
            return;
        }
        self._dom_element_help.classList.toggle( 'shinken-hidden' );
    };
    self.closeHelp         = function () {
        if ( !self._dom_element_help ) {
            return;
        }
        self._dom_element_help.classList.add( 'shinken-hidden' );
    };
    return self;
})( CONTROLLER.Help || {} );
MANAGER.HelpGenerator = (function ( self ) {
    "use strict";
    self.content                   = [];
    self.size                      = 0;
    self.init                              = function (type_trad) {
        self.type_trad = type_trad;
        self.initContent();
        if ( !self.size ) {
            return;
        }
        self.buildButtonHtml();
        self.buildContentHtml();
        self.initEventListener();
    };
    self.initContent               = function () {
        var _found = document.querySelectorAll( ".shinken-help-container .shinken-help-content" );
        for ( var i = 0, _size_i = _found.length; i < _size_i; i++ ) {
            self.content.push( new OBJECT.Help( _found[ i ] ) );
            DOM.Service.removeElement( _found[ i ] );
        }
        self.size    = self.content.length;
        self.content = SHINKEN.TOOLS.ARRAY.sortArrayMultiple( self.content, [ "order_tab", "name_tab", "order" ] );
    };
    self.initEventListener         = function () {
        document.addEventListener( 'keydown', function ( event ) {
            MANAGER.EventManager.keydown( event );
        } );
    };
    self.buildButtonHtml           = function () {
        var _button_f1       = DOM.Service.createElement( 'div', { class: "shinken-help-button-container", onclick: "CONTROLLER.Help.toggleHelp(event)", 'data-name': "toggle_help" } );
        _button_f1.innerHTML = '<button class="shinken-button"><table><tr><td><span class="key">F1</span></td><td>' + _( 'common.help.label', self.type_trad ) + '</td></tr></table></button>';
        document.body.appendChild( _button_f1 );
    };
    self.buildContentHtml          = function (class_to_add) {
        var _content_to_html  = DOM.Service.createElement( 'div', {
            id     : "id-shinken-help-pop-up",
            class  : "shinken-hidden " + class_to_add,
            onclick: "MANAGER.EventManager.stopPropagation(event)"
        } );
        var _container_html   = DOM.Service.createElement( 'div', { class: "shinken-help-container" } );
        var _container_html_2 = DOM.Service.createElement( 'div', { class: "shinken-help-container-2" } );
        var _container_html_3 = DOM.Service.createElement( 'div', { class: "shinken-help-container-3" },
            "<div class='shinken-text-centred'><div class='shinken-help-title'>" + _( 'common.help.label', self.type_trad ) + "</div></div>" );
        var _current_tab;
        var _current_tab_name = "";
        for ( var i = 0, _size_i = self.size; i < _size_i; i++ ) {
            if ( _current_tab_name !== self.content[ i ].tab ) {
                _current_tab_name = self.content[ i ].tab;
                _current_tab      = WINDOW.ElementService.getWindowTargetHtml( 'div', _current_tab_name, !i );
                _container_html_3.appendChild( _current_tab );
            }
            _current_tab.appendChild( self.content[ i ].getHtml() );
        }
        _content_to_html.appendChild( _container_html );
        _container_html.appendChild( _container_html_2 );
        _container_html_2.appendChild( self.buildWindowsLineHtml() );
        _container_html_2.appendChild( _container_html_3 );
        document.body.appendChild( _content_to_html );
        document.body.appendChild( _content_to_html );
    };
    self.buildWindowsLineHtml      = function () {
        var _to_return = DOM.Service.createElement( 'div', {
            class      : "shinken-help-windows-title-menu shinken-window-group",
            "data-name": "help-group",
            onclick    : "MANAGER.EventManager.clickOnWindowNavigation(event,'help-group')"
        } );
        var _tab_list  = SHINKEN.TOOLS.ARRAY.extractKeys( this.content, [ 'tab', 'name_tab' ], true, true );
        _tab_list      = SHINKEN.TOOLS.ARRAY.removeDuplicateArray( _tab_list );
        _tab_list      = self.concatDuplicationWindowID( _tab_list );
        var _current;
        for ( var i = 0, _size_i = _tab_list.length; i < _size_i; i++ ) {
            _current = _tab_list[ i ];
            _to_return.appendChild( WINDOW.ElementService.getWindowHtml( "div", _current[ 0 ], _current[ 1 ], "help-group", !i ) );
        }
        var _button_close = DOM.Service.createElement( 'div', { class: "shinken-help-close-button shinkon-times-bold", onclick: "CONTROLLER.Help.toggleHelp(event)" } );
        _to_return.appendChild( _button_close );
        return _to_return;
    };
    self.concatDuplicationWindowID = function ( tab_list ) {
        var _to_return = [];
        var _mapping   = {};
        var _current;
        var _index;
        for ( var i = 0, _size_i = tab_list.length; i < _size_i; i++ ) {
            _current = tab_list[ i ];
            if ( _mapping[ _current[ 0 ] ] ) {
                _index                    = _mapping[ _current[ 0 ] ] - 1;
                _to_return[ _index ][ 1 ] = _to_return[ _index ][ 1 ] + SHINKEN.TOOLS.STRING.CONST.WHITE_SPACE + _current[ 1 ];
            }
            else {
                _mapping[ _current[ 0 ] ] = _to_return.push( _current );
            }
        }
        return _to_return;
    };
    return self;
})( MANAGER.HelpGenerator || {} );
OBJECT.Help = function ( dom_element ) {
    this.dom_element = dom_element;
    this.tab         = dom_element.dataset.tab;
    this.order       = parseInt( dom_element.dataset.order ) || 1;
    this.order_tab   = parseInt( dom_element.dataset.tabOrder ) || 1;
    this.name_tab    = dom_element.dataset.tabName || "??";
};
OBJECT.Help.prototype = {
    getHtml: function () {
        return this.dom_element;
    }
};
SHINKEN.TOOLS.NOTIFICATION = {};
SHINKEN.TOOLS.NOTIFICATION = (function ( self ) {
    "use strict";
    
    var __instance_notification_container = new SHINKEN.OBJECT.NOTIFICATION.Container();
    
    
    
    self.cleanAllNotification   = function () {
        __instance_notification_container.cleanAllNotification();
    };
    self.addNotification        = function ( message, status, element_to_bind_with, notification_placement, time_before_remove ) {
        __instance_notification_container.init();
        __instance_notification_container.addNotification( message, status, element_to_bind_with, notification_placement, time_before_remove );
    };
    self.addNotificationStyled  = function ( message, status, styles, time_before_remove ) {
        __instance_notification_container.init();
        __instance_notification_container.addNotificationStyled( message, status, styles, time_before_remove );
    };
    self.addNotificationForSave = function ( message, status ) {
        __instance_notification_container.init();
        __instance_notification_container.addNotificationStyled(
            message,
            status,
            {
                top            : '172px',
                right          : '10px',
                padding        : '2px 5px 2px 5px',
                'border-radius': '3px'
            },
            2500 );
    };
    return self;
})( SHINKEN.TOOLS.NOTIFICATION || {} );
var SHINKEN_GRID   = {};
SHINKEN_GRID.CONST = {
    PARAM: {
        GRID     : {
            SHINKEN_GRID_UUID              : 'shinken_grid_uuid',
            TYPE                           : 'type',
            GRID_ELEMENTS                  : 'grid_elements',
            DEFAULT_CONFIGURATION          : 'layouts',
            ORDERING                       : 'ordering',
            TILES_MAX_X                    : 'nb_tiles_in_width',
            TILES_MAX_Y                    : 'nb_tiles_in_height',
            SEPARATION_GRID_ELEMENT_MIN    : 'separation_grid_element_min',
            SEPARATION_GRID_ELEMENT_MAX    : 'separation_grid_element_max',
            SEPARATION_GRID_ELEMENT_PERCENT: 'separation_grid_element_percent'
        },
        GRID_CELL: {
            SHINKEN_GRID_CELL_UUID: 'shinken_grid_cell_uuid',
            POSITION_X            : 'position_x',
            POSITION_Y            : 'position_y',
            HEIGHT                : 'height',
            WIDTH                 : 'width',
            CONTENT               : 'content'
        }
    },
    WEATHER_WIDGET_LAYOUT  : {
        CONTENT       : 'content',
        CONTENT_VALUES: {
            PROPERTY_USED_AS_NAME: 'property_used_as_name',
            STATE_ICON           : 'state_icon',
            BACKGROUND           : 'background',
            DISPLAY_SLA          : 'display_sla'
        }
    },
    SPECIAL_VALUE: {
        SEPARATION_GRID_ELEMENT_MAX_UNLIMITED       : 'unlimited'
    },
    SEPARATOR_WIDGET_LAYOUT: {
        CONTENT       : 'content',
        CONTENT_VALUES: {
            TEXT_COLOR: 'text_color'
        }
    },
    TITLE_WIDGET_LAYOUT    : {
        CONTENT       : 'content',
        CONTENT_VALUES: {
            TEXT_COLOR: 'text_color'
        }
    }
};
SHINKEN_GRID.Cell           = function ( data ) {
    this.init( data );
};
SHINKEN_GRID.Cell.prototype = {
    init: function ( data ) {
        this.position_x = 0;
        this.position_y = 0;
        this.content    = "";
        this.class      = "shinken-grid-cell shinken-draggable";
        this.type       = "default";
        this.uuid       = SHINKEN.TOOLS.STRING.buildUUID();
        this.updateData( data );
    },
    
    getClosestPosition: function () {
        var _x = DOM.Service.getBoundingClientRect( this.dom_element, DOM.CONST.STYLE.LEFT );
        var _y = DOM.Service.getBoundingClientRect( this.dom_element, DOM.CONST.STYLE.TOP );
        this.setPosition( Math.round( _x / this.tile_pixel_size ), Math.round( _y / this.tile_pixel_size ) );
    },
    setPosition       : function ( new_x, new_y ) {
        this.position_x = Math.max( 0, Math.min( this[ SHINKEN_GRID.CONST.PARAM.GRID.TILES_MAX_X ] - this.getComputedWidth(), new_x ) );
        this.position_y = Math.max( 0, new_y );
        DOM.Service.setStyles( this.dom_element, { "top": this.position_y * this.tile_pixel_size, "left": this.position_x * this.tile_pixel_size } );
    },
    getChildrenObject    : function () {
        return [this.content];
    },
    getChildrenObjectDict: function () {
        var _to_return                                           = {};
        _to_return[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.CONTENT ] = this.content;
        return _to_return;
    },
    _getObjectToJson     : function () {
        var _to_return                                              = {};
        _to_return[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_X ] = this[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_X ];
        _to_return[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_Y ] = this[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_Y ];
        _to_return[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.WIDTH ]      = this[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.WIDTH ];
        _to_return[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.HEIGHT ]     = this[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.HEIGHT ];
        return _to_return;
    },
    
    computeMapping: function ( mapping ) {
        if ( this.content ) {
            this.content.computeMapping( mapping );
        }
    },
    updateSize    : function ( tile_pixel_size ) {
        this.tile_pixel_size = tile_pixel_size;
        DOM.Service.setStyles( this.dom_element, this.getStyle() );
        this.dom_element.className = this.getClass();
        this.content.updateSize();
    },
    
    
    computeHtml     : function ( shinken_grid, extra_class ) {
        if ( extra_class ){
            this.class += " " + extra_class;
        }
        this.tile_pixel_size                                                  = shinken_grid.tile_pixel_size;
        this[ SHINKEN_GRID.CONST.PARAM.GRID.TILES_MAX_X ]                     = shinken_grid[ SHINKEN_GRID.CONST.PARAM.GRID.TILES_MAX_X ];
        this[ SHINKEN_GRID.CONST.PARAM.GRID.SEPARATION_GRID_ELEMENT_MIN ]     = shinken_grid[ SHINKEN_GRID.CONST.PARAM.GRID.SEPARATION_GRID_ELEMENT_MIN ];
        this[ SHINKEN_GRID.CONST.PARAM.GRID.SEPARATION_GRID_ELEMENT_MAX ]     = shinken_grid[ SHINKEN_GRID.CONST.PARAM.GRID.SEPARATION_GRID_ELEMENT_MAX ];
        this[ SHINKEN_GRID.CONST.PARAM.GRID.SEPARATION_GRID_ELEMENT_PERCENT ] = shinken_grid[ SHINKEN_GRID.CONST.PARAM.GRID.SEPARATION_GRID_ELEMENT_PERCENT ];
        
        this.dom_element = DOM.Service.createElement( "div", this.getAttribute() );
        
        var _to_add_container = DOM.Service.createElement( "div", { class: 'shinken-grid-cell-container shinken-height-100' } );
        
        
        DOM.Service.addElementTo( _to_add_container, this.dom_element );
        DOM.Service.addElementTo( this.dom_element, shinken_grid.dom_element );
        this.content.setDomElementParent( _to_add_container );
        this.content.computeHtml( this.tile_pixel_size * this.getComputedWidth(), this.tile_pixel_size * this.height );
    },
    getAttribute    : function () {
        var _to_return = {
            class: this.getClass(),
            style: DOM.Service.styleToHtml( this.getStyle() ),
            id   : this.uuid
        };
        return _to_return;
    },
    getClass        : function () {
        var _to_return     = this.class;
        var _computed_size = this.tile_pixel_size * this.getComputedWidth();
        return _to_return;
    },
    getComputedWidth: function () {
        return this.width === "all" ? this[ SHINKEN_GRID.CONST.PARAM.GRID.TILES_MAX_X ] : this.width;
    },
    getStyle        : function () {
        var _to_return                       = {};
        _to_return[ DOM.CONST.STYLE.WIDTH ]  = this.tile_pixel_size * this.getComputedWidth();
        _to_return[ DOM.CONST.STYLE.HEIGHT ] = this.tile_pixel_size * this.height;
        _to_return[ DOM.CONST.STYLE.TOP ]    = this.tile_pixel_size * this.position_y;
        _to_return[ DOM.CONST.STYLE.LEFT ]   = this.tile_pixel_size * this.position_x;
    
        var _padding = parseInt( DOM.BodyService.getWidth() * this[ SHINKEN_GRID.CONST.PARAM.GRID.SEPARATION_GRID_ELEMENT_PERCENT ] / 100 );
        if ( !_to_return[ DOM.CONST.STYLE.WIDTH ]  || ! _to_return[ DOM.CONST.STYLE.HEIGHT ] ){
            _padding = 0;
        }
        else {
            if ( this[ SHINKEN_GRID.CONST.PARAM.GRID.SEPARATION_GRID_ELEMENT_MAX ] !== SHINKEN_GRID.CONST.SPECIAL_VALUE.SEPARATION_GRID_ELEMENT_MAX_UNLIMITED ) {
                _padding = Math.min( _padding, this[ SHINKEN_GRID.CONST.PARAM.GRID.SEPARATION_GRID_ELEMENT_MAX ] );
            }
            _padding                              = Math.max( _padding, this[ SHINKEN_GRID.CONST.PARAM.GRID.SEPARATION_GRID_ELEMENT_MIN ] );
            
        }
        _to_return[ DOM.CONST.STYLE.PADDING ] = _padding / 2;
        return _to_return;
    },
    updateData : function ( data ) {
        if ( !data ) {
            return;
        }
        var _keys     = Object.keys( data );
        var _sizeData = _keys.length;
        var _currentKey;
        for ( var i = 0; i < _sizeData; i++ ) {
            _currentKey = _keys[ i ];
            this.setData( _currentKey, data[ _currentKey ] );
        }
    },
    setData    : function ( key, value ) {
        switch ( key ) {
            case SHINKEN_GRID.CONST.PARAM.GRID_CELL.SHINKEN_GRID_CELL_UUID:
            case SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_X:
            case SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_Y:
            case SHINKEN_GRID.CONST.PARAM.GRID_CELL.HEIGHT:
            case SHINKEN_GRID.CONST.PARAM.GRID_CELL.WIDTH:
                this[ key ] = value;
                break;
            case SHINKEN_GRID.CONST.PARAM.GRID_CELL.CONTENT:
                this.initContent( value );
                break;
            case SHINKEN.OBJECT.CONST.VALIDATION.FIELD.MESSAGES:
                this.setMessages( value );
                break;
        }
    },
    initContent: function ( data ) {
        this.content = WIDGET.factory( data );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_GRID.Cell, SHINKEN.OBJECT.ShinkenObjectJson );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_GRID.Cell, SHINKEN.OBJECT.InterfaceHtml );
SHINKEN_GRID.Cells           = function ( data ) {
    this.init( data );
};
SHINKEN_GRID.Cells.prototype = {
    init: function ( data ) {
        this.content      = [];
        this.mapping_uuid = {};
        if ( data ) {
            this.initData( data );
        }
    },
    
    computeNewPosition: function ( uuid ) {
        if ( this.mapping_uuid[ uuid ] ) {
            this.mapping_uuid[ uuid ].getClosestPosition();
        }
    },
    getChildrenObject    : function () {
        return this.content;
    },
    getChildrenObjectDict: function () {
        return this.content;
    },
    
    computeMapping: function ( mapping ) {
        for ( var i = 0, _size_i = this.content.length; i < _size_i; i++ ) {
            this.content[ i ].computeMapping( mapping );
        }
    },
    updateSize    : function ( tile_pixel_size ) {
        for ( var i = 0, _size_i = this.content.length; i < _size_i; i++ ) {
            this.content[ i ].updateSize( tile_pixel_size );
        }
    },
    
    computeHtml: function ( shinken_grid, extra_class ) {
        for ( var i = 0, _size_i = this.content.length; i < _size_i; i++ ) {
            DOM.Service.addElementTo( this.content[ i ].computeHtml( shinken_grid, extra_class ) );
        }
    },
    initData      : function ( data ) {
        for ( var i = 0, _size_i = data.length; i < _size_i; i++ ) {
            this.addCell( data[ i ] );
        }
    },
    addCell       : function ( data ) {
        var _to_return = new SHINKEN_GRID.Cell( data );
        this.content.push( _to_return );
        this.mapping_uuid[ _to_return.uuid ] = _to_return;
        return _to_return;
    },
    addHiddenCell : function ( pos_x, pos_y ) {
        var data                                              = {};
        data[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_X ] = pos_x;
        data[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_Y ] = pos_y;
        data[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.HEIGHT ]     = 1;
        data[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.WIDTH ]      = 1;
        data[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.CONTENT ]    = { type: WIDGET.CONST.WIDGET_TYPE.SHINKEN_GRID_STRUCTURE, content: pos_x + "-" + pos_y };
        var _cell                                             = this.addCell( data );
        _cell.type                                            = WIDGET.CONST.WIDGET_TYPE.SHINKEN_GRID_STRUCTURE;
        _cell.addClass( WIDGET.CONST.WIDGET_TYPE.SHINKEN_GRID_STRUCTURE );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_GRID.Cells, SHINKEN.OBJECT.ShinkenObjectJson );
SHINKEN_GRID.Grid           = function ( data ) {
    this.init( data );
};
SHINKEN_GRID.Grid.prototype = {
    init: function ( data ) {
        this.uuid            = SHINKEN.TOOLS.STRING.buildUUID();
        this.tile_pixel_size = 0;
        this.updateData( data );
    },
    onMouseMove : function ( event ) {
    },
    onMouseLeave: function ( event ) {
    },
    onScroll    : function ( event ) {
    },
    getChildrenObject      : function () {
        return [this.cells, this[ SHINKEN_GRID.CONST.PARAM.GRID.DEFAULT_CONFIGURATION ]];
    },
    getChildrenObjectDict  : function () {
        var to_return                                                    = {};
        to_return[ SHINKEN_GRID.CONST.PARAM.GRID.GRID_ELEMENTS ]         = this.cells;
        to_return[ SHINKEN_GRID.CONST.PARAM.GRID.DEFAULT_CONFIGURATION ] = this[ SHINKEN_GRID.CONST.PARAM.GRID.DEFAULT_CONFIGURATION ];
        return to_return;
    },
    _getObjectToJson       : function () {
        var to_return                                                              = {};
        to_return[ SHINKEN_GRID.CONST.PARAM.GRID.ORDERING ]                        = this[ SHINKEN_GRID.CONST.PARAM.GRID.ORDERING ];
        to_return[ SHINKEN_GRID.CONST.PARAM.GRID.TILES_MAX_X ]                     = this[ SHINKEN_GRID.CONST.PARAM.GRID.TILES_MAX_X ];
        to_return[ SHINKEN_GRID.CONST.PARAM.GRID.TILES_MAX_Y ]                     = this[ SHINKEN_GRID.CONST.PARAM.GRID.TILES_MAX_Y ];
        to_return[ SHINKEN_GRID.CONST.PARAM.GRID.SEPARATION_GRID_ELEMENT_MAX ]     = this[ SHINKEN_GRID.CONST.PARAM.GRID.SEPARATION_GRID_ELEMENT_MAX ];
        to_return[ SHINKEN_GRID.CONST.PARAM.GRID.SEPARATION_GRID_ELEMENT_MIN ]     = this[ SHINKEN_GRID.CONST.PARAM.GRID.SEPARATION_GRID_ELEMENT_MIN ];
        to_return[ SHINKEN_GRID.CONST.PARAM.GRID.SEPARATION_GRID_ELEMENT_PERCENT ] = this[ SHINKEN_GRID.CONST.PARAM.GRID.SEPARATION_GRID_ELEMENT_PERCENT ];
        to_return[ SHINKEN_GRID.CONST.PARAM.GRID.TYPE ]                            = this[ SHINKEN_GRID.CONST.PARAM.GRID.TYPE ];
        return to_return;
    },
    setDefaultConfiguration: function ( value ) {
        this[ SHINKEN_GRID.CONST.PARAM.GRID.DEFAULT_CONFIGURATION ] = new SHINKEN.OBJECT.DefaultConfiguration( value );
    },
    computeNewPosition: function ( uuid ) {
        this.cells.computeNewPosition( uuid );
    },
    computeMapping    : function ( mapping ) {
        if ( this.cells ) {
            this.cells.computeMapping( mapping );
        }
    },
    computeSizes      : function () {
        this.updateStyle();
        this.computeTileSize();
        this.cells.updateSize( this.tile_pixel_size );
        if ( this.cells_documentation ) {
            this.cells_documentation.updateSize( this.tile_pixel_size );
        }
        
    },
    computeTileSize   : function () {
        this.tile_pixel_size = DOM.Service.getBoundingClientRect( this.dom_element, DOM.CONST.STYLE.WIDTH ) / this[ SHINKEN_GRID.CONST.PARAM.GRID.TILES_MAX_X ];
    },
    
    
    initDomElementHtml: function ( dom_parent ) {
        this.dom_element = DOM.Service.createElement( "div", { id: "id-shinken-" + this.uuid, class: "shinken-grid" } );
    },
    computeHtml       : function ( dom_parent ) {
        this.initDomElementHtml();
        DOM.Service.addElementTo( this.dom_element, dom_parent );
        DOM.Service.setDataSet( this.dom_element, 'gridUuid', this.uuid );
        
        this.computeTileSize();
        if ( this.cells_documentation ) {
            this.cells_documentation.computeHtml( this, "shinken-grid-structure" );
        }
        this.cells.computeHtml( this );
        this.updateStyle();
    },
    getComputedStyle  : function () {
        var _to_return                       = {};
        _to_return[ DOM.CONST.STYLE.HEIGHT ] = 0;
        return _to_return;
    },
    updateStyle       : function ( force_hidden ) {
        DOM.Service.setStyles( this.dom_element, this.getComputedStyle() );
    },
    updateData              : function ( data ) {
        if ( !data ) {
            return;
        }
        
        var _keys     = Object.keys( data );
        var _sizeData = _keys.length;
        var _currentKey;
        for ( var i = 0; i < _sizeData; i++ ) {
            _currentKey = _keys[ i ];
            if ( _currentKey !== SHINKEN_GRID.CONST.PARAM.GRID.GRID_ELEMENTS ) {
                this.setData( _currentKey, data[ _currentKey ] );
            }
        }
        if ( data[ SHINKEN_GRID.CONST.PARAM.GRID.GRID_ELEMENTS ] ) {
            this.setData( SHINKEN_GRID.CONST.PARAM.GRID.GRID_ELEMENTS, data[ SHINKEN_GRID.CONST.PARAM.GRID.GRID_ELEMENTS ] );
        }
    },
    setData                 : function ( key, value ) {
        switch ( key ) {
            case SHINKEN_GRID.CONST.PARAM.GRID.SHINKEN_GRID_UUID:
            case SHINKEN_GRID.CONST.PARAM.GRID.TILES_MAX_X:
            case SHINKEN_GRID.CONST.PARAM.GRID.TILES_MAX_Y:
            case SHINKEN_GRID.CONST.PARAM.GRID.TYPE:
            case SHINKEN_GRID.CONST.PARAM.GRID.SEPARATION_GRID_ELEMENT_MIN:
            case SHINKEN_GRID.CONST.PARAM.GRID.SEPARATION_GRID_ELEMENT_MAX:
            case SHINKEN_GRID.CONST.PARAM.GRID.SEPARATION_GRID_ELEMENT_PERCENT:
                this[ key ] = value;
                break;
            case SHINKEN_GRID.CONST.PARAM.GRID.DEFAULT_CONFIGURATION:
                this.setDefaultConfiguration( value );
                break;
            case SHINKEN_GRID.CONST.PARAM.GRID.GRID_ELEMENTS:
                this.initCellsGrid( value );
                break;
            case SHINKEN.OBJECT.CONST.VALIDATION.FIELD.MESSAGES:
                this.setMessages( value );
                break;
            default:
                if ( !this.setDataOnInheritedObject( key, value ) ) {
                    console.warn( "[IGNORED DATA]", key, value );
                    this.setUnknownValue( key, value );
                }
                break;
        }
    },
    setDataOnInheritedObject: function ( key, value ) {
        return false;
    },
    initCellsGrid           : function ( data ) {
        this.cells                 = new SHINKEN_GRID.Cells( data );
    }
    
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_GRID.Grid, SHINKEN.OBJECT.ShinkenObjectJson );
SHINKEN_GRID.Grids           = function ( default_values ) {
    this.default_values = default_values;
};
SHINKEN_GRID.Grids.prototype = {
    init: function ( data ) {
        this.content = [];
        this.type    = null;
        this._initGrid( data );
        this._computeMapping();
    },
    computeNewPosition: function ( uuid ) {
        for ( var i = 0, _size_i = this.content.length; i < _size_i; i++ ) {
            this.content[ i ].computeNewPosition( uuid );
        }
    },
    onMouseMove       : function ( event ) {
        var _parent_dom_element = DOM.Service.findParentElementWithClass( event.target, 'shinken-parent-mouse-move-listener', 30 );
        if ( !_parent_dom_element ) {
            return;
        }
        this.getGridByUUID( _parent_dom_element.dataset.gridUuid ).onMouseMove( event );
    },
    onMouseLeave      : function ( event ) {
        var _parent_dom_element = DOM.Service.findParentElementWithClass( event.target, 'shinken-parent-mouse-leave-listener', 30 );
        if ( !_parent_dom_element ) {
            return;
        }
        this.getGridByUUID( _parent_dom_element.dataset.gridUuid ).onMouseLeave( event );
    },
    onScroll          : function ( event ) {
        for ( var i = 0, _size_i = this.content.length; i < _size_i; i++ ) {
            this.content[ i ].onScroll( event );
        }
    },
    mouseWheel        : function ( event ) {
        for ( var i = 0, _size_i = this.content.length; i < _size_i; i++ ) {
            this.content[ i ].mouseWheel( event );
        }
    },
    setType          : function ( to_set ) {
        this.type = to_set;
    },
    getGridByUUID    : function ( grid_uuid ) {
        return SHINKEN.TOOLS.ARRAY.findFirstElementWith( this.content, 'uuid', grid_uuid );
    },
    getChildrenObject: function () {
        return this.content;
    },
    getChildrenObjectDict   : function () {
        return this.content;
    },
    _computeMapping: function () {
        this.mapping_uuid_content = {};
        for ( var i = 0, _size_i = this.content.length; i < _size_i; i++ ) {
            this.content[ i ].computeMapping( this.mapping_uuid_content );
        }
    },
    computeSizes   : function () {
        for ( var i = 0, _size_i = this.content.length; i < _size_i; i++ ) {
            this.content[ i ].computeSizes();
        }
    },
    
    computeHtml: function ( dom_parent ) {
        this.dom_element = DOM.Service.createElement( "div", { class: "shinken-grids" } );
        DOM.Service.addElementTo( this.dom_element, dom_parent );
        for ( var i = 0, _size_i = this.content.length; i < _size_i; i++ ) {
            this.content[ i ].computeHtml( this.dom_element );
        }
    },
    reset            : function () {
        this.content = [];
        DOM.Service.removeElement( this.dom_element );
    },
    _initGrid        : function ( data ) {
        for ( var i = 0, _size_i = data.length; i < _size_i; i++ ) {
            this.content.push( new SHINKEN_GRID.Grid( this.default_values, data[ i ] ) );
        }
    },
    updateContentData: function ( data ) {
        var _keys = Object.keys( data );
        var _current_key;
        for ( let i = 0, _size = _keys.length; i < _size; i++ ) {
            _current_key = _keys[ i ];
            if ( this.mapping_uuid_content[ _current_key ] ) {
                for ( var j = 0, _size_j = this.mapping_uuid_content[ _current_key ].length; j < _size_j; j++ ) {
                    this.mapping_uuid_content[ _current_key ][ j ].updateData( data[ _current_key ] );
                }
            }
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_GRID.Grids, SHINKEN.OBJECT.ShinkenObjectJson );
WINDOW.ElementGroup           = function ( name ) {
    this.name = SHINKEN.TOOLS.STRING.escapeBackslash(name);
    this.list = {};
    this.init();
};
WINDOW.ElementGroup.prototype = {
    init                     : function () {
        this.dom_element = document.querySelector( '.' + WINDOW.CONST.CLASS.WINDOW_GROUP + '[data-name="' + this.name + '"]' );
        this.initWindows();
    },
    initWindows              : function () {
        var _dom_elements = this.dom_element.querySelectorAll( '.' + WINDOW.CONST.CLASS.WINDOW_TAB + '[data-group-name="' + this.name + '"]' );
        this.size         = _dom_elements.length;
        var _current;
        var _current_name;
        var _has_properties;
        for ( var i = 0; i < this.size; i++ ) {
            _current                   = _dom_elements[ i ];
            _current_name              = _current.dataset.name;
            _has_properties            = _current.dataset.hasProperties;
            this.list[ _current_name ] = _has_properties ? new WINDOW.ElementWithProperties( _current_name, _current ) : new WINDOW.Element( _current_name, _current );
            MANAGER.__instance_object_distributor.addObject( this.list[ _current_name ].getID(), this.list[ _current_name ] );
        }
    },
    getActiveWindow          : function () {
        var _keys = Object.keys( this.list );
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            if ( this.list[ _keys[ i ] ].is_active ) {
                return this.list[ _keys[ i ] ];
            }
        }
        return null;
    },
    clickOnWindow            : function ( window_name ) {
        var _keys = Object.keys( this.list );
        var _current;
        var current_window;
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current = this.list[ _keys[ i ] ];
            _current.setActive( _current.getName() === window_name );
            if ( _current.is_active ) {
                current_window = _current;
            }
        }
        if ( current_window.hasProperties() ) {
            MANAGER.ListenerEventManager.afterAction( MANAGER.CONST.AFTER_ACTION.UPDATE_VIEW_ON_WINDOW_PROPERTIES, window_name );
        }
    },
    getElementByID           : function ( id ) {
        var _keys = Object.keys( this.list );
        var _current;
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current = this.list[ _keys[ i ] ];
            if ( _current.getID() === id ) {
                return _current;
            }
        }
        return null;
    },
    getElementByName         : function ( name ) {
        var _keys = Object.keys( this.list );
        var _current;
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current = this.list[ _keys[ i ] ];
            if ( _current.getName() === name ) {
                return _current;
            }
        }
        return null;
    },
    setParentCounter         : function ( parent ) {
        var _keys = Object.keys( this.list );
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            this.list[ _keys[ i ] ].setParentCounter( parent );
        }
    },
    pulsateElementIfNotActive: function ( window_name ) {
        if ( this.getActiveWindow().getName() !== window_name ) {
            DOM.Service.askAddClass( this.getElementByName( window_name ).dom_element, 'shinken-pulsate', 2000 );
        }
    }
};
WINDOW.ElementService = (function ( self ) {
    self.getWindowTargetHtml = function ( dom_tag, tab_name, is_active ) {
        var _class_to_add = is_active ? "shinken-window-target" : "shinken-window-target shinken-hidden";
        var _to_return    = DOM.Service.createElement( dom_tag, { id: "id-shinken-window-" + tab_name + "-target", class: _class_to_add } );
        return _to_return;
    };
    self.getWindowHtml       = function ( dom_tag, window_id, label, group_name, is_active ) {
        var _class_to_add = is_active ? "shinken-window-element shinken-active" : "shinken-window-element";
        var _to_return    = DOM.Service.createElement( dom_tag, {
            class            : _class_to_add,
            "data-group-name": group_name,
            "data-name"      : window_id,
            id               : "id-shinken-window-" + window_id
        }, label );
        return _to_return;
    };
    return self;
})( WINDOW.ElementService || {} );
WINDOW.Element           = function ( name, dom_element, is_menu ) {
    this.__class_name__ = 'WINDOW.Element';
    this.name        = name;
    this.dom_element = dom_element;
    this.is_menu     = !!is_menu;
    this.init();
};
WINDOW.Element.prototype = {
    init          : function () {
        this.initDomElement();
        if ( this.is_menu ) {
            var _dom_element_counters = this.dom_element.querySelectorAll( '.shinken-counter' );
            this.counters             = {};
            var _current;
            for ( var i = 0, _size_i = _dom_element_counters.length; i < _size_i; i++ ) {
                _current                                      = _dom_element_counters[ i ];
                this.counters[ _current.dataset.counterType ] = new SHINKEN.OBJECT.Counter();
                this.counters[ _current.dataset.counterType ].init( _current );
            }
        }
        else {
            this.initCounters();
        }
    },
    initDomElement: function () {
        this.id = this.dom_element.getAttribute( 'id' );
        if ( this.is_menu ) {
            return;
        }
        if ( this.dom_element.classList.contains( "shinken-active" ) ) {
            this.is_active = true;
        }
        this.dom_element_target = document.getElementById( this.id + '-target' );
        if ( !this.dom_element_target ) {
            console.warn( "[LA STRUCTURE HTML des windows n'est pas correcte]", this.id, this.id + '-target  ==> not found' );
        }
    },
    getName       : function () {
        return this.name;
    },
    getID         : function () {
        return this.id;
    },
    setHasRequired: function ( to_set ) {
        if ( to_set ) {
            this.dom_element.querySelector( '.shinken-required-field' ).classList.remove( 'shinken-hidden' );
        }
    },
    setActive     : function ( to_set ) {
        this.is_active = to_set;
        if ( this.is_active ) {
            this.dom_element.classList.add( 'shinken-active' );
            this.dom_element_target.classList.remove( 'shinken-hidden' );
        }
        else {
            this.dom_element.classList.remove( 'shinken-active' );
            this.dom_element_target.classList.add( 'shinken-hidden' );
        }
    },
    hasProperties : function () {
        return false;
    },
    updateCounter : function ( name, value ) {
        this.counters[ name ].update( "counter", value );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( WINDOW.Element, SHINKEN.OBJECT.CounterInterface );
WINDOW.ElementWithProperties           = function ( name, dom_element, is_menu ) {
    this.__class_name__ = 'WINDOW.ElementWithProperties';
    
    this.name        = name;
    this.dom_element = dom_element;
    this.is_menu     = !!is_menu;
    this.init();
};
WINDOW.ElementWithProperties.prototype = {
    hasProperties: function () {
        return true;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( WINDOW.ElementWithProperties, WINDOW.Element );
