CONTROLLER.List = (function ( self ) {
    "use strict";
    self.controller_name            = MANAGER.CONST.CONTROLLER.LIST_ALL;
    self.init                       = function () {
        self.initDomElementFilters();
        //self.updateCleanButtonStatus();
        self.mass_action = new SHINKEN_LIST_MassAction( document.querySelector( '#id-shinken-table-mass-action' ) );
    };
    self.initDomElementFilters      = function () {
        var _dom_elements = document.querySelectorAll( '.shinken-list-filter-container' );
        var _current;
        for ( var i = 0, _size = _dom_elements.length; i < _size; i++ ) {
            _current = MANAGER.__instance_filter_distributor.findElement( _dom_elements[ i ].dataset.name, false, "", _dom_elements[ i ] );
            _current.initWhenInputReady();
        }
    };
    //********************************************  EVENT LISTENER  **************************************************//
    self.updateMassActonCountSelect = function ( datas ) {
        self.mass_action.updateMassActonCountSelect( datas );
    };
    self.hidePopup                  = function ( to_ignore ) {
        if ( to_ignore !== self.mass_action ) {
            self.mass_action.hidePopup();
        }
        if ( self._dom_element_help && to_ignore !== self._dom_element_help ) {
            self.setHelp( false );
        }
        MANAGER.__instance_filter_distributor.hidePopups();
        if ( MANAGER.DragNDropManager.single_element_drag ) {
            MANAGER.DragNDropManager.dragEndSingle();
        }
    };
    self.keydown                    = function ( event, key_code ) {
        if ( MANAGER.__instance_filter_distributor.getLastInstanceFocus() ) {
            switch ( key_code ) {
                case SHINKEN.CONST.KEY_CODE.F1:
                    self.toggleHelp( event );
                    break;
                case SHINKEN.CONST.KEY_CODE.ESCAPE:
                    self.hidePopup();
                    break;
                case SHINKEN.CONST.KEY_CODE.TAB:
                    setTimeout( function () {
                        var _parent_dom_element = DOM.Service.findParentElementWithClass( document.activeElement, "shinken-parent-event-listener", 50 );
                        var parent_name         = _parent_dom_element.dataset.name;
                        if ( MANAGER.__instance_filter_distributor.getLastInstanceFocus() ) {
                            clearTimeout( MANAGER.__instance_filter_distributor.getLastInstanceFocus().component.input.timeout_ask_compute_after_change );
                        }
                        MANAGER.__instance_filter_distributor.findElement( parent_name, true );
                        if ( MANAGER.__instance_filter_distributor.getLastInstanceFocus() ) {
                            MANAGER.__instance_filter_distributor.getLastInstanceFocus().askComputeAfterChange( MANAGER.__instance_filter_distributor.getLastInstanceFocus().component.input.dom_element, null, self.controller_name );
                        }
                    }, 0 );
                    break;
                default:
                    MANAGER.__instance_filter_distributor.getLastInstanceFocus().keydown( event, key_code );
                    //self.updateCleanButtonStatus();
                    break;
            }
        }
        else {
            switch ( key_code ) {
                case SHINKEN.CONST.KEY_CODE.F1:
                    if ( self._dom_element_help ) {
                        self._dom_element_help.classList.add( 'shinken-hidden' );
                    }
                    break;
            }
        }
    };
    self.updateCleanButtonStatus    = function () {
        var _dom_button_clean = MANAGER.__instance_button_distributor.findButton( "clean-filter-list-all" ).dom_element;
        var _filters          = MANAGER.__instance_filter_distributor.getAllElements();
        for ( var i = 0; i < _filters.length; i++ ) {
            if ( _filters[ i ].isActive() ) {
                _dom_button_clean.classList.remove( 'shinken-disabled' );
                return;
            }
        }
        _dom_button_clean.classList.add( 'shinken-disabled' );
    };
    self.cleanFilters               = function () {
        if ( MANAGER.__instance_button_distributor.findButton( "clean-filter-list-all" ).dom_element.classList.contains( 'shinken-disabled' ) ) {
            return;
        }
        var _urlParams  = SHINKEN.HIGHWAY.getParams();
        var _urlFilters = _urlParams[ 'filter' ];
        var _filters    = MANAGER.__instance_filter_distributor.getAllElements();
        
        if ( _urlFilters ) {
            delete _urlParams[ 'filter' ];
            SHINKEN.HIGHWAY.goTo( SHINKEN.HIGHWAY.getPath() + SHINKEN.HIGHWAY.buildParamsToUrl( _urlParams ) );
        }
        else {
            for ( var i = 0; i < _filters.length; i++ ) {
                if ( _filters[ i ].isActive() ) {
                    _filters[ i ].setValue( "" );
                    _filters[ i ].setActive( false );
                }
            }
            MANAGER.__instance_button_distributor.findButton( "clean-filter-list-all" ).dom_element.classList.add( 'shinken-disabled' );
        }
    };
    self.clickOnSelector            = function ( event ) {
        event.stopPropagation();
        var _parent_dom_element = DOM.Service.findParentElementWithClass( event.target, "shinken-parent-event-listener", 50 );
        var _name               = _parent_dom_element.dataset.name;
        switch ( _name ) {
            case SHINKEN_LIST.CONST.MASS_ACTION.NAME:
                self.hidePopup( self.mass_action );
                self.mass_action.clickOnSelector( event );
                break;
        }
    };
    self.clickOnItemSelector        = function ( event, parent_name, dom_element ) {
        var _parent_dom_element = DOM.Service.findParentElementWithClass( event.target, "shinken-parent-event-listener", 50 );
        var _name               = _parent_dom_element.dataset.name;
        switch ( _name ) {
            case SHINKEN_LIST.CONST.MASS_ACTION.NAME:
                self.mass_action.clickOnItemSelector( event, parent_name, dom_element );
                break;
            default:
                var _last_filter_focus  = MANAGER.__instance_filter_distributor.getLastInstanceFocus();
                var _parent_dom_element = DOM.Service.findParentElementWithDataSet( event.target, 'keyName', 10 );
                var _key_name           = _parent_dom_element.dataset.keyName;
                _last_filter_focus.clickOnItemSelector( _key_name, _parent_dom_element, null, event );
                self.updateCleanButtonStatus();
        }
    };
    self.toggleHelp                 = function ( event ) {
        event.preventDefault();
        event.stopPropagation();
        self.setHelp( self._dom_element_help ? self._dom_element_help.classList.contains( 'shinken-hidden' ) : true );
    };
    self.setHelp                    = function ( to_set ) {
        if ( !self._dom_element_help ) {
            if ( !to_set ) {
                return;
            }
            self._dom_element_help = document.getElementById( 'id-shinken-list-filter-help' );
            self._dom_element_help.classList.remove( 'shinken-hidden' );
            var _bound = DOM.Service.getBoundingClientRect( self._dom_element_help );
            DOM.Service.setStyles( self._dom_element_help, { "top": window.innerHeight - _bound[ DOM.CONST.STYLE.HEIGHT ] - 100, "left": window.innerWidth - _bound[ DOM.CONST.STYLE.WIDTH ] - 30 } );
            return;
        }
        
        to_set ? self._dom_element_help.classList.remove( 'shinken-hidden' ) : self._dom_element_help.classList.add( 'shinken-hidden' );
    };
    self.clickOnInput               = function ( event ) {
        self.hidePopup( self._dom_element_help );
        event.stopPropagation();
        var _list_element = MANAGER.__instance_filter_distributor.findElement( getParentNameFromEvent( event ), true );
        if ( _list_element !== null && typeof (_list_element) !== "undefined" ) {
            _list_element.clickOnInput();
        }
        //self.updateCleanButtonStatus();
    };
    self.onChangeOnInput            = function ( event ) {
        if ( event.keyCode === SHINKEN.CONST.KEY_CODE.ESCAPE ) {
            return;
        }
        var _list_element = MANAGER.__instance_filter_distributor.findElement( getParentNameFromEvent( event ), true );
        _list_element.askComputeAfterChange( event.target, null, { 'controller_name': self.controller_name } );
        self.updateCleanButtonStatus();
        self.has_complexe_filter_on = true;
    };
    self.mouseEnter                 = function ( event ) {
        var _parent_dom_element = DOM.Service.findParentElementWithClass( event.target, "shinken-parent-event-listener", 50 );
        var _name               = _parent_dom_element.dataset.name;
        switch ( _name ) {
            default:
                var _last_filter_focus  = MANAGER.__instance_filter_distributor.getLastInstanceFocus();
                var _parent_dom_element = DOM.Service.findParentElementWithClass( event.target, "shinken-option", 10 );
                if ( _last_filter_focus ) {
                    var _list = _last_filter_focus.getListElement( event );
                    _list.updateLastAutoSelectIndex( _list.list_mapping[ _parent_dom_element.dataset.keyName ], COMPONENT.CONST.AUTO_SELECT_ACTION_TYPE.MOUSE );
                }
                break;
        }
    };
    //********************************************  RELOAD    ******************************************************//
    self.validateFilters            = function () {
        var _elements = MANAGER.__instance_filter_distributor.getAllElements();
        var _current;
        for ( var i = 0, _size_i = _elements.length; i < _size_i; i++ ) {
            _current = _elements[ i ].component.input;
            _current.validateValueInput( true, true );
            if ( _current.getCounterError().counter_final ) {
                _current.message.footer = _( "validator.filter.call_to_list_avoid" );
                _current.setMessage( _current.message );
                return false;
            }
        }
        return true;
    };
    self.getFilterAndReload         = function ( forced ) {
        if ( !forced && self.has_complexe_filter_on ) {
            return;
        }
        if ( !self.validateFilters() ) {
            return;
        }
        var _param      = "" + __get_filter_from_object_filter() + __get_filter_from_input() + __get_filter_from_select();//+ __get_filter_state_workflow();
        var _path       = SHINKEN.HIGHWAY.getPath();
        var _url        = _path;
        var _old_params = SHINKEN.HIGHWAY.getParams();
        if ( _param === "" ) {
            delete _old_params[ "filter" ];
        }
        else {
            _old_params[ "filter" ] = _param.substring( 0, _param.length - 1 );
        }
        _old_params     = changeDefaultFilterValueToDisplay( _old_params );
        var _new_params = SHINKEN.HIGHWAY.buildParamsToUrl( _old_params );
        _url            = _url + _new_params;
        
        
        SHINKEN.HIGHWAY.goTo( _url );
    };
    self.resizeDone                 = function () {
        if ( self._dom_element_help ) {
            if ( self._dom_element_help.classList.contains( 'shinken-hidden' ) ) {
                delete self._dom_element_help;
            }
            else {
                delete self._dom_element_help;
                self.setHelp( true );
            }
        }
    };
    
    function changeDefaultFilterValueToDisplay ( _params ) {
        if ( !_params[ 'filter' ] ) {
            return _params;
        }
        var _splited_params        = _params[ 'filter' ].split( '~' );
        var _size                  = 0;
        var _list                  = [];
        var _splited_value         = [];
        var _splited_unique_params = [];
        var _param_name            = "";
        var _result                = [];
        for ( var index = 0; index < _splited_params.length; index++ ) {
            _splited_unique_params = _splited_params[ index ].split( ':' );
            _splited_value         = _splited_unique_params[ 1 ].split( new RegExp( "([^|&()]+)+" ) );
            _param_name            = _splited_unique_params[ 0 ];
            if ( !MANAGER.__instance_filter_distributor.filters[ _param_name ] ) {
                _result.push( _param_name + ':' + _splited_value.join( "" ) );
                continue;
            }
            _size = MANAGER.__instance_filter_distributor.filters[ _param_name ].component.select.list_element.size_list;
            _list = MANAGER.__instance_filter_distributor.filters[ _param_name ].component.select.list_element.list;
            for ( var i = 0; i < _splited_value.length; i++ ) {
                if ( !_splited_value[ i ] || SHINKEN.TOOLS.STRING.containsAny( _splited_value[ i ], [ '|', '(', ')', '|', '&' ] ) ) {
                    continue;
                }
                for ( var j = 0; j < _size; j++ ) {
                    if ( _list[ j ][ 'element' ][ 'label' ].toLowerCase() === _splited_value[ i ].toLowerCase() ) {
                        if ( _list[ j ][ 'element' ][ 'label' ].startsWith( '--' ) && _list[ j ][ 'element' ][ 'label' ].endsWith( '--' ) ) {
                            _splited_value[ i ] = _list[ j ][ 'element' ][ 'name' ];
                            break;
                        }
                    }
                }
            }
            _result.push( _param_name + ':' + _splited_value.join( "" ) );
        }
        _params[ 'filter' ] = SHINKEN.TOOLS.STRING.utf8Encode( _result.join( '~' ) );
        return _params;
    };
    
    //********************************************  INTERNAL    ******************************************************//
    function getParentNameFromEvent ( event ) {
        var _parent_dom_element = DOM.Service.findParentElementWithClass( event.target, "shinken-parent-event-listener", 50 );
        var parent_name         = _parent_dom_element.dataset.name;
        return parent_name;
    };
    return self;
})
( CONTROLLER.List || {} );

var doActionWhenDomReady = function ( e ) {
    document.addEventListener( 'keydown', function ( event ) {
        MANAGER.EventManager.keydown( event );
    } );
    document.addEventListener( "click", function ( e ) {
        if ( MANAGER.EventManager.mouse_down_target === MANAGER.EventManager.mouse_up_target ) {
            CONTROLLER.List.hidePopup();
            MANAGER.__instance_property_distributor.hidePopups();
        }
    } );
    document.addEventListener( "mousedown", function ( e ) {
        MANAGER.EventManager.mouse_down_target = e.target;
    } );
    document.addEventListener( "mouseup", function ( e ) {
        MANAGER.EventManager.mouse_up_target = e.target;
    } );
    
    doActionWhenDomReady_old();
    CONTROLLER.List.init();
};