var KEY_SESSION_STORAGE_SAVING_LOG_MSG = "message_saving_log";
var TIMEOUT_SAVING_LOG_SUCCESS         = 2000;

function hide_saving_log () {
    var _saving_log     = document.getElementById( "saving-log" );
    var _saving_log_msg = document.getElementById( "saving-log-msg" );
    
    SHINKEN.DOM.hide( _saving_log );
    _saving_log_msg.innerHTML = null;
    
    App.Scope.resetAdjustHeight( $( '.shinken-container-host-info' ) );
    $( window ).trigger( 'resize' );
}

function show_saving_log ( title, content, saving_log_class, show_close_btn, modal_title, modal_content ) {
    var _saving_log = document.getElementById( "saving-log" );
    
    if ( !_saving_log ) {
        console.error( "Cannot display message [" + modal_title + "]:[" + modal_content + "]" );
        return;
    }
    
    var _saving_log_msg          = document.getElementById( "saving-log-msg" );
    var _saving_log_title_text   = document.getElementById( "saving-log-title-text" );
    var _close_saving_log        = document.getElementById( "close-saving-log" );
    var _saving_log_modal_button = document.getElementById( "saving-log-modal-button" );
    var _saving_log_modal_header = document.getElementById( "saving-log-modal-header" );
    var _saving_log_modal_body   = document.getElementById( "saving-log-modal-body" );
    
    _saving_log.className            = "alert saving-log " + saving_log_class;
    _saving_log_title_text.innerHTML = title;
    _saving_log_msg.innerHTML        = content;
    
    SHINKEN.DOM.show( _saving_log );
    if ( show_close_btn ) {
        SHINKEN.DOM.show( _close_saving_log );
    }
    else {
        SHINKEN.DOM.hide( _close_saving_log );
    }
    
    if ( modal_content ) {
        SHINKEN.DOM.show( _saving_log_modal_button );
        _saving_log_modal_body.innerHTML = modal_content;
        
        if ( modal_title ) {
            _saving_log_modal_header.innerHTML = modal_title;
            SHINKEN.DOM.show( _saving_log_modal_button, 'inline-block' );
        }
        else {
            SHINKEN.DOM.hide( _saving_log_modal_header );
        }
    }
    else {
        SHINKEN.DOM.hide( _saving_log_modal_button );
    }
    
    App.Scope.adjustHeight( $( '#saving-log' ), $( '.shinken-container-host-info' ), $( '#right-column' ), false );
    $( window ).trigger( 'resize' );
    
    var _area_draggable = document.getElementsByClassName( 'elements-panel' )[ 0 ];
    if ( _area_draggable ) {
        SHINKEN.MODAL.setDraggable( true, _area_draggable );
    }
}

function finallyLoading () {
    var _show_close_btn = true;
    
    var msg = sessionStorage.getItem( KEY_SESSION_STORAGE_SAVING_LOG_MSG );
    if ( !msg ) {
        return;
    }
    msg               = JSON.parse( msg );
    var modal_title   = msg.title;
    var modal_content = '';
    var log_text      = '';
    var log_class     = msg.type;
    
    if ( msg.log_class ) {
        log_class = msg.log_class;
    }
    
    if ( msg.messages ) {
        modal_content = '<ul>';
        for ( var i = 0; i < msg.messages.length; i++ ) {
            if ( i === 0 ) {
                log_text += msg.messages[ i ];
            }
            modal_content += "<li>" + msg.messages[ i ] + "</li>";
        }
        modal_content += '</ul>';
        if ( msg.messages.length === 1 ) {
            modal_title   = null;
            modal_content = null;
        }
    }
    
    if ( !msg.is_persistent ) {
        _show_close_btn = msg.is_persistent;
        setTimeout( hide_saving_log, TIMEOUT_SAVING_LOG_SUCCESS );
    }
    show_saving_log( modal_title, log_text, log_class, _show_close_btn, modal_title, modal_content );
    sessionStorage.removeItem( KEY_SESSION_STORAGE_SAVING_LOG_MSG );
    
    $( window ).trigger( 'resize' );
}

window.onload = function () {
    finallyLoading();
};