'use strict';

COMPONENT.TagInformation           = function ( dom_element ) {
    //dom_element
    //params
    //dom_element_label
    this.params = [];
    if ( dom_element ) {
        this.status = dom_element.dataset.status;
        this.initDomElement( dom_element );
    }
    else {
        this.buildHtml();
        this.status = '';
    }
};
COMPONENT.TagInformation.prototype = {
    initDomElement: function ( dom_element ) {
        this.dom_element       = dom_element;
        this.dom_element_label = this.dom_element.querySelector( '.shinken-label-information' );
    },
    setStatus     : function ( to_set ) {
        if ( this.status === to_set ) {
            return;
        }
        this.status                     = to_set;
        DOM.Service.setDataSet( this.dom_element, 'status', to_set );
        var _tooltip                    = "";
        var _tooltip_type               = "";
        var _innerHTML                  = "";
        
        switch ( this.status ) {
            case COMPONENT.CONST.TAG_INFORMATION.STATUS.ALL_DISABLED:
                _tooltip      = _( 'element.information_only_disable_tags_tooltip' );
                _tooltip_type = SHINKEN_TOOLTIP.TYPE.WARNING_BORDER;
                _innerHTML    = _( 'element.information_only_disable_tags' );
                break;
            case COMPONENT.CONST.TAG_INFORMATION.STATUS.ALL_DISABLED_OVERRIDE:
                _tooltip      = _( 'element.information_only_disable_tags_override_tooltip' );
                _tooltip_type = SHINKEN_TOOLTIP.TYPE.WARNING_BORDER;
                _innerHTML    = _( 'element.information_only_disable_tags' );
                break;
            case COMPONENT.CONST.TAG_INFORMATION.STATUS.NOT_VALID_FOR_ARBITER:
                _tooltip      = _( 'element.error-will-not-through-arbiter-tooltip' );
                _tooltip_type = SHINKEN_TOOLTIP.TYPE.ERROR_BORDER;
                _innerHTML    = _( 'element.error-will-not-through-arbiter' );
                break;
            case COMPONENT.CONST.TAG_INFORMATION.STATUS.USER_GROUP_COHERENCY:
                _tooltip      = _( 'element.beware_user_groups_coherency' );
                _tooltip_type = SHINKEN_TOOLTIP.TYPE.BEWARE_BORDER;
                _innerHTML    = _( 'element.error-will-not-through-arbiter' );
                break;
            case COMPONENT.CONST.TAG_INFORMATION.STATUS.IN_SHELL:
                _tooltip      = _( 'element.tooltip_shell' );
                _tooltip_type = SHINKEN_TOOLTIP.TYPE.BEWARE_BORDER;
                _innerHTML    = _( 'element.beware' );
                break;
            case COMPONENT.CONST.TAG_INFORMATION.STATUS.CHECK_DUPLICATE:
                _tooltip      = SHINKEN.TOOLS.STRING.format( _( 'element.check_duplicate_on_the_same' ), this.params[ 0 ] );
                _tooltip_type = SHINKEN_TOOLTIP.TYPE.ERROR_BORDER;
                _innerHTML    = _( 'element.error-will-not-through-arbiter' );
                break;
            case COMPONENT.CONST.TAG_INFORMATION.STATUS.LOCKED:
                _tooltip      = SHINKEN.TOOLS.STRING.format( this.params );
                _tooltip_type = SHINKEN_TOOLTIP.TYPE.ERROR_BORDER;
                _innerHTML    = _( 'element.error' );
                break;
            default:
                break;
        }
        this.dom_element.setAttribute( 'shi-tip-html', _tooltip );
        this.dom_element.setAttribute( 'shi-tip-type', _tooltip_type );
        this.dom_element_label.innerHTML = _innerHTML;
    },
    buildHtml     : function () {
        var _to_return = DOM.Service.createElement( 'span', { class: 'shinken-information-tag', onmouseenter: 'SHINKEN_TOOLTIP.showTooltip(this)', onmouseleave: 'SHINKEN_TOOLTIP.hideTooltip()' } );
        DOM.Service.addElementTo( DOM.Service.createElement( 'span', { class: 'shinken-label-information' } ), _to_return );
        DOM.Service.addElementTo( DOM.Service.createElement( 'span', { class: 'shinken-tag-mark' }, '?' ), _to_return );
        this.initDomElement( _to_return );
    },
    setParams     : function ( to_set ) {
        this.params = to_set;
    }
};
